/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless;

import com.idrsolutions.image.DataReader;
import java.io.IOException;

class HTable {
    private final int[][][] l = new int[4][2][16];
    private final int[][][][] v = new int[4][2][16][200];
    private final int[][] tc = new int[4][2];
    private static final int MSB = Integer.MIN_VALUE;

    HTable() {
    }

    public void read(DataReader data, int[][][] HuffTab) throws IOException {
        int count = 2;
        int length = data.getU16();
        while (count < length) {
            int i;
            int temp = data.getU8();
            ++count;
            int t = temp & 0xF;
            if (t > 3) {
                throw new IOException("Huffman Data Error");
            }
            int c = temp >> 4;
            if (c > 2) {
                throw new IOException("Huffman Data Error");
            }
            this.tc[t][c] = 1;
            for (i = 0; i < 16; ++i) {
                this.l[t][c][i] = data.getU8();
                ++count;
            }
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < this.l[t][c][i]; ++j) {
                    if (count > length) {
                        throw new IOException("Huffman Data Error");
                    }
                    this.v[t][c][i][j] = data.getU8();
                    ++count;
                }
            }
        }
        if (count != length) {
            throw new IOException("Huffman Data Error");
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.tc[i][j] == 0) continue;
                HTable.build(HuffTab[i][j], this.l[i][j], this.v[i][j]);
            }
        }
    }

    private static void build(int[] tab, int[] L, int[][] V) throws IOException {
        int n;
        int j;
        int i;
        int temp = 256;
        int k = 0;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < L[i]; ++j) {
                for (n = 0; n < temp >> i + 1; ++n) {
                    tab[k] = V[i][j] | i + 1 << 8;
                    ++k;
                }
            }
        }
        i = 1;
        while (k < 256) {
            tab[k] = i | Integer.MIN_VALUE;
            ++i;
            ++k;
        }
        int tp = 1;
        k = 0;
        for (i = 8; i < 16; ++i) {
            for (j = 0; j < L[i]; ++j) {
                for (n = 0; n < temp >> i - 7; ++n) {
                    tab[tp * 256 + k] = V[i][j] | i + 1 << 8;
                    ++k;
                }
                if (k < 256) continue;
                if (k > 256) {
                    throw new IOException("Huffman Data Error");
                }
                k = 0;
                ++tp;
            }
        }
    }
}

