/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.SubbandCoefficient;
import java.util.List;

class Trns {
    private static final float alpha = -1.5861343f;
    private static final float beta = -0.052980117f;
    private static final float gamma = 0.8829111f;
    private static final float delta = 0.44350687f;
    private static final float zeta = 1.2301741f;
    private static final float zeta_ = 0.8128931f;
    private final boolean reversible;

    Trns(boolean reversible) {
        this.reversible = reversible;
    }

    public SubbandCoefficient getInversed(List<SubbandCoefficient> subCos, int u0, int v0) {
        SubbandCoefficient sb = subCos.get(0);
        for (int i = 1; i < subCos.size(); ++i) {
            sb = this.getNext(sb, subCos.get(i), u0, v0);
        }
        return sb;
    }

    private static void applyFilter(float[] data, int size, boolean reversible) {
        block8: {
            float next;
            int len;
            block9: {
                int n;
                int aa = 3;
                int bb = 5;
                int cc = 4 + size - 2;
                int dd = 4 + size;
                data[aa--] = data[bb++];
                data[dd++] = data[cc--];
                data[aa--] = data[bb++];
                data[dd++] = data[cc--];
                data[aa--] = data[bb++];
                data[dd++] = data[cc--];
                data[aa] = data[bb];
                data[dd] = data[cc];
                len = size >> 1;
                if (!reversible) break block9;
                int j = 4;
                for (n = len; n >= 0; --n) {
                    int n2 = j;
                    data[n2] = data[n2] - (float)((int)(data[j - 1] + data[j + 1] + 2.0f) >> 2);
                    j += 2;
                }
                j = 5;
                for (n = len - 1; n >= 0; --n) {
                    int n3 = j;
                    data[n3] = data[n3] + (float)((int)(data[j - 1] + data[j + 1]) >> 1);
                    j += 2;
                }
                break block8;
            }
            int j = 1;
            int n = len + 4;
            while (n > 0) {
                int n4 = j;
                data[n4] = data[n4] * 0.8128931f;
                --n;
                j += 2;
            }
            j = 2;
            float current = 0.44350687f * data[j - 1];
            for (n = len + 2; n >= 0; --n) {
                next = 0.44350687f * data[j + 1];
                data[j] = 1.2301741f * data[j] - current - next;
                if (--n < 0) break;
                current = 0.44350687f * data[(j += 2) + 1];
                data[j] = 1.2301741f * data[j] - current - next;
                j += 2;
            }
            j = 3;
            current = 0.8829111f * data[j - 1];
            for (n = len + 1; n >= 0; --n) {
                next = 0.8829111f * data[j + 1];
                int n5 = j;
                data[n5] = data[n5] - (current + next);
                if (--n < 0) break;
                current = 0.8829111f * data[(j += 2) + 1];
                int n6 = j;
                data[n6] = data[n6] - (current + next);
                j += 2;
            }
            j = 4;
            current = -0.052980117f * data[j - 1];
            for (n = len; n >= 0; --n) {
                next = -0.052980117f * data[j + 1];
                int n7 = j;
                data[n7] = data[n7] - (current + next);
                if (--n < 0) break;
                current = -0.052980117f * data[(j += 2) + 1];
                int n8 = j;
                data[n8] = data[n8] - (current + next);
                j += 2;
            }
            if (len == 0) break block8;
            j = 5;
            current = -1.5861343f * data[j - 1];
            for (n = len - 1; n >= 0; --n) {
                next = -1.5861343f * data[j + 1];
                int n9 = j;
                data[n9] = data[n9] - (current + next);
                if (--n >= 0) {
                    current = -1.5861343f * data[(j += 2) + 1];
                    int n10 = j;
                    data[n10] = data[n10] - (current + next);
                    j += 2;
                    continue;
                }
                break;
            }
        }
    }

    private SubbandCoefficient getNext(SubbandCoefficient ll, SubbandCoefficient other, int u0, int v0) {
        int u;
        int v;
        int widthLL = ll.width;
        int heightLL = ll.height;
        int width = other.width;
        int height = other.height;
        int w2 = width << 1;
        int k = 0;
        for (int i = 0; i < heightLL; ++i) {
            int l = i * w2;
            for (int j = 0; j < widthLL; ++j) {
                other.floatItems[l] = ll.floatItems[k++];
                l += 2;
            }
        }
        int bufferPadding = 4;
        float[] rowBuffer = new float[width + 8];
        if (width == 1) {
            if ((u0 & 1) != 0) {
                k = 0;
                for (v = 0; v < height; ++v) {
                    int n = k++;
                    other.floatItems[n] = other.floatItems[n] * 0.5f;
                }
            }
        } else {
            k = 0;
            for (v = 0; v < height; ++v) {
                System.arraycopy(other.floatItems, k, rowBuffer, 4, width);
                Trns.applyFilter(rowBuffer, width, this.reversible);
                System.arraycopy(rowBuffer, 4, other.floatItems, k, width);
                k += width;
            }
        }
        int numBuffers = 16;
        float[][] colBuffers = new float[numBuffers][height + 8];
        int currentBuffer = 0;
        int ss = 4 + height;
        if (height == 1) {
            if ((v0 & 1) != 0) {
                u = 0;
                while (u < width) {
                    int n = u++;
                    other.floatItems[n] = (float)((double)other.floatItems[n] * 0.5);
                }
            }
        } else {
            for (u = 0; u < width; ++u) {
                if (currentBuffer == 0) {
                    numBuffers = Math.min(width - u, numBuffers);
                    k = u;
                    for (int l = 4; l < ss; ++l) {
                        for (int b = 0; b < numBuffers; ++b) {
                            colBuffers[b][l] = other.floatItems[k + b];
                        }
                        k += width;
                    }
                    currentBuffer = numBuffers;
                }
                float[] buffer = colBuffers[--currentBuffer];
                Trns.applyFilter(buffer, height, this.reversible);
                if (currentBuffer != 0) continue;
                k = u - numBuffers + 1;
                for (int l = 4; l < ss; ++l) {
                    for (int b = 0; b < numBuffers; ++b) {
                        other.floatItems[k + b] = colBuffers[b][l];
                    }
                    k += width;
                }
            }
        }
        SubbandCoefficient sc = new SubbandCoefficient();
        sc.width = width;
        sc.height = height;
        sc.floatItems = other.floatItems;
        return sc;
    }
}

