/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileResolution;
import java.util.List;

public class RPCL
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final int maxNL;
    private final Tile tile;
    private int r;
    private int l;
    private int c;
    private int p;
    private final int[] maxNumPrecinctsInLevel;

    public RPCL(Info info, int tileIndex) {
        SIZ siz = info.siz;
        this.tile = info.tilesMap.get(tileIndex);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = siz.Csiz;
        this.maxNL = this.tile.cod.nDecompLevel;
        this.maxNumPrecinctsInLevel = new int[this.maxNL + 1];
        this.r = 0;
        while (this.r <= this.maxNL) {
            int maxNumPrecincts = 0;
            this.c = 0;
            while (this.c < this.componentsCount) {
                List<TileResolution> resolutions = this.tile.components.get((int)this.c).resolutions;
                if (this.r < resolutions.size()) {
                    maxNumPrecincts = Math.max(maxNumPrecincts, resolutions.get((int)this.r).precinctInfo.numPrecincts);
                }
                ++this.c;
            }
            this.maxNumPrecinctsInLevel[this.r] = maxNumPrecincts;
            ++this.r;
        }
        this.r = 0;
        this.c = 0;
    }

    @Override
    public Packet getNextPacket() {
        while (this.r <= this.maxNL) {
            while (this.p < this.maxNumPrecinctsInLevel[this.r]) {
                while (this.c < this.componentsCount) {
                    TileComponent component = this.tile.components.get(this.c);
                    if (this.r > this.tile.cod.nDecompLevel) continue;
                    TileResolution resolution = component.resolutions.get(this.r);
                    int numprecincts = resolution.precinctInfo.numPrecincts;
                    if (this.p >= numprecincts) continue;
                    if (this.l < this.layersCount) {
                        Packet packet = this.createPacket(resolution, this.p, this.l);
                        ++this.l;
                        return packet;
                    }
                    this.l = 0;
                    ++this.c;
                }
                this.c = 0;
                ++this.p;
            }
            ++this.r;
            this.p = 0;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution resolution, int precintNumber, int layerNumber) {
        Packet packet = new Packet();
        packet.layerNumber = layerNumber;
        for (TileBand subband : resolution.tileBands) {
            for (CodeBlock codeBlock : subband.codeBlocks) {
                if (codeBlock.precinctNumber != precintNumber) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }
}

