/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.LUT;

public class EntropyDecoder {
    private final byte[] stream;
    private final int maxLen;
    private final int dataEnd;
    private int bp;
    private int ch;
    private int cl;
    private int ct;
    private int a;

    public EntropyDecoder(byte[] stream, int offset, int len) {
        this.stream = stream;
        this.maxLen = stream.length;
        this.bp = offset;
        this.dataEnd = len;
        this.ch = stream[offset] & 0xFF;
        this.cl = 0;
        this.byteIn();
        this.ch = this.ch << 7 & 0xFFFF | this.cl >> 9 & 0x7F;
        this.cl = this.cl << 7 & 0xFFFF;
        this.ct -= 7;
        this.a = 32768;
    }

    private void byteIn() {
        if (this.bp + 1 < this.maxLen && (this.stream[this.bp] & 0xFF) == 255) {
            int b1 = this.stream[this.bp + 1] & 0xFF;
            if (b1 > 143) {
                this.cl += 65280;
                this.ct = 8;
            } else {
                ++this.bp;
                this.cl += (this.stream[this.bp] & 0xFF) << 9;
                this.ct = 7;
            }
        } else {
            ++this.bp;
            this.cl += this.bp < this.dataEnd ? (this.stream[this.bp] & 0xFF) << 8 : 65280;
            this.ct = 8;
        }
        if (this.cl > 65535) {
            this.ch += this.cl >> 16;
            this.cl &= 0xFFFF;
        }
    }

    public int decodeBit(byte[] contexts, int pos) {
        int d;
        int cx_idx = contexts[pos] >> 1;
        int cx_mps = contexts[pos] & 1;
        int qe_ = LUT.QE[cx_idx];
        this.a -= qe_;
        if (this.ch < qe_) {
            if (this.a < qe_) {
                this.a = qe_;
                d = cx_mps;
                cx_idx = LUT.NMPS[cx_idx];
            } else {
                this.a = qe_;
                d = 1 ^ cx_mps;
                if (LUT.SWITCHML[cx_idx] == 1) {
                    cx_mps = d;
                }
                cx_idx = LUT.NLPS[cx_idx];
            }
        } else {
            this.ch -= qe_;
            if ((this.a & 0x8000) != 0) {
                return cx_mps;
            }
            if (this.a < qe_) {
                d = 1 ^ cx_mps;
                if (LUT.SWITCHML[cx_idx] == 1) {
                    cx_mps = d;
                }
                cx_idx = LUT.NLPS[cx_idx];
            } else {
                d = cx_mps;
                cx_idx = LUT.NMPS[cx_idx];
            }
        }
        do {
            if (this.ct == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.ch = this.ch << 1 & 0xFFFF | this.cl >> 15 & 1;
            this.cl = this.cl << 1 & 0xFFFF;
            --this.ct;
        } while ((this.a & 0x8000) == 0);
        contexts[pos] = (byte)(cx_idx << 1 | cx_mps);
        return d;
    }
}

