/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.ico;

import com.idrsolutions.image.DataByteLittle;
import com.idrsolutions.image.DataFileLittle;
import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.ImageTypeFinder;
import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.ico.IcoInfo;
import com.idrsolutions.image.png.PngDecoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class IcoDecoder {
    public BufferedImage read(byte[] icoData) throws Exception {
        DataByteLittle reader = new DataByteLittle(icoData);
        List<IcoInfo> infos = IcoDecoder.grabIcoInfos(reader);
        BufferedImage img = IcoDecoder.grabImage(infos.get(0), reader);
        reader.close();
        return img;
    }

    public BufferedImage read(File icoFile) throws Exception {
        DataFileLittle reader = new DataFileLittle(icoFile);
        List<IcoInfo> infos = IcoDecoder.grabIcoInfos(reader);
        BufferedImage img = IcoDecoder.grabImage(infos.get(0), reader);
        reader.close();
        return img;
    }

    private static List<IcoInfo> grabIcoInfos(DataReader reader) throws IOException {
        boolean valid;
        int reserved = reader.getU16();
        int type = reader.getU16();
        boolean bl = valid = reserved == 0 && (type == 1 || type == 2);
        if (!valid) {
            throw new IOException("Not a valid ICO image");
        }
        int imageCount = reader.getU16();
        ArrayList<IcoInfo> infoList = new ArrayList<IcoInfo>();
        for (int i = 0; i < imageCount; ++i) {
            IcoInfo info = new IcoInfo();
            info.iw = reader.getU8();
            info.ih = reader.getU8();
            info.nPalColor = reader.getU8();
            reader.skip(1);
            info.colorPlanes = reader.getU16();
            info.bpp = reader.getU16();
            info.dataLen = reader.getU32();
            info.offset = reader.getU32();
            infoList.add(info);
        }
        return infoList;
    }

    private static BufferedImage grabImage(IcoInfo info, DataReader reader) throws Exception {
        reader.moveTo(info.offset);
        byte[] imgData = new byte[info.dataLen];
        reader.read(imgData);
        boolean isPNG = ImageTypeFinder.isPNG(imgData);
        if (isPNG) {
            PngDecoder decoder = new PngDecoder();
            return decoder.read(imgData);
        }
        BmpDecoder decoder = new BmpDecoder();
        byte[] bmpData = new byte[imgData.length + 14];
        ByteBuffer buffer = ByteBuffer.wrap(bmpData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)66);
        buffer.put((byte)77);
        buffer.putInt(bmpData.length);
        buffer.putInt(0);
        buffer.putInt(54);
        int position = buffer.position();
        buffer.put(imgData);
        buffer.position(position);
        buffer.putInt(40);
        buffer.putInt(info.iw == 0 ? 256 : info.iw);
        buffer.putInt(info.ih == 0 ? 256 : info.ih);
        buffer.putShort((short)info.colorPlanes);
        buffer.putShort((short)info.bpp);
        if (info.nPalColor != 0) {
            position = buffer.position() + 16;
            buffer.position(position);
            buffer.putInt(info.nPalColor);
        }
        return decoder.read(bmpData);
    }
}

