/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.dicom;

import com.idrsolutions.image.DataByteLittle;
import com.idrsolutions.image.DataFileLittle;
import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.ToolBinary;
import com.idrsolutions.image.ToolGray;
import com.idrsolutions.image.ToolGray16;
import com.idrsolutions.image.ToolRGB;
import com.idrsolutions.image.dicom.DataElement;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeglossless.JpegLosslessDecoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DicomDecoder
extends JDeliImage {
    private DataReader reader;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int OB = 20290;
    private static final int OD = 20292;
    private static final int OF = 20294;
    private static final int OW = 20311;
    private static final int PN = 20558;
    private static final int QQ = 16191;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SQ = 21329;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int UN = 21838;
    private static final int US = 21843;
    private static final int UT = 21844;

    public BufferedImage read(byte[] dicomData) throws Exception {
        this.reader = new DataByteLittle(dicomData);
        this.reader.moveTo(128);
        int[] dicm = new int[]{68, 73, 67, 77};
        for (int i = 0; i < 4; ++i) {
            if (this.reader.getU8() == dicm[i]) continue;
            throw new IOException("Not a Valid DICOM file");
        }
        BufferedImage img = DicomDecoder.grabImage(0, this.reader);
        this.reader.close();
        return img;
    }

    public BufferedImage read(File dicomFile) throws Exception {
        this.reader = new DataFileLittle(dicomFile);
        this.reader.moveTo(128);
        int[] dicm = new int[]{68, 73, 67, 77};
        for (int i = 0; i < 4; ++i) {
            if (this.reader.getU8() == dicm[i]) continue;
            throw new IOException("Not a Valid DICOM file");
        }
        BufferedImage img = DicomDecoder.grabImage(0, this.reader);
        this.reader.close();
        return img;
    }

    public BufferedImage read(int frameNumber, File dicomFile) throws Exception {
        if (frameNumber == 0) {
            throw new Exception("frameNumber should start from 1");
        }
        this.reader = new DataFileLittle(dicomFile);
        this.reader.moveTo(128);
        int[] dicm = new int[]{68, 73, 67, 77};
        for (int i = 0; i < 4; ++i) {
            if (this.reader.getU8() == dicm[i]) continue;
            throw new IOException("Not a Valid DICOM file");
        }
        BufferedImage img = DicomDecoder.grabImage(frameNumber - 1, this.reader);
        this.reader.close();
        return img;
    }

    public BufferedImage read(int frameNumber, byte[] dicomData) throws Exception {
        if (frameNumber == 0) {
            throw new Exception("frameNumber should start from 1");
        }
        this.reader = new DataByteLittle(dicomData);
        this.reader.moveTo(128);
        int[] dicm = new int[]{68, 73, 67, 77};
        for (int i = 0; i < 4; ++i) {
            if (this.reader.getU8() == dicm[i]) continue;
            throw new IOException("Not a Valid DICOM file");
        }
        BufferedImage img = DicomDecoder.grabImage(frameNumber - 1, this.reader);
        this.reader.close();
        return img;
    }

    public int getFrameCount(byte[] dicomData) throws IOException {
        this.reader = new DataByteLittle(dicomData);
        this.reader.moveTo(128);
        int[] dicm = new int[]{68, 73, 67, 77};
        for (int i = 0; i < 4; ++i) {
            if (this.reader.getU8() == dicm[i]) continue;
            throw new IOException("Not a Valid DICOM file");
        }
        List<Long> list = DicomDecoder.grabPixelList(this.reader);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public int getFrameCount(File dicomFile) throws IOException {
        this.reader = new DataFileLittle(dicomFile);
        this.reader.moveTo(128);
        int[] dicm = new int[]{68, 73, 67, 77};
        for (int i = 0; i < 4; ++i) {
            if (this.reader.getU8() == dicm[i]) continue;
            throw new IOException("Not a Valid DICOM file");
        }
        List<Long> list = DicomDecoder.grabPixelList(this.reader);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private static byte[] getBytesFromOffsets(DataReader reader, long offset) throws IOException {
        int off = (int)(offset >>> 32);
        int len = (int)offset;
        byte[] data = new byte[len];
        int old = reader.getPosition();
        reader.moveTo(off);
        reader.read(data);
        reader.moveTo(old);
        return data;
    }

    private static int getIntFromOffsets(DataReader reader, long offset) throws IOException {
        int off = (int)(offset >>> 32);
        int len = (int)offset;
        int old = reader.getPosition();
        reader.moveTo(off);
        int xx = 0;
        switch (len) {
            case 1: {
                xx = reader.getU8();
                break;
            }
            case 2: {
                xx = reader.getU16();
                break;
            }
            case 3: {
                xx = reader.getU16();
                break;
            }
            case 4: {
                xx = reader.getU32();
            }
        }
        reader.moveTo(old);
        return xx;
    }

    private static List<Long> grabPixelList(DataReader reader) throws IOException {
        reader.moveTo(132);
        do {
            DataElement element = DicomDecoder.readDataElement(reader);
            switch (element.tag) {
                case 2145386512: {
                    return element.dataOffsets;
                }
            }
        } while (reader.getPosition() + 4 <= reader.getLength());
        return null;
    }

    private static BufferedImage grabImage(int frame, DataReader reader) throws Exception {
        List<Long> pixList = null;
        byte[] syntax = null;
        String photometric = "MONOCHROME1";
        int rows = 0;
        int columns = 0;
        int bitsAllocated = 8;
        reader.moveTo(132);
        do {
            DataElement element = DicomDecoder.readDataElement(reader);
            switch (element.tag) {
                case 2145386512: {
                    pixList = element.dataOffsets;
                    break;
                }
                case 131088: {
                    syntax = DicomDecoder.getBytesFromOffsets(reader, element.dataOffsets.get(0));
                    break;
                }
                case 2621444: {
                    photometric = new String(DicomDecoder.getBytesFromOffsets(reader, element.dataOffsets.get(0))).trim();
                    break;
                }
                case 2621456: {
                    rows = DicomDecoder.getIntFromOffsets(reader, element.dataOffsets.get(0));
                    break;
                }
                case 2621457: {
                    columns = DicomDecoder.getIntFromOffsets(reader, element.dataOffsets.get(0));
                    break;
                }
                case 2621696: {
                    bitsAllocated = DicomDecoder.getIntFromOffsets(reader, element.dataOffsets.get(0));
                }
            }
        } while (reader.getPosition() + 4 <= reader.getLength());
        if (pixList == null) {
            throw new IOException("no pixels found");
        }
        byte[] pixData = DicomDecoder.getBytesFromOffsets(reader, pixList.get(frame));
        if (syntax != null) {
            String syntaxStr = new String(syntax).trim();
            if (syntaxStr.equals("1.2.840.10008.1.2.4.90") || syntaxStr.equals("1.2.840.10008.1.2.4.91") || syntaxStr.equals("1.2.840.10008.1.2.4.92") || syntaxStr.equals("1.2.840.10008.1.2.4.93")) {
                Jpeg2000Decoder decoder = new Jpeg2000Decoder();
                return decoder.read(pixData);
            }
            if (syntaxStr.equals("1.2.840.10008.1.2.4.50") || syntaxStr.equals("1.2.840.10008.1.2.4.51")) {
                JpegDecoder decoder = new JpegDecoder();
                return decoder.read(pixData);
            }
            if (syntaxStr.equals("1.2.840.10008.1.2.4.57") || syntaxStr.equals("1.2.840.10008.1.2.4.70")) {
                JpegLosslessDecoder decoder = new JpegLosslessDecoder();
                return decoder.read(pixData);
            }
            if (syntaxStr.equals("1.2.840.10008.1.2")) {
                return DicomDecoder.getUncompressed(photometric, rows, columns, bitsAllocated, pixData);
            }
            if (syntaxStr.equals("1.2.840.10008.1.2.1\u0000")) {
                return DicomDecoder.getUncompressed(photometric, rows, columns, bitsAllocated, pixData);
            }
            throw new IOException("Transfer Syntax UID : " + syntaxStr + " is not supported yet");
        }
        int firstUSHORT = (pixData[0] & 0xFF) << 8 | pixData[1] & 0xFF;
        if (firstUSHORT == 65496) {
            JpegDecoder decoder = new JpegDecoder();
            return decoder.read(pixData);
        }
        Jpeg2000Decoder decoder = new Jpeg2000Decoder();
        return decoder.read(pixData);
    }

    private static DataElement readDataElement(DataReader reader) throws IOException {
        int vl;
        int h0 = reader.getU16();
        int h1 = reader.getU16();
        int tag = h0 << 16 | h1;
        int a0 = reader.getU8();
        int a1 = reader.getU8();
        int vr = a0 << 8 | a1;
        switch (vr) {
            case 20290: 
            case 20294: 
            case 20311: 
            case 21329: 
            case 21838: 
            case 21844: {
                reader.getU16();
                vl = reader.getU32();
                break;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20292: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: {
                vl = reader.getU16();
                break;
            }
            default: {
                vr = 0;
                int a2 = reader.getU8();
                int a3 = reader.getU8();
                vl = a3 << 24 | a2 << 16 | a1 << 8 | a0;
            }
        }
        if (vl == -1) {
            vl = 0;
        }
        DataElement ele = new DataElement();
        ele.tag = tag;
        ele.vl = vl;
        ele.vr = vr;
        if (vl == 0) {
            if (tag == 2145386512) {
                ele.dataOffsets = DicomDecoder.readPixelOffsets(reader);
            } else {
                ele.dataOffsets.add((long)reader.getPosition() << 32);
            }
        } else {
            long offset = (long)reader.getPosition() << 32 | (long)vl;
            reader.skip(vl);
            ele.dataOffsets.add(offset);
        }
        return ele;
    }

    private static List<Long> readPixelOffsets(DataReader reader) throws IOException {
        DicomDecoder.readDataElement(reader);
        boolean isEndOfSequence = false;
        ArrayList<Long> temp = new ArrayList<Long>();
        while (!isEndOfSequence) {
            DataElement item = DicomDecoder.readDataElement(reader);
            isEndOfSequence = item.tag == -73507;
            if (isEndOfSequence) continue;
            temp.addAll(item.dataOffsets);
        }
        return temp;
    }

    private static BufferedImage getUncompressed(String chrome, int height, int width, int bps, byte[] pixData) {
        if (chrome.startsWith("MONO")) {
            if (chrome.equals("MONOCHROME1")) {
                for (int i = 0; i < 10; ++i) {
                    pixData[i] = (byte)(~(pixData[i] & 0xFF));
                }
            }
            if (bps == 8) {
                ToolGray gray = new ToolGray(width, height);
                gray.setData(pixData);
                return gray.getBufferedImage();
            }
            if (bps == 16) {
                ToolGray16 gray = new ToolGray16(width, height);
                gray.setData(pixData);
                return gray.getBufferedImage();
            }
            if (bps < 8) {
                ToolBinary gray = new ToolBinary(width, height, bps);
                gray.setData(pixData);
                return gray.getBufferedImage();
            }
        } else if (chrome.startsWith("RGB")) {
            ToolRGB rgb = new ToolRGB(width, height);
            rgb.setData(pixData);
            return rgb.getBufferedImage();
        }
        return null;
    }
}

