/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.bmp;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class BmpEncoder {
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        int bps = BmpEncoder.getBPS(image);
        int rowSize = (image.getWidth() * bps + 31) / 32 * 4;
        int pixArrayLen = rowSize * image.getHeight();
        BmpEncoder.putLe16(outputStream, 19778);
        BmpEncoder.putLe32(outputStream, pixArrayLen + 54);
        BmpEncoder.putLe32(outputStream, 0);
        int offset = 54;
        int padding = 0;
        if (image.getType() == 13 || bps <= 8) {
            padding = 1024;
            offset += padding;
        }
        BmpEncoder.putLe32(outputStream, offset);
        BmpEncoder.putLe32(outputStream, 40);
        BmpEncoder.putLe32(outputStream, image.getWidth());
        BmpEncoder.putLe32(outputStream, image.getHeight());
        BmpEncoder.putLe16(outputStream, 1);
        BmpEncoder.putLe16(outputStream, bps);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, pixArrayLen);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? 256 : 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? 256 : 0);
        if (padding > 0) {
            if (image.getType() == 13) {
                IndexColorModel icm = (IndexColorModel)image.getColorModel();
                byte[] r = new byte[256];
                byte[] g = new byte[256];
                byte[] b = new byte[256];
                byte[] a = new byte[256];
                icm.getReds(r);
                icm.getGreens(g);
                icm.getBlues(b);
                icm.getAlphas(a);
                for (int i = 0; i < 256; ++i) {
                    byte[] bb = new byte[]{r[i], g[i], b[i], a[i]};
                    outputStream.write(bb);
                }
            } else {
                for (int i = 0; i < 256; ++i) {
                    byte[] bb = new byte[]{(byte)i, (byte)i, (byte)i, -1};
                    outputStream.write(bb);
                }
            }
        }
        switch (image.getType()) {
            case 12: {
                BufferedImage convertedImg = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                convertedImg.getGraphics().drawImage(image, 0, 0, null);
                BmpEncoder.encodeGray(convertedImg, outputStream, rowSize);
                break;
            }
            case 10: {
                BmpEncoder.encodeGray(image, outputStream, rowSize);
                break;
            }
            case 13: {
                BmpEncoder.encodeIndexed(image, outputStream, rowSize);
                break;
            }
            case 5: {
                BmpEncoder.encodeBYTE_BGR(image, outputStream);
                break;
            }
            case 6: 
            case 7: {
                BmpEncoder.encodeBYTE_ABGR(image, outputStream);
                break;
            }
            case 4: {
                BmpEncoder.encodeINT_BGR(image, outputStream);
                break;
            }
            case 1: {
                BmpEncoder.encodeINT_RGB(image, outputStream);
                break;
            }
            case 2: 
            case 3: {
                BmpEncoder.encodeINT_ARGB(image, outputStream);
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                converted.getGraphics().drawImage(image, 0, 0, null);
                BmpEncoder.encodeBYTE_BGR(converted, outputStream);
            }
        }
    }

    private static void encodeGray(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int balance = rowSize - image.getWidth();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < balance; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeIndexed(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int balance = rowSize - image.getWidth();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < balance; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_BGR(BufferedImage image, OutputStream os) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth() * 3;
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
                os.write(pix[p++] & 0xFF);
                os.write(pix[p++] & 0xFF);
            }
        }
    }

    private static void encodeBYTE_ABGR(BufferedImage image, OutputStream os) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth() * 4;
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p + 1] & 0xFF);
                os.write(pix[p + 2] & 0xFF);
                os.write(pix[p + 3] & 0xFF);
                os.write(pix[p] & 0xFF);
                p += 4;
            }
        }
    }

    private static void encodeINT_BGR(BufferedImage image, OutputStream os) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t >> 16 & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t & 0xFF);
            }
        }
    }

    private static void encodeINT_RGB(BufferedImage image, OutputStream os) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t >> 16 & 0xFF);
            }
        }
    }

    private static void encodeINT_ARGB(BufferedImage image, OutputStream os) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t >> 16 & 0xFF);
                os.write(t >> 24 & 0xFF);
            }
        }
    }

    private static void putLe16(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
    }

    private static void putLe32(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v >> 16 & 0xFF);
        os.write(v >> 24 & 0xFF);
    }

    private static int getBPS(BufferedImage image) {
        switch (image.getType()) {
            case 12: {
                return 8;
            }
            case 10: {
                return 8;
            }
            case 13: {
                return 8;
            }
            case 1: 
            case 4: 
            case 5: {
                return 24;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 32;
            }
        }
        return 24;
    }
}

