/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.DataReader;

public class DataByteLittle
implements DataReader {
    private int p;
    private final byte[] data;

    public DataByteLittle(byte[] data) {
        this.data = data;
        this.p = 0;
    }

    @Override
    public int getU8() {
        return this.data[this.p++] & 0xFF;
    }

    @Override
    public int getU16() {
        return this.data[this.p++] & 0xFF | (this.data[this.p++] & 0xFF) << 8;
    }

    @Override
    public int getU24() {
        return this.data[this.p++] & 0xFF | (this.data[this.p++] & 0xFF) << 8 | (this.data[this.p++] & 0xFF) << 16;
    }

    @Override
    public int getU32() {
        return this.data[this.p++] & 0xFF | (this.data[this.p++] & 0xFF) << 8 | (this.data[this.p++] & 0xFF) << 16 | (this.data[this.p++] & 0xFF) << 24;
    }

    @Override
    public void read(byte[] copyTo) {
        System.arraycopy(this.data, this.p, copyTo, 0, copyTo.length);
        this.p += copyTo.length;
    }

    @Override
    public void skip(int n) {
        this.p += n;
    }

    @Override
    public void moveTo(int p) {
        this.p = p;
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public void close() {
    }

    @Override
    public int getPosition() {
        return this.p;
    }
}

