/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search;

import coldfusion.filter.FusionContext;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.io.File;
import java.util.Map;

public class ORMSearchSettings {
    public static final String SEARCH = "search";
    public static final String AUTOINDEX = "autoindex";
    public static final String LANGUAGE = "language";
    public static final String INDEXDIR = "indexdir";
    public static final String DEFAULT_LANGUAGE = "english";
    private boolean autoIndex = false;
    private String language = "english";
    private File indexBaseDir;

    public ORMSearchSettings(Map<String, Object> ormSettings) {
        Object searchObj = ormSettings.get(SEARCH);
        String appcfc_indexDir = null;
        if (searchObj != null && searchObj instanceof Map) {
            String languageStr;
            Map searchSetting = (Map)searchObj;
            if (searchSetting.get(AUTOINDEX) != null) {
                this.autoIndex = this.getBooleanValue(searchSetting.get(AUTOINDEX).toString(), false);
            }
            if ((languageStr = (String)searchSetting.get(LANGUAGE)) != null && languageStr.length() > 0) {
                this.language = languageStr;
            }
            appcfc_indexDir = (String)searchSetting.get(INDEXDIR);
        }
        this.resolveAndCreateIndexDir(appcfc_indexDir);
    }

    public File getIndexBaseDir() {
        return this.indexBaseDir;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    private boolean getBooleanValue(String str, boolean defaultVal) {
        if (str == null) {
            return defaultVal;
        }
        return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str);
    }

    private void resolveAndCreateIndexDir(String appcfc_IndexDir) {
        String baseIndexPath;
        if (appcfc_IndexDir != null) {
            if (appcfc_IndexDir.length() > 1 && (appcfc_IndexDir.startsWith(File.separator) || appcfc_IndexDir.charAt(1) == ':')) {
                baseIndexPath = appcfc_IndexDir;
            } else {
                String appLocation = FusionContext.getCurrent().getApplicationPath();
                baseIndexPath = appLocation + File.separator + appcfc_IndexDir;
            }
        } else if (ServiceFactory.getRuntimeService().getORMSearchIndexDirectory() != null && ServiceFactory.getRuntimeService().getORMSearchIndexDirectory().length() > 0) {
            String rootIndexPath = ServiceFactory.getRuntimeService().getORMSearchIndexDirectory();
            String appName = FusionContext.getCurrent().getApplicationName();
            baseIndexPath = rootIndexPath + File.separator + appName;
        } else {
            String cfusionPath = ServiceFactory.getRuntimeService().getRootDir();
            String appName = FusionContext.getCurrent().getApplicationName();
            baseIndexPath = cfusionPath + File.separator + "ormindex" + File.separator + appName;
        }
        this.indexBaseDir = this.performSanityCheck(baseIndexPath);
    }

    private File performSanityCheck(String dirPath) {
        File directory = new File(dirPath);
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                throw new IndexDirectoryConfigurationException(RB.getString((Object)this, (String)"indexDirCreationFailed", (Object)dirPath));
            }
        } else if (!directory.isDirectory()) {
            throw new IndexDirectoryConfigurationException(RB.getString((Object)this, (String)"IndexPathNotADirectory", (Object)dirPath));
        }
        if (!directory.canWrite()) {
            throw new IndexDirectoryConfigurationException(RB.getString((Object)this, (String)"indexDirNotwritable", (Object)dirPath));
        }
        return directory;
    }

    public static class IndexDirectoryConfigurationException
    extends RuntimeException {
        public IndexDirectoryConfigurationException(String message) {
            super(message);
        }
    }
}

