/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.orm.ORMUtils;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.orm.hibernate.ConfigurationManager;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.search.EntityNotIndexableException;
import coldfusion.orm.search.ORMSearchException;
import coldfusion.orm.search.ORMSearchFactory;
import coldfusion.orm.search.Task.AddLuceneTask;
import coldfusion.orm.search.Task.LuceneTask;
import coldfusion.orm.search.Task.LuceneTaskHelper;
import coldfusion.orm.search.Task.PurgeLuceneTask;
import coldfusion.orm.search.Task.SearchLuceneTask;
import coldfusion.orm.search.Task.SearchQueryHelper;
import coldfusion.orm.search.core.EntityWorkSpace;
import coldfusion.orm.search.lucene.DocumentBuilder;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.tagext.sql.TransactionTag;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Version;

public class ORMSearchManager {
    private static Map<String, ORMSearchFactory> appNameVsORMSearchFactory = new CaseInsensitiveMap();
    public static final Version VERSION_LUCENE = Version.LUCENE_6_6_1;
    private static ThreadLocal<Map<String, LinkedList<LuceneTask>>> luceneTasks = new ThreadLocal();
    private static ORMSearchManager instance = new ORMSearchManager();

    public static ORMSearchManager getInstance() {
        return instance;
    }

    public static ORMSearchFactory getCurrentSearchFactory() {
        String appName = FusionContext.getCurrent().getApplicationName();
        ORMSearchFactory searchFactory = appNameVsORMSearchFactory.get(appName);
        if (searchFactory == null) {
            searchFactory = new ORMSearchFactory();
            appNameVsORMSearchFactory.put(appName, searchFactory);
        }
        return searchFactory;
    }

    public static void removeSearchFactory(ApplicationScope app) {
        ORMSearchFactory searchFactory;
        if (app != null && (searchFactory = appNameVsORMSearchFactory.remove(app.getName())) != null) {
            searchFactory.release();
        }
    }

    public void ORMIndex() {
        this.checkSearchEnabled();
        Set<String> entitySet = ORMSearchManager.getCurrentSearchFactory().getEntitySet();
        for (String entityName : entitySet) {
            this._ORMIndexPurge(entityName);
            this._ORMIndex(entityName);
        }
    }

    public void ORMIndex(Object entityNameOrInstance) {
        this.checkSearchEnabled();
        if (entityNameOrInstance instanceof String) {
            this._ORMIndex((String)entityNameOrInstance);
        } else if (entityNameOrInstance instanceof PersistentTemplateProxy) {
            this._ORMIndex_entity_Instance(entityNameOrInstance, true);
        } else if (entityNameOrInstance instanceof List) {
            HashMap<String, LinkedList<PersistentTemplateProxy>> taskMap = new HashMap<String, LinkedList<PersistentTemplateProxy>>();
            for (Object object : (List)entityNameOrInstance) {
                if (!(object instanceof PersistentTemplateProxy)) continue;
                PersistentTemplateProxy entity = (PersistentTemplateProxy)object;
                String entityName = ORMSearchManager.getEntityName((TemplateProxy)entity);
                LinkedList<PersistentTemplateProxy> taskList = (LinkedList<PersistentTemplateProxy>)taskMap.get(entityName);
                if (taskList == null) {
                    taskList = new LinkedList<PersistentTemplateProxy>();
                    taskMap.put(entityName, taskList);
                }
                taskList.add(entity);
            }
            if (taskMap.size() > 0) {
                Set keys = taskMap.keySet();
                for (String entityName : keys) {
                    LinkedList entityList = (LinkedList)taskMap.get(entityName);
                    EntityWorkSpace workSpace = ORMSearchManager.getCurrentSearchFactory().getEntityWorkSpace(entityName);
                    for (PersistentTemplateProxy entity : entityList) {
                        DocumentBuilder docBuilder = new DocumentBuilder(entityName, entity);
                        this.cleanDocumentIndex(workSpace, docBuilder);
                        AddLuceneTask task = new AddLuceneTask(entityName, docBuilder);
                        ((LuceneTask)task).performTask(workSpace);
                    }
                    workSpace.flushWriter();
                }
            }
        }
    }

    private void _ORMIndex(String entityName) {
        Array entityNameList = ListFunc.ListToArray((String)entityName, (String)",");
        for (String name : entityNameList) {
            this._ORMIndexPurge(name);
            this._ORMIndex_Entity(name);
        }
    }

    private void _ORMIndex_Entity(String entityName) {
        if (!ORMSearchManager.isEntityIndexable(entityName)) {
            throw new EntityNotIndexableException(entityName, "ORMIndex");
        }
        List entityList = ORMUtils.getPersistenceManager().load(entityName);
        EntityWorkSpace workSpace = ORMSearchManager.getCurrentSearchFactory().getEntityWorkSpace(entityName);
        for (PersistentTemplateProxy entity : entityList) {
            this._ORMIndex_entity_Instance(entity, false);
        }
        workSpace.flushWriter();
    }

    private void _ORMIndex_entity_Instance(Object entity_instance, boolean flush) {
        if (entity_instance instanceof PersistentTemplateProxy) {
            PersistentTemplateProxy entity = (PersistentTemplateProxy)entity_instance;
            String entityName = ORMSearchManager.getEntityName((TemplateProxy)entity);
            if (entityName == null) {
                throw new EntityNotIndexableException(entityName, "ORMIndex");
            }
            EntityWorkSpace workSpace = ORMSearchManager.getCurrentSearchFactory().getEntityWorkSpace(entityName);
            this._ORMIndex_entity_Instance(entity, entityName, workSpace, flush);
            if (flush) {
                workSpace.flushWriter();
            }
        }
    }

    private void _ORMIndex_entity_Instance(PersistentTemplateProxy entity, String entityName, EntityWorkSpace workSpace, boolean clearIndex) {
        DocumentBuilder docBuilder = new DocumentBuilder(entityName, entity);
        if (clearIndex) {
            this.cleanDocumentIndex(workSpace, docBuilder);
        }
        AddLuceneTask task = new AddLuceneTask(entityName, docBuilder);
        ((LuceneTask)task).performTask(workSpace);
    }

    private void cleanDocumentIndex(EntityWorkSpace workSpace, DocumentBuilder docBuilder) {
        try {
            IndexReader reader = workSpace.getIndexReader();
            Term term = docBuilder.getDocumentIndexTerm();
            int num = reader.docFreq(term);
            if (num > 0) {
                IndexWriter indexWriter = workSpace.getIndexWriter();
                indexWriter.deleteDocuments(new Term[]{term});
            }
        }
        catch (IOException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"cleanUpTaskError"), e);
        }
    }

    public void ORMIndexPurge() {
        this.checkSearchEnabled();
        Set<String> entitySet = ORMSearchManager.getCurrentSearchFactory().getEntitySet();
        for (String entityName : entitySet) {
            this._ORMIndexPurge(entityName);
        }
    }

    public void ORMIndexPurge(String entityName) {
        this.checkSearchEnabled();
        Array entityNameList = ListFunc.ListToArray((String)entityName, (String)",");
        for (String name : entityNameList) {
            if (!ORMSearchManager.isEntityIndexable(name)) {
                throw new EntityNotIndexableException(name, "ORMIndexPurge");
            }
            this._ORMIndexPurge(name);
        }
    }

    public void _ORMIndexPurge(String entityName) {
        if (!ORMSearchManager.isEntityIndexable(entityName)) {
            throw new EntityNotIndexableException(entityName, "ORMIndex");
        }
        PurgeLuceneTask task = new PurgeLuceneTask(entityName, null);
        ((LuceneTask)task).performTask(ORMSearchManager.getCurrentSearchFactory().getEntityWorkSpace(entityName));
    }

    public Object ORMSearch(String query, String entityName) {
        this.checkSearchEnabled();
        return this.ORMSearch(query, entityName, new LinkedList());
    }

    public Object ORMSearch(String query, String entityName, Object fieldNames) {
        this.checkSearchEnabled();
        return this.ORMSearch(query, entityName, fieldNames, new HashMap());
    }

    public Object ORMSearch(String query, String entityName, Object fieldNames, Map options) {
        if (entityName == null) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"NullEntityNameForSearch"));
        }
        this.checkSearchEnabled();
        Struct result = new Struct(2);
        ArrayList<Struct> entityDataList = new ArrayList<Struct>();
        int totalRecordCount = 0;
        List<String> entityNameList = this.buildEntityNameList(entityName, "ORMSearch");
        int maxResultCount = this.getNumericValueFromMap(options, "maxResults", -1);
        for (String eName : entityNameList) {
            SearchLuceneTask luceneTask = SearchQueryHelper.createSearchTask(eName, query, fieldNames, options);
            SearchQueryHelper.executeSearchTask(eName, luceneTask);
            Object tempResult = luceneTask.getResult();
            if (!(tempResult instanceof Struct)) continue;
            Struct struct = (Struct)tempResult;
            List individualEntityRecordList = (List)struct.get((Object)"DATA");
            if (individualEntityRecordList != null && individualEntityRecordList.size() > 0) {
                if (maxResultCount == -1) {
                    entityDataList.addAll(individualEntityRecordList);
                } else if (entityDataList.size() < maxResultCount) {
                    int tobeadded = maxResultCount - entityDataList.size();
                    if (individualEntityRecordList.size() <= tobeadded) {
                        entityDataList.addAll(individualEntityRecordList);
                    } else {
                        for (int i = 0; i < tobeadded; ++i) {
                            entityDataList.add((Struct)individualEntityRecordList.get(i));
                        }
                    }
                }
            }
            int individualEntityMaxRecordCount = (Integer)struct.get((Object)"MaxTotalCount");
            totalRecordCount += individualEntityMaxRecordCount;
        }
        result.put((Object)"MaxTotalCount", (Object)totalRecordCount);
        result.put((Object)"DATA", entityDataList);
        return result;
    }

    public Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected) {
        return this.ORMSearchOffline(query, entityName, fieldTobeSelected, new LinkedList());
    }

    public Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected, Object fieldNames) {
        return this.ORMSearchOffline(query, entityName, fieldTobeSelected, fieldNames, new HashMap());
    }

    public Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected, Object fieldNames, Map options) {
        if (entityName == null) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"NullEntityNameForSearch"));
        }
        if (!(fieldTobeSelected instanceof List)) {
            throw new ORMSearchException(RB.getString(ORMSearchManager.class, (String)"invalidFieldTobeSelectedParameter"));
        }
        this.checkSearchEnabled();
        List fieldTobeSelected_list = (List)fieldTobeSelected;
        if (fieldTobeSelected_list.size() == 0) {
            throw new ORMSearchException(RB.getString(ORMSearchManager.class, (String)"FieldForTobeSelectedParameter_emptyArray"));
        }
        List<String> entityNameList = this.buildEntityNameList(entityName, "ORMSearchOffline");
        Struct result = new Struct(2);
        ArrayList<Struct> entityDataList = new ArrayList<Struct>();
        int totalRecordCount = 0;
        int maxResultCount = this.getNumericValueFromMap(options, "maxResults", -1);
        for (String eName : entityNameList) {
            SearchLuceneTask luceneTask = SearchQueryHelper.createSearchTask(eName, query, fieldNames, options);
            SearchQueryHelper.executeSearchTask(eName, luceneTask);
            Object tempResult = luceneTask.getOfflineResult(fieldTobeSelected_list);
            if (!(tempResult instanceof Struct)) continue;
            Struct struct = (Struct)tempResult;
            List individualEntityRecordList = (List)struct.get((Object)"DATA");
            if (individualEntityRecordList != null && individualEntityRecordList.size() > 0) {
                if (maxResultCount == -1) {
                    entityDataList.addAll(individualEntityRecordList);
                } else if (entityDataList.size() < maxResultCount) {
                    int tobeadded = maxResultCount - entityDataList.size();
                    if (individualEntityRecordList.size() <= tobeadded) {
                        entityDataList.addAll(individualEntityRecordList);
                    } else {
                        for (int i = 0; i < tobeadded; ++i) {
                            entityDataList.add((Struct)individualEntityRecordList.get(i));
                        }
                    }
                }
            }
            int individualEntityMaxRecordCount = (Integer)struct.get((Object)"MaxTotalCount");
            totalRecordCount += individualEntityMaxRecordCount;
        }
        result.put((Object)"MaxTotalCount", (Object)totalRecordCount);
        result.put((Object)"DATA", entityDataList);
        return result;
    }

    private int getNumericValueFromMap(Map map, String key, int defaultValue) {
        Object value = map.get(key);
        if (value != null) {
            try {
                return Cast._int(value, (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void addLuceneTask(LuceneTask task) {
        LinkedList<LuceneTask> taskList;
        Map<String, LinkedList<LuceneTask>> taskMap = luceneTasks.get();
        if (taskMap == null) {
            taskMap = new Hashtable<String, LinkedList<LuceneTask>>();
            luceneTasks.set(taskMap);
        }
        if ((taskList = taskMap.get(task.getEntityName())) == null) {
            taskList = new LinkedList();
            taskMap.put(task.getEntityName(), taskList);
        }
        taskList.add(task);
    }

    public static void clearLuceneTask() {
        Map<String, LinkedList<LuceneTask>> taskMap = luceneTasks.get();
        if (taskMap != null) {
            taskMap.clear();
        }
    }

    public static Map<String, LinkedList<LuceneTask>> getAllLuceneTasks() {
        Map<String, LinkedList<LuceneTask>> taskMap = luceneTasks.get();
        if (taskMap == null) {
            return null;
        }
        return taskMap;
    }

    public void onCommit() {
        Map<String, LinkedList<LuceneTask>> taskMap;
        if (ORMSearchManager.getCurrentSearchFactory().getSearchSettings() != null && ORMSearchManager.getCurrentSearchFactory().getSearchSettings().isAutoIndex() && (taskMap = ORMSearchManager.getAllLuceneTasks()) != null && taskMap.size() > 0) {
            Set<String> keys = taskMap.keySet();
            for (String entityName : keys) {
                LinkedList<LuceneTask> tasks = taskMap.get(entityName);
                for (LuceneTask task : tasks) {
                    try {
                        LuceneTaskHelper.performLuceneTask(task);
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error((Object)e.getMessage());
                    }
                }
                ORMSearchManager.getCurrentSearchFactory().getEntityWorkSpace(entityName).flushWriter();
            }
            ORMSearchManager.clearLuceneTask();
        }
    }

    public void onFlush() {
        if (TransactionTag.getCurrent() == null) {
            this.onCommit();
        }
    }

    public void onRollBack() {
        ORMSearchManager.clearLuceneTask();
    }

    public void onPageRequestEnd() {
        this.onCommit();
    }

    public void onPageRequestEnd(Throwable t) {
        boolean flush;
        boolean bl = flush = t == null || t instanceof AbortException;
        if (flush) {
            this.onCommit();
        } else {
            ORMSearchManager.clearLuceneTask();
        }
    }

    public void onRequestEnd() {
    }

    public void onRequestStart() {
    }

    public static String getEntityName(TemplateProxy entityObj) {
        String cfcName = entityObj.getName();
        return ORMSearchManager.getCurrentSearchFactory().getEntityName(cfcName);
    }

    public static boolean isEntityIndexable(String entityName) {
        return ORMSearchManager.getCurrentSearchFactory().isEntityIndexable(entityName);
    }

    private void checkSearchEnabled() {
        FeatureRouter.getInstance().allowFeature(EFRConstants.orm_search.intValue(), null);
        String appName = FusionContext.getCurrent().getApplicationName();
        HibernateConfiguration config = ConfigurationManager.getInstance().getConfiguration(appName);
        if (config == null || !config.getORMSettings().isSearchEnabled()) {
            throw new SearchNotEnabledException("Search is not enabled for " + appName + " application");
        }
    }

    private List<String> buildEntityNameList(String entityNameStr, String callerMethodName) {
        LinkedList<String> entityNameList = new LinkedList<String>();
        if (entityNameStr.length() == 0) {
            entityNameList.addAll(ORMSearchManager.getCurrentSearchFactory().getEntitySet());
        } else {
            Array entityNames = ListFunc.ListToArray((String)entityNameStr, (String)",");
            LinkedHashSet<String> entitySet = new LinkedHashSet<String>();
            for (String entityName : entityNames) {
                if (!ORMSearchManager.isEntityIndexable(entityName)) {
                    throw new EntityNotIndexableException(entityName, callerMethodName);
                }
                Set<String> entityGraph = ORMSearchManager.getCurrentSearchFactory().getIndexHierarchy(entityName);
                if (entityGraph == null || entityGraph.size() <= 0) continue;
                entitySet.addAll(entityGraph);
            }
            entityNameList.addAll(entitySet);
        }
        return entityNameList;
    }

    public static class SearchNotEnabledException
    extends RuntimeException {
        public SearchNotEnabledException(String message) {
            super(message);
        }
    }
}

