/*
 * Decompiled with CFR 0.152.
 */
package com.zingchart;

import com.zingchart.Utils;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.TreeMap;
import org.mozilla.javascript.ScriptableObject;

public class CanvasGradient
extends ScriptableObject {
    private static final long serialVersionUID = 438270592527335643L;
    private boolean radial;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float r1;
    private float r2;
    private TreeMap<Float, String> stops = new TreeMap();
    private Paint paint;

    @Override
    public String getClassName() {
        return "CanvasGradient";
    }

    public void jsConstructor(double px1, double py1, double pr1, double px2, double py2, double pr2) {
        this.x1 = (float)px1;
        this.y1 = (float)py1;
        this.r1 = (float)pr1;
        this.x2 = (float)px2;
        this.y2 = (float)py2;
        this.r2 = (float)pr2;
        if (this.x1 == this.x2) {
            this.x2 += 1.0f;
        }
        if (this.y1 == this.y2) {
            this.y2 += 1.0f;
        }
        this.radial = pr1 != -1.0 || pr2 != -1.0;
    }

    public void jsFunction_addColorStop(double where, String color) {
        if (this.radial && this.r1 > 0.0f) {
            if (this.stops.size() == 0 && where == 0.0) {
                this.stops.put(new Float(where), color);
            }
            where = where * (double)(this.r2 - this.r1) / (double)this.r2 + (double)(this.r1 / this.r2);
        }
        if (this.stops.get(new Float(where)) != null) {
            where += where / 1000.0;
        }
        if (where < 0.0) {
            where = 0.0;
        }
        if (where > 1.0) {
            where = 1.0;
        }
        this.stops.put(new Float(where), color);
    }

    public Paint getPaint() {
        float[] where = new float[this.stops.size()];
        Color[] color = new Color[this.stops.size()];
        int i = 0;
        for (Map.Entry<Float, String> item : this.stops.entrySet()) {
            where[i] = Float.parseFloat(((Object)item.getKey()).toString());
            color[i] = Utils.parseColor(item.getValue().toString());
            ++i;
        }
        this.paint = this.radial ? new RadialGradientPaint(new Point2D.Float(this.x1, this.y1), this.r2, where, color) : new LinearGradientPaint(this.x1, this.y1, this.x2, this.y2, where, color);
        return this.paint;
    }
}

