/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.aws.lambda.client;

import coldfusion.aws.lambda.LambdaResponseUtil;
import coldfusion.aws.lambda.client.CFLambdaClient;
import coldfusion.aws.lambda.client.CFLambdaServiceConfig;
import coldfusion.aws.lambda.client.LambdaUtil;
import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Array;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.serverless.LambdaException;
import java.util.List;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;

public class CFLambdaClientImpl
implements CFLambdaClient {
    private Logger logger = CFLogs.SERVER_LOG;
    LambdaClient lambdaClient;
    LambdaClientBuilder lambdaClientBuilder = LambdaClient.builder();
    private TagAttributeList tagAttributeList;
    String credentialRegion;
    private static final String RESPONSE_STATUS_CODE = "statusCode";
    private static final String ERROR_FIELD = "errorField";
    private static final String LOG_RESULT = "logResult";
    private static final String PAYLOAD = "payload";
    private static final String EXECUTED_VERSION_FIELD = "executedVersionField";

    public CFLambdaClientImpl(AWSCredential credential, CFLambdaServiceConfig config) {
        this.logger.debug((Object)"creating lambda client");
        this.lambdaClientBuilder.credentialsProvider(LambdaUtil.getAWSCredential(credential));
        this.lambdaClientBuilder.region(Region.of((String)credential.getRegion()));
        this.lambdaClientBuilder.httpClient(ApacheHttpClient.builder().build());
        LambdaUtil.configureLambdaClientBuilder(this.lambdaClientBuilder, config);
        this.lambdaClient = (LambdaClient)this.lambdaClientBuilder.build();
        this.tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.LAMBDA.name());
        this.credentialRegion = credential.getRegion();
    }

    @Override
    public Struct InvokeFunction(String functionName) {
        return this.InvokeFunction(functionName, null);
    }

    @Override
    public Struct InvokeFunction(String functionName, Struct requestOptions) {
        try {
            Struct responseStruct = new Struct();
            InvokeResponse res = null;
            InvokeRequest.Builder requestBuilder = InvokeRequest.builder().functionName(functionName);
            if (requestOptions != null) {
                String qualifier;
                String clientContext;
                String logType;
                String invocationType;
                Object payload = requestOptions.get((Object)PAYLOAD);
                if (payload != null) {
                    String payloadString = null;
                    if (payload instanceof String) {
                        payloadString = (String)payload;
                    } else if (payload instanceof Struct) {
                        payloadString = JSONUtils.serializeJSON((Object)payload);
                    }
                    if (payloadString != null) {
                        requestBuilder.payload(SdkBytes.fromUtf8String((String)payloadString));
                    }
                }
                if ((invocationType = (String)requestOptions.get((Object)"invocationType")) != null) {
                    requestBuilder.invocationType(invocationType);
                }
                if ((logType = (String)requestOptions.get((Object)"logType")) != null) {
                    requestBuilder.logType(logType);
                }
                if ((clientContext = (String)requestOptions.get((Object)"clientContext")) != null) {
                    requestBuilder.clientContext(clientContext);
                }
                if ((qualifier = (String)requestOptions.get((Object)"qualifier")) != null) {
                    requestBuilder.qualifier(qualifier);
                }
            }
            res = this.lambdaClient.invoke((InvokeRequest)requestBuilder.build());
            String value = res.payload().asUtf8String();
            responseStruct.put((Object)RESPONSE_STATUS_CODE, (Object)res.statusCode());
            if (res.payload() != null) {
                responseStruct.put((Object)PAYLOAD, (Object)value);
            }
            if (res.functionError() != null) {
                responseStruct.put((Object)ERROR_FIELD, (Object)res.functionError());
            }
            if (res.logResult() != null) {
                responseStruct.put((Object)LOG_RESULT, (Object)res.logResult());
            }
            if (res.executedVersion() != null) {
                responseStruct.put((Object)EXECUTED_VERSION_FIELD, (Object)res.executedVersion());
            }
            return responseStruct;
        }
        catch (Exception e) {
            throw new LambdaException.LambdaServiceException(e.getMessage());
        }
    }

    @Override
    public Array ListFunctions() {
        return this.ListFunctions(null);
    }

    @Override
    public Array ListFunctions(Struct params) {
        try {
            ListFunctionsResponse functionResult = null;
            ListFunctionsRequest.Builder listFunctionsRequestBuilder = ListFunctionsRequest.builder();
            if (params != null) {
                String marker;
                String functionVersion;
                String masterRegion = (String)params.get((Object)"masterRegion");
                if (masterRegion != null) {
                    listFunctionsRequestBuilder.masterRegion(masterRegion);
                    listFunctionsRequestBuilder.functionVersion("ALL");
                }
                if ((functionVersion = (String)params.get((Object)"functionVersion")) != null) {
                    listFunctionsRequestBuilder.functionVersion(functionVersion);
                }
                if ((marker = (String)params.get((Object)"marker")) != null) {
                    listFunctionsRequestBuilder.marker(marker);
                }
                int maxItems = params.get((Object)"maxItems") != null ? (Integer)params.get((Object)"maxItems") : 10;
                listFunctionsRequestBuilder.maxItems(Integer.valueOf(maxItems));
            }
            functionResult = this.lambdaClient.listFunctions((ListFunctionsRequest)listFunctionsRequestBuilder.build());
            List list = functionResult.functions();
            Array result = LambdaResponseUtil.getListResults(list);
            return result;
        }
        catch (Exception e) {
            throw new LambdaException.LambdaServiceException(e.getMessage());
        }
    }
}

