/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel;

import coldfusion.excel.ExcelDataFormatter;
import coldfusion.excel.ExcelInfo;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDateTimeParser;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.tagext.lang.SpreadSheetTag;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.DateUtils;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.WeakHashMap;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFOptimiser;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties;

public class Excel
implements Serializable {
    private static final int MAX_WIDTH = 65280;
    public static final String XSSF_FORMAT = "XSSF";
    public static final String HSSF_FORMAT = "HSSF";
    public static final String SXSSF_FORMAT = "SXSSF";
    private Workbook workbook = null;
    private Drawing drawing = null;
    private static FormulaEvaluator evaluator = null;
    private static short defaultformat = 0;
    private static int DATETYPE = 1;
    private static int NULL = 2;
    private static int NUMERIC = 3;
    private static int STRING = 4;
    private static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss a";
    private static final SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
    private static final SimpleDateFormat dateformatter2 = new SimpleDateFormat("dd/MM/yyyy");
    private static Map<Integer, Integer> DATATYPEMAPPER;
    private static Map<String, Integer> DATATYPESTRINGMAPPER;
    private static String STRINGDATATYPE;
    private static String DATEDATATYPE;
    private static String NUMERICDATATYPE;
    private String autofilter;
    private static String value;
    private static Map<Workbook, Map<Short, CellStyle>> CELLSTYLESMAP;
    private static Map<Workbook, Map<Struct, CellStyle>> CELLSTYLESALLMAP;

    public Excel() {
        this(HSSF_FORMAT);
    }

    public Excel(String xmlformat) {
        this.createNewWorkbook("Sheet1", xmlformat, 0);
    }

    public Excel(String sheetname, String xmlformat) {
        this(sheetname, xmlformat, 0);
    }

    public Excel(String sheetname, String xmlformat, int rows) {
        this.createNewWorkbook(sheetname, xmlformat, rows);
    }

    public Excel(InputStream inp) {
        this.createNewWorkbook(inp);
    }

    private void createNewWorkbook(String sheetname) {
        this.createNewWorkbook(sheetname, HSSF_FORMAT, 0);
    }

    private void createNewWorkbook(String sheetname, String xmlformat, int rows) {
        this.workbook = xmlformat.equalsIgnoreCase(XSSF_FORMAT) ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = this.workbook.createSheet();
        this.drawing = sheet.createDrawingPatriarch();
        this.workbook.setSheetName(0, sheetname);
    }

    public static void applyRowbreaks(String rowbreaks, Sheet sheet) {
        int rows = Excel.getRowCount(sheet);
        if (Excel.isNotNull(rowbreaks)) {
            for (String row : rowbreaks.split(",")) {
                try {
                    int rownum = Integer.valueOf(row.trim());
                    if (rownum < 1 || rownum > rows) {
                        throw new SpreadSheetTag.ExcelInvalidBreaksException(row);
                    }
                    sheet.setRowBreak(rownum - 1);
                }
                catch (NumberFormatException e) {
                    throw new SpreadSheetTag.ExcelInvalidBreaksException(row);
                }
            }
        }
    }

    public static void applyColumnbreaks(String breaks, Sheet sheet) {
        int cols = Excel.getColumnCount(sheet);
        if (Excel.isNotNull(breaks)) {
            for (String col : breaks.split(",")) {
                try {
                    int colnum = Integer.valueOf(col.trim());
                    if (colnum < 1 || colnum > cols) {
                        throw new SpreadSheetTag.ExcelInvalidBreaksException(col);
                    }
                    sheet.setColumnBreak(colnum - 1);
                }
                catch (NumberFormatException e) {
                    throw new SpreadSheetTag.ExcelInvalidBreaksException(col);
                }
            }
        }
    }

    public static void applyAutofilter(String autofilter, Sheet sheet) {
        if (Excel.isNotNull(autofilter)) {
            sheet.setAutoFilter(CellRangeAddress.valueOf((String)autofilter.trim()));
        }
    }

    private static boolean isNotNull(String s) {
        return null != s && s.trim().length() != 0;
    }

    private void createNewWorkbook(InputStream inp) {
        try {
            this.workbook = WorkbookFactory.create((InputStream)inp);
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelReadException((Throwable)e);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelReadException((Throwable)e);
        }
    }

    public static void createSheet(ExcelInfo excelinfo, String sheetname) {
        Workbook book = excelinfo.getWorkbook();
        book.createSheet(sheetname);
    }

    public static void createSheet(ExcelInfo excelinfo) {
        Workbook book = excelinfo.getWorkbook();
        book.createSheet();
    }

    public static void removeSheet(ExcelInfo excelinfo, String sheetname) {
        Workbook book = excelinfo.getWorkbook();
        if (book.getNumberOfSheets() <= 1) {
            throw new SpreadSheetTag.SpreadSheetLastSheetException();
        }
        int sheetnumber = book.getSheetIndex(sheetname);
        if (sheetnumber <= -1) {
            throw new SpreadSheetTag.SpreadSheetInvalidSheetNameException(sheetname);
        }
        book.removeSheetAt(sheetnumber);
        if (excelinfo.getExcelSheetName().equalsIgnoreCase(sheetname)) {
            sheetnumber = book.getActiveSheetIndex();
            if (book instanceof XSSFWorkbook && sheetnumber >= book.getNumberOfSheets()) {
                book.setActiveSheet(--sheetnumber);
            }
            String newSheet = book.getSheetName(sheetnumber);
            excelinfo.setExcelSheetName(newSheet);
            excelinfo.setExcelSheetNumber(sheetnumber);
        } else {
            int newSheetNumber = book.getSheetIndex(excelinfo.getExcelSheetName());
            excelinfo.setExcelSheetNumber(newSheetNumber);
        }
    }

    public static void setActiveSheet(ExcelInfo excelinfo, String sheetname) {
        int index = 0;
        try {
            Workbook book = excelinfo.getWorkbook();
            index = book.getSheetIndex(sheetname);
            book.setActiveSheet(index);
            excelinfo.setExcelSheetNumber(index);
            excelinfo.setExcelSheetName(sheetname);
            excelinfo.setSheetNoProvided(false);
            Sheet s = book.getSheetAt(index);
            excelinfo.setDrawing(s.createDrawingPatriarch());
        }
        catch (IllegalArgumentException e) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException(sheetname);
        }
    }

    public static void setActiveSheet(ExcelInfo excelinfo, int sheetnumber) {
        try {
            Workbook book = excelinfo.getWorkbook();
            String sheetname = book.getSheetName(--sheetnumber);
            book.setActiveSheet(sheetnumber);
            excelinfo.setExcelSheetName(sheetname);
            excelinfo.setExcelSheetNumber(sheetnumber);
            excelinfo.setSheetNoProvided(false);
            Sheet s = book.getSheetAt(sheetnumber);
            excelinfo.setDrawing(s.createDrawingPatriarch());
        }
        catch (IllegalArgumentException e) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber);
        }
    }

    public ExcelInfo getExcelInfo() {
        ExcelInfo excelinfo = new ExcelInfo(this.workbook);
        excelinfo.setExcelRowCount(0);
        String sheetname = this.workbook.getSheetName(0);
        int sheetindex = this.workbook.getSheetIndex(sheetname);
        excelinfo.setExcelSheetName(sheetname);
        excelinfo.setExcelSheetNumber(sheetindex);
        Struct i = Excel.info(excelinfo);
        if (i != null) {
            excelinfo.setSummaryInfo(i);
        }
        if (this.drawing != null) {
            excelinfo.setDrawing(this.drawing);
        }
        return excelinfo;
    }

    public static void addInfo(ExcelInfo excel, Struct summary) {
        CaseInsensitiveMap summaryInfo = new CaseInsensitiveMap();
        Set s = summary.keySet();
        if (s.isEmpty()) {
            return;
        }
        String[] values = new String[]{"title", "author", "category", "subject", "comments", "keywords", "manager", "company"};
        for (String key : s) {
            for (String value : values) {
                if (!key.equalsIgnoreCase(value)) continue;
                summaryInfo.put((Object)value.toUpperCase(), summary.get((Object)key));
            }
        }
        if (!summaryInfo.isEmpty()) {
            excel.setSummaryInfo(summaryInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMLSummary(File file, ExcelInfo info, XSSFWorkbook book) {
        OutputStream os = null;
        try {
            POIXMLProperties prop = book.getProperties();
            PackagePropertiesPart part = prop.getCoreProperties().getUnderlyingProperties();
            CTProperties extProp = prop.getExtendedProperties().getUnderlyingProperties();
            if (null != info) {
                CaseInsensitiveMap summary = info.getSummaryInfo();
                Set set = summary.keySet();
                for (String s : set) {
                    if (s.equalsIgnoreCase("author")) {
                        part.setCreatorProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("comments")) {
                        part.setDescriptionProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("company")) {
                        extProp.setCompany((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("manager")) {
                        extProp.setManager((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("category")) {
                        part.setCategoryProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("keywords")) {
                        part.setKeywordsProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("subject")) {
                        part.setSubjectProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (!s.equalsIgnoreCase("title")) continue;
                    part.setTitleProperty((String)summary.get((Object)s));
                }
            }
            os = VFSFileFactory.getOutputStream((File)file);
            book.write(os);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.warn((Object)RB.getString((Object)new Excel(), (String)"SpreadSheet.DocumentProperties", (Object)file));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOLE2Summary(File file, ExcelInfo info) {
        InputStream is = null;
        OutputStream os = null;
        try {
            DocumentSummaryInformation dsi;
            SummaryInformation si;
            is = VFSFileFactory.getInputStream((File)file);
            POIFSFileSystem poifs = new POIFSFileSystem(is);
            is.close();
            DirectoryNode dir = poifs.getRoot();
            try {
                DocumentEntry siEntry = (DocumentEntry)dir.getEntry("\u0005SummaryInformation");
                DocumentInputStream dis = new DocumentInputStream(siEntry);
                PropertySet ps = new PropertySet((InputStream)dis);
                dis.close();
                si = new SummaryInformation(ps);
            }
            catch (FileNotFoundException ex) {
                si = PropertySetFactory.newSummaryInformation();
            }
            catch (IllegalArgumentException ex) {
                si = PropertySetFactory.newSummaryInformation();
            }
            try {
                DocumentEntry dsiEntry = (DocumentEntry)dir.getEntry("\u0005DocumentSummaryInformation");
                DocumentInputStream dis = new DocumentInputStream(dsiEntry);
                PropertySet ps = new PropertySet((InputStream)dis);
                dis.close();
                dsi = new DocumentSummaryInformation(ps);
            }
            catch (IllegalArgumentException ex) {
                dsi = PropertySetFactory.newDocumentSummaryInformation();
            }
            catch (FileNotFoundException ex) {
                dsi = PropertySetFactory.newDocumentSummaryInformation();
            }
            if (null != info) {
                CaseInsensitiveMap summary = info.getSummaryInfo();
                Set set = summary.keySet();
                for (String s : set) {
                    if (s.equalsIgnoreCase("author")) {
                        si.setAuthor((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("title")) {
                        si.setTitle((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("comments")) {
                        si.setComments((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("subject")) {
                        si.setSubject((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("keywords")) {
                        si.setKeywords((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("category")) {
                        dsi.setCategory((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("manager")) {
                        dsi.setManager((String)summary.get((Object)s));
                        continue;
                    }
                    if (!s.equalsIgnoreCase("company")) continue;
                    dsi.setCompany((String)summary.get((Object)s));
                }
            }
            si.setEditTime(Calendar.getInstance().getTime().getTime());
            si.write((DirectoryEntry)dir, "\u0005SummaryInformation");
            dsi.write((DirectoryEntry)dir, "\u0005DocumentSummaryInformation");
            os = VFSFileFactory.getOutputStream((File)file);
            poifs.writeFilesystem(os);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.warn((Object)RB.getString((Object)new Excel(), (String)"SpreadSheet.DocumentProperties", (Object)file));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Struct info(ExcelInfo excel) {
        Struct infostruct = new Struct();
        Workbook workbook = excel.getWorkbook();
        SummaryInformation summary = null;
        if (workbook instanceof HSSFWorkbook) {
            String value;
            HSSFWorkbook hssfworkbook = (HSSFWorkbook)workbook;
            try {
                summary = hssfworkbook.getSummaryInformation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DocumentSummaryInformation summary2 = null;
            try {
                summary2 = hssfworkbook.getDocumentSummaryInformation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (summary != null) {
                infostruct.put((Object)"SPREADSHEETTYPE", (Object)"Excel");
                value = summary.getAuthor();
                infostruct.put((Object)"AUTHOR", (Object)(value != null ? value : ""));
                Date d = summary.getCreateDateTime();
                if (d != null) {
                    infostruct.put((Object)"CREATIONDATE", (Object)d.toString());
                } else {
                    infostruct.put((Object)"CREATIONDATE", (Object)"");
                }
                long l = summary.getEditTime();
                value = l != 0L ? new Date(l).toString() : "";
                infostruct.put((Object)"LASTEDITED", (Object)(value != null ? value : ""));
                d = summary.getLastSaveDateTime();
                if (d != null) {
                    infostruct.put((Object)"LASTSAVED", (Object)d.toString());
                } else {
                    infostruct.put((Object)"LASTSAVED", (Object)"");
                }
                value = summary.getLastAuthor();
                infostruct.put((Object)"LASTAUTHOR", (Object)(value != null ? value : ""));
                value = summary.getTitle();
                infostruct.put((Object)"TITLE", (Object)(value != null ? value : ""));
                value = summary.getSubject();
                infostruct.put((Object)"SUBJECT", (Object)(value != null ? value : ""));
                value = summary.getKeywords();
                infostruct.put((Object)"KEYWORDS", (Object)(value != null ? value : ""));
                value = summary.getComments();
                infostruct.put((Object)"COMMENTS", (Object)(value != null ? value : ""));
            }
            if (summary2 != null) {
                value = summary2.getCategory();
                infostruct.put((Object)"CATEGORY", (Object)(value != null ? value : ""));
                value = summary2.getCompany();
                infostruct.put((Object)"COMPANY", (Object)(value != null ? value : ""));
                value = summary2.getManager();
                infostruct.put((Object)"MANAGER", (Object)(value != null ? value : ""));
            }
            int sheets = workbook.getNumberOfSheets();
            infostruct.put((Object)"SHEETS", (Object)sheets);
            if (sheets > 0) {
                String sheetname = workbook.getSheetName(0);
                for (int i = 1; i < sheets; ++i) {
                    sheetname = sheetname + "," + workbook.getSheetName(i);
                }
                infostruct.put((Object)"SHEETNAMES", (Object)sheetname);
            }
        } else if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xssfworkbook = (XSSFWorkbook)workbook;
            try {
                OleDateTime parseDateTime;
                String value = null;
                POIXMLProperties props = xssfworkbook.getProperties();
                PackagePropertiesPart partprops = props.getCoreProperties().getUnderlyingProperties();
                CTProperties extprops = props.getExtendedProperties().getUnderlyingProperties();
                infostruct.put((Object)"TITLE", (Object)partprops.getTitleProperty().orElse(""));
                infostruct.put((Object)"SUBJECT", (Object)partprops.getSubjectProperty().orElse(""));
                infostruct.put((Object)"CATEGORY", (Object)partprops.getCategoryProperty().orElse(""));
                value = partprops.getCreatedPropertyString();
                if (value != null) {
                    parseDateTime = CFDateTimeParser.parseDateTime((String)value);
                    value = dateformatter.format((Date)parseDateTime);
                }
                infostruct.put((Object)"CREATIONDATE", (Object)(value != null ? value : ""));
                infostruct.put((Object)"AUTHOR", (Object)partprops.getCreatorProperty().orElse(""));
                value = partprops.getModifiedPropertyString();
                if (value != null) {
                    parseDateTime = CFDateTimeParser.parseDateTime((String)value);
                    value = dateformatter.format((Date)parseDateTime);
                }
                infostruct.put((Object)"LASTEDITED", (Object)(value != null ? value : ""));
                infostruct.put((Object)"KEYWORDS", (Object)partprops.getKeywordsProperty().orElse(""));
                infostruct.put((Object)"LASTAUTHOR", (Object)partprops.getLastModifiedByProperty().orElse(""));
                infostruct.put((Object)"COMMENTS", (Object)partprops.getDescriptionProperty().orElse(""));
                value = extprops.getCompany();
                infostruct.put((Object)"COMPANY", (Object)(value != null ? value : ""));
                value = extprops.getManager();
                infostruct.put((Object)"MANAGER", (Object)(value != null ? value : ""));
            }
            catch (Exception value) {
                // empty catch block
            }
            infostruct.put((Object)"SPREADSHEETTYPE", (Object)"Excel (2007)");
            int sheets = xssfworkbook.getNumberOfSheets();
            infostruct.put((Object)"SHEETS", (Object)sheets);
            if (sheets > 0) {
                String sheetname = xssfworkbook.getSheetName(0);
                for (int i = 1; i < sheets; ++i) {
                    sheetname = sheetname + "," + xssfworkbook.getSheetName(i);
                }
                infostruct.put((Object)"SHEETNAMES", (Object)sheetname);
            }
        }
        return infostruct;
    }

    public static byte[] readBinary(ExcelInfo excel) {
        Workbook workbook = excel.getWorkbook();
        Excel.cleanStyles(workbook);
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("readBinary", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return out.toByteArray();
    }

    public ExcelInfo getExcelInfo(String name) {
        ExcelInfo excelinfo = new ExcelInfo(this.workbook);
        Sheet sheet = this.workbook.getSheet(name);
        if (null == sheet) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException(name);
        }
        excelinfo.setExcelRowCount(Excel.getRowCount(sheet));
        excelinfo.setExcelSheetName(name);
        excelinfo.setExcelSheetNumber(this.workbook.getSheetIndex(name));
        Struct i = Excel.info(excelinfo);
        if (i != null) {
            excelinfo.setSummaryInfo(i);
        }
        return excelinfo;
    }

    public ExcelInfo getExcelInfo(int sheetno) {
        int sheets = this.workbook.getNumberOfSheets();
        Sheet sheet = null;
        if (sheetno >= sheets) {
            return this.getExcelInfo(sheetno + 1 + "");
        }
        sheet = this.workbook.getSheetAt(sheetno);
        if (null == sheet) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno);
        }
        ExcelInfo excelinfo = new ExcelInfo(this.workbook);
        excelinfo.setExcelRowCount(Excel.getRowCount(sheet));
        excelinfo.setExcelSheetName(this.workbook.getSheetName(sheetno));
        excelinfo.setExcelSheetNumber(sheetno);
        Struct i = Excel.info(excelinfo);
        if (i != null) {
            excelinfo.setSummaryInfo(i);
        }
        return excelinfo;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private Row getRowAt(Sheet sheet, int rownum) {
        return sheet.getRow(rownum);
    }

    private static Cell getCellAt(Row row, int cellnum) {
        return row.getCell(cellnum);
    }

    private static int getRowCount(Sheet sheet) {
        if (sheet != null) {
            return sheet.getPhysicalNumberOfRows();
        }
        return 0;
    }

    public int getMaxColumnCount(int sheetnumber) {
        int count = 0;
        if (this.workbook != null) {
            Sheet sheet = this.workbook.getSheetAt(sheetnumber);
            count = Excel.getColumnCount(sheet);
        }
        return count;
    }

    public static int getColumnCount(Sheet sheet) {
        Iterator iter = sheet.iterator();
        short max = 0;
        while (iter.hasNext()) {
            Row hssfrow = (Row)iter.next();
            short cells = hssfrow.getLastCellNum();
            if (max >= cells) continue;
            max = cells;
        }
        return max;
    }

    public static Struct getCommentAt(Row hssfRow, int column) {
        Comment comment;
        Cell hssfCell = Excel.getCellAt(hssfRow, column);
        Struct c = null;
        if (hssfCell != null && (comment = hssfCell.getCellComment()) != null) {
            c = new Struct();
            String value = comment.getAuthor();
            if (value != null) {
                c.put((Object)"AUTHOR", (Object)value);
            } else {
                c.put((Object)"AUTHOR", (Object)"");
            }
            c.put((Object)"COLUMN", (Object)(comment.getColumn() + 1));
            c.put((Object)"ROW", (Object)(comment.getRow() + 1));
            RichTextString rt = comment.getString();
            if (rt != null) {
                c.put((Object)"COMMENT", (Object)rt.getString());
            } else {
                c.put((Object)"COMMENT", (Object)"");
            }
        }
        return c;
    }

    public String getFormulaAt(Row hssfRow, int column) {
        Cell hssfCell = Excel.getCellAt(hssfRow, column);
        String formula = "";
        try {
            if (hssfCell != null) {
                formula = hssfCell.getCellFormula();
            }
        }
        catch (Exception es) {
            return "";
        }
        return formula;
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    public static String getCellDateFormat(Cell cell) {
        String dt;
        CellStyle style = cell.getCellStyle();
        short i = style.getDataFormat();
        switch (i) {
            case 14: {
                dt = "MM/dd/yyyy";
                break;
            }
            case 15: {
                dt = "dd-MMM";
                break;
            }
            case 16: {
                dt = "dd-MMM-yy";
                break;
            }
            case 17: {
                dt = "MMMM-yy";
                break;
            }
            case 18: {
                dt = "hh:mm aa";
                break;
            }
            case 19: {
                dt = "hh:mm:ss aa";
                break;
            }
            case 20: {
                dt = "hh:mm";
                break;
            }
            case 21: {
                dt = "hh:mm:ss";
                break;
            }
            case 22: {
                dt = "MM/dd/yyyy hh:mm";
                break;
            }
            case 45: {
                dt = "mm:ss";
                break;
            }
            case 46: {
                dt = "hh:mm:ss";
                break;
            }
            case 47: {
                dt = "mm:ss.SSSS";
                break;
            }
            default: {
                dt = "dd-MMM-yy";
            }
        }
        return dt;
    }

    public static String getValueAt(Row hssfRow, int column) {
        if (hssfRow != null) {
            String content;
            block18: {
                Cell hssfCell = Excel.getCellAt(hssfRow, column);
                content = "";
                DataFormatter formatter = new DataFormatter();
                if (hssfCell != null) {
                    if (CellType.FORMULA != hssfCell.getCellType()) {
                        try {
                            content = formatter.formatCellValue(hssfCell);
                            if (!content.equalsIgnoreCase("")) break block18;
                            if (CellType.NUMERIC == hssfCell.getCellType()) {
                                String format = hssfCell.getCellStyle().getDataFormatString();
                                double d = hssfCell.getNumericCellValue();
                                ExcelDataFormatter formatter2 = new ExcelDataFormatter(format);
                                content = formatter2.format(d);
                            } else if (CellType.STRING == hssfCell.getCellType()) {
                                RichTextString text = hssfCell.getRichStringCellValue();
                                content = text.getString();
                            }
                        }
                        catch (Exception e) {
                            content = Excel.handleFormulaException(hssfCell);
                        }
                    } else if (evaluator != null) {
                        try {
                            content = formatter.formatCellValue(hssfCell, evaluator);
                            if (content.equalsIgnoreCase("")) {
                                content = hssfCell.getCellFormula();
                            }
                        }
                        catch (Exception e) {
                            try {
                                content = hssfCell.getNumericCellValue() + "";
                            }
                            catch (Exception ee) {
                                try {
                                    content = hssfCell.getStringCellValue() + "";
                                }
                                catch (Exception eee) {
                                    content = hssfCell.getCellFormula();
                                }
                            }
                        }
                    } else {
                        content = hssfCell.getCellFormula();
                    }
                }
            }
            return content;
        }
        return "";
    }

    private static String handleFormulaException(Cell hssfCell) {
        if (hssfCell.getCellType() == CellType.ERROR) {
            byte errorValue = hssfCell.getErrorCellValue();
            if (errorValue == FormulaError.DIV0.getCode()) {
                return "#DIV/0!";
            }
            if (errorValue == FormulaError.NA.getCode()) {
                return "#N/A";
            }
            if (errorValue == FormulaError.NAME.getCode()) {
                return "#NAME?";
            }
            if (errorValue == FormulaError.NULL.getCode()) {
                return "#NULL!";
            }
            if (errorValue == FormulaError.NUM.getCode()) {
                return "#NUM!";
            }
            if (errorValue == FormulaError.REF.getCode()) {
                return "#REF!";
            }
            if (errorValue == FormulaError.VALUE.getCode()) {
                return "#VALUE!";
            }
            return "Unknown error value: " + errorValue + "!";
        }
        return "";
    }

    public void mergeCells(ExcelInfo excelinfo, int rowfrom, int rowto, int colfrom, int colto) {
        if (colto < colfrom) {
            throw new SpreadSheetTag.MergeCellsInvalidValueException(colfrom, colto);
        }
        if (rowto < rowfrom) {
            throw new SpreadSheetTag.MergeCellsInvalidValueException(rowfrom, rowto);
        }
        Workbook book = excelinfo.getWorkbook();
        Sheet s = book.getSheet(excelinfo.getExcelSheetName());
        CellRangeAddress region = new CellRangeAddress(rowfrom - 1, rowto - 1, colfrom - 1, colto - 1);
        s.addMergedRegion(region);
        excelinfo.setExcelRowCount(Excel.getRowCount(s));
        excelinfo.setWorkbook(book);
    }

    public static void setFooter(ExcelInfo excelinfo, String lfooter, String cfooter, String rfooter) {
        Workbook b = excelinfo.getWorkbook();
        Sheet s = b.getSheet(excelinfo.getExcelSheetName());
        Footer f = s.getFooter();
        f.setCenter(cfooter);
        f.setLeft(lfooter);
        f.setRight(rfooter);
    }

    public static void setHeader(ExcelInfo excelinfo, String lheader, String cheader, String rheader) {
        Workbook b = excelinfo.getWorkbook();
        Sheet s = b.getSheet(excelinfo.getExcelSheetName());
        Header h = s.getHeader();
        h.setCenter(cheader);
        h.setLeft(lheader);
        h.setRight(rheader);
    }

    public String[] getValuesAt(Sheet sheet, int row) {
        Row hssfrow = this.getRowAt(sheet, row);
        if (hssfrow != null) {
            int lastcell = hssfrow.getLastCellNum();
            if (lastcell < 0) {
                return null;
            }
            String[] values = new String[lastcell];
            int index = 0;
            for (int cellindex = 0; cellindex < lastcell; ++cellindex) {
                values[index] = Excel.getValueAt(hssfrow, cellindex);
                ++index;
            }
            return values;
        }
        return null;
    }

    public String[] getValuesAt(int sheetno, int row) {
        Sheet sheet = this.workbook.getSheetAt(sheetno);
        CreationHelper createHelper = this.workbook.getCreationHelper();
        evaluator = createHelper.createFormulaEvaluator();
        Row hssfrow = this.getRowAt(sheet, row);
        if (hssfrow != null) {
            int firstcell = hssfrow.getFirstCellNum();
            short lastcell = hssfrow.getLastCellNum();
            String[] values = new String[lastcell - firstcell];
            int index = 0;
            for (int cellindex = firstcell; cellindex < lastcell; ++cellindex) {
                values[index] = Excel.getValueAt(hssfrow, cellindex);
                ++index;
            }
            return values;
        }
        return null;
    }

    public String[] getValuesAt(Sheet sheet, int row, Integer[] cols) {
        Row hssfrow = this.getRowAt(sheet, row);
        if (hssfrow != null) {
            String[] values = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                int colnum = cols[i];
                values[i] = Excel.getValueAt(hssfrow, colnum - 1);
            }
            return values;
        }
        return null;
    }

    public String[] getValuesAt(Sheet sheet, int row, int startcol, int endcol) {
        Row hssfrow = this.getRowAt(sheet, row);
        if (hssfrow != null) {
            short lastcell = hssfrow.getLastCellNum();
            String[] values = new String[endcol - startcol];
            if (endcol > lastcell) {
                endcol = lastcell;
            }
            int index = 0;
            for (int cellindex = startcol; cellindex < endcol; ++cellindex) {
                String value = Excel.getValueAt(hssfrow, cellindex);
                if (value == null) continue;
                values[index] = value;
                ++index;
            }
            return values;
        }
        return null;
    }

    public static void addRows(ExcelInfo info, String[] rows, int row, int colnum, boolean insert, String[] datatypes) {
        int start = row;
        int var = 0;
        String lastdatatype = null;
        int sheetContaingRows = Excel.isSheetContaingRows(info);
        if (row > 0) {
            sheetContaingRows = row;
        } else if (sheetContaingRows >= 0) {
            sheetContaingRows += 2;
        }
        for (String rowValue : rows) {
            String datatype = null;
            if (null != datatypes) {
                datatype = datatypes[var++];
            }
            if (null != datatype) {
                lastdatatype = datatype;
            }
            Excel.addRow(info, rowValue, sheetContaingRows, colnum, insert, lastdatatype);
            if (sheetContaingRows == -1) {
                sheetContaingRows += 3;
                continue;
            }
            ++sheetContaingRows;
        }
    }

    public static int isSheetContaingRows(ExcelInfo info) {
        int last;
        String sheetname;
        Workbook book = info.getWorkbook();
        Sheet sheet = book.getSheet(sheetname = info.getExcelSheetName());
        Row r = sheet.getRow(last = Excel.getLastRowNum(sheet));
        if (r == null) {
            last = -1;
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRows(ExcelInfo info, QueryTable q, int row, int colnum, boolean insert, String[] dt, boolean includeColumnHeader) {
        Workbook book = info.getWorkbook();
        CreationHelper createHelper = book.getCreationHelper();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = book.getSheet(sheetname);
        QueryTableMetaData metadata = q.getMeta();
        String[] cols = q.getColumnList();
        int len = cols.length;
        Integer[] datatypes = new Integer[len];
        Integer[] lastdatatype = new Integer[len];
        Integer[] defaultdatatype = new Integer[len];
        if (includeColumnHeader && cols != null && cols.length > 0) {
            Excel.addRow(sheet, cols, row, colnum, createHelper, insert, book, datatypes);
            if (row > 0) {
                ++row;
            }
        }
        for (int j = 0; j < cols.length; ++j) {
            try {
                datatypes[j] = metadata.getColumnType(j + 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int dtpos = 0;
        try {
            while (!q.isLast()) {
                boolean ignoreFormat;
                String property;
                coldfusion.sql.imq.Row r = q.getRow(q.getCurrentRow());
                String[] s = new String[len];
                for (int j = 0; j < cols.length; ++j) {
                    Object colValue = r.getColumn(j);
                    if (colValue != null) {
                        if (colValue instanceof char[]) {
                            s[j] = new String((char[])colValue);
                            continue;
                        }
                        s[j] = colValue.toString();
                        continue;
                    }
                    s[j] = "";
                }
                if (null != dt) {
                    if (null != (datatypes = Excel.getParsedDatatypes(dt[dtpos++], cols.length))) {
                        lastdatatype = datatypes;
                    }
                } else {
                    lastdatatype = datatypes;
                }
                if ((property = System.getProperty("coldfusion.spreadsheet.ignoreformat")) != null && (ignoreFormat = Boolean.parseBoolean(property))) {
                    lastdatatype = defaultdatatype;
                }
                Excel.addRow(sheet, s, row, colnum, createHelper, insert, book, lastdatatype);
                if (row > 0) {
                    ++row;
                }
                q.next();
            }
        }
        finally {
            q.close();
        }
        info.setExcelRowCount(Excel.getRowCount(sheet));
    }

    public static void addRows(ExcelInfo info, QueryTable q, int row, int colnum, boolean insert, String[] dt) {
        Excel.addRows(info, q, row, colnum, insert, dt, false);
    }

    public void addRow(ExcelInfo info, String row, boolean insert) {
        Excel.addRow(info, row, -1, 0, insert, null);
    }

    public static void autoResize(ExcelInfo excelObj, Object autosize) {
        Excel.autoResize(excelObj, false, autosize);
    }

    public static void autoResize(ExcelInfo excelObj, boolean useMergedColumns, Object autosize) {
        Workbook workbook = excelObj.getWorkbook();
        ArrayList ignore_columns = excelObj.getIgnoreColumnsForAutoResize();
        int numberOfSheets = workbook.getNumberOfSheets();
        Sheet sheet = null;
        for (int i = 0; i < numberOfSheets; ++i) {
            sheet = workbook.getSheetAt(i);
            Excel.autoResize(sheet, useMergedColumns, ignore_columns, autosize);
        }
    }

    public static void autoResize(Sheet sheet, boolean useMergedColumns, ArrayList ignore_columns, Object autosize) {
        FastArray cols = null;
        if (CFPage.IsBoolean((Object)autosize)) {
            boolean isautosize = Cast._boolean((Object)autosize);
            if (!isautosize) {
                return;
            }
        } else {
            cols = (FastArray)autosize;
        }
        int columns = Excel.getColumnCount(sheet);
        for (int i = 0; i < columns; ++i) {
            if (cols != null && !cols.contains((Object)(i + 1 + ""))) continue;
            if (ignore_columns != null) {
                if (ignore_columns.contains(i + 1)) continue;
                sheet.autoSizeColumn(i, useMergedColumns);
                continue;
            }
            sheet.autoSizeColumn(i, useMergedColumns);
        }
    }

    public static void autoResize(ExcelInfo excelObj, int column) {
        Excel.autoResize(excelObj, column, false);
    }

    public static void autoResize(ExcelInfo excelObj, int column, boolean useMergedColumns) {
        Workbook workbook = excelObj.getWorkbook();
        ArrayList ignore_columns = excelObj.getIgnoreColumnsForAutoResize();
        int numberOfSheets = workbook.getNumberOfSheets();
        Sheet sheet = null;
        for (int i = 0; i < numberOfSheets; ++i) {
            sheet = workbook.getSheetAt(i);
            if (ignore_columns.contains(column)) continue;
            sheet.autoSizeColumn(column - 1, useMergedColumns);
        }
    }

    public static void addRow(ExcelInfo info, String row, int rownum, int colnum, boolean insert, String datatype) {
        String[] strArray = Excel.getParsedValue(row);
        Integer[] datatypeArray = Excel.getParsedDatatypes(datatype, strArray.length);
        Excel.addRow(info, strArray, rownum, colnum, insert, datatypeArray);
    }

    public static Integer[] getParsedDatatypes(String datatype, int size) {
        String[] dtsplit;
        if (null == datatype || "".equals(datatype.trim())) {
            return null;
        }
        Integer[] intList = new Integer[size];
        int var = 0;
        for (String type : dtsplit = datatype.split(";")) {
            ++var;
            String[] split = type.trim().split(":");
            if (split.length > 2) {
                throw new SpreadSheetTag.ExcelInvalidDatatypevalueException(datatype);
            }
            String dt = split[0].trim();
            if (!Excel.isValidDatatype(dt)) {
                throw new SpreadSheetTag.ExcelInvalidDatatypeException(dt);
            }
            if (split.length == 1) {
                if (var != dtsplit.length) {
                    throw new SpreadSheetTag.ExcelNoColumnDatatypeException(dt);
                }
                for (int i = 0; i < size; ++i) {
                    if (intList[i] != null) continue;
                    intList[i] = DATATYPESTRINGMAPPER.get(dt);
                }
                continue;
            }
            for (String s : split[1].trim().split(",")) {
                int pos = -1;
                if (s.contains("-")) {
                    String[] hyphensplit = s.split("-");
                    try {
                        int startindex = Integer.parseInt(hyphensplit[0].trim());
                        int lastindex = Integer.parseInt(hyphensplit[1].trim());
                        if (lastindex <= startindex || startindex < 1 || lastindex > size) {
                            throw new SpreadSheetTag.ExcelInvalidDatatypeRangeNumberException(s);
                        }
                        for (int k = startindex; k <= lastindex; ++k) {
                            intList[k - 1] = DATATYPESTRINGMAPPER.get(dt);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new SpreadSheetTag.ExcelInvalidDatatypeRangeNumberException(s);
                    }
                }
                try {
                    pos = Integer.parseInt(s.trim());
                    if (pos > size || pos < 1) {
                        throw new SpreadSheetTag.ExcelInvalidDatatypeColNumberException(s);
                    }
                }
                catch (Exception e) {
                    throw new SpreadSheetTag.ExcelInvalidDatatypeColNumberException(s);
                }
                intList[pos - 1] = DATATYPESTRINGMAPPER.get(dt);
            }
        }
        return intList;
    }

    private static boolean isValidDatatype(String dt) {
        for (String datatype : DATATYPESTRINGMAPPER.keySet()) {
            if (!datatype.equalsIgnoreCase(dt)) continue;
            return true;
        }
        return false;
    }

    public void addRow(ExcelInfo info, String[] row, boolean insert) {
        Excel.addRow(info, row, -1, 0, insert, null);
    }

    public static void addRow(Sheet sheet, String[] row, int rownum, int colnum, CreationHelper createHelper, boolean insert, Workbook book, Integer[] datatypes) {
        int last = Excel.getLastRowNum(sheet);
        Row r = sheet.getRow(last);
        rownum = rownum < 0 ? (last == 0 && r == null ? last : last + 1) : --rownum;
        r = sheet.getRow(rownum);
        if (r != null) {
            if (insert) {
                sheet.shiftRows(rownum, last, 1, true, true);
            } else {
                sheet.removeRow(r);
            }
        }
        r = sheet.createRow(rownum);
        if (colnum > 0) {
            --colnum;
        }
        for (int index = 0; index < row.length; ++index) {
            Cell c = r.createCell(colnum + index);
            String value = row[index];
            try {
                boolean attemptDouble = true;
                String tmpValue = value.trim();
                Integer type = null;
                if (null != datatypes) {
                    type = datatypes[index];
                }
                if (null == type) {
                    if (tmpValue.length() > 0 && !Character.isDigit(tmpValue.charAt(tmpValue.length() - 1))) {
                        attemptDouble = false;
                    }
                    if (attemptDouble) {
                        double i = Double.parseDouble(value);
                        Excel.createNumericCell(c, i);
                        continue;
                    }
                    Excel.createNonNumericCell(book, c, value, createHelper);
                    continue;
                }
                Excel.createDatatypeAwareCell(type, c, value, createHelper, book);
                continue;
            }
            catch (NumberFormatException e) {
                Excel.createNonNumericCell(book, c, value, createHelper);
            }
        }
    }

    private static void createNonNumericCell(Workbook book, Cell c, String value, CreationHelper createHelper) {
        if (!value.equalsIgnoreCase("")) {
            String lValue = value.toLowerCase();
            if (!lValue.endsWith("p") && !lValue.endsWith("a") && DateUtils.isDate((Object)value.trim())) {
                Excel.createDateCell(book, c, value, createHelper);
            } else {
                Excel.createStringCell(c, value, createHelper);
            }
        } else {
            Excel.createBlankCell(c, createHelper);
        }
    }

    private static void createNumericCell(Cell c, double value) {
        c.setCellType(CellType.NUMERIC);
        c.setCellValue(value);
    }

    private static void createDateCell(Workbook book, Cell c, String value, CreationHelper createHelper) {
        c.setCellType(CellType.NUMERIC);
        Date date = DateUtils.parseDateTime((String)value);
        if (DateUtils.getYear((Date)date) == 1899 && DateUtils.getMonth((Date)date) == 12 && DateUtils.getDayOfMonth((Date)date) == 30) {
            date = DateUtils.addDate((String)"d", (int)2, (Date)date);
        }
        c.setCellValue(date);
        CellStyle cs = null;
        short poiformat = Excel.getDateFormat(value, date, createHelper);
        Map<Short, CellStyle> csbookmap = CELLSTYLESMAP.get(book);
        if (csbookmap != null) {
            cs = csbookmap.get(poiformat);
        } else {
            CELLSTYLESMAP.put(book, new HashMap());
        }
        if (cs == null) {
            cs = book.createCellStyle();
            cs.setDataFormat(poiformat);
            CELLSTYLESMAP.get(book).put(poiformat, cs);
        }
        c.setCellStyle(cs);
    }

    private static short getDateFormat(String dateValue, Date dateObj, CreationHelper createHelper) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateObj);
        short day = (short)cal.get(5);
        short month = (short)(cal.get(2) + 1);
        short year = (short)cal.get(1);
        short hour = (short)cal.get(11);
        short hour2 = (short)cal.get(10);
        short minute = (short)cal.get(12);
        short second = (short)cal.get(13);
        StringBuilder buf = new StringBuilder();
        ArrayList<String> formatArray = new ArrayList<String>();
        ArrayList<String> formatTimeArray = new ArrayList<String>();
        String formatTimeStr = "";
        String formatStr = "";
        boolean dayAdded = false;
        boolean monthAdded = false;
        boolean yearAdded = false;
        boolean hourAdded = false;
        boolean minuteAdded = false;
        boolean secondAdded = false;
        dateValue = dateValue.trim();
        boolean defaultDate = Excel.isDefaultDate(dateObj);
        for (int i = 0; i < dateValue.length(); ++i) {
            char ch = dateValue.charAt(i);
            if (!Character.isDigit(ch)) {
                try {
                    short value;
                    try {
                        value = Short.parseShort(buf.toString());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (value == day && !dayAdded && !defaultDate) {
                        formatArray.add("dd");
                        dayAdded = true;
                    } else if (value == month && !monthAdded && !defaultDate) {
                        formatArray.add("mm");
                        monthAdded = true;
                    } else if (value == year || (year + "").endsWith(buf.toString()) && !yearAdded && !defaultDate) {
                        formatArray.add("yyyy");
                        yearAdded = true;
                    } else if (!(value != hour && value != hour2 || hourAdded)) {
                        formatTimeArray.add("h");
                        hourAdded = true;
                    } else if (value == minute && !minuteAdded) {
                        formatTimeArray.add("mm");
                        minuteAdded = true;
                    } else if (value == second && !secondAdded) {
                        formatTimeArray.add("ss");
                        secondAdded = true;
                    }
                }
                catch (Exception e) {
                    return Excel.getDefaultFormat(createHelper);
                }
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            try {
                short value = Short.parseShort(buf.toString());
                if (value == day && !dayAdded) {
                    formatArray.add("dd");
                } else if (value == month && !monthAdded) {
                    formatArray.add("mm");
                } else if (value == year && !yearAdded) {
                    formatArray.add("yyyy");
                } else if (value == hour && !hourAdded) {
                    formatTimeArray.add("h");
                } else if (value == minute && !minuteAdded) {
                    formatTimeArray.add("mm");
                } else if (value == second && !secondAdded) {
                    formatTimeArray.add("ss");
                }
            }
            catch (Exception e) {
                return Excel.getDefaultFormat(createHelper);
            }
        }
        if (formatArray.size() < 3 && formatTimeArray.size() < 2) {
            return Excel.getDefaultFormat(createHelper);
        }
        if (formatArray.size() >= 3) {
            formatStr = (String)formatArray.get(0) + "/" + (String)formatArray.get(1) + "/" + (String)formatArray.get(2);
        }
        if (formatTimeArray.size() >= 2) {
            if (formatTimeArray.size() == 2 && (hour != 0 || minute != 0)) {
                formatTimeStr = (String)formatTimeArray.get(0) + ":" + (String)formatTimeArray.get(1);
            } else if (formatTimeArray.size() == 3 && (hour != 0 || minute != 0 || second != 0)) {
                formatTimeStr = (String)formatTimeArray.get(0) + ":" + (String)formatTimeArray.get(1) + ":" + (String)formatTimeArray.get(2);
            }
        }
        return createHelper.createDataFormat().getFormat(formatStr + " " + formatTimeStr);
    }

    private static boolean isDefaultDate(Date dateObj) {
        int year = dateObj.getYear();
        int month = dateObj.getMonth();
        int day = dateObj.getDate();
        return year == 0 && month == 0 && day == 1;
    }

    private static short getDefaultFormat(CreationHelper createHelper) {
        return createHelper.createDataFormat().getFormat("mm/dd/yyyy");
    }

    private static void createStringCell(Cell c, String value, CreationHelper createHelper) {
        c.setCellType(CellType.STRING);
        RichTextString str = createHelper.createRichTextString(value);
        c.setCellValue(str);
    }

    private static void createBlankCell(Cell c, CreationHelper createHelper) {
        c.setCellType(CellType.BLANK);
        c.setCellValue(createHelper.createRichTextString(""));
    }

    public static void addRow(ExcelInfo info, String[] row, int rownum, int colnum, boolean insert, Integer[] datatypes) {
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            CreationHelper createHelper = book.getCreationHelper();
            Excel.addRow(sheet, row, rownum, colnum, createHelper, insert, book, datatypes);
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("addRow", (Throwable)e);
        }
    }

    public static void addColumn(ExcelInfo info, String column, String datatype) {
        Excel.addColumn(info, column, -1, -1, true, datatype);
    }

    public static void addColumn(ExcelInfo info, String column, int rownum, int colnum, boolean insert, String datatype) {
        String[] strArray = Excel.getParsedValue(column);
        Integer[] dtArray = Excel.getParsedDatatypes(datatype, strArray.length);
        Excel.addColumn(info, strArray, rownum, colnum, insert, dtArray);
    }

    private static boolean canParse(String currentString, String next, int currentIndex, int totalLength, int count, boolean parsed) {
        if (currentString.startsWith("'") && currentString.endsWith("'")) {
            return !parsed;
        }
        return !parsed && count > 1 && currentIndex + 1 != totalLength && currentString.startsWith("'") && !next.startsWith("'");
    }

    private static String[] getParsedValue(String value) {
        ArrayList<String> s1 = new ArrayList<String>();
        String[] s = value.split(",");
        int count = value.replaceAll("[^']", "").length();
        if (count <= 1) {
            for (String temp : s) {
                s1.add(temp);
            }
        } else {
            boolean parsed = false;
            StringBuilder temp = null;
            for (int i = 0; i < s.length; ++i) {
                String tempStr = s[i];
                String next = "";
                if (i + 1 < s.length) {
                    next = s[i + 1];
                }
                if (Excel.canParse(tempStr, next, i, s.length, count, parsed)) {
                    if (!tempStr.endsWith("'")) {
                        parsed = true;
                        temp = new StringBuilder();
                        temp.append(tempStr.replaceFirst("'", ""));
                    } else if (!(tempStr = tempStr.replaceFirst("'", "")).equals("")) {
                        tempStr = tempStr.substring(0, tempStr.length() - 1);
                    }
                } else if (parsed) {
                    if (tempStr.endsWith("'")) {
                        if (temp != null) {
                            temp.append("," + tempStr.substring(0, tempStr.length() - 1));
                        }
                        parsed = false;
                    } else if (temp != null) {
                        temp.append("," + tempStr);
                    }
                }
                if (!parsed || i + 1 == s.length) {
                    if (temp != null) {
                        s1.add(temp.toString());
                        temp = null;
                    } else {
                        s1.add(tempStr);
                    }
                }
                count -= tempStr.replaceAll("[^']", "").length();
            }
        }
        String[] strArray = new String[s1.size()];
        s1.toArray(strArray);
        return strArray;
    }

    public static void shiftRows(ExcelInfo info, int from, int to, int unit) {
        try {
            if (unit != 0) {
                Workbook book = info.getWorkbook();
                String sheetname = info.getExcelSheetName();
                Sheet sheet = book.getSheet(sheetname);
                to = to < 0 ? Excel.getLastRowNum(sheet) : --to;
                sheet.shiftRows(from - 1, to, unit);
                info.setExcelRowCount(Excel.getRowCount(sheet));
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelInvalidArgumentRowException((Throwable)e);
        }
    }

    public static void shiftRows(ExcelInfo info, int from, int unit) {
        try {
            if (unit != 0) {
                Excel.shiftRows(info, from, -1, unit);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("shiftRows", (Throwable)e);
        }
    }

    public static void shiftColumns(ExcelInfo info, int from, int unit) {
        try {
            if (unit != 0) {
                Excel.shiftColumns(info, from, -1, unit);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("shiftColumns", (Throwable)e);
        }
    }

    private static void copyCell(Cell fromcell, Cell tocell) {
        Comment comment;
        CellStyle style;
        CellType celltype = fromcell.getCellType();
        if (celltype == CellType.NUMERIC) {
            Date d = fromcell.getDateCellValue();
            if (d != null) {
                tocell.setCellValue(d);
            } else {
                tocell.setCellValue(fromcell.getNumericCellValue());
            }
        } else if (celltype == CellType.BOOLEAN) {
            tocell.setCellValue(fromcell.getBooleanCellValue());
        } else if (celltype == CellType.ERROR) {
            tocell.setCellErrorValue(fromcell.getErrorCellValue());
        } else if (celltype == CellType.FORMULA) {
            tocell.setCellFormula(fromcell.getCellFormula());
        } else if (celltype == CellType.STRING) {
            tocell.setCellValue(fromcell.getRichStringCellValue());
        }
        Hyperlink hyper = fromcell.getHyperlink();
        if (hyper != null) {
            tocell.setHyperlink(hyper);
        }
        if ((style = fromcell.getCellStyle()) != null) {
            tocell.setCellStyle(style);
        }
        if ((comment = fromcell.getCellComment()) != null) {
            tocell.setCellComment(comment);
        }
    }

    private static void moveCell(Row row, Cell cell, int column) {
        if (column < 0) {
            throw new SpreadSheetTag.ExcelInvalidCellValue();
        }
        Cell c1 = row.getCell(column);
        if (c1 != null) {
            throw new SpreadSheetTag.ExcelInvalidArgumentException(column);
        }
        c1 = row.createCell(column, cell.getCellType());
        Excel.copyCell(cell, c1);
        row.removeCell(cell);
    }

    private static void updateNewMergedRegion(Sheet s, CellRangeAddress[] address, int fromcol, int tocol, int unit) {
        CellRangeAddress r = null;
        ArrayList<Integer> mergedIndices = new ArrayList<Integer>();
        for (int i = 0; i < address.length; ++i) {
            r = address[i];
            if (r.getFirstColumn() < fromcol || r.getLastColumn() > tocol) continue;
            mergedIndices.add(i);
        }
        if (mergedIndices.size() == 0) {
            return;
        }
        Collections.reverse(mergedIndices);
        Iterator iterator = mergedIndices.iterator();
        while (iterator.hasNext()) {
            int mergedIndex = (Integer)iterator.next();
            s.removeMergedRegion(mergedIndex);
            r = address[mergedIndex];
            int orig = r.getFirstColumn();
            r.setFirstColumn(orig + unit);
            orig = r.getLastColumn();
            r.setLastColumn(orig + unit);
            s.addMergedRegion(r);
        }
    }

    private static ArrayList<Integer> getOriginalWidth(Sheet s, int fromcol, int tocol) {
        if (tocol < 0) {
            tocol = Excel.getColumnCount(s);
        }
        ArrayList<Integer> widths = new ArrayList<Integer>();
        for (int i = fromcol; i <= tocol; ++i) {
            widths.add(s.getColumnWidth(i));
        }
        return widths;
    }

    private static void applyWidth(Sheet s, int fromcol, int tocol, int unit, ArrayList<Integer> widths) {
        if (tocol < 0) {
            tocol = Excel.getColumnCount(s);
        }
        int index = 0;
        for (int i = fromcol; i <= tocol; ++i) {
            s.setColumnWidth(i + unit, widths.get(index++).intValue());
        }
    }

    public static void shiftColumns(ExcelInfo info, int from, int to, int unit) {
        if (unit != 0) {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int startrow = Excel.getFirstRowNum(sheet);
            int lastrow = Excel.getLastRowNum(sheet);
            --from;
            if (to > 0) {
                --to;
            }
            int to_save = to;
            int maxcol = to;
            CellRangeAddress[] mergedRegions = Excel.getMergedRegions(sheet);
            ArrayList<Integer> widths = Excel.getOriginalWidth(sheet, from, to);
            Excel.applyWidth(sheet, from, to, unit, widths);
            for (int j = startrow; j <= lastrow; ++j) {
                Cell c;
                int k;
                Row row = sheet.getRow(j);
                to = to_save;
                if (row == null) continue;
                if (unit > 0) {
                    if (to < 0) {
                        to = row.getLastCellNum();
                    }
                    if (to > maxcol) {
                        maxcol = to;
                    }
                    for (k = to; k >= from; --k) {
                        c = row.getCell(k);
                        if (c == null) continue;
                        Excel.moveCell(row, c, k + unit);
                    }
                    continue;
                }
                if (to < 0) {
                    to = row.getLastCellNum();
                }
                if (to > maxcol) {
                    maxcol = to;
                }
                for (k = from; k <= to; ++k) {
                    c = row.getCell(k);
                    if (c == null) continue;
                    Excel.moveCell(row, c, k + unit);
                }
            }
            if (mergedRegions.length > 0) {
                Excel.updateNewMergedRegion(sheet, mergedRegions, from, maxcol, unit);
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
    }

    public static void addColumn(ExcelInfo info, String[] column, int rownum, int colnum, boolean insert, Integer[] dt) {
        try {
            if (insert && colnum > 0) {
                Excel.shiftColumns(info, colnum, 1);
            }
            Excel.insertColumn(info, column, rownum, colnum, dt);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("addColumn", (Throwable)e);
        }
    }

    public static void insertColumn(ExcelInfo info, String[] column, int rownum, int colnum, Integer[] dt) {
        Workbook book = info.getWorkbook();
        CreationHelper createHelper = book.getCreationHelper();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = book.getSheet(sheetname);
        int startrow = rownum < 0 ? Excel.getFirstRowNum(sheet) : rownum - 1;
        if (startrow == -1) {
            startrow = 0;
        }
        int index = 0;
        Row row = sheet.getRow(startrow);
        if (row == null) {
            row = sheet.createRow(startrow);
            row.createCell(0);
            if (colnum < 0) {
                colnum = 0;
            }
        }
        if (colnum < 0) {
            colnum = row.getLastCellNum();
        } else if (colnum != 0) {
            --colnum;
        }
        int last = startrow + column.length;
        for (int j = startrow; j < last; ++j) {
            Cell c2;
            block17: {
                row = sheet.getRow(j);
                if (row == null) {
                    row = sheet.createRow(j);
                }
                Cell c1 = row.getCell(colnum) == null ? row.createCell(colnum) : row.getCell(colnum);
                c2 = row.getCell(colnum + 1);
                String value = column[index];
                Integer type = null;
                if (null != dt) {
                    type = dt[index];
                }
                if (null == type) {
                    try {
                        double i = Double.parseDouble(value);
                        c1.setCellValue(i);
                        c1.setCellType(CellType.NUMERIC);
                    }
                    catch (NumberFormatException e) {
                        if (!value.equalsIgnoreCase("")) {
                            RichTextString str = createHelper.createRichTextString(value);
                            c1.setCellValue(str);
                            int colwidth = sheet.getColumnWidth(colnum);
                            short len = (short)value.length();
                            len = (short)((double)(len * 8) / 0.05);
                            if (colwidth < len) {
                                sheet.setColumnWidth(colnum, len + 1);
                            }
                            c1.setCellType(CellType.STRING);
                            break block17;
                        }
                        c1.setCellValue(createHelper.createRichTextString(""));
                        c1.setCellType(CellType.BLANK);
                    }
                } else {
                    try {
                        Excel.createDatatypeAwareCell(type, c1, value, createHelper, book);
                    }
                    catch (NumberFormatException e) {
                        Excel.createNonNumericCell(book, c1, value, createHelper);
                    }
                }
            }
            ++index;
            if (c2 == null) continue;
        }
        info.setExcelRowCount(Excel.getRowCount(sheet));
    }

    private static void createDatatypeAwareCell(Integer type, Cell c1, String value, CreationHelper createHelper, Workbook book) {
        Integer mappedtype = DATATYPEMAPPER.get(type);
        if (null == mappedtype) {
            Excel.createStringCell(c1, value, createHelper);
        } else if (NULL == mappedtype || value != null && value.trim().length() == 0) {
            Excel.createBlankCell(c1, createHelper);
        } else if (NUMERIC == mappedtype) {
            Excel.createNumericCell(c1, Double.parseDouble(value));
        } else if (DATETYPE == mappedtype) {
            Excel.createDateCell(book, c1, value, createHelper);
        } else {
            Excel.createStringCell(c1, value, createHelper);
        }
    }

    public void deleteRows(ExcelInfo info, String range) {
        block6: {
            try {
                Workbook book = info.getWorkbook();
                String sheetname = info.getExcelSheetName();
                Sheet sheet = book.getSheet(sheetname);
                if (sheet == null) break block6;
                if (range.contains(",")) {
                    Integer[] rows = Excel.doProcessList(range);
                    for (int i = 0; i < rows.length; ++i) {
                        int rownum = rows[i];
                        Row r = sheet.getRow(rownum - 1);
                        if (r == null) continue;
                        sheet.removeRow(r);
                    }
                } else {
                    int[] rows = Excel.doProcessRange(range);
                    int startrow = rows[0];
                    int endrow = rows[1];
                    for (int i = startrow; i <= endrow; ++i) {
                        Row r = sheet.getRow(i - 1);
                        if (r == null) continue;
                        sheet.removeRow(r);
                    }
                }
                info.setExcelRowCount(Excel.getRowCount(sheet));
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("deleteRows", (Throwable)e);
            }
        }
    }

    public void deleteRow(ExcelInfo info, int rownum) {
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row r = sheet.getRow(rownum - 1);
            if (r != null) {
                sheet.removeRow(r);
                info.setExcelRowCount(Excel.getRowCount(sheet));
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("deleteRow", (Throwable)e);
        }
    }

    public void deleteColumn(ExcelInfo info, int colnum) {
        try {
            int first;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int last = Excel.getLastRowNum(sheet);
            for (int i = first = Excel.getFirstRowNum(sheet); i <= last; ++i) {
                Cell c;
                Row r = sheet.getRow(i);
                if (r == null || (c = r.getCell(colnum - 1)) == null) continue;
                r.removeCell(c);
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("deleteColumn", (Throwable)e);
        }
    }

    public void deleteColumns(ExcelInfo info, String range) {
        try {
            int first;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int last = Excel.getLastRowNum(sheet);
            for (int j = first = Excel.getFirstRowNum(sheet); j <= last; ++j) {
                Cell c;
                Object object;
                Object[] rows;
                Row r = sheet.getRow(j);
                if (range.contains(",")) {
                    rows = Excel.doProcessList(range);
                    for (object = 0; object < rows.length; ++object) {
                        int colnum = rows[object];
                        if (r == null || (c = r.getCell(colnum - 1)) == null) continue;
                        r.removeCell(c);
                    }
                    continue;
                }
                rows = Excel.doProcessRange(range);
                object = rows[0];
                Integer endcol = rows[1];
                for (Object object2 = object; object2 <= endcol; ++object2) {
                    if (r == null || (c = r.getCell(object2 - 1)) == null) continue;
                    r.removeCell(c);
                }
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("deleteColumns", (Throwable)e);
        }
    }

    private static short getHSSFColor(String value) {
        try {
            HSSFColor.HSSFColorPredefined color = HSSFColor.HSSFColorPredefined.valueOf((String)value.toUpperCase());
            return color.getIndex();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static BorderStyle getBorderStyle(String style) {
        if (style.equalsIgnoreCase("NONE")) {
            return BorderStyle.NONE;
        }
        if (style.equalsIgnoreCase("THIN")) {
            return BorderStyle.THIN;
        }
        if (style.equalsIgnoreCase("MEDIUM")) {
            return BorderStyle.MEDIUM;
        }
        if (style.equalsIgnoreCase("DASHED")) {
            return BorderStyle.DASHED;
        }
        if (style.equalsIgnoreCase("HAIR")) {
            return BorderStyle.HAIR;
        }
        if (style.equalsIgnoreCase("THICK")) {
            return BorderStyle.THICK;
        }
        if (style.equalsIgnoreCase("DOUBLE")) {
            return BorderStyle.DOUBLE;
        }
        if (style.equalsIgnoreCase("DOTTED")) {
            return BorderStyle.DOTTED;
        }
        if (style.equalsIgnoreCase("MEDIUM_DASHED")) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (style.equalsIgnoreCase("DASH_DOT")) {
            return BorderStyle.DASH_DOT;
        }
        if (style.equalsIgnoreCase("MEDIUM_DASH_DOT")) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (style.equalsIgnoreCase("DASH_DOT_DOT")) {
            return BorderStyle.DASH_DOT_DOT;
        }
        if (style.equalsIgnoreCase("MEDIUM_DASH_DOT_DOT")) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (style.equalsIgnoreCase("SLANTED_DASH_DOT")) {
            return BorderStyle.SLANTED_DASH_DOT;
        }
        return BorderStyle.NONE;
    }

    private static void mergeFonts(Font srcFont, Font destFont) {
        if (!srcFont.equals(destFont)) {
            destFont.setBold(srcFont.getBold());
            destFont.setCharSet(srcFont.getCharSet());
            destFont.setColor(srcFont.getColor());
            destFont.setFontHeight(srcFont.getFontHeight());
            destFont.setFontName(srcFont.getFontName());
            destFont.setItalic(srcFont.getItalic());
            destFont.setStrikeout(srcFont.getStrikeout());
            destFont.setTypeOffset(srcFont.getTypeOffset());
            destFont.setUnderline(srcFont.getUnderline());
        }
    }

    private static void mergeCellStyles(CellStyle src, CellStyle dest) {
        dest.setAlignment(src.getAlignmentEnum());
        dest.setBorderBottom(src.getBorderBottomEnum());
        dest.setBorderLeft(src.getBorderLeftEnum());
        dest.setBorderRight(src.getBorderRightEnum());
        dest.setBorderTop(src.getBorderTopEnum());
        dest.setBottomBorderColor(src.getBottomBorderColor());
        dest.setDataFormat(src.getDataFormat());
        dest.setFillBackgroundColor(src.getFillBackgroundColor());
        dest.setFillForegroundColor(src.getFillForegroundColor());
        dest.setFillPattern(src.getFillPatternEnum());
        dest.setHidden(src.getHidden());
        dest.setIndention(src.getIndention());
        dest.setLeftBorderColor(src.getLeftBorderColor());
        dest.setLocked(src.getLocked());
        dest.setRightBorderColor(src.getRightBorderColor());
        dest.setRotation(src.getRotation());
        dest.setTopBorderColor(src.getTopBorderColor());
        dest.setVerticalAlignment(src.getVerticalAlignmentEnum());
        dest.setWrapText(src.getWrapText());
    }

    private static Font findFont(Workbook book, Font f, Struct format) {
        Font font;
        boolean boldWeight = f.getBold();
        short color = f.getColor();
        short fontHeight = f.getFontHeight();
        String name = f.getFontName();
        boolean italic = f.getItalic();
        boolean strikeout = f.getStrikeout();
        short typeOffset = f.getTypeOffset();
        byte underline = f.getUnderline();
        Object value = null;
        value = format.get((Object)"font");
        if (value != null) {
            name = (String)value;
        }
        if ((value = format.get((Object)"fontsize")) != null) {
            fontHeight = Cast._short((Object)value, (boolean)false);
            fontHeight = (short)(fontHeight * 20);
        }
        if ((value = format.get((Object)"color")) != null) {
            value = ((String)value).toUpperCase();
            color = Excel.getHSSFColor((String)value);
        }
        if ((value = format.get((Object)"italic")) != null) {
            italic = Cast._boolean((Object)value);
        }
        if ((value = format.get((Object)"strikeout")) != null) {
            strikeout = Cast._boolean((Object)value);
        }
        if ((value = format.get((Object)"bold")) != null && Cast._boolean((Object)value)) {
            boldWeight = true;
        }
        if ((value = format.get((Object)"underline")) != null && Cast._boolean((Object)value)) {
            underline = 1;
        }
        if ((font = book.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline)) == null) {
            font = Excel.createFont(book);
            Excel.mergeFonts(f, font);
            return font;
        }
        return font;
    }

    private static Font createFont(Workbook book) {
        short numfonts = (short)(book.getNumberOfFonts() - 1);
        if (numfonts > 3) {
            numfonts = (short)(numfonts + 1);
        }
        Font font = numfonts == Short.MAX_VALUE ? book.getFontAt(numfonts) : book.createFont();
        return font;
    }

    private static CellStyle getCellStyle(Workbook book, CellStyle origcellstyle, Struct format) {
        short index;
        CellStyle cellstyle = null;
        boolean setFormatCellbyCell = Boolean.getBoolean("coldfusion.format.cellwise");
        if (setFormatCellbyCell || Excel.isCellWiseStyling(format)) {
            Excel.cleanStyles(book);
            cellstyle = book.createCellStyle();
        } else {
            Map<Struct, CellStyle> csbookmap = CELLSTYLESALLMAP.get(book);
            if (csbookmap != null) {
                cellstyle = csbookmap.get(format);
            } else {
                CELLSTYLESALLMAP.put(book, new HashMap());
            }
            if (cellstyle == null) {
                Excel.cleanStyles(book);
                cellstyle = book.createCellStyle();
                CELLSTYLESALLMAP.get(book).put(format, cellstyle);
            } else {
                return cellstyle;
            }
        }
        cellstyle.cloneStyleFrom(origcellstyle);
        short fontIndex = origcellstyle.getFontIndex();
        Font origfont = book.getFontAt(fontIndex);
        Font font = Excel.findFont(book, origfont, format);
        DataFormat dataformat = book.createDataFormat();
        Object value = format.get((Object)"font");
        if (value != null) {
            font.setFontName((String)value);
        }
        if ((value = format.get((Object)"fontsize")) != null) {
            font.setFontHeightInPoints(Cast._short((Object)value, (boolean)false));
        }
        if ((value = format.get((Object)"color")) != null) {
            index = Excel.getHSSFColor(((String)value).toUpperCase());
            font.setColor(index);
        }
        if ((value = format.get((Object)"italic")) != null) {
            font.setItalic(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"strikeout")) != null) {
            font.setStrikeout(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"bold")) != null) {
            if (Cast._boolean((Object)value)) {
                font.setBold(true);
            } else {
                font.setBold(false);
            }
        }
        if ((value = format.get((Object)"underline")) != null) {
            if (Cast._boolean((Object)value)) {
                font.setUnderline((byte)1);
            } else {
                font.setUnderline((byte)0);
            }
        }
        cellstyle.setFont(font);
        value = format.get((Object)"bgcolor");
        if (value != null) {
            index = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setFillBackgroundColor(index);
            cellstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((value = format.get((Object)"fgcolor")) != null) {
            index = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setFillForegroundColor(index);
            cellstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((value = format.get((Object)"fillpattern")) != null) {
            String val = ((String)value).toUpperCase();
            if (val.equalsIgnoreCase("SQUARES")) {
                cellstyle.setFillPattern(FillPatternType.SQUARES);
            } else if (val.equalsIgnoreCase("NOFILL")) {
                cellstyle.setFillPattern(FillPatternType.NO_FILL);
            } else if (val.equalsIgnoreCase("SOLID_FOREGROUND")) {
                cellstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            } else if (val.equalsIgnoreCase("FINE_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.FINE_DOTS);
            } else if (val.equalsIgnoreCase("ALT_BARS")) {
                cellstyle.setFillPattern(FillPatternType.ALT_BARS);
            } else if (val.equalsIgnoreCase("SPARSE_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.SPARSE_DOTS);
            } else if (val.equalsIgnoreCase("THICK_HORZ_BANDS")) {
                cellstyle.setFillPattern(FillPatternType.THICK_HORZ_BANDS);
            } else if (val.equalsIgnoreCase("THICK_VERT_BANDS")) {
                cellstyle.setFillPattern(FillPatternType.THICK_VERT_BANDS);
            } else if (val.equalsIgnoreCase("THICK_BACKWARD_DIAG")) {
                cellstyle.setFillPattern(FillPatternType.THICK_BACKWARD_DIAG);
            } else if (val.equalsIgnoreCase("THICK_FORWARD_DIAG")) {
                cellstyle.setFillPattern(FillPatternType.THICK_FORWARD_DIAG);
            } else if (val.equalsIgnoreCase("DIAMONDS")) {
                cellstyle.setFillPattern(FillPatternType.DIAMONDS);
            } else if (val.equalsIgnoreCase("LESS_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.LESS_DOTS);
            } else if (val.equalsIgnoreCase("LEAST_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.LEAST_DOTS);
            } else if (val.equalsIgnoreCase("BIG_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.BIG_SPOTS);
            }
        }
        if ((value = format.get((Object)"leftborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle(((String)value).toUpperCase());
            cellstyle.setBorderLeft(borderval);
        }
        if ((value = format.get((Object)"rightborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle((String)value);
            cellstyle.setBorderRight(borderval);
        }
        if ((value = format.get((Object)"topborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle((String)value);
            cellstyle.setBorderTop(borderval);
        }
        if ((value = format.get((Object)"bottomborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle((String)value);
            cellstyle.setBorderBottom(borderval);
        }
        if ((value = (String)format.get((Object)"leftbordercolor")) != null) {
            short index2 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setLeftBorderColor(index2);
        }
        if ((value = (String)format.get((Object)"rightbordercolor")) != null) {
            short index3 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setRightBorderColor(index3);
        }
        if ((value = (String)format.get((Object)"topbordercolor")) != null) {
            short index4 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setTopBorderColor(index4);
        }
        if ((value = (String)format.get((Object)"bottombordercolor")) != null) {
            short index5 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setBottomBorderColor(index5);
        }
        if ((value = format.get((Object)"rotation")) != null) {
            try {
                cellstyle.setRotation(Cast._short((Object)value, (boolean)false));
            }
            catch (Exception e) {
                throw new SpreadSheetTag.InvalidValueException(Cast._String((Object)value), "rotation");
            }
        }
        if ((value = format.get((Object)"dataformat")) != null) {
            cellstyle.setDataFormat(dataformat.getFormat((String)value));
        }
        if ((value = format.get((Object)"indent")) != null) {
            try {
                cellstyle.setIndention(Cast._short((Object)value, (boolean)false));
            }
            catch (Exception e) {
                throw new SpreadSheetTag.InvalidValueException(Cast._String((Object)value), "indent");
            }
        }
        if ((value = format.get((Object)"hidden")) != null) {
            cellstyle.setHidden(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"locked")) != null) {
            cellstyle.setLocked(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"alignment")) != null) {
            String val = ((String)value).toUpperCase();
            if (val.equalsIgnoreCase("LEFT")) {
                cellstyle.setAlignment(HorizontalAlignment.LEFT);
            } else if (val.equalsIgnoreCase("RIGHT")) {
                cellstyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (val.equalsIgnoreCase("CENTER")) {
                cellstyle.setAlignment(HorizontalAlignment.CENTER);
            } else if (val.equalsIgnoreCase("JUSTIFY")) {
                cellstyle.setAlignment(HorizontalAlignment.JUSTIFY);
            } else if (val.equalsIgnoreCase("GENERAL")) {
                cellstyle.setAlignment(HorizontalAlignment.GENERAL);
            } else if (val.equalsIgnoreCase("FILL")) {
                cellstyle.setAlignment(HorizontalAlignment.FILL);
            } else if (val.equalsIgnoreCase("CENTER_SELECTION")) {
                cellstyle.setAlignment(HorizontalAlignment.CENTER_SELECTION);
            }
        }
        if ((value = format.get((Object)"verticalalignment")) != null) {
            String val = ((String)value).toUpperCase();
            if (val.equalsIgnoreCase("VERTICAL_TOP")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.TOP);
            } else if (val.equalsIgnoreCase("VERTICAL_BOTTOM")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
            } else if (val.equalsIgnoreCase("VERTICAL_CENTER")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
            } else if (val.equalsIgnoreCase("VERTICAL_JUSTIFY")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.JUSTIFY);
            }
        }
        if ((value = format.get((Object)"textwrap")) != null) {
            cellstyle.setWrapText(Cast._boolean((Object)value));
        }
        return cellstyle;
    }

    private static boolean isCellWiseStyling(Struct format) {
        if (!format.containsKey((Object)"styleCellwise")) {
            return false;
        }
        if (format.get((Object)"styleCellwise") instanceof CFBoolean) {
            return ((CFBoolean)format.get((Object)"styleCellwise")).value;
        }
        return format.get((Object)"styleCellwise").equals("true");
    }

    public static void setColumnWidth(ExcelInfo info, int column, int width) {
        if (width < 0) {
            throw new SpreadSheetTag.SpreadsheetInvalidWidth(width);
        }
        Workbook book = info.getWorkbook();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = book.getSheet(sheetname);
        sheet.setColumnWidth(column - 1, width * 256);
    }

    public static void setRowHeight(ExcelInfo info, int row, float heightInPoints) {
        String sheetname;
        if (row > 65535) {
            throw new SpreadSheetTag.SpreadsheetInvalidRowException(row);
        }
        if (heightInPoints < 0.0f) {
            throw new SpreadSheetTag.SpreadsheetInvalidHeight(heightInPoints);
        }
        Workbook book = info.getWorkbook();
        Sheet sheet = book.getSheet(sheetname = info.getExcelSheetName());
        Row hssfrow = sheet.getRow(row - 1);
        if (hssfrow != null) {
            hssfrow.setHeightInPoints(heightInPoints);
        } else {
            hssfrow = sheet.createRow(row - 1);
            hssfrow.setHeightInPoints(heightInPoints);
        }
    }

    public static void formatCellRange(ExcelInfo info, Struct format, int startrow, int startcolumn, int endrow, int endcolumn) {
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            for (int i = startrow - 1; i < endrow; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) {
                    row = sheet.createRow(i);
                }
                Struct rowFormat = (Struct)format.clone();
                rowFormat.put(Key.getInstance((String)(i + "")), (Object)i);
                for (int c = startcolumn - 1; c < endcolumn; ++c) {
                    Cell cell = row.getCell(c);
                    if (cell == null) {
                        cell = row.createCell(c);
                    }
                    CellStyle def = cell.getCellStyle();
                    CellStyle cellstyle = Excel.getCellStyle(book, def, rowFormat);
                    cell.setCellStyle(cellstyle);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatCellRange", (Throwable)e);
        }
    }

    private static void cleanStyles(Workbook book) {
        if (book instanceof HSSFWorkbook && (book.getNumCellStyles() >= Short.MAX_VALUE || book.getNumCellStyles() < 0)) {
            try {
                HSSFOptimiser.optimiseFonts((HSSFWorkbook)((HSSFWorkbook)book));
                HSSFOptimiser.optimiseCellStyles((HSSFWorkbook)((HSSFWorkbook)book));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void formatCell(ExcelInfo info, Struct format, int row, int column) {
        try {
            Cell cell;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            if ((cell = hssfrow.getCell(column - 1)) == null) {
                cell = hssfrow.createCell(column - 1);
            }
            CellStyle def = cell.getCellStyle();
            CellStyle cellstyle = Excel.getCellStyle(book, def, format);
            cell.setCellStyle(cellstyle);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatCell", (Throwable)e);
        }
    }

    public static void formatRows(ExcelInfo info, Struct format, String range) {
        String value = (String)format.get((Object)"size");
        if (value != null) {
            value = value.trim();
        }
        if (range.contains(",")) {
            Integer[] rows = Excel.doProcessList(range);
            for (int i = 0; i < rows.length; ++i) {
                int rownum = rows[i];
                Excel.formatRow(info, format, value, rownum);
            }
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            ArrayList<Integer> resizedColumns = new ArrayList<Integer>();
            for (int i = 0; i < rows.length; ++i) {
                Row row = sheet.getRow(rows[i] - 1);
                if (row == null) continue;
                Iterator cellIterator = row.iterator();
                while (cellIterator.hasNext()) {
                    int colnum = ((Cell)cellIterator.next()).getColumnIndex();
                    if (resizedColumns.contains(colnum)) continue;
                    sheet.autoSizeColumn(colnum, true);
                    resizedColumns.add(colnum);
                }
            }
        } else {
            int[] v = Excel.doProcessRange(range);
            int start = v[0];
            int end = v[1];
            for (int i = start; i <= end; ++i) {
                Excel.formatRow(info, format, value, i);
            }
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            ArrayList<Integer> resizedColumns = new ArrayList<Integer>();
            for (int i = start; i <= end; ++i) {
                Row row = sheet.getRow(i - 1);
                if (row == null) continue;
                Iterator cellIterator = row.iterator();
                while (cellIterator.hasNext()) {
                    int colnum = ((Cell)cellIterator.next()).getColumnIndex();
                    if (resizedColumns.contains(colnum)) continue;
                    sheet.autoSizeColumn(colnum, true);
                    resizedColumns.add(colnum);
                }
            }
        }
    }

    public static void formatColumns(ExcelInfo info, Struct format, String range) {
        Object value = format.get((Object)"size");
        if (range.contains(",")) {
            Integer[] columns = Excel.doProcessList(range);
            for (int i = 0; i < columns.length; ++i) {
                int colnum = columns[i];
                Excel.formatColumn(info, format, value, colnum);
            }
        } else {
            int[] v = Excel.doProcessRange(range);
            int start = v[0];
            int end = v[1];
            for (int i = start; i <= end; ++i) {
                Excel.formatColumn(info, format, value, i);
            }
        }
    }

    public static void formatColumn(ExcelInfo info, Struct format, Object size, int column) {
        if (column < 1) {
            throw new SpreadSheetTag.ExcelInvalidColumnSpecifiedException();
        }
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Object value = format.get((Object)"hidden");
            if (value != null) {
                sheet.setColumnHidden(column - 1, Cast._boolean((Object)value));
            }
            int start = Excel.getFirstRowNum(sheet);
            int last = Excel.getLastRowNum(sheet);
            boolean autosize = false;
            for (int i = start; i <= last; ++i) {
                Cell cell;
                Row row = sheet.getRow(i);
                if (row == null) continue;
                if (size != null) {
                    row.setHeightInPoints(Cast._float((Object)size, (boolean)false) + 1.0f);
                }
                if ((cell = row.getCell(column - 1)) == null) continue;
                if (!autosize) {
                    autosize = true;
                }
                CellStyle def = cell.getCellStyle();
                CellStyle cellstyle = Excel.getCellStyle(book, def, format);
                cell.setCellStyle(cellstyle);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatColumn", (Throwable)e);
        }
    }

    public static void formatColumn(ExcelInfo info, Struct format, int column) {
        Object value = format.get((Object)"size");
        Excel.formatColumn(info, format, value, column);
    }

    public static void formatRow(ExcelInfo info, Struct format, String size, int row) {
        CellStyle cellstyle = null;
        if (row < 1) {
            throw new SpreadSheetTag.ExcelInvalidRowSpecifiedException();
        }
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            String value = (String)format.get((Object)"hidden");
            if (value != null) {
                if (value.equalsIgnoreCase("yes")) {
                    value = "true";
                }
                if (value.equalsIgnoreCase("no")) {
                    value = "false";
                }
                hssfrow.setZeroHeight(Cast._boolean((String)value));
            }
            if (hssfrow != null) {
                if (size != null) {
                    hssfrow.setHeightInPoints(new Float(size).floatValue() + 1.0f);
                }
                for (Cell cell : hssfrow) {
                    CellStyle def = cell.getCellStyle();
                    cellstyle = Excel.getCellStyle(book, def, format);
                    cell.setCellStyle(cellstyle);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatRow", (Throwable)e);
        }
    }

    public static void formatRow(ExcelInfo info, Struct format, int row) {
        String value = "";
        value = (String)format.get((Object)"size");
        if (value != null) {
            value = value.trim();
        }
        Excel.formatRow(info, format, value, row);
    }

    public static void setCellValue(ExcelInfo info, String value, int row, int column, String datatype) {
        block10: {
            try {
                Workbook book = info.getWorkbook();
                CreationHelper createHelper = book.getCreationHelper();
                String sheetname = info.getExcelSheetName();
                Sheet sheet = book.getSheet(sheetname);
                Row hssfrow = sheet.getRow(row - 1);
                if (hssfrow == null) {
                    hssfrow = sheet.createRow(row - 1);
                }
                Cell c = hssfrow.getCell(column - 1);
                CellStyle style = null;
                if (c != null) {
                    style = c.getCellStyle() != null ? c.getCellStyle() : null;
                    hssfrow.removeCell(c);
                }
                c = hssfrow.createCell(column - 1);
                if (style != null) {
                    c.setCellStyle(style);
                }
                try {
                    if (null == datatype) {
                        if (style != null && style.getDataFormatString().equalsIgnoreCase("@")) {
                            Excel.setCellStringValue(sheet, c, column, value, createHelper);
                        } else {
                            double i = Double.parseDouble(value);
                            c.setCellType(CellType.NUMERIC);
                            c.setCellValue(i);
                        }
                        break block10;
                    }
                    Excel.createDatatypeAwareCell(Excel.getParsedDatatypes(datatype, 1)[0], c, value, createHelper, book);
                }
                catch (NumberFormatException e) {
                    Excel.setCellStringValue(sheet, c, column, value, createHelper);
                }
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("setCellValue", (Throwable)e);
            }
        }
    }

    private static void setCellStringValue(Sheet sheet, Cell c, int column, String value, CreationHelper createHelper) {
        if (!value.equalsIgnoreCase("")) {
            c.setCellType(CellType.STRING);
            RichTextString str = createHelper.createRichTextString(value);
            c.setCellValue(str);
            int colwidth = sheet.getColumnWidth(column - 1);
            short len = (short)value.length();
            len = (short)((double)(len * 8) / 0.05);
            if (colwidth < len) {
                sheet.setColumnWidth(column - 1, len + 1);
            }
        } else {
            c.setCellType(CellType.BLANK);
            c.setCellValue(createHelper.createRichTextString(""));
        }
    }

    public static String getCellValue(ExcelInfo info, int row, int column) {
        String retval = "";
        Workbook wb = info.getWorkbook();
        CreationHelper createHelper = wb.getCreationHelper();
        evaluator = createHelper.createFormulaEvaluator();
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            retval = Excel.getValueAt(hssfrow, column - 1);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellValue", (Throwable)e);
        }
        return retval;
    }

    public static void addFreezePane(ExcelInfo info, int col, int row, int leftcol, int toprow) {
        if (row < 0 || row > 65535) {
            throw new SpreadSheetTag.SpreadsheetInvalidRowException(row);
        }
        if (toprow < 0 || toprow > 65535) {
            throw new SpreadSheetTag.SpreadsheetInvalidRowException(toprow);
        }
        if (leftcol < col) {
            throw new SpreadSheetTag.FreezePaneInvalidColSplitParameter(leftcol, col);
        }
        if (toprow < row) {
            throw new SpreadSheetTag.FreezePaneInvalidRowSplitParameter(toprow, row);
        }
        Workbook wb = info.getWorkbook();
        Sheet sheet = wb.getSheetAt(info.getExcelSheetNumber());
        sheet.createFreezePane(col, row, leftcol, toprow);
    }

    public static void addSplitPane(ExcelInfo info, int col, int row, int leftcol, int toprow, String position) {
        Workbook wb = info.getWorkbook();
        int activepane = position.equalsIgnoreCase("upper_right") ? 1 : (position.equalsIgnoreCase("lower_left") ? 2 : (position.equalsIgnoreCase("lower_right") ? 0 : (position.equalsIgnoreCase("upper_left") ? 3 : 3)));
        if (wb instanceof HSSFWorkbook) {
            HSSFSheet sheet = (HSSFSheet)wb.getSheetAt(info.getExcelSheetNumber());
            sheet.createSplitPane(col, row, leftcol, toprow, activepane);
        } else {
            XSSFSheet sheet = (XSSFSheet)wb.getSheetAt(info.getExcelSheetNumber());
            sheet.createSplitPane(col, row, leftcol, toprow, activepane);
        }
    }

    public static Comment createComment(Workbook wb, Drawing drawing, Struct comment) {
        short numfonts;
        String value = (String)comment.get((Object)"comment");
        if (value == null) {
            return null;
        }
        String commentString = value;
        CreationHelper factory = wb.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(4);
        anchor.setRow1(8);
        anchor.setCol2(6);
        anchor.setRow2(11);
        value = (String)comment.get((Object)"anchor");
        if (value != null && value.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(value, "\t\n,");
            int index = 0;
            int count = stringTokenizer.countTokens();
            if (count == 4) {
                String[] c = new String[count];
                while (stringTokenizer.hasMoreElements()) {
                    c[index] = stringTokenizer.nextToken().trim();
                    ++index;
                }
                int top = new Integer(c[0]);
                int left = new Integer(c[1]);
                int bottom = new Integer(c[2]);
                int right = new Integer(c[3]);
                anchor.setCol1(top);
                anchor.setRow1(left);
                anchor.setCol2(bottom);
                anchor.setRow2(right);
            }
        }
        Comment cellComment = drawing.createCellComment(anchor);
        value = (String)comment.get((Object)"author");
        if (value != null) {
            cellComment.setAuthor(value);
            commentString = value + ":\n " + commentString;
        }
        if ((numfonts = (short)(wb.getNumberOfFonts() - 1)) > 3) {
            numfonts = (short)(numfonts + 1);
        }
        Font font = numfonts == Short.MAX_VALUE ? wb.getFontAt(numfonts) : wb.createFont();
        value = (String)comment.get((Object)"font");
        if (value != null) {
            font.setFontName(value);
        }
        if ((value = (String)comment.get((Object)"size")) != null) {
            value = value.trim();
            font.setFontHeightInPoints(new Short(value).shortValue());
        }
        if ((value = (String)comment.get((Object)"color")) != null) {
            value = value.toUpperCase();
            short index = Excel.getHSSFColor(value);
            font.setColor(index);
        }
        if ((value = (String)comment.get((Object)"italic")) != null) {
            if (value.equalsIgnoreCase("yes")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("no")) {
                value = "false";
            }
            font.setItalic(Boolean.parseBoolean(value));
        }
        if ((value = (String)comment.get((Object)"strikeout")) != null) {
            if (value.equalsIgnoreCase("yes")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("no")) {
                value = "false";
            }
            font.setStrikeout(Boolean.parseBoolean(value));
        }
        if ((value = (String)comment.get((Object)"bold")) != null) {
            if (value.equalsIgnoreCase("yes")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("no")) {
                value = "false";
            }
            if (Boolean.parseBoolean(value)) {
                font.setBold(true);
            }
        }
        if ((value = (String)comment.get((Object)"underline")) != null) {
            if (value.equalsIgnoreCase("yes")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("no")) {
                value = "false";
            }
            if (Boolean.parseBoolean(value)) {
                font.setUnderline((byte)1);
            }
        }
        RichTextString richText = factory.createRichTextString(commentString);
        richText.applyFont(font);
        cellComment.setString(richText);
        value = (String)comment.get((Object)"visible");
        if (value != null) {
            if (value.equalsIgnoreCase("yes")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("no")) {
                value = "false";
            }
            cellComment.setVisible(Boolean.parseBoolean(value));
        } else {
            cellComment.setVisible(false);
        }
        if (wb instanceof HSSFWorkbook) {
            HSSFComment hssfcomment = (HSSFComment)cellComment;
            value = (String)comment.get((Object)"fillcolor");
            if (value != null) {
                value = value.toUpperCase();
                try {
                    Field f = Color.class.getDeclaredField(value);
                    if (null != f) {
                        Color color = (Color)f.get(null);
                        hssfcomment.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
                    }
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            if ((value = (String)comment.get((Object)"horizontalalignment")) != null) {
                value = value.trim();
                if ((value = value.toUpperCase()).equalsIgnoreCase("LEFT")) {
                    hssfcomment.setHorizontalAlignment((short)1);
                } else if (value.equalsIgnoreCase("CENTER")) {
                    hssfcomment.setHorizontalAlignment((short)2);
                } else if (value.equalsIgnoreCase("RIGHT")) {
                    hssfcomment.setHorizontalAlignment((short)3);
                } else if (value.equalsIgnoreCase("JUSTIFY")) {
                    hssfcomment.setHorizontalAlignment((short)4);
                } else if (value.equalsIgnoreCase("DISTRIBUTED")) {
                    hssfcomment.setHorizontalAlignment((short)7);
                }
            }
            if ((value = (String)comment.get((Object)"verticalalignment")) != null) {
                value = value.trim();
                if ((value = value.toUpperCase()).equalsIgnoreCase("TOP")) {
                    hssfcomment.setVerticalAlignment((short)1);
                } else if (value.equalsIgnoreCase("CENTER")) {
                    hssfcomment.setVerticalAlignment((short)2);
                } else if (value.equalsIgnoreCase("BOTTOM")) {
                    hssfcomment.setVerticalAlignment((short)3);
                } else if (value.equalsIgnoreCase("JUSTIFY")) {
                    hssfcomment.setVerticalAlignment((short)4);
                } else if (value.equalsIgnoreCase("DISTRIBUTED")) {
                    hssfcomment.setVerticalAlignment((short)7);
                }
            }
            if ((value = (String)comment.get((Object)"linestyle")) != null) {
                value = value.trim();
                if ((value = value.toUpperCase()).equalsIgnoreCase("SOLID")) {
                    hssfcomment.setLineStyle(0);
                } else if (value.equalsIgnoreCase("DASHSYS")) {
                    hssfcomment.setLineStyle(1);
                } else if (value.equalsIgnoreCase("DOTSYS")) {
                    hssfcomment.setLineStyle(2);
                } else if (value.equalsIgnoreCase("DASHDOTSYS")) {
                    hssfcomment.setLineStyle(3);
                } else if (value.equalsIgnoreCase("DASHDOTDOTSYS")) {
                    hssfcomment.setLineStyle(4);
                } else if (value.equalsIgnoreCase("DOTGEL")) {
                    hssfcomment.setLineStyle(5);
                } else if (value.equalsIgnoreCase("DASHGEL")) {
                    hssfcomment.setLineStyle(6);
                } else if (value.equalsIgnoreCase("LONGDASHGEL")) {
                    hssfcomment.setLineStyle(7);
                } else if (value.equalsIgnoreCase("DASHDOTGEL")) {
                    hssfcomment.setLineStyle(8);
                } else if (value.equalsIgnoreCase("LONGDASHDOTGEL")) {
                    hssfcomment.setLineStyle(9);
                } else if (value.equalsIgnoreCase("LONGDASHDOTDOTGEL")) {
                    hssfcomment.setLineStyle(10);
                } else {
                    hssfcomment.setLineStyle(-1);
                }
            }
            if ((value = (String)comment.get((Object)"linewidth")) != null) {
                value = value.trim();
                hssfcomment.setLineWidth(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"marginbottom")) != null) {
                value = value.trim();
                hssfcomment.setMarginBottom(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"margintop")) != null) {
                value = value.trim();
                hssfcomment.setMarginTop(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"marginleft")) != null) {
                value = value.trim();
                hssfcomment.setMarginLeft(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"marginright")) != null) {
                value = value.trim();
                hssfcomment.setMarginRight(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"nofill")) != null) {
                if (value.equalsIgnoreCase("yes")) {
                    value = "true";
                }
                if (value.equalsIgnoreCase("no")) {
                    value = "false";
                }
                hssfcomment.setNoFill(Boolean.parseBoolean(value));
            }
            if ((value = (String)comment.get((Object)"linestylecolor")) != null) {
                value = value.toUpperCase();
                try {
                    Field f = Color.class.getDeclaredField(value);
                    if (null != f) {
                        Color color = (Color)f.get(null);
                        hssfcomment.setLineStyleColor(color.getRed(), color.getGreen(), color.getBlue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return hssfcomment;
        }
        return cellComment;
    }

    public void setCellComment(ExcelInfo info, Struct comment, int row, int column) {
        try {
            Comment cellComment;
            Drawing drawing;
            Cell c;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            if ((c = hssfrow.getCell(column - 1)) == null) {
                c = hssfrow.createCell(column - 1);
            }
            if ((drawing = info.getDrawing()) == null) {
                drawing = sheet.createDrawingPatriarch();
                info.setDrawing(drawing);
            }
            if (comment.get((Object)"anchor") == null) {
                String anchor = column - 1 + "," + (row - 1) + "," + (column + 1) + "," + (row + 2);
                comment.put((Object)"anchor", (Object)anchor);
            }
            if ((cellComment = Excel.createComment(book, drawing, comment)) != null) {
                c.setCellComment(cellComment);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("setCellComment", (Throwable)e);
        }
    }

    public static ArrayList<Struct> getCellComment(ExcelInfo info) {
        ArrayList<Struct> comments = new ArrayList<Struct>();
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int startrow = Excel.getFirstRowNum(sheet);
            int endrow = Excel.getLastRowNum(sheet);
            for (int i = startrow; i < endrow; ++i) {
                Row hssfrow = sheet.getRow(i);
                if (hssfrow == null) continue;
                int firstcell = hssfrow.getFirstCellNum();
                short lastcell = hssfrow.getLastCellNum();
                for (int j = firstcell; j < lastcell; ++j) {
                    Struct c = Excel.getCommentAt(hssfrow, j);
                    if (c == null) continue;
                    comments.add(c);
                }
            }
            return comments;
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellComment", (Throwable)e);
        }
    }

    public static Struct getCellComment(ExcelInfo info, int row, int column) {
        Struct c;
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            c = Excel.getCommentAt(hssfrow, column - 1);
            if (c == null) {
                c = new Struct();
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellComment", (Throwable)e);
        }
        return c;
    }

    public void setCellFormula(ExcelInfo info, String formula, int row, int column) {
        try {
            Cell c;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            if ((c = hssfrow.getCell(column - 1)) == null) {
                c = hssfrow.createCell(column - 1);
            }
            c.setCellFormula(formula);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("setCellFormula", (Throwable)e);
        }
    }

    public ArrayList<Struct> getCellFormula(ExcelInfo info) {
        ArrayList<Struct> formulas = new ArrayList<Struct>();
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int startrow = Excel.getFirstRowNum(sheet);
            int endrow = Excel.getLastRowNum(sheet);
            for (int i = startrow; i < endrow; ++i) {
                Row hssfrow = sheet.getRow(i);
                if (hssfrow == null) continue;
                int firstcell = hssfrow.getFirstCellNum();
                short lastcell = hssfrow.getLastCellNum();
                for (int j = firstcell; j < lastcell; ++j) {
                    String s = this.getFormulaAt(hssfrow, j);
                    if (s.equalsIgnoreCase("")) continue;
                    Struct c = new Struct();
                    c.put((Object)"FORMULA", (Object)s);
                    c.put((Object)"ROW", (Object)i);
                    c.put((Object)"COLUMN", (Object)j);
                    formulas.add(c);
                }
            }
            return formulas;
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellFormula", (Throwable)e);
        }
    }

    public String getCellFormula(ExcelInfo info, int row, int column) {
        String formula = "";
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow != null) {
                formula = this.getFormulaAt(hssfrow, column - 1);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellFormula", (Throwable)e);
        }
        return formula;
    }

    public ArrayList<String[]> readXLS(int sheetno, Integer[] rows, int excludeRow) {
        ArrayList<Object> excel = new ArrayList<String[]>();
        try {
            if (this.workbook.getNumberOfSheets() <= sheetno) {
                throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
            }
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            if (sheet != null) {
                excel = new ArrayList();
                for (int i = 0; i < rows.length; ++i) {
                    String[] values;
                    int rownum = rows[i];
                    if (rownum - 1 == excludeRow || (values = this.getValuesAt(sheet, rownum - 1)) == null) continue;
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    public static void writeCSVToExcel(String filename, String csv, String sheetname, String password, boolean update, Object autosize) {
        String linesep = System.getProperty("line.separator");
        String[] tokens = csv.split(linesep);
        ArrayList<String[]> values = new ArrayList<String[]>();
        for (int ii = 0; ii < tokens.length; ++ii) {
            String s = tokens[ii];
            String[] line = s.split(",");
            ArrayList<String> s1 = new ArrayList<String>();
            for (int i = 0; i < line.length; ++i) {
                StringBuffer tempbuf = new StringBuffer(line[i]);
                String temp = tempbuf.toString();
                if (tempbuf.length() > 0 && tempbuf.charAt(0) == '\"') {
                    if (tempbuf.toString().endsWith("\"")) {
                        tempbuf.setCharAt(0, ' ');
                        tempbuf.setCharAt(tempbuf.length() - 1, ' ');
                        temp = Excel.removeLRSpace(tempbuf);
                        s1.add(temp);
                        continue;
                    }
                    boolean found = false;
                    while (i + 1 < line.length) {
                        int nextState = 0;
                        String next = line[i + 1];
                        if (next.startsWith("\"")) {
                            next = next.replaceFirst("\"", "");
                            ++nextState;
                        }
                        tempbuf.setCharAt(0, ' ');
                        tempbuf.append(",").append(next);
                        ++i;
                        if (!next.endsWith("\"")) continue;
                        found = true;
                        int l = tempbuf.length();
                        if (++nextState != 2) {
                            tempbuf.setCharAt(l - 1, ' ');
                        }
                        temp = Excel.removeLRSpace(tempbuf);
                        break;
                    }
                    temp = Excel.removeLRSpace(tempbuf);
                }
                if (line.length == 1 && temp.startsWith("\"") && temp.endsWith("\"")) {
                    tempbuf.setCharAt(0, ' ');
                    int l = tempbuf.length();
                    tempbuf.setCharAt(l - 1, ' ');
                    temp = Excel.removeLRSpace(tempbuf);
                }
                s1.add(temp);
            }
            String[] row = new String[s1.size()];
            for (int i = 0; i < s1.size(); ++i) {
                row[i] = (String)s1.get(i);
            }
            values.add(row);
        }
        Excel.writeExcel(filename, values, sheetname, password, update, autosize);
    }

    private static String removeLRSpace(StringBuffer tempbuf) {
        String temp = tempbuf.toString();
        temp = temp.replaceAll("\\s+$", "");
        temp = temp.replaceAll("^\\s+", "");
        return temp;
    }

    public String populateCSV(ArrayList<String[]> values) {
        String csvString = "";
        ListIterator<String[]> iter = values.listIterator();
        String linesep = System.getProperty("line.separator");
        while (iter.hasNext()) {
            String[] row = iter.next();
            for (int index = 0; index < row.length; ++index) {
                String val = row[index];
                if (val == null) continue;
                if (val.contains(",")) {
                    val = "\"" + val + "\"";
                }
                csvString = index == 0 ? csvString + val : csvString + "," + val;
            }
            csvString = csvString + linesep;
        }
        return csvString;
    }

    public static void addImage(ExcelInfo info, byte[] image, String type, String anchorVal) {
        block18: {
            try {
                int pictype;
                String sheetname = info.getExcelSheetName();
                Workbook book = info.getWorkbook();
                Sheet sheet = book.getSheet(sheetname);
                if (sheet == null) break block18;
                if ((type = type.toUpperCase()).equalsIgnoreCase("PNG")) {
                    pictype = 6;
                } else if (type.equalsIgnoreCase("JPG") || type.equalsIgnoreCase("JPEG")) {
                    pictype = 5;
                } else if (type.equalsIgnoreCase("DIB")) {
                    pictype = 7;
                } else {
                    throw new SpreadSheetTag.UnSupportedPictureTypeException(type);
                }
                int imgindex = book.addPicture(image, pictype);
                StringTokenizer stringTokenizer = new StringTokenizer(anchorVal, "\t\n,");
                int index = 0;
                int count = stringTokenizer.countTokens();
                String[] values = new String[count];
                while (stringTokenizer.hasMoreElements()) {
                    values[index] = stringTokenizer.nextToken().trim();
                    ++index;
                }
                CreationHelper helper = book.getCreationHelper();
                Drawing drawing = info.getDrawing();
                if (drawing == null) {
                    try {
                        if (book instanceof HSSFWorkbook) {
                            HSSFSheet s = (HSSFSheet)sheet;
                            drawing = s.getDrawingPatriarch();
                        } else {
                            XSSFSheet s1 = (XSSFSheet)sheet;
                            drawing = (Drawing)s1.getCTWorksheet().getDrawing();
                        }
                    }
                    catch (Exception e) {
                        drawing = sheet.createDrawingPatriarch();
                    }
                    if (drawing == null) {
                        drawing = sheet.createDrawingPatriarch();
                    }
                }
                ClientAnchor anchor = helper.createClientAnchor();
                if (values.length == 8 || values.length == 4) {
                    short endcol;
                    short endrow;
                    short startcol;
                    short startrow;
                    int dy2;
                    int dx2;
                    int dy1;
                    int dx1;
                    if (values.length == 8) {
                        dx1 = new Integer(values[0]);
                        dy1 = new Integer(values[1]);
                        dx2 = new Integer(values[2]);
                        dy2 = new Integer(values[3]);
                        startrow = new Short(values[4]);
                        startcol = new Short(values[5]);
                        endrow = new Short(values[6]);
                        endcol = new Short(values[7]);
                    } else {
                        dx1 = 0;
                        dy1 = 0;
                        dx2 = 0;
                        dy2 = 255;
                        startrow = new Short(values[0]);
                        startcol = new Short(values[1]);
                        endrow = new Short(values[2]);
                        endcol = new Short(values[3]);
                    }
                    startrow = (short)(startrow - 1);
                    startcol = (short)(startcol - 1);
                    endrow = (short)(endrow - 1);
                    endcol = (short)(endcol - 1);
                    anchor.setCol1((int)startcol);
                    anchor.setCol2((int)endcol);
                    anchor.setDx1(dx1);
                    anchor.setDx2(dx2);
                    anchor.setDy1(dy1);
                    anchor.setDy2(dy2);
                    anchor.setRow1((int)startrow);
                    anchor.setRow2((int)endrow);
                    Picture picture = drawing.createPicture(anchor, imgindex);
                }
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("addImage", (Throwable)e);
            }
        }
    }

    public static void addImage(ExcelInfo info, String image, String anchorVal) {
        byte[] picData;
        block11: {
            FileInputStream picIn = null;
            picData = null;
            try {
                File picFile = VFSFileFactory.getFileObject((String)image);
                if (picFile.exists()) {
                    long length = picFile.length();
                    picData = new byte[(int)length];
                    picIn = new FileInputStream(picFile);
                    picIn.read(picData);
                    break block11;
                }
                throw new FileNotFoundException(image);
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("addImage", (Throwable)e);
            }
            finally {
                if (picIn != null) {
                    try {
                        picIn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        String temp = image.toUpperCase();
        int i = temp.lastIndexOf(".");
        Excel.addImage(info, picData, temp.substring(i + 1, temp.length()), anchorVal);
    }

    public ArrayList<String[]> readXLS(int sheetno, String rowrange, int excludeRow) {
        if (this.workbook.getNumberOfSheets() <= sheetno) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
        }
        CreationHelper helper = this.workbook.getCreationHelper();
        evaluator = helper.createFormulaEvaluator();
        if (rowrange.contains(",")) {
            Integer[] rows = Excel.doProcessList(rowrange);
            return this.readXLS(sheetno, rows, excludeRow);
        }
        int[] rows = Excel.doProcessRange(rowrange);
        int startrow = rows[0];
        int endrow = rows[1];
        ArrayList<String[]> excel = null;
        --startrow;
        try {
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            if (sheet != null) {
                excel = new ArrayList<String[]>();
                for (int index = startrow; index < endrow; ++index) {
                    String[] values;
                    if (index == excludeRow || (values = this.getValuesAt(sheet, index)) == null || values.length <= 0) continue;
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    public ArrayList<String[]> readXLS(int sheetno, String rowrange, String colrange, int excludeRow) {
        int startrow = 0;
        int endrow = 0;
        boolean processrowlist = false;
        Integer[] rows = new Integer[]{};
        if (this.workbook.getNumberOfSheets() <= sheetno) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
        }
        ArrayList<Object> excel = new ArrayList<String[]>();
        CreationHelper helper = this.workbook.getCreationHelper();
        try {
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            evaluator = helper.createFormulaEvaluator();
            if (sheet != null) {
                if (!rowrange.equalsIgnoreCase("")) {
                    if (rowrange.contains(",")) {
                        rows = Excel.doProcessList(rowrange);
                        processrowlist = true;
                    } else {
                        int[] rowstruct = Excel.doProcessRange(rowrange);
                        startrow = rowstruct[0] - 1;
                        endrow = rowstruct[1];
                    }
                } else {
                    startrow = Excel.getFirstRowNum(sheet);
                    endrow = Excel.getLastRowNum(sheet) + 1;
                }
                if (colrange.contains(",")) {
                    Integer[] cols = Excel.doProcessList(colrange);
                    excel = new ArrayList();
                    if (!processrowlist) {
                        for (int index = startrow; index < endrow; ++index) {
                            String[] values;
                            if (index == excludeRow || (values = this.getValuesAt(sheet, index, cols)) == null) continue;
                            excel.add(values);
                        }
                    } else {
                        for (int index = 0; index < rows.length; ++index) {
                            String[] values;
                            int rownum = rows[index];
                            if (rownum - 1 == excludeRow || (values = this.getValuesAt(sheet, rownum - 1, cols)) == null) continue;
                            excel.add(values);
                        }
                    }
                } else {
                    int[] v = Excel.doProcessRange(colrange);
                    int startcol = v[0] - 1;
                    int endcol = v[1];
                    excel = new ArrayList();
                    if (!processrowlist) {
                        for (int index = startrow; index < endrow; ++index) {
                            String[] values;
                            if (index == excludeRow || (values = this.getValuesAt(sheet, index, startcol, endcol)) == null) continue;
                            excel.add(values);
                        }
                    } else {
                        for (int index = 0; index < rows.length; ++index) {
                            String[] values;
                            int rownum = rows[index];
                            if (rownum - 1 == excludeRow || (values = this.getValuesAt(sheet, rownum - 1, startcol, endcol)) == null) continue;
                            excel.add(values);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    private static int getFirstRowNum(Sheet sheet) {
        int n = sheet.getFirstRowNum();
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private static int getLastRowNum(Sheet sheet) {
        int n = sheet.getLastRowNum();
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public ArrayList<String[]> readXLS(int sheetno, int excludeRow) {
        if (this.workbook.getNumberOfSheets() <= sheetno) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
        }
        ArrayList<Object> excel = new ArrayList<String[]>();
        try {
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            CreationHelper helper = this.workbook.getCreationHelper();
            evaluator = helper.createFormulaEvaluator();
            if (sheet != null) {
                excel = new ArrayList();
                int startrow = Excel.getFirstRowNum(sheet);
                int endrow = Excel.getLastRowNum(sheet);
                for (int index = startrow; index <= endrow; ++index) {
                    String[] values;
                    if (index == excludeRow || (values = this.getValuesAt(sheet, index)) == null) continue;
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    public void writeExcel(String xlsfile, ExcelInfo i, int sheetno, String sheetname, String password, boolean update, boolean autosize) {
        i.setExcelSheetNumber(sheetno);
        i.setExcelSheetName(sheetname);
        Excel.writeExcel(xlsfile, i, password, update, autosize);
    }

    public static void writeExcel(String xlsfile, ExcelInfo i, String sheetname, String password, boolean update, Object autosize) {
        i.setExcelSheetName(sheetname);
        Excel.writeExcel(xlsfile, i, password, update, autosize);
    }

    public static void cloneCell(Cell src, Cell dest, CreationHelper helper, Map<CellStyle, CellStyle> styleCache) {
        Hyperlink link;
        Comment comment;
        try {
            comment = src.getCellComment();
        }
        catch (Exception e) {
            comment = null;
        }
        if (comment != null) {
            dest.setCellComment(comment);
        }
        if ((link = src.getHyperlink()) != null) {
            dest.setHyperlink(link);
        }
        switch (src.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)src)) {
                    double value = src.getNumericCellValue();
                    if (Excel.isValidExcelDate(value)) {
                        dest.setCellValue(src.getDateCellValue());
                        break;
                    }
                    dest.setCellValue(value);
                    break;
                }
                dest.setCellValue(src.getNumericCellValue());
                break;
            }
            case STRING: {
                RichTextString text = src.getRichStringCellValue();
                dest.setCellValue(text);
                break;
            }
            case FORMULA: {
                String formula = null;
                formula = src.getCellFormula();
                if (formula == null) break;
                dest.setCellFormula(formula);
                break;
            }
            default: {
                dest.setCellValue(helper.createRichTextString(""));
            }
        }
        CellStyle srcstyle = src.getCellStyle();
        CellStyle deststyle = styleCache.get(srcstyle);
        if (null == deststyle) {
            deststyle = dest.getSheet().getWorkbook().createCellStyle();
            deststyle.cloneStyleFrom(srcstyle);
            styleCache.put(srcstyle, deststyle);
        }
        dest.setCellStyle(deststyle);
    }

    public static void _cloneStyle(CellStyle srcstyle, CellStyle deststyle) {
        deststyle.setAlignment(srcstyle.getAlignmentEnum());
        deststyle.setBorderBottom(srcstyle.getBorderBottomEnum());
        deststyle.setBorderLeft(srcstyle.getBorderLeftEnum());
        deststyle.setBorderRight(srcstyle.getBorderRightEnum());
        deststyle.setBorderTop(srcstyle.getBorderTopEnum());
        deststyle.setBottomBorderColor(srcstyle.getBottomBorderColor());
        deststyle.setDataFormat(srcstyle.getDataFormat());
        deststyle.setFillForegroundColor(srcstyle.getFillForegroundColor());
        deststyle.setFillBackgroundColor(srcstyle.getFillBackgroundColor());
        deststyle.setFillPattern(srcstyle.getFillPatternEnum());
        deststyle.setHidden(srcstyle.getHidden());
        deststyle.setIndention(srcstyle.getIndention());
        deststyle.setLeftBorderColor(srcstyle.getLeftBorderColor());
        deststyle.setLocked(srcstyle.getLocked());
        deststyle.setRightBorderColor(srcstyle.getRightBorderColor());
        deststyle.setRotation(srcstyle.getRotation());
        deststyle.setTopBorderColor(srcstyle.getTopBorderColor());
        deststyle.setVerticalAlignment(srcstyle.getVerticalAlignmentEnum());
        deststyle.setWrapText(srcstyle.getWrapText());
    }

    private static CellRangeAddress[] getMergedRegions(Sheet sheet) {
        int count = sheet.getNumMergedRegions();
        CellRangeAddress[] regions = new CellRangeAddress[count];
        for (int i = 0; i < count; ++i) {
            regions[i] = sheet instanceof HSSFSheet ? ((HSSFSheet)sheet).getMergedRegion(i) : ((XSSFSheet)sheet).getMergedRegion(i);
        }
        return regions;
    }

    private static void cloneSheet(Sheet src, Sheet dest, CreationHelper helper) {
        Header h;
        int first = Excel.getFirstRowNum(src);
        int last = Excel.getLastRowNum(src);
        HashMap<CellStyle, CellStyle> styleCache = new HashMap<CellStyle, CellStyle>();
        for (int j = first; j <= last; ++j) {
            Row row = src.getRow(j);
            if (row == null) continue;
            Row newrow = dest.createRow(j);
            newrow.setHeight(row.getHeight());
            int cellcount = row.getLastCellNum();
            for (int i = 0; i < cellcount; ++i) {
                Cell cell = row.getCell(i);
                if (cell != null && cell.getCellStyle() != null) {
                    dest.setColumnHidden(i, cell.getCellStyle().getHidden());
                }
                if (cell == null) continue;
                Cell newcell = newrow.createCell(cell.getColumnIndex(), cell.getCellType());
                Excel.cloneCell(cell, newcell, helper, styleCache);
            }
        }
        CellRangeAddress[] mergedRegions = Excel.getMergedRegions(src);
        for (int i = 0; i < mergedRegions.length; ++i) {
            dest.addMergedRegion(mergedRegions[i]);
        }
        PaneInformation paneinfo = src.getPaneInformation();
        if (null != paneinfo) {
            if (paneinfo.isFreezePane()) {
                dest.createFreezePane((int)paneinfo.getVerticalSplitPosition(), (int)paneinfo.getHorizontalSplitPosition(), (int)paneinfo.getVerticalSplitLeftColumn(), (int)paneinfo.getHorizontalSplitTopRow());
            } else {
                dest.createSplitPane((int)paneinfo.getVerticalSplitPosition(), (int)paneinfo.getHorizontalSplitPosition(), (int)paneinfo.getVerticalSplitLeftColumn(), (int)paneinfo.getHorizontalSplitTopRow(), (int)paneinfo.getActivePane());
            }
        }
        int columncount = Excel.getColumnCount(src);
        for (int i = 0; i < columncount; ++i) {
            int width = src.getColumnWidth(i);
            if (width > 65280) {
                dest.setColumnWidth(i, 65280);
                continue;
            }
            dest.setColumnWidth(i, width);
        }
        Footer f = src.getFooter();
        if (f != null) {
            Footer destf = dest.getFooter();
            destf.setCenter(f.getCenter());
            destf.setLeft(f.getLeft());
            destf.setRight(f.getRight());
        }
        if ((h = src.getHeader()) != null) {
            Header desth = dest.getHeader();
            desth.setCenter(h.getCenter());
            desth.setLeft(h.getLeft());
            desth.setRight(h.getRight());
        }
    }

    public static void writeExcel(String xlsfile, ExcelInfo i, String password, boolean update, Object autosizeColumn) {
        Workbook wb;
        Workbook book;
        block54: {
            book = i.getWorkbook();
            wb = null;
            Excel.cleanStyles(book);
            Excel.clearStyleMap(book);
            String action = "write";
            if (book != null) {
                try {
                    String sheetname = i.getExcelSheetName();
                    int sheetnumber = i.getExcelSheetNumber();
                    if (VFSFileFactory.getFileObject((String)xlsfile).exists() && update) {
                        action = "update";
                        InputStream inp = null;
                        try {
                            inp = VFSFileFactory.getInputStream((String)xlsfile);
                            wb = WorkbookFactory.create((InputStream)inp);
                        }
                        catch (IOException e) {
                            throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                        }
                        finally {
                            if (inp != null) {
                                try {
                                    inp.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        Sheet newsheet = wb.createSheet(sheetname);
                        CreationHelper helper = wb.getCreationHelper();
                        Sheet book_newSheet = book.getSheet(sheetname);
                        boolean isSheetAlreadyPresent = true;
                        if (book_newSheet == null) {
                            isSheetAlreadyPresent = false;
                            book_newSheet = book.createSheet(sheetname);
                        }
                        CreationHelper book_helper = book.getCreationHelper();
                        if (!Excel.isPasswordNull(password)) {
                            if (wb instanceof HSSFWorkbook) {
                                ((HSSFSheet)newsheet).protectSheet(password);
                            } else {
                                newsheet.protectSheet(password);
                            }
                        }
                        Sheet sheet = null;
                        sheet = i.isSheetNoProvided() ? book.getSheetAt(0) : book.getSheetAt(i.getExcelSheetNumber());
                        if (sheet != null) {
                            Excel.cloneSheet(sheet, newsheet, helper);
                            if (!isSheetAlreadyPresent) {
                                Excel.cloneSheet(sheet, book_newSheet, book_helper);
                            }
                            int sheetIndex = book.getSheetIndex(sheetname);
                            i.setExcelSheetNumber(sheetIndex);
                            book.setActiveSheet(sheetIndex);
                        }
                        OutputStream out = null;
                        try {
                            if (wb instanceof HSSFWorkbook) {
                                out = VFSFileFactory.getOutputStream((String)xlsfile);
                                wb.write(out);
                            }
                            break block54;
                        }
                        catch (IOException e) {
                            throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    OutputStream out = null;
                    try {
                        if (i.isSheetNoProvided()) {
                            sheetnumber = 0;
                        }
                        if (!book.getSheetName(sheetnumber).equalsIgnoreCase(sheetname)) {
                            book.setSheetName(sheetnumber, sheetname);
                        }
                        Sheet sheet = book.getSheet(sheetname);
                        if (autosizeColumn != null) {
                            Excel.autoResize(i, autosizeColumn);
                        }
                        if (!Excel.isPasswordNull(password)) {
                            if (book instanceof HSSFWorkbook) {
                                ((HSSFSheet)sheet).protectSheet(password);
                            } else {
                                sheet.protectSheet(password);
                            }
                        }
                        if (book instanceof HSSFWorkbook) {
                            out = VFSFileFactory.getOutputStream((String)xlsfile);
                            book.write(out);
                        }
                    }
                    catch (IOException e) {
                        throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception e) {
                    throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                }
            }
        }
        File poifile = VFSFileFactory.getFileObject((String)xlsfile);
        if (book instanceof HSSFWorkbook) {
            Excel.writeOLE2Summary(poifile, i);
        } else if (book instanceof XSSFWorkbook) {
            if (update) {
                Excel.writeXMLSummary(poifile, i, (XSSFWorkbook)wb);
            } else {
                Excel.writeXMLSummary(poifile, i, (XSSFWorkbook)book);
            }
        }
    }

    private static void clearStyleMap(Workbook book) {
        CELLSTYLESMAP.remove(book);
        CELLSTYLESALLMAP.remove(book);
    }

    private static boolean isPasswordNull(String password) {
        return password == null || password.length() == 0;
    }

    public static void writeExcel(String xlsfile, ArrayList<String[]> excelvar, String sheetname, String password, boolean update, Object autosizeColumn) {
        InputStream inp = null;
        OutputStream out = null;
        String action = "write";
        Object wb = null;
        if (update) {
            action = "update";
        }
        try {
            if (VFSFileFactory.getFileObject((String)xlsfile).exists() && update) {
                inp = VFSFileFactory.getInputStream((String)xlsfile);
                wb = WorkbookFactory.create((InputStream)inp);
            } else {
                wb = xlsfile.endsWith(".xls") ? new HSSFWorkbook() : new XSSFWorkbook();
            }
            CreationHelper helper = wb.getCreationHelper();
            Sheet s = null;
            if (wb != null) {
                s = wb.createSheet(sheetname);
            }
            if (!Excel.isPasswordNull(password)) {
                if (wb instanceof HSSFWorkbook) {
                    ((HSSFSheet)s).protectSheet(password);
                } else {
                    s.protectSheet(password);
                }
            }
            Row r = null;
            Cell c = null;
            ListIterator<String[]> iter = excelvar.listIterator();
            int start = 0;
            while (iter.hasNext()) {
                r = s.createRow(start);
                String[] row = iter.next();
                float columnwidth = 0.0f;
                for (int index = 0; index < row.length; ++index) {
                    c = r.createCell(index);
                    String value = row[index];
                    Double i = Cast._double((String)value, (boolean)false, (boolean)false, (boolean)false);
                    if (i != null) {
                        c.setCellType(CellType.NUMERIC);
                        c.setCellValue(i.doubleValue());
                        continue;
                    }
                    if (value.equals("")) {
                        c.setCellType(CellType.BLANK);
                        c.setCellValue(helper.createRichTextString(""));
                        continue;
                    }
                    c.setCellType(CellType.STRING);
                    RichTextString str = helper.createRichTextString(value);
                    c.setCellValue(str);
                    int colwidth = s.getColumnWidth(index);
                    short len = (short)value.length();
                    len = (short)((double)(len * 8) / 0.05);
                    if (colwidth >= len) continue;
                    s.setColumnWidth(index, len + 1);
                }
                ++start;
            }
            if (autosizeColumn != null) {
                Excel.autoResize(s, false, null, autosizeColumn);
            }
            out = VFSFileFactory.getOutputStream((String)xlsfile);
            wb.write(out);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        File poifile = VFSFileFactory.getFileObject((String)xlsfile);
        if (wb instanceof HSSFWorkbook) {
            Excel.writeOLE2Summary(poifile, null);
        } else if (wb instanceof XSSFWorkbook) {
            Excel.writeXMLSummary(poifile, null, (XSSFWorkbook)wb);
        }
    }

    private static void writeDocSummary(String xlsfile, ExcelInfo i) {
        Workbook newbook;
        File poifile;
        block8: {
            poifile = VFSFileFactory.getFileObject((String)xlsfile);
            newbook = null;
            InputStream is = null;
            try {
                is = VFSFileFactory.getInputStream((File)poifile);
                newbook = WorkbookFactory.create((InputStream)is);
            }
            catch (Exception e) {
                if (is == null) break block8;
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (newbook != null) {
            if (newbook instanceof HSSFWorkbook) {
                Excel.writeOLE2Summary(poifile, i);
            } else if (newbook instanceof XSSFWorkbook) {
                Excel.writeXMLSummary(poifile, i, (XSSFWorkbook)newbook);
            }
        }
    }

    public ArrayList<String[]> readXLS(String xlsfile, int sheetno, int row) {
        ArrayList<String[]> excel = new ArrayList<String[]>();
        InputStream inp = null;
        try {
            inp = VFSFileFactory.getInputStream((String)xlsfile);
            Workbook wb = WorkbookFactory.create((InputStream)inp);
            if (wb.getNumberOfSheets() <= sheetno) {
                throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
            }
            if (wb instanceof HSSFWorkbook && ((HSSFWorkbook)wb).isWriteProtected()) {
                throw new SpreadSheetTag.ExcelLockedSheetException();
            }
            Sheet sheet = wb.getSheetAt(sheetno);
            if (sheet != null) {
                excel = new ArrayList();
                String[] values = this.getValuesAt(sheet, row);
                if (values != null) {
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception exception) {}
            }
        }
        return excel;
    }

    public static int[] doProcessRange(String range) {
        int[] values = new int[2];
        try {
            if (range.contains("-")) {
                int dot = range.indexOf("-");
                values[0] = new Integer(range.substring(0, dot));
                if (range.length() >= 3) {
                    values[1] = new Integer(range.substring(dot + 1, range.length()));
                }
            } else {
                values[0] = new Integer(range);
                values[1] = values[0];
            }
        }
        catch (NumberFormatException e) {
            throw new SpreadSheetTag.InvalidRangeException(range);
        }
        return values;
    }

    public static Integer[] doProcessList(String list) {
        ArrayList<Integer> rangeval = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(list, "\t\n,");
            rangeval = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreElements()) {
                String token = stringTokenizer.nextToken().trim();
                if (token.contains("-")) {
                    int[] v = Excel.doProcessRange(token);
                    int startrow = v[0];
                    int endrow = v[1];
                    for (int j = startrow; j <= endrow; ++j) {
                        rangeval.add(j);
                    }
                    continue;
                }
                rangeval.add(new Integer(token));
            }
        }
        catch (NumberFormatException e) {
            throw new SpreadSheetTag.InvalidRangeException(list);
        }
        Integer[] retval = new Integer[rangeval.size()];
        for (int i = 0; i < rangeval.size(); ++i) {
            retval[i] = (Integer)rangeval.get(i);
        }
        return retval;
    }

    public void setAutofilter(String autofilter) {
        this.autofilter = autofilter;
    }

    public String getAutofilter() {
        return this.autofilter;
    }

    static {
        dateformatter.setTimeZone(TimeZone.getDefault());
        dateformatter2.setTimeZone(TimeZone.getDefault());
        DATATYPEMAPPER = new HashMap<Integer, Integer>();
        DATATYPEMAPPER.put(2, NUMERIC);
        DATATYPEMAPPER.put(4, NUMERIC);
        DATATYPEMAPPER.put(-5, NUMERIC);
        DATATYPEMAPPER.put(3, NUMERIC);
        DATATYPEMAPPER.put(8, NUMERIC);
        DATATYPEMAPPER.put(6, NUMERIC);
        DATATYPEMAPPER.put(-6, NUMERIC);
        DATATYPEMAPPER.put(5, NUMERIC);
        DATATYPEMAPPER.put(7, NUMERIC);
        DATATYPEMAPPER.put(0, NULL);
        DATATYPEMAPPER.put(16, STRING);
        DATATYPEMAPPER.put(91, DATETYPE);
        DATATYPEMAPPER.put(92, DATETYPE);
        DATATYPEMAPPER.put(93, DATETYPE);
        DATATYPESTRINGMAPPER = new CaseInsensitiveMap();
        STRINGDATATYPE = "STRING";
        DATEDATATYPE = "DATE";
        NUMERICDATATYPE = "NUMERIC";
        DATATYPESTRINGMAPPER.put(NUMERICDATATYPE, 2);
        DATATYPESTRINGMAPPER.put(STRINGDATATYPE, -1);
        DATATYPESTRINGMAPPER.put(DATEDATATYPE, 91);
        CELLSTYLESMAP = new WeakHashMap<Workbook, Map<Short, CellStyle>>();
        CELLSTYLESALLMAP = new WeakHashMap<Workbook, Map<Struct, CellStyle>>();
    }
}

