/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.tagext.net.websocket.server.protocol.ResponsePacketWriter;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class WebSocketFrameEncoder
extends OneToOneEncoder {
    private int webSocket_spec_version;

    public WebSocketFrameEncoder(int spec_version) {
        this.webSocket_spec_version = spec_version;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame.isText()) {
                if (this.webSocket_spec_version > -1) {
                    return ResponsePacketWriter.writeHybi_text(channel, frame);
                }
                return ResponsePacketWriter.writeHixie_text(channel, frame);
            }
            return ResponsePacketWriter.writeHixie_binary(channel, frame);
        }
        return msg;
    }
}

