/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.cluster;

import coldfusion.log.CFLogs;
import coldfusion.runtime.JSONUtils;
import coldfusion.tagext.net.websocket.server.cluster.PeerInfo;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.util.RB;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Map;
import org.apache.log4j.Logger;

public class MulticastDiscovery {
    public static byte MAGIC = 0;
    public static byte VERSION = 1;
    private static Logger logger = Logger.getLogger(MulticastDiscovery.class);
    private int port;
    private String groupName;
    private WebSocketClusterManager clusterManager;
    private MulticastSocket mcSocket;
    private InetAddress multicastGroup;
    private boolean keepListening = true;

    public MulticastDiscovery(String groupName, int multicast_port) {
        this.port = multicast_port;
        this.groupName = groupName;
        this.clusterManager = WebSocketClusterManager.getInstance();
        this.startMulticastSocket();
    }

    private void startMulticastSocket() {
        try {
            this.multicastGroup = InetAddress.getByName(this.groupName);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.debug((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastGroupNametNotFree", (Object)this.groupName));
        }
        try {
            this.mcSocket = new MulticastSocket(this.port);
            this.mcSocket.joinGroup(this.multicastGroup);
        }
        catch (IOException e) {
            e.printStackTrace();
            CFLogs.SERVER_LOG.info((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastPortNotFree", (Object)this.port));
        }
    }

    public void stopMulticastSocket() {
        try {
            this.keepListening = false;
            this.mcSocket.leaveGroup(this.multicastGroup);
            this.multicastGroup = null;
            this.mcSocket.close();
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastSocketStopError", (Object)e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastNodeUpMessage(PeerInfo peerInfo) {
        String data = JSONUtils.serializeJSON((Object)peerInfo.getPeerInfoAsMap(), (Object)false, (boolean)false, (boolean)false);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(MAGIC);
        DatagramPacket dp = null;
        try {
            bout.write(data.getBytes());
            bout.flush();
            dp = new DatagramPacket(bout.toByteArray(), bout.size(), this.multicastGroup, this.port);
            bout.close();
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastNodeUpBroadcastError", (Object)e.getMessage()));
        }
        try {
            this.mcSocket.send(dp);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastNodeUpBroadcastError", (Object)e.getMessage()));
        }
        finally {
            dp = null;
        }
    }

    public void startListeningInMessage() {
        MultiCastReceiver multicastReceiver = new MultiCastReceiver();
        Thread multicastReceiverThread = new Thread(multicastReceiver);
        multicastReceiverThread.start();
    }

    private PeerInfo parseInMessage(DatagramPacket dataPacket) {
        PeerInfo peer = null;
        try {
            String data = null;
            byte[] dataInput = dataPacket.getData();
            peer = new PeerInfo();
            if (dataInput[0] == MAGIC) {
                data = new String(dataInput, 1, dataPacket.getLength() - 1);
            }
            if (data != null) {
                Map peerInfoMap = null;
                Object jsonObject = JSONUtils.deserializeJSON(data, (boolean)true, (boolean)false);
                if (jsonObject instanceof Map) {
                    peerInfoMap = (Map)jsonObject;
                } else {
                    CFLogs.WEBSOCKET_LOG.info((Object)"WebSocket request header should be in map format as key-value pair.");
                }
                if (peerInfoMap != null) {
                    String hostName = (String)peerInfoMap.get("HOSTNAME");
                    String nodeName = (String)peerInfoMap.get("NODENAME");
                    String nodeIP = (String)peerInfoMap.get("NODEIP");
                    peer.setHostName(hostName);
                    peer.setNodeName(nodeName);
                }
            }
        }
        catch (Exception e) {
            CFLogs.WEBSOCKET_LOG.info((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastNotificatiMessageParseError", (Object)e.getMessage()));
        }
        return peer;
    }

    private class MultiCastReceiver
    implements Runnable {
        private MultiCastReceiver() {
        }

        @Override
        public void run() {
            CFLogs.WEBSOCKET_LOG.info((Object)"Starting MultiCast socket listener to receive node up/down event..");
            while (MulticastDiscovery.this.keepListening) {
                try {
                    byte[] inbuf = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(inbuf, inbuf.length);
                    MulticastDiscovery.this.mcSocket.receive(packet);
                    PeerInfo peer = MulticastDiscovery.this.parseInMessage(packet);
                    MulticastDiscovery.this.clusterManager.addAndAcknowledgeRemotePeer(peer);
                }
                catch (IOException e) {
                    CFLogs.WEBSOCKET_LOG.info((Object)RB.getString(MulticastDiscovery.class, (String)"MulticastNotificationReceiveError", (Object)e.getMessage()));
                }
            }
        }
    }
}

