/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.ContainerReference;
import coldfusion.azure.blob.consumer.AbstractAccessRequestConsumer;
import coldfusion.azure.blob.consumer.AccessConditionConsumer;
import coldfusion.azure.blob.request.BlobCopyRequest;
import coldfusion.cloud.CloudServiceAgent;
import coldfusion.cloud.CloudVendorName;
import coldfusion.cloud.VendorCredential;
import coldfusion.cloud.azure.AzureCredential;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.blob.StandardBlobTier;
import java.util.Collections;
import java.util.Objects;

public class BlobCopyRequestConsumer
extends AbstractAccessRequestConsumer<BlobCopyRequest> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public BlobCopyRequestConsumer() {
        this.put("source", new ConsumerValidator((blobCopyRequest, value) -> {
            String src = this.cast.getStringProperty(value);
            int index = src.indexOf(47);
            blobCopyRequest.setSourceContainer(src.substring(0, index));
            blobCopyRequest.setSourceBlob(src.substring(index + 1));
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("sourceVersion", new ConsumerValidator((blobCopyRequest, value) -> blobCopyRequest.setSnapshotId(this.cast.getStringProperty(value)), Collections.emptyList()));
        this.put("sourceAccessCondition", new ConsumerValidator((blobCopyRequest, value) -> {
            AccessCondition accessCondition = new AccessCondition();
            ValidatorFiller.INSTANCE.fillObject((Object)accessCondition, this.cast.getMapProperty(value), (ConsumerMap)new AccessConditionConsumer());
            blobCopyRequest.setSourceAccessCondition(accessCondition);
        }, Collections.emptyList()));
        this.put("root", new ConsumerValidator((blobCopyRequest, value) -> blobCopyRequest.setDestinationContainer(this.cast.getStringProperty(value)), Collections.emptyList()));
        this.put("blobName", new ConsumerValidator((blobCopyRequest, value) -> blobCopyRequest.setDestinationBlob(this.cast.getStringProperty(value)), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("storageClass", new ConsumerValidator((blobCopyRequest, value) -> blobCopyRequest.setStorageClass(StandardBlobTier.valueOf((String)this.cast.getStringProperty(value))), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("credential", new ConsumerValidator((blobCopyRequest, value) -> {
            VendorCredential azureCredential = ServiceFactory.getVendorCredentialService().getVendorCredential(value);
            if (Objects.isNull(azureCredential)) {
                throw new ValidationException(RB.getString(CloudServiceAgent.class, (String)"incorrectCredentialAlias"));
            }
            if (azureCredential.vendorName() != CloudVendorName.AZURE) {
                throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidAzureCredential"));
            }
            blobCopyRequest.setAzureCredential((AzureCredential)azureCredential);
        }, Collections.emptyList()));
    }
}

