/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.s3.S3ServiceConfig;
import coldfusion.s3.S3ServiceImpl;
import coldfusion.s3.S3Utils;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public enum S3ServiceProducer implements CloudServiceProducer<AWSCredential, S3ServiceConfig>
{
    INSTANCE;

    private static Map<Integer, CloudService> cloudServiceMap;

    public CloudService getServiceHandle(AWSCredential vendorCredential, S3ServiceConfig serviceConfig) {
        int hashCode = Objects.hash(vendorCredential.hashCode(), serviceConfig.hashCode());
        return cloudServiceMap.getOrDefault(hashCode, this.getS3ServiceHandle(hashCode, vendorCredential, serviceConfig));
    }

    private CloudService getS3ServiceHandle(int hashCode, AWSCredential vendorCredential, S3ServiceConfig serviceConfig) {
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)vendorCredential.getRegion()))).credentialsProvider(S3Utils.getAWSCredential(vendorCredential))).httpClient(ApacheHttpClient.builder().connectionMaxIdleTime(Duration.ofSeconds(60L)).maxConnections(Integer.valueOf(50)).build());
        Optional.ofNullable(serviceConfig.httpClientBuilder).ifPresent(httpClientBuilder -> {
            s3ClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
            s3ClientBuilder.httpClient(null);
        });
        Optional.ofNullable(serviceConfig.clientOverrideConfiguration).ifPresent(arg_0 -> ((S3ClientBuilder)s3ClientBuilder).overrideConfiguration(arg_0));
        Optional.ofNullable(serviceConfig.getS3Configuration()).ifPresent(arg_0 -> ((S3ClientBuilder)s3ClientBuilder).serviceConfiguration(arg_0));
        S3Client s3Client = (S3Client)s3ClientBuilder.build();
        S3ServiceImpl s3Service = new S3ServiceImpl(s3Client, vendorCredential);
        cloudServiceMap.put(hashCode, s3Service);
        return s3Service;
    }

    static {
        cloudServiceMap = new HashMap<Integer, CloudService>();
    }
}

