/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.es;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.Settings;
import coldfusion.monitor.beans.Cluster;
import coldfusion.monitor.beans.ESDetails;
import coldfusion.monitor.beans.Group;
import coldfusion.monitor.beans.NonRequestData;
import coldfusion.monitor.beans.RequestData;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.datastore.MonitoringDatastoreClient;
import coldfusion.monitor.datastore.QueryBuilder;
import coldfusion.monitor.es.RingBufferESRequestEvent;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.monitor.util.PasswordUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceFactory;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.sniff.ElasticsearchHostsSniffer;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.node.Node;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public enum ElasticSearchClient implements MonitoringDatastoreClient
{
    INSTANCE;

    private RestClient restClient;
    private Sniffer sniffer;
    private boolean isInitialized;
    String libDir = System.getProperty("lib_dir");
    private Logger logger = CFLogs.MONITOR_LOG;
    String esHost = "";
    int esPort = 0;
    String esProtocol;
    String esUsername;
    String esPassword;
    private BulkProcessor bulkProcessor;
    private Disruptor<RingBufferESRequestEvent> disruptor;
    private static boolean dump_to_es;
    private static boolean dump_to_lmax;
    private String bulkWaitSrategy = "LITE";
    private int connectionRequestTimeOut = 120000;
    private int socketTimeOut = 120000;
    private int connectionTimeOut = 120000;
    private int retryTimeOut = 12000;
    private int es_bulk_action = 2000;
    private int es_bulk_size = 10;
    private int es_sniffInterval = 30000;
    private int es_bulk_threads = Runtime.getRuntime().availableProcessors();
    private int es_flush_interval = 10;
    private int es_numberof_retry = 3;
    private int ring_buffer_size = 2048;
    private int retryCount = 0;

    public void initializeDBParameters(ConfigMap generalSettings) {
        this.esHost = Settings.toStringValue((Map)generalSettings, (String)"elasticsearchhost", (String)"");
        this.esPort = Settings.toIntValue((Map)generalSettings, (String)"elasticsearchport", (int)0);
        this.esProtocol = Settings.toStringValue((Map)generalSettings, (String)"elasticSearchProtocol", (String)"http");
        this.esUsername = Settings.toStringValue((Map)generalSettings, (String)"elasticSearchUsername", (String)"");
        this.esPassword = PasswordUtils.decryptPassword((String)Settings.toStringValue((Map)generalSettings, (String)"elasticSearchPassword", (String)""));
    }

    private void initializeESConfig(ConfigMap generalSettings) {
        this.bulkWaitSrategy = Settings.toStringValue((Map)generalSettings, (String)"bulkwaitstrategy", (String)"LITE");
        this.connectionRequestTimeOut = Settings.toIntValue((Map)generalSettings, (String)"esconnectionrequesttimeout", (int)120000);
        this.socketTimeOut = Settings.toIntValue((Map)generalSettings, (String)"essockettimeout", (int)120000);
        this.connectionTimeOut = Settings.toIntValue((Map)generalSettings, (String)"esconnectiontimeout", (int)120000);
        this.retryTimeOut = Settings.toIntValue((Map)generalSettings, (String)"esretrytimeout", (int)120000);
        this.es_bulk_action = Settings.toIntValue((Map)generalSettings, (String)"esbulkaction", (int)2000);
        this.es_bulk_size = Settings.toIntValue((Map)generalSettings, (String)"esbulksize", (int)10);
        this.es_sniffInterval = Settings.toIntValue((Map)generalSettings, (String)"essniffinterval", (int)30000);
        this.es_bulk_threads = Settings.toIntValue((Map)generalSettings, (String)"esbulkthreads", (int)Runtime.getRuntime().availableProcessors());
        this.es_flush_interval = Settings.toIntValue((Map)generalSettings, (String)"esflushinterval", (int)10);
        this.es_numberof_retry = Settings.toIntValue((Map)generalSettings, (String)"esnumberofretry", (int)3);
        this.ring_buffer_size = Settings.toIntValue((Map)generalSettings, (String)"ringbuffersize", (int)2048);
    }

    public void initialize(ConfigMap generalSettings) {
        try {
            this.initializeDBParameters(generalSettings);
            this.initializeESConfig(generalSettings);
            ESDetails esDetails = new ESDetails();
            esDetails.setElasticSearchHost(this.esHost);
            esDetails.setElsaticSearchPort(this.esPort);
            esDetails.setElasticSearchProtocol(this.esProtocol);
            esDetails.setUsername(this.esUsername);
            esDetails.setPassword(this.esPassword);
            if (!this.validateUrl(esDetails)) {
                return;
            }
            this.createClients(esDetails);
            this.isInitialized = true;
        }
        catch (Exception ex) {
            this.isInitialized = false;
        }
    }

    public void setIntialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public String query(String index, String type, String requestBody, String filterPath) {
        String responseJson = "";
        Response response = null;
        NStringEntity entity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
        try {
            response = filterPath == null ? this.restClient.performRequest("POST", index + "/" + type + "/_search/template?ignore_unavailable=true", Collections.emptyMap(), (HttpEntity)entity, new Header[0]) : this.restClient.performRequest("POST", index + "/" + type + "/_search/template?filter_path=" + filterPath + "?ignore_unavailable=true", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            System.err.println("error while making query from es");
            e.printStackTrace();
        }
        return responseJson;
    }

    public String getElasticSearchHost() {
        return this.esHost;
    }

    public int getElasticSearchPort() {
        return this.esPort;
    }

    public boolean validateUrl(ESDetails esDetails) {
        if (esDetails.getElasticSearchHost().length() <= 0 || esDetails.getElsaticSearchPort() == 0) {
            if (!ServiceFactory.getRuntimeService().isCommandLineCompile()) {
                // empty if block
            }
            return false;
        }
        if (!this.isElasticSearchUp(esDetails)) {
            this.logger.warn((Object)("ElasticSearch instance host:port " + esDetails.getElasticSearchHost() + ":" + esDetails.getElsaticSearchPort() + " is not running, hence Monitoring Service is not initialized"));
            return false;
        }
        return true;
    }

    public boolean isElasticSearchUp(ESDetails esDetails) {
        boolean running = false;
        RestClient restClient = INSTANCE.createRestClient(esDetails);
        try {
            Response response = restClient.performRequest("GET", "/", Collections.singletonMap("pretty", "true"), new Header[0]);
            if (response.getStatusLine().getStatusCode() == 200) {
                running = true;
            }
            restClient.close();
        }
        catch (Exception e) {
            running = false;
            this.logger.warn((Object)("ElasticSearch with host: " + esDetails.getElasticSearchHost() + " and port: " + esDetails.getElsaticSearchPort() + " is not running. Exception: " + e.getMessage()));
        }
        return running;
    }

    public RestClient createRestClient(ESDetails esDetails) {
        RestClient restClient = null;
        RestClientBuilder builder = null;
        if (esDetails != null && esDetails.getUsername() != null && esDetails.getPassword() != null && esDetails.getUsername() != "" && esDetails.getPassword() != "") {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esDetails.getUsername(), esDetails.getPassword()));
            builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esDetails.getElasticSearchHost(), esDetails.getElsaticSearchPort(), esDetails.getElasticSearchProtocol())}).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    return requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(3600000);
                }
            }).setMaxRetryTimeoutMillis(60000).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                    return httpAsyncClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 4).build());
                }
            });
        } else {
            builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esDetails.getElasticSearchHost(), esDetails.getElsaticSearchPort(), esDetails.getElasticSearchProtocol())}).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    return requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(3600000);
                }
            }).setMaxRetryTimeoutMillis(60000).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                    return httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 4).build());
                }
            });
        }
        restClient = builder.build();
        return restClient;
    }

    public void createClients(ESDetails esDetails) {
        if (this.restClient == null) {
            this.restClient = this.createRestClient(esDetails);
        }
        if (esDetails.getElasticSearchProtocol().equalsIgnoreCase("https")) {
            ElasticsearchHostsSniffer hostsSniffer = new ElasticsearchHostsSniffer(this.restClient, ElasticsearchHostsSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchHostsSniffer.Scheme.HTTPS);
            this.sniffer = Sniffer.builder((RestClient)this.restClient).setSniffIntervalMillis(30000).setHostsSniffer((HostsSniffer)hostsSniffer).build();
        } else {
            this.sniffer = Sniffer.builder((RestClient)this.restClient).setSniffIntervalMillis(this.es_sniffInterval).build();
        }
        RestHighLevelClient client = new RestHighLevelClient(this.restClient);
        org.elasticsearch.common.settings.Settings settings = org.elasticsearch.common.settings.Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), "high-level-client").build();
        ThreadPool threadPool = new ThreadPool(settings, new ExecutorBuilder[0]);
        BulkProcessor.Builder builder = new BulkProcessor.Builder((x$0, x$1) -> client.bulkAsync(x$0, x$1, new Header[0]), this.getBulkListener(), threadPool);
        builder.setBulkActions(this.es_bulk_action);
        builder.setBulkSize(new ByteSizeValue((long)this.es_bulk_size, ByteSizeUnit.MB));
        builder.setConcurrentRequests(this.es_bulk_threads);
        builder.setFlushInterval(TimeValue.timeValueSeconds((long)this.es_flush_interval));
        builder.setBackoffPolicy(BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueSeconds((long)1L), (int)this.es_numberof_retry));
        this.bulkProcessor = builder.build();
        String DUMP_ES = System.getProperty("DUMP_ES", "true");
        dump_to_es = Boolean.parseBoolean(DUMP_ES);
        String DUMP_LMAX = System.getProperty("DUMP_LMAX", "true");
        dump_to_lmax = Boolean.parseBoolean(DUMP_LMAX);
        this.logger.debug((Object)("BULK_ACTION: " + this.es_bulk_action));
        this.logger.debug((Object)("BULK_SIZE: " + this.es_bulk_size));
        this.logger.debug((Object)("Bulk Wait Strategy: " + this.bulkWaitSrategy));
        this.logger.debug((Object)("BUFFER_SIZE: " + this.ring_buffer_size));
        this.logger.debug((Object)("BULK_THREADS: " + this.es_bulk_threads));
        this.logger.debug((Object)("Dump to LMAX: " + DUMP_LMAX));
        this.logger.debug((Object)("Dump to ES: " + DUMP_ES));
        if (dump_to_lmax) {
            this.disruptor = new Disruptor(RingBufferESRequestEvent::new, this.ring_buffer_size, Executors.defaultThreadFactory(), ProducerType.MULTI, this.getWaitStrategy());
            this.disruptor.handleEventsWith(new EventHandler[]{(event, sequence, endOfBatch) -> {
                if (event.getRequestData() != null) {
                    event.converReqestDataToIndexRequest();
                }
                if (event.getNonRequestData() != null) {
                    event.converNonReqestDataToIndexRequest();
                }
                if (dump_to_es) {
                    this.bulkProcessor.add(event.getRequest());
                }
            }});
            this.disruptor.start();
        }
    }

    private WorkHandlerImpl[] getWorkHandlers(int count) {
        WorkHandlerImpl[] workHandlers = new WorkHandlerImpl[count];
        for (int i = 0; i < count; ++i) {
            WorkHandlerImpl impl;
            workHandlers[i] = impl = new WorkHandlerImpl();
        }
        return workHandlers;
    }

    private WaitStrategy getWaitStrategy() {
        switch (this.bulkWaitSrategy) {
            case "BLOCK": {
                return new BlockingWaitStrategy();
            }
            case "YIELD": {
                return new YieldingWaitStrategy();
            }
            case "SLEEP": {
                return new SleepingWaitStrategy();
            }
            case "SPIN": {
                return new BusySpinWaitStrategy();
            }
            case "LITE": {
                return new LiteBlockingWaitStrategy();
            }
        }
        return new BlockingWaitStrategy();
    }

    private BulkProcessor.Listener getBulkListener() {
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                int numberOfActions = request.numberOfActions();
                ElasticSearchClient.this.logger.debug((Object)("Executing bulk" + executionId + " with " + numberOfActions + " requests"));
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    ElasticSearchClient.this.logger.error((Object)"Bulk Failed");
                } else {
                    ElasticSearchClient.this.logger.debug((Object)("Bulk requests completed in " + response.getTook().getMillis() + " milliseconds"));
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                if (failure instanceof NoNodeAvailableException) {
                    ElasticSearchClient.this.logger.error((Object)"Datastore server is not accessible", failure);
                } else {
                    ElasticSearchClient.this.logger.error((Object)"Error sending data to datastore server", failure);
                    failure.printStackTrace();
                }
            }
        };
        return listener;
    }

    public void closeConnection() {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
            if (this.restClient != null) {
                this.restClient.close();
            }
            if (this.bulkProcessor != null) {
                this.bulkProcessor.flush();
                this.bulkProcessor.close();
            }
            if (this.disruptor != null) {
                this.disruptor.shutdown();
            }
            this.restClient = null;
            this.sniffer = null;
            this.bulkProcessor = null;
            this.isInitialized = false;
        }
        catch (IOException e) {
            this.logger.error((Object)"Error Closing the ES Client ", (Throwable)e);
        }
    }

    public Cluster findClusterId(String host, String port) {
        Map params = Collections.emptyMap();
        String query = this.getClusterQuery(host, port);
        NStringEntity entity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        try {
            Response indexResponse = INSTANCE.getRestClient().performRequest("POST", "/misc_data/cluster_config_data/_search/template", params, (HttpEntity)entity, new Header[0]);
            String responseBody = EntityUtils.toString((HttpEntity)indexResponse.getEntity());
            Cluster clusterObj = JSONConverter.INSTANCE.toClusterObject(responseBody);
            this.logger.debug((Object)("cluster id set is  " + Configuration.INSTANCE.getClusterId()));
            return clusterObj;
        }
        catch (IOException io) {
            this.logger.debug((Object)"Current node is not a part of any cluster", (Throwable)io);
            return null;
        }
    }

    public HttpEntity call(String method, String endpoint, Map<String, String> params, HttpEntity entity) {
        try {
            Response response = INSTANCE.getRestClient().performRequest("GET", "/alerts/notification/_search", Collections.singletonMap("pretty", "true"), entity, new Header[0]);
            if (response != null) {
                return response.getEntity();
            }
        }
        catch (IOException io) {
            this.logger.debug((Object)("Error while calling the method " + method + ", endpoint " + endpoint), (Throwable)io);
        }
        return null;
    }

    private String getClusterQuery(String host, String port) {
        String query = QueryBuilder.getQuery((String)"cluster-group-from-instance", Arrays.asList("host", "port"), Arrays.asList(host, port));
        return query;
    }

    public String findGroupId(String instanceId) {
        Map params = Collections.emptyMap();
        String query = JSONConverter.INSTANCE.getClusterQuery(instanceId);
        NStringEntity entity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        try {
            Response indexResponse = INSTANCE.getRestClient().performRequest("POST", "/misc_data/group_config_data/_search", params, (HttpEntity)entity, new Header[0]);
            String responseBody = EntityUtils.toString((HttpEntity)indexResponse.getEntity());
            Group groupObj = JSONConverter.INSTANCE.toGroupObject(responseBody);
            if (groupObj != null) {
                this.logger.debug((Object)("Group id set is  " + groupObj.getGroupId()));
                Configuration.INSTANCE.setGroupId(groupObj.getGroupId());
                Configuration.INSTANCE.setGroupName(groupObj.getGroupName());
                return groupObj.getGroupId();
            }
            if (Configuration.INSTANCE.getGroupId() != null) {
                Configuration.INSTANCE.setGroupId(null);
                Configuration.INSTANCE.setGroupName(null);
            }
        }
        catch (IOException io) {
            this.logger.error((Object)"Current node is not part of group", (Throwable)io);
        }
        return null;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public boolean isInitialized() {
        return this.isInitialized && Configuration.INSTANCE.isEsHealthy();
    }

    public void updateDocument(String index, String type, String docId, String scriptCode, Map<String, Object> params) {
        Script script = new Script(ScriptType.INLINE, "painless", scriptCode, params);
        String requestId = docId;
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).type(type).id(docId).script(script).scriptParams(params);
        updateRequest.retryOnConflict(3);
        this.sendMetric(updateRequest);
    }

    public void submit(String json) {
        IndexRequest request = new IndexRequest(this.getLatestRequestIndex(), "request").source(json, XContentType.JSON);
        this.sendMetric(request);
    }

    public void submit(Map data) {
        IndexRequest request = new IndexRequest(this.getLatestRequestIndex(), "request").source(data);
        this.sendMetric(request);
    }

    public void submit(RequestData data) {
        this.sendMetric(data);
    }

    public void submit(NonRequestData data) {
        this.sendMetric(data);
    }

    public void submit(String json, String index, String type) {
        IndexRequest request = new IndexRequest(index, type).source(json, XContentType.JSON);
        this.sendMetric(request);
    }

    public void submit(String json, String index, String type, String id) {
        IndexRequest request = new IndexRequest(index, type, id).source(json, XContentType.JSON);
        this.sendMetric(request);
    }

    public void submit(String json, String type) {
        IndexRequest request = new IndexRequest(this.getLatestRequestIndex(), type).source(json, XContentType.JSON);
        this.sendMetricDirect(request);
    }

    private void sendMetricDirect(IndexRequest request) {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.add(request);
        }
    }

    private void sendMetric(IndexRequest request) {
        if (dump_to_lmax) {
            this.disruptor.publishEvent((event, sequence) -> event.setRequest(request));
        }
    }

    public void sendMetric(UpdateRequest request) {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.add((DocWriteRequest)request);
        }
    }

    private void sendMetric(RequestData requestData) {
        if (dump_to_lmax) {
            this.disruptor.publishEvent((event, sequence) -> event.setRequestData(requestData));
        }
    }

    private void sendMetric(NonRequestData nonrequestData) {
        if (dump_to_lmax) {
            this.disruptor.publishEvent((event, sequence) -> event.setNonRequestData(nonrequestData));
        }
    }

    public String getLatestRequestIndex() {
        LocalDate date = LocalDate.now();
        String index = "request-data-" + date.toString();
        return index;
    }

    public String getDocument(String endPoint) {
        String json = null;
        try {
            Response response = this.restClient.performRequest("GET", endPoint, Collections.singletonMap("pretty", "true"), new Header[0]);
            HttpEntity entity = response.getEntity();
            json = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException ex) {
            this.logger.error((Object)"Error retrieving configuration object, verify PMS settings", (Throwable)ex);
        }
        return json;
    }

    public boolean indexExists(String index) {
        if (this.restClient != null) {
            try {
                Response response = this.restClient.performRequest("GET", index, Collections.singletonMap("pretty", "true"), new Header[0]);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return true;
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)(index + " does not exists"), (Throwable)ex);
            }
        }
        return false;
    }

    public boolean documentExists(String docId) {
        if (this.restClient != null) {
            try {
                Response response = this.restClient.performRequest("GET", docId, Collections.singletonMap("pretty", "true"), new Header[0]);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return true;
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)(docId + " does not exists"), (Throwable)ex);
            }
        }
        return false;
    }

    public int indexDocument(String str, String index, String type) {
        this.logger.debug((Object)("indexing data for index" + index));
        Response indexResponse = null;
        NStringEntity entity = new NStringEntity(str, ContentType.APPLICATION_JSON);
        try {
            indexResponse = this.restClient.performRequest("POST", index + type + "/", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        }
        catch (IOException ex) {
            this.logger.error((Object)("Exception while calling indexDocument :" + ex.getStackTrace()));
        }
        return indexResponse.getStatusLine().getStatusCode();
    }

    public int indexDocument(String str, String index, String type, String id) {
        this.logger.debug((Object)("indexing data for index" + index));
        Response indexResponse = null;
        NStringEntity entity = new NStringEntity(str, ContentType.APPLICATION_JSON);
        try {
            indexResponse = this.restClient.performRequest("POST", index + type + id + "/", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        }
        catch (IOException ex) {
            this.logger.error((Object)("Exception while calling indexDocument :" + ex.getStackTrace()));
        }
        return indexResponse.getStatusLine().getStatusCode();
    }

    public int indexDocument(String str, String url) {
        this.logger.debug((Object)("indexing data for url" + url));
        Response indexResponse = null;
        NStringEntity entity = new NStringEntity(str, ContentType.APPLICATION_JSON);
        try {
            indexResponse = this.restClient.performRequest("POST", url, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        }
        catch (ResponseException ex) {
            this.logger.error((Object)("Response exception occurred while calling indexDocument : for url " + url + " with document " + str), (Throwable)ex);
            return 500;
        }
        catch (IOException ex) {
            if (this.retryCount < 3) {
                this.logger.error((Object)("Exception occurred while calling indexDocument : for url " + url + " with document " + str), (Throwable)ex);
                ++this.retryCount;
            } else {
                Configuration.INSTANCE.setEsHealthy(false);
            }
            return 500;
        }
        catch (Throwable ex) {
            if (this.retryCount < 3) {
                this.logger.error((Object)("Exception occurred while calling indexDocument : for url " + url + " with document " + str), ex);
                ++this.retryCount;
            } else {
                Configuration.INSTANCE.setEsHealthy(false);
            }
            return 500;
        }
        if (!Configuration.INSTANCE.isEsHealthy()) {
            this.retryCount = 0;
            Configuration.INSTANCE.setEsHealthy(true);
            TaskScheduler.INSTANCE.updateStaticMetrics();
        }
        return indexResponse.getStatusLine().getStatusCode();
    }

    public boolean isESUrlChanged(String host, int port) {
        if (!Configuration.INSTANCE.isSettingsLoaded()) {
            return true;
        }
        String existingESHost = INSTANCE.getElasticSearchHost();
        int existingESPort = INSTANCE.getElasticSearchPort();
        if (existingESHost == null || existingESPort == 0) {
            return false;
        }
        if (existingESHost == host && existingESPort == port) {
            return false;
        }
        return false;
    }

    public void call(String json, String index, String type, String api) {
        try {
            NStringEntity entity = new NStringEntity(json, ContentType.APPLICATION_JSON);
            this.restClient.performRequest("POST", index + type + "/" + api, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)("Fatal transport error: " + e.getMessage()));
            this.logger.debug((Object)("Detailed error: " + e.getStackTrace()));
        }
    }

    public boolean isDataSourceUp() {
        if (!this.isInitialized) {
            return false;
        }
        return this.indexExists("/");
    }

    public void deleteDocument(String index, String type, String id) {
        this.logger.debug((Object)("deleting document" + index));
        try {
            if (this.documentExists("/" + index + "/" + type + "/" + id + "/")) {
                this.getRestClient().performRequest("DELETE", "/" + index + "/" + type + "/" + id + "/", Collections.emptyMap(), new Header[0]);
            }
        }
        catch (IOException ex) {
            this.logger.debug((Object)"Exception while deleting heartbeat document for custom instance name in horizontal cluster :", (Throwable)ex);
        }
    }

    static {
        dump_to_es = true;
        dump_to_lmax = true;
    }

    private class WorkHandlerImpl
    implements WorkHandler<RingBufferESRequestEvent> {
        private WorkHandlerImpl() {
        }

        public void onEvent(RingBufferESRequestEvent event) throws Exception {
            if (event.getRequestData() != null) {
                event.converReqestDataToIndexRequest();
            }
            if (dump_to_es) {
                ElasticSearchClient.this.bulkProcessor.add(event.getRequest());
            }
        }
    }
}

