/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.frodo;

import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.BufferedBlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.digests.SHAKEDigest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.engines.AESEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Exceptions;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n2, int n3) {
        this.n = n2;
        this.q = n3;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        BufferedBlockCipher cipher = new BufferedBlockCipher(new AESEngine());

        public Aes128MatrixGenerator(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            for (int i2 = 0; i2 < this.n; ++i2) {
                for (int i3 = 0; i3 < this.n; i3 += 8) {
                    System.arraycopy(Pack.shortToLittleEndian((short)(i2 & 0xFFFF)), 0, byArray2, 0, 2);
                    System.arraycopy(Pack.shortToLittleEndian((short)(i3 & 0xFFFF)), 0, byArray2, 2, 2);
                    this.aes128(byArray3, byArray, byArray2);
                    for (int i4 = 0; i4 < 8; ++i4) {
                        sArray[i2 * this.n + i3 + i4] = (short)(Pack.littleEndianToShort(byArray3, 2 * i4) % this.q);
                    }
                }
            }
            return sArray;
        }

        void aes128(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            try {
                KeyParameter keyParameter = new KeyParameter(byArray2);
                this.cipher.init(true, keyParameter);
                int n2 = this.cipher.processBytes(byArray3, 0, byArray3.length, byArray, 0);
                this.cipher.doFinal(byArray, n2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw Exceptions.illegalStateException(invalidCipherTextException.toString(), invalidCipherTextException);
            }
        }
    }

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16 * this.n / 8];
            for (short s2 = 0; s2 < this.n; s2 = (short)(s2 + 1)) {
                byte[] byArray3 = Arrays.concatenate(Pack.shortToLittleEndian(s2), byArray);
                SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
                sHAKEDigest.update(byArray3, 0, byArray3.length);
                sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
                for (int n2 = 0; n2 < this.n; n2 = (int)((short)(n2 + 1))) {
                    sArray[s2 * this.n + n2] = (short)(Pack.littleEndianToShort(byArray2, 2 * n2) % this.q);
                }
            }
            return sArray;
        }
    }
}

