/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.resourceloader;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.LoaderHelpers;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import com.lotus.sametime.resourceloader.TocFile;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ResourceLoaderComp
implements ResourceLoaderService,
STCompApi {
    private static final String RESOURCE_FILE_EXTENSION = ".properties";
    private static final String ARCHIVE_FILE_EXTENSION = ".zip";
    private Locale m_locale = null;
    private URL m_searchPath = null;
    private String m_namespace = null;
    private Hashtable m_resourceTable = new Hashtable();
    private Hashtable m_tocTable = new Hashtable();
    private Vector m_missingTocList = new Vector();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.resourceloader");

    public ResourceLoaderComp(STSession sTSession) throws DuplicateObjectException {
        sTSession.registerComponent("com.lotus.sametime.resourceloader.ResourceLoaderComp", this);
    }

    public void processSTEvent(STEvent sTEvent) {
    }

    public void componentLoaded(STCompApi sTCompApi) {
    }

    public void setNamespace(String string) {
        this.m_namespace = string;
        this.m_resourceTable.clear();
        this.m_tocTable.clear();
        this.m_missingTocList.removeAllElements();
    }

    public STBundle getBundle(String string) {
        STBundle sTBundle = this.getBundle(string, this.m_searchPath);
        if (sTBundle == null && this.m_searchPath != null) {
            sTBundle = this.getBundle(string, null);
        }
        return sTBundle;
    }

    public STBundle getBundle(String string, boolean bl) {
        if (bl) {
            return this.getBundle(string, this.m_searchPath);
        }
        return this.getBundle(string, null);
    }

    public STBundle getBundle(String string, URL uRL) {
        if (uRL == null) {
            return this.getBundle(string, this.getLocale(), null);
        }
        return this.getBundle(string, this.getLocale(), uRL.toExternalForm());
    }

    public STBundle getBundle(String string, Locale locale, String string2) {
        STBundle sTBundle = null;
        STBundle sTBundle2 = null;
        STBundle sTBundle3 = null;
        Vector vector = this.createSearchStrings(string, locale);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            sTBundle2 = this.fetchResourceBundle(string2, string3 + RESOURCE_FILE_EXTENSION);
            if (sTBundle2 == null) continue;
            if (sTBundle == null) {
                sTBundle = sTBundle2;
            }
            if (sTBundle3 != null) {
                sTBundle3.setParent(sTBundle2);
            }
            sTBundle3 = sTBundle2;
        }
        if (sTBundle == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getBundle", "Warning: bundle " + string + " not found");
            }
            System.out.println("Failed to load the required resources, Check that the resource are available in your classpath");
        }
        return sTBundle;
    }

    public boolean getResourceArchive(String string) {
        boolean bl = this.getResourceArchive(string, this.m_searchPath);
        if (!bl && this.m_searchPath != null) {
            bl = this.getResourceArchive(string, null);
        }
        return bl;
    }

    public boolean getResourceArchive(String string, boolean bl) {
        if (bl) {
            return this.getResourceArchive(string, this.m_searchPath);
        }
        return this.getResourceArchive(string, null);
    }

    public boolean getResourceArchive(String string, URL uRL) {
        if (uRL == null) {
            return this.getResourceArchive(string, this.getLocale(), null);
        }
        return this.getResourceArchive(string, this.getLocale(), uRL.toExternalForm());
    }

    public boolean getResourceArchive(String string, Locale locale, String string2) {
        boolean bl = false;
        Vector vector = this.createSearchStrings(string, locale);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            bl |= this.fetchResourceArchive(string2, string3 + ARCHIVE_FILE_EXTENSION);
        }
        if (!bl && this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "getResourceArchive", "Couldn't load archive file: " + string + " from " + string2);
        }
        return bl;
    }

    public Image getImage(String string, boolean bl) {
        if (bl) {
            return this.getImage(string, this.m_searchPath.toExternalForm());
        }
        return this.getImage(string, (String)null);
    }

    public Image getImage(String string) {
        Image image = null;
        if (this.m_searchPath != null) {
            image = this.getImage(string, this.m_searchPath.toExternalForm());
        }
        if (image == null) {
            image = this.getImage(string, (String)null);
        }
        return image;
    }

    public Image getImage(String string, URL uRL) {
        return this.getImage(string, uRL.toExternalForm());
    }

    public Image getImage(String string, String string2) {
        String string3 = (string2 == null ? "" : string2) + string;
        Image image = null;
        Object v = this.m_resourceTable.get(string3);
        if (v != null) {
            Debug.stAssert(v instanceof Image);
            image = (Image)v;
        } else if (this.isAvailable(string, string2)) {
            try {
                int n;
                InputStream inputStream = LoaderHelpers.getResourceAsStream(string2, this.m_namespace, string);
                Debug.stAssert(inputStream != null);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "getImage", "Can't load image: " + string);
                }
                iOException.printStackTrace();
                return null;
            }
            this.m_resourceTable.put(string3, image);
        }
        return image;
    }

    public void setSearchPath(URL uRL) {
        this.m_searchPath = uRL;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale != null ? this.m_locale : Locale.getDefault();
    }

    protected STBundle fetchResourceBundle(String string, String string2) {
        String string3 = (string == null ? "" : string) + string2;
        STBundle sTBundle = null;
        Object v = this.m_resourceTable.get(string3);
        if (v != null) {
            Debug.stAssert(v instanceof STBundle);
            sTBundle = (STBundle)v;
        } else if (this.isAvailable(string2, string)) {
            try {
                sTBundle = STBundle.getBundle(string, this.m_namespace, string2);
                sTBundle.setLoader(this);
                this.m_resourceTable.put(string3, sTBundle);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sTBundle;
    }

    protected boolean fetchResourceArchive(String string, String string2) {
        if (this.isAvailable(string2, string)) {
            InputStream inputStream = null;
            try {
                inputStream = LoaderHelpers.getResourceAsStream(string, this.m_namespace, string2);
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                DataInputStream dataInputStream = new DataInputStream(zipInputStream);
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    byte[] byArray = new byte[(int)zipEntry.getSize()];
                    dataInputStream.readFully(byArray);
                    this.addResourceToTable(string, zipEntry.getName(), byArray);
                }
                inputStream.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected synchronized TocFile fetchResourceBundleTOC(String string, String string2) {
        String string3 = (string == null ? "" : string) + (string2 == null ? "" : string2);
        TocFile tocFile = (TocFile)this.m_tocTable.get(string3);
        if (tocFile == null && !this.m_missingTocList.contains(string3)) {
            try {
                tocFile = TocFile.getTocFile(string, this.m_namespace, string2);
                this.m_tocTable.put(string3, tocFile);
            }
            catch (IOException iOException) {
                this.m_missingTocList.addElement(string3);
            }
        }
        return tocFile;
    }

    protected boolean isAvailable(String string, String string2) {
        TocFile tocFile = this.fetchResourceBundleTOC(string2, null);
        if (tocFile == null) {
            return true;
        }
        return tocFile.contains(string);
    }

    protected Vector createSearchStrings(String string, Locale locale) {
        Vector<String> vector = new Vector<String>();
        if (locale != null) {
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = locale.getVariant();
            if (!("".equals(string2) || "".equals(string3) || "".equals(string4))) {
                vector.addElement(string + "_" + string2 + "_" + string3 + "_" + string4);
            }
            if (!"".equals(string2) && !"".equals(string3)) {
                vector.addElement(string + "_" + string2 + "_" + string3);
            }
            if (!"".equals(string2)) {
                vector.addElement(string + "_" + string2);
            }
        }
        vector.addElement(string);
        return vector;
    }

    public void addResourceToTable(String string, String string2, byte[] byArray) throws IOException {
        Object object;
        Object object2 = null;
        if (string2.endsWith(RESOURCE_FILE_EXTENSION)) {
            object = new ByteArrayInputStream(byArray);
            object2 = new STBundle((InputStream)object);
        } else {
            object2 = Toolkit.getDefaultToolkit().createImage(byArray);
        }
        object = (string == null ? "" : string) + string2;
        this.m_resourceTable.put(object, object2);
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.m_searchPath != null) {
            inputStream = this.getResourceAsStream(string, this.m_searchPath.toExternalForm());
        }
        if (inputStream == null) {
            inputStream = this.getResourceAsStream(string, null);
        }
        return inputStream;
    }

    public InputStream getResourceAsStream(String string, String string2) {
        InputStream inputStream = null;
        try {
            inputStream = LoaderHelpers.getResourceAsStream(string2, this.m_namespace, string);
            Debug.stAssert(inputStream != null);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getResourceAsStream", "Can't load resource: " + string);
            }
            iOException.printStackTrace();
        }
        return inputStream;
    }
}

