/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import com.lotus.sametime.gdk.tooltip.STToolTip;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.DefaultSorter;
import com.lotus.sametime.guiutils.tree.McListView;
import com.lotus.sametime.guiutils.tree.Sorter;
import com.lotus.sametime.guiutils.tree.TreeModel;
import com.lotus.sametime.guiutils.tree.TreeView;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class McTitleView
extends Canvas
implements MouseListener,
MouseMotionListener,
STToolTip,
FocusListener {
    protected McListView m_mcListView;
    protected int m_nbOfLeftColumns;
    protected int m_nbOfRightColumns;
    protected Vector m_leftTitles;
    protected Vector m_rightTitles;
    protected CellData m_nameTitle;
    private int m_mouseX = -1;
    private int m_mouseY = -1;
    private Sorter m_sorter = null;
    private Sorter m_nameSorter = new DefaultSorter();
    private String m_nameTooltip;
    private boolean m_dragging = false;
    private int m_borderNo;
    private int m_columnNoPressed = Integer.MAX_VALUE;
    private int m_highestColumnNo = 0;
    private int m_lowestColumnNo = 0;
    private int m_leftMostColumnNo = 0;
    private boolean m_tabPressed = false;
    private boolean m_shiftPressed = false;
    private Method m_transferFocus = null;
    private Method m_transferFocusBackward = null;

    public McTitleView(McListView mcListView, Vector vector, Vector vector2) {
        Object object;
        this.m_mcListView = mcListView;
        this.m_nbOfLeftColumns = vector.size();
        this.m_nbOfRightColumns = vector2.size();
        this.m_leftTitles = vector;
        this.m_rightTitles = vector2;
        if (this.m_nbOfLeftColumns > 0) {
            this.m_lowestColumnNo = -this.m_nbOfLeftColumns;
            this.m_leftMostColumnNo = -1;
        }
        if (this.m_nbOfRightColumns > 0) {
            this.m_highestColumnNo = this.m_nbOfRightColumns;
        }
        this.m_nameTitle = new CellData("  Name");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(SystemColor.control);
        try {
            object = this.getClass();
            this.m_transferFocus = ((Class)object).getMethod("transferFocus", null);
            this.m_transferFocusBackward = ((Class)object).getMethod("transferFocusBackward", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.m_transferFocus = null;
            this.m_transferFocusBackward = null;
        }
        this.addFocusListener(this);
        object = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                block8: {
                    if (keyEvent.getKeyCode() == 9) {
                        McTitleView.this.m_tabPressed = true;
                        McTitleView.this.m_shiftPressed = (keyEvent.getModifiers() & 1) != 0;
                        if (McTitleView.this.m_transferFocus != null) {
                            try {
                                if (McTitleView.this.m_shiftPressed) {
                                    McTitleView.this.m_transferFocusBackward.invoke((Object)McTitleView.this, null);
                                    break block8;
                                }
                                McTitleView.this.m_transferFocus.invoke((Object)McTitleView.this, null);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                System.out.println(illegalAccessException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                System.out.println(invocationTargetException);
                            }
                        }
                    } else if (keyEvent.getKeyCode() == 32 && McTitleView.this.m_columnNoPressed != Integer.MAX_VALUE) {
                        MouseEvent mouseEvent = new MouseEvent(McTitleView.this, 502, 0L, 0, 0, 0, 1, false);
                        McTitleView.this.mouseReleased(mouseEvent);
                    }
                }
            }
        };
        this.addKeyListener((KeyListener)object);
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[]{Boolean.TYPE};
            Method method = clazz.getMethod("setFocusTraversalKeysEnabled", classArray);
            Object[] objectArray = new Object[]{Boolean.FALSE};
            method.invoke((Object)this, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addColumn(int n, ColumnAttributes columnAttributes) {
        Vector vector = n > 0 ? this.m_rightTitles : this.m_leftTitles;
        vector.insertElementAt(columnAttributes, Math.abs(n) - 1);
        if (n > 0) {
            ++this.m_nbOfRightColumns;
            ++this.m_highestColumnNo;
        } else {
            ++this.m_nbOfLeftColumns;
            --this.m_lowestColumnNo;
            this.m_leftMostColumnNo = -1;
        }
    }

    public int getNbOfLeftColumns() {
        return this.m_nbOfLeftColumns;
    }

    public int getNbOfRightColumns() {
        return this.m_nbOfRightColumns;
    }

    public Vector getLeftTitles() {
        return this.m_leftTitles;
    }

    public Vector getRightTitles() {
        return this.m_rightTitles;
    }

    public CellData getNameTitle() {
        return this.m_nameTitle;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.m_mcListView.getMinimumSize();
        dimension.width -= 2 * this.m_mcListView.getBorderSize();
        dimension.setSize(dimension.width, TreeView.ITEM_HEIGHT);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        CellData cellData;
        int n;
        ColumnAttributes columnAttributes;
        int n2;
        Rectangle rectangle = this.getBounds();
        graphics.setClip(0, 0, rectangle.width, rectangle.height);
        int n3 = this.m_mcListView.getTreeView().m_HorizontalOffset;
        int n4 = this.getSize().height;
        Rectangle rectangle2 = new Rectangle();
        if (this.m_nbOfLeftColumns > 0) {
            for (n2 = 0; n2 < this.m_nbOfLeftColumns; ++n2) {
                columnAttributes = (ColumnAttributes)this.m_leftTitles.elementAt(n2);
                n = columnAttributes.getWidth();
                graphics.setColor(this.getBackground());
                graphics.fill3DRect(n3, 0, n - 1, n4 - 1, this.isTitlePressed(-(n2 + 1), n3, 0, n - 1, n4 - 1));
                rectangle2.setLocation(n3, 0);
                rectangle2.setSize(n, n4);
                cellData = columnAttributes.getProvider().getColumnHeader(columnAttributes);
                graphics.setColor(Color.black);
                cellData.drawData(graphics, this, rectangle2);
                n3 += n;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(n3, 0, this.m_mcListView.getNameWidth() - 1, n4 - 1, this.isTitlePressed(0, n3, 0, this.m_mcListView.getNameWidth() - 1, n4 - 1));
        rectangle2.setLocation(n3, 0);
        rectangle2.setSize(this.m_mcListView.getNameWidth(), n4);
        graphics.setColor(Color.black);
        this.m_nameTitle.drawData(graphics, this, rectangle2);
        n3 += this.m_mcListView.getNameWidth();
        if (this.m_nbOfRightColumns > 0) {
            for (n2 = 0; n2 < this.m_nbOfRightColumns; ++n2) {
                columnAttributes = (ColumnAttributes)this.m_rightTitles.elementAt(n2);
                n = columnAttributes.getWidth();
                graphics.setColor(this.getBackground());
                graphics.fill3DRect(n3, 0, n - 1, n4 - 1, this.isTitlePressed(n2 + 1, n3, 0, n - 1, n4 - 1));
                rectangle2.setLocation(n3, 0);
                rectangle2.setSize(n, n4);
                cellData = columnAttributes.getProvider().getColumnHeader(columnAttributes);
                graphics.setColor(Color.black);
                cellData.drawData(graphics, this, rectangle2);
                n3 += n;
            }
        }
        if (n3 < rectangle.width) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n3, 0, rectangle.width - n3 - 1, n4 - 1);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_mouseX = mouseEvent.getX();
        this.m_mouseY = mouseEvent.getY();
        int n = this.getColNumberByXLoc(this.m_mouseX);
        this.m_columnNoPressed = Integer.MAX_VALUE;
        if (this.mouseIsOverColumnBorder(this.m_mouseX)) {
            this.m_dragging = true;
        } else {
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_dragging) {
            this.m_dragging = false;
            return;
        }
        boolean bl = this.m_columnNoPressed != Integer.MAX_VALUE;
        Object object = null;
        int n = 0;
        int n2 = this.m_mcListView.getTreeView().m_HorizontalOffset;
        int n3 = this.getSize().height;
        if (bl || !bl && mouseEvent.getY() > 0 && mouseEvent.getY() < n3 && mouseEvent.getX() > n2) {
            ColumnAttributes columnAttributes;
            Enumeration enumeration = this.m_leftTitles.elements();
            if (bl && this.m_columnNoPressed < 0 || !bl) {
                while (enumeration.hasMoreElements()) {
                    columnAttributes = (ColumnAttributes)enumeration.nextElement();
                    if (!bl && mouseEvent.getX() < (n2 += columnAttributes.getWidth()) || bl && this.m_columnNoPressed == -(n + 1)) {
                        n = -(n + 1);
                        object = columnAttributes.getSorter();
                        break;
                    }
                    ++n;
                }
            }
            if (null == object && (!bl && mouseEvent.getX() < (n2 += this.m_mcListView.getNameWidth()) || bl && this.m_columnNoPressed == 0)) {
                object = this.m_nameSorter;
            }
            if (null == object) {
                enumeration = this.m_rightTitles.elements();
                while (enumeration.hasMoreElements()) {
                    columnAttributes = (ColumnAttributes)enumeration.nextElement();
                    if (!bl && mouseEvent.getX() < (n2 += columnAttributes.getWidth()) || bl && this.m_columnNoPressed == n + 1) {
                        ++n;
                        object = columnAttributes.getSorter();
                        break;
                    }
                    ++n;
                }
            }
        }
        if (object != null && !object.equals(this.m_sorter)) {
            this.m_sorter = object;
            if (null != this.m_sorter) {
                ((TreeModel)this.m_mcListView.getTreeView().getModel()).setSorter(this.m_sorter);
            }
        }
        this.m_mouseX = -1;
        this.m_mouseY = -1;
        if (bl) {
            bl = false;
            this.m_columnNoPressed = Integer.MAX_VALUE;
        }
        this.repaint();
    }

    private boolean isTitlePressed(int n, int n2, int n3, int n4, int n5) {
        if (this.m_dragging) {
            return true;
        }
        boolean bl = true;
        if (n == this.m_columnNoPressed || this.m_mouseX > n2 && this.m_mouseX < n2 + n4 && this.m_mouseY > n3 && this.m_mouseY < n3 + n5) {
            bl = false;
        }
        return bl;
    }

    public void setTooltipForNameColumn(String string) {
        this.m_nameTooltip = string;
    }

    public Vector getToolTipComponents() {
        Vector<McTitleView> vector = new Vector<McTitleView>();
        vector.addElement(this);
        return vector;
    }

    public void setHoverBased(boolean bl) {
    }

    public boolean isHoverBased() {
        return true;
    }

    public void setToolTipText(Component component, String string) {
    }

    private int getColNumberByXLoc(int n) {
        ColumnAttributes columnAttributes;
        Enumeration enumeration = this.getLeftTitles().elements();
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            columnAttributes = (ColumnAttributes)enumeration.nextElement();
            if (n < (n2 += columnAttributes.getWidth())) {
                return -(n3 + 1);
            }
            ++n3;
        }
        if (n < (n2 += this.m_mcListView.getNameWidth())) {
            return 0;
        }
        Enumeration enumeration2 = this.getRightTitles().elements();
        n3 = 0;
        while (enumeration2.hasMoreElements()) {
            columnAttributes = (ColumnAttributes)enumeration2.nextElement();
            if (n < (n2 += columnAttributes.getWidth())) {
                return n3 + 1;
            }
            ++n3;
        }
        return Integer.MIN_VALUE;
    }

    public String getToolTipText(Component component, Point point) {
        String string = this.m_nameTooltip;
        int n = this.getColNumberByXLoc(point.x);
        switch (n) {
            case -2147483648: {
                string = null;
                break;
            }
            case 0: {
                string = this.m_nameTooltip;
                break;
            }
            default: {
                ColumnAttributes columnAttributes = n < 0 ? (ColumnAttributes)this.m_leftTitles.elementAt(-n - 1) : (ColumnAttributes)this.m_rightTitles.elementAt(n - 1);
                string = columnAttributes.getTooltipText();
            }
        }
        return string;
    }

    public void setSorterForNameColumn(Sorter sorter) {
        this.m_nameSorter = sorter;
    }

    public void setNameColData(CellData cellData) {
        this.m_nameTitle = cellData;
    }

    private boolean mouseIsOverColumnBorder(int n) {
        int n2;
        ColumnAttributes columnAttributes;
        int n3;
        int n4 = this.m_mcListView.getTreeView().m_HorizontalOffset;
        for (n3 = 0; n3 < this.m_nbOfLeftColumns; ++n3) {
            columnAttributes = (ColumnAttributes)this.m_leftTitles.elementAt(n3);
            n2 = columnAttributes.getWidth();
            if (n <= (n4 += n2) - 3 || n >= n4 + 3) continue;
            this.m_borderNo = -(n3 + 1);
            return true;
        }
        if (this.m_nbOfRightColumns > 0) {
            if (n > (n4 += this.m_mcListView.getNameWidth()) - 3 && n < n4 + 3) {
                this.m_borderNo = 0;
                return true;
            }
            for (n3 = 0; n3 < this.m_nbOfRightColumns - 1; ++n3) {
                columnAttributes = (ColumnAttributes)this.m_rightTitles.elementAt(n3);
                n2 = columnAttributes.getWidth();
                if (n <= (n4 += n2) - 3 || n >= n4 + 3) continue;
                this.m_borderNo = n3 + 1;
                return true;
            }
        }
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        ColumnAttributes columnAttributes;
        int n;
        int n2;
        int n3;
        int n4;
        Vector vector;
        int n5 = mouseEvent.getX();
        int n6 = n5 - this.m_mouseX;
        if (n6 == 0) {
            return;
        }
        if (this.m_borderNo < 0) {
            vector = this.m_leftTitles;
            n4 = -this.m_borderNo;
            n3 = n4 < this.m_nbOfLeftColumns ? n4 + 1 : 0;
        } else {
            vector = this.m_rightTitles;
            n4 = this.m_borderNo;
            n3 = n4 + 1;
        }
        int n7 = n6 < 0 ? n4 : n3;
        if (n7 == 0) {
            n2 = this.m_mcListView.getNameWidth();
            n = this.m_mcListView.getTreeView().getMinNameWidth();
        } else {
            columnAttributes = (ColumnAttributes)vector.elementAt(n7 - 1);
            n2 = columnAttributes.getWidth();
            n = ColumnAttributes.getMinColumnWidth();
        }
        int n8 = n2 - n;
        if (Math.abs(n6) > n8) {
            n6 = n6 < 0 ? -n8 : n8;
        }
        if (Math.abs(n6) > 0) {
            if (n4 == 0) {
                this.m_mcListView.setNameWidth(this.m_mcListView.getNameWidth() + n6);
            } else {
                columnAttributes = (ColumnAttributes)vector.elementAt(n4 - 1);
                columnAttributes.setWidth(columnAttributes.getWidth() + n6);
            }
            if (n3 == 0) {
                this.m_mcListView.setNameWidth(this.m_mcListView.getNameWidth() - n6);
            } else {
                columnAttributes = (ColumnAttributes)vector.elementAt(n3 - 1);
                columnAttributes.setWidth(columnAttributes.getWidth() - n6);
            }
            this.repaint();
            this.m_mcListView.getTreeView().repaint();
            this.m_mouseX = n5;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseIsOverColumnBorder(mouseEvent.getPoint().x)) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.m_columnNoPressed = this.m_columnNoPressed == Integer.MAX_VALUE ? (this.m_shiftPressed ? this.m_highestColumnNo : this.m_leftMostColumnNo) : (this.m_shiftPressed ? (this.m_columnNoPressed > 0 ? --this.m_columnNoPressed : (this.m_columnNoPressed == 0 ? this.m_lowestColumnNo : this.m_columnNoPressed + 1)) : (this.m_columnNoPressed >= 0 ? ++this.m_columnNoPressed : (this.m_columnNoPressed == this.m_lowestColumnNo ? 0 : this.m_columnNoPressed - 1)));
        this.m_tabPressed = false;
        this.m_shiftPressed = false;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.m_columnNoPressed < this.m_highestColumnNo && this.m_tabPressed && !this.m_shiftPressed || this.m_columnNoPressed != this.m_leftMostColumnNo && this.m_tabPressed && this.m_shiftPressed) {
            this.requestFocus();
        } else {
            this.m_columnNoPressed = Integer.MAX_VALUE;
            this.repaint();
        }
    }
}

