/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.sttable.table;

import com.lotus.sametime.guiutils.sttable.StTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class TableHeader
extends Component {
    private StTable table;
    private int[] sensorPositions = null;
    private int runner = -1;
    private int headerHeight = 20;
    private int x = 0;

    public TableHeader(StTable stTable) {
        this.table = stTable;
        this.enableEvents(48L);
        this.setCursor(Cursor.getPredefinedCursor(11));
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setFont(new Font("Times-Roman", 0, 14));
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && this.runner == -1) {
            int n = mouseEvent.getX() + this.x;
            for (int i = this.sensorPositions.length - 1; i >= 0; --i) {
                if (n <= this.sensorPositions[i] - 5 || n >= this.sensorPositions[i] + 5) continue;
                this.runner = i;
                break;
            }
        } else if (mouseEvent.getID() == 502) {
            this.runner = -1;
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            if (this.runner != -1) {
                this.table.columnWidthChanged(this.runner, mouseEvent.getX() + this.x - this.sensorPositions[this.runner]);
            }
            mouseEvent.consume();
        }
    }

    public boolean contains(int n, int n2) {
        if (this.sensorPositions != null && this.sensorPositions.length > 0) {
            n += this.x;
            int n3 = this.table.getAutoResizeMode() != 0 ? this.sensorPositions.length - 1 : this.sensorPositions.length;
            for (int i = 0; i < n3; ++i) {
                if (n < this.sensorPositions[i] - 5 || n > this.sensorPositions[i] + 5) continue;
                return true;
            }
        }
        return false;
    }

    public Dimension getPreferredSize() {
        return new Dimension(1, this.headerHeight);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.sensorPositions == null || this.sensorPositions.length == 0) {
            return;
        }
        int n = this.sensorPositions[this.sensorPositions.length - 1] - this.x + 2;
        Container container = this.getParent().getParent();
        if (container != null) {
            graphics.setColor(container.getBackground());
            graphics.fillRect(n, 0, this.getSize().width - n, this.headerHeight);
        }
        if (this.sensorPositions == null) {
            return;
        }
        this.table.getTableRenderer().paintHeader(this.table, graphics, this.sensorPositions, this.x, n, this.headerHeight, this.getBackground(), this.getForeground(), this.getFont());
    }

    public void adjustWidths(int[] nArray) {
        int n = 0;
        this.sensorPositions = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.sensorPositions[i] = n += nArray[i];
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public void setOffset(int n) {
        this.x = n;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }
}

