/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import com.lotus.sametime.core.util.Queue;

public class PriorityQueue {
    private Queue[] m_priorityQueues;
    private static final int DEFAULT_MAX_PRIORITY = 4;
    public static final int MIN_PRIORITY_VALUE = 0;
    private int m_firstQueueWithContent = -1;

    public PriorityQueue() {
        this(4);
    }

    public PriorityQueue(int n) {
        this.m_priorityQueues = new Queue[n + 1];
        for (int i = 0; i < this.m_priorityQueues.length; ++i) {
            this.m_priorityQueues[i] = new Queue();
        }
    }

    public synchronized void put(Object object, int n) {
        if (n >= this.m_priorityQueues.length) {
            n = this.m_priorityQueues.length - 1;
        } else if (n < 0) {
            n = 0;
        }
        this.m_priorityQueues[n].put(object);
        if (this.m_firstQueueWithContent == -1 || n < this.m_firstQueueWithContent) {
            this.m_firstQueueWithContent = n;
        }
    }

    public synchronized Object getNext() {
        int n;
        Object object = null;
        int n2 = n = this.m_firstQueueWithContent == -1 ? 0 : this.m_firstQueueWithContent;
        while (n < this.m_priorityQueues.length) {
            if (!this.m_priorityQueues[n].isEmpty()) {
                object = this.m_priorityQueues[n].getNext();
                if (this.m_priorityQueues[n].isEmpty()) {
                    this.m_firstQueueWithContent = -1;
                    break;
                }
                this.m_firstQueueWithContent = n;
                break;
            }
            ++n;
        }
        return object;
    }

    public synchronized void put(Object object) {
        this.put(object, 0);
    }

    public synchronized boolean isEmpty() {
        boolean bl = true;
        for (int i = 0; bl && i < this.m_priorityQueues.length; bl &= this.m_priorityQueues[i].isEmpty(), ++i) {
        }
        return bl;
    }
}

