/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.types;

import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class STPrivacyList
implements Cloneable {
    private boolean m_excluding;
    private Hashtable m_people = new Hashtable();
    private Hashtable m_groups = new Hashtable();
    private Hashtable m_targets;
    private Hashtable m_requestors;

    public STPrivacyList(NdrInputStream ndrInputStream) throws IOException {
        this.loadPeople(ndrInputStream);
    }

    public STPrivacyList(NdrInputStream ndrInputStream, boolean bl) throws IOException {
        this.loadPeople(ndrInputStream);
        if (bl) {
            this.loadRequestors(ndrInputStream);
        }
    }

    protected STPrivacyList(STPrivacyList sTPrivacyList) {
        this.m_excluding = sTPrivacyList.isExcluding();
        this.m_people = sTPrivacyList.getPeople();
        this.m_groups = sTPrivacyList.getGroups();
        this.m_targets = sTPrivacyList.getTargets();
        this.m_requestors = sTPrivacyList.getRequestors();
    }

    public STPrivacyList(boolean bl, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        this.m_excluding = bl;
        this.m_people = hashtable;
        this.m_targets = hashtable2;
        this.m_requestors = hashtable3;
    }

    public STPrivacyList(boolean bl) {
        this.m_excluding = bl;
    }

    public static final STPrivacyList loadNewList(NdrInputStream ndrInputStream) throws IOException {
        STPrivacyList sTPrivacyList = new STPrivacyList(false);
        sTPrivacyList.newLoad(ndrInputStream);
        return sTPrivacyList;
    }

    public boolean isExcluding() {
        return this.m_excluding;
    }

    public void setExcluding(boolean bl) {
        this.m_excluding = bl;
    }

    public boolean isSeenBy(STUser sTUser) {
        boolean bl = this.m_people.get(sTUser.getId()) != null;
        return bl && !this.m_excluding || !bl && this.m_excluding;
    }

    public void addUser(STUser sTUser) {
        this.m_people.put(sTUser.getId(), sTUser);
    }

    public void removeUser(STUser sTUser) {
        this.m_people.remove(sTUser.getId());
    }

    public void addGroup(STGroup sTGroup) {
        this.m_groups.put(sTGroup.getId(), sTGroup);
    }

    public void removeGroup(STGroup sTGroup) {
        this.m_groups.remove(sTGroup.getId());
    }

    public Hashtable getPeople() {
        return (Hashtable)this.m_people.clone();
    }

    public Hashtable getGroups() {
        return (Hashtable)this.m_groups.clone();
    }

    public Hashtable getTargets() {
        if (this.m_targets == null) {
            return null;
        }
        Hashtable hashtable = null;
        hashtable = (Hashtable)this.m_targets.clone();
        return hashtable;
    }

    public Hashtable getRequestors() {
        if (this.m_requestors == null) {
            return null;
        }
        Hashtable hashtable = null;
        hashtable = (Hashtable)this.m_requestors.clone();
        return hashtable;
    }

    public Enumeration elements() {
        return this.getPeopleEnumeration();
    }

    public Enumeration getPeopleEnumeration() {
        return this.m_people.elements();
    }

    public Enumeration getGroupEnumeration() {
        return this.m_groups.elements();
    }

    public Enumeration getTargetElements() {
        if (this.m_targets != null) {
            return this.m_targets.elements();
        }
        return null;
    }

    public Enumeration getRequestorElements() {
        if (this.m_requestors != null) {
            return this.m_requestors.elements();
        }
        return null;
    }

    public void dump(NdrOutputStream ndrOutputStream, boolean bl) throws IOException {
        STUser sTUser;
        Enumeration enumeration;
        ndrOutputStream.writeBoolean(this.m_excluding);
        this.dumpSTObjects(this.m_people, ndrOutputStream, bl);
        if (this.m_targets != null) {
            ndrOutputStream.writeInt(this.m_targets.size());
            enumeration = this.m_targets.elements();
            while (enumeration.hasMoreElements()) {
                sTUser = (STUser)enumeration.nextElement();
                ndrOutputStream.writeBoolean(bl);
                sTUser.getId().dump(ndrOutputStream);
                if (!bl) continue;
                ndrOutputStream.writeUTF(sTUser.getName());
            }
        }
        if (this.m_requestors != null) {
            ndrOutputStream.writeInt(this.m_requestors.size());
            enumeration = this.m_requestors.elements();
            while (enumeration.hasMoreElements()) {
                sTUser = (STUser)enumeration.nextElement();
                ndrOutputStream.writeBoolean(bl);
                sTUser.getId().dump(ndrOutputStream);
                if (!bl) continue;
                ndrOutputStream.writeUTF(sTUser.getName());
            }
        }
    }

    public void load(NdrInputStream ndrInputStream) throws IOException {
        this.loadPeople(ndrInputStream);
        this.loadRequestors(ndrInputStream);
    }

    public void loadPeople(NdrInputStream ndrInputStream) throws IOException {
        this.m_people.clear();
        this.m_excluding = ndrInputStream.readBoolean();
        for (int i = ndrInputStream.readInt(); i > 0; --i) {
            boolean bl = ndrInputStream.readBoolean();
            STId sTId = new STId(ndrInputStream);
            String string = "";
            if (bl) {
                string = ndrInputStream.readUTF();
            }
            STUser sTUser = new STUser(sTId, string, "");
            this.addUser(sTUser);
        }
    }

    public boolean loadRequestors(NdrInputStream ndrInputStream) throws IOException {
        this.m_targets = new Hashtable();
        this.m_requestors = new Hashtable();
        this.m_targets.clear();
        this.m_requestors.clear();
        try {
            for (int i = ndrInputStream.readInt(); i > 0; --i) {
                boolean bl = ndrInputStream.readBoolean();
                STId sTId = new STId(ndrInputStream);
                String string = "";
                if (bl) {
                    string = ndrInputStream.readUTF();
                }
                STUser sTUser = new STUser(sTId, string, "");
                this.m_requestors.put(sTUser.getId(), sTUser);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public Object clone() {
        return new STPrivacyList(this);
    }

    public void newDump(NdrOutputStream ndrOutputStream, boolean bl) throws IOException {
        ndrOutputStream.writeBoolean(this.m_excluding);
        this.dumpSTObjects(this.m_people, ndrOutputStream, bl);
        this.dumpSTObjects(this.m_groups, ndrOutputStream, bl);
        Hashtable hashtable = this.m_targets != null ? this.m_targets : this.m_requestors;
        this.dumpSTObjects(hashtable, ndrOutputStream, bl);
    }

    private void dumpSTObjects(Hashtable hashtable, NdrOutputStream ndrOutputStream, boolean bl) throws IOException {
        if (hashtable == null) {
            ndrOutputStream.writeInt(0);
            return;
        }
        ndrOutputStream.writeInt(hashtable.size());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            STObject sTObject = (STObject)enumeration.nextElement();
            ndrOutputStream.writeBoolean(bl);
            sTObject.getId().dump(ndrOutputStream);
            if (!bl) continue;
            ndrOutputStream.writeUTF(sTObject.getName());
        }
    }

    protected void newLoad(NdrInputStream ndrInputStream) throws IOException {
        this.m_excluding = ndrInputStream.readBoolean();
        this.m_people = this.loadSTUserTable(ndrInputStream);
        this.m_groups = this.loadSTGroupTable(ndrInputStream);
        this.m_requestors = this.m_targets = this.loadSTUserTable(ndrInputStream);
    }

    private Hashtable loadSTUserTable(NdrInputStream ndrInputStream) throws IOException {
        Hashtable<STId, STUser> hashtable = new Hashtable<STId, STUser>();
        for (int i = ndrInputStream.readInt(); i > 0; --i) {
            boolean bl = ndrInputStream.readBoolean();
            STId sTId = new STId(ndrInputStream);
            String string = "";
            if (bl) {
                string = ndrInputStream.readUTF();
            }
            STUser sTUser = new STUser(sTId, string, "");
            hashtable.put(sTId, sTUser);
        }
        return hashtable;
    }

    private Hashtable loadSTGroupTable(NdrInputStream ndrInputStream) throws IOException {
        Hashtable<STId, STGroup> hashtable = new Hashtable<STId, STGroup>();
        for (int i = ndrInputStream.readInt(); i > 0; --i) {
            boolean bl = ndrInputStream.readBoolean();
            STId sTId = new STId(ndrInputStream);
            String string = "";
            if (bl) {
                string = ndrInputStream.readUTF();
            }
            STGroup sTGroup = new STGroup(sTId, string, "");
            hashtable.put(sTId, sTGroup);
        }
        return hashtable;
    }
}

