/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.types;

import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class STObjectImpl
implements STObject,
Serializable {
    private STId m_stId;
    private String m_name;
    private String m_desc;

    public STObjectImpl(STId sTId, String string, String string2) {
        this.m_stId = sTId;
        this.m_name = string != null ? string.intern() : null;
        this.m_desc = string2 != null ? string2.intern() : null;
    }

    public STObjectImpl(NdrInputStream ndrInputStream) throws IOException {
        this.load(ndrInputStream);
    }

    public STId getId() {
        return this.m_stId;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDesc() {
        return this.m_desc;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof STObject) {
            bl = this.m_stId.equals(((STObject)object).getId());
        }
        return bl;
    }

    public int hashCode() {
        return this.m_stId.hashCode() ^ "STObject".hashCode();
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        this.m_stId.dump(ndrOutputStream);
        ndrOutputStream.writeUTF(this.m_name);
        ndrOutputStream.writeUTF(this.m_desc);
    }

    protected void load(NdrInputStream ndrInputStream) throws IOException {
        this.m_stId = new STId(ndrInputStream);
        this.m_name = ndrInputStream.readUTF();
        this.m_desc = ndrInputStream.readUTF();
        if (this.m_name != null) {
            this.m_name = this.m_name.intern();
        }
        if (this.m_desc != null) {
            this.m_desc = this.m_desc.intern();
        }
    }

    protected void setId(STId sTId) {
        this.m_stId = sTId;
    }

    protected void setName(String string) {
        this.m_name = string.intern();
    }

    protected void setDesc(String string) {
        this.m_desc = string.intern();
    }

    public String toString() {
        return super.toString() + " name = " + this.m_name + " id = {" + this.m_stId + "} " + " desc = " + this.m_desc;
    }
}

