/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.comparch;

import com.lotus.sametime.core.comparch.DispatchingThreadPool;
import com.lotus.sametime.core.comparch.MessageDispatcher;
import java.util.logging.Level;
import java.util.logging.Logger;

class MessageDispatchingThread
implements Runnable {
    private static final String THREAD_NAME = "Chuck the postman's dispatching thread.";
    private static int c_threadCount = 0;
    private Thread m_dispatcherThread = null;
    private DispatchingThreadPool m_pool;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.comparch");

    MessageDispatchingThread(DispatchingThreadPool dispatchingThreadPool) {
        this.m_pool = dispatchingThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageDispatcher messageDispatcher;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "Dispatching thread " + this + " started.");
        }
        while ((messageDispatcher = this.m_pool.getQueue()) != null) {
            messageDispatcher.flush();
            this.m_pool.unlockQueue(messageDispatcher);
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "Dispatching thread " + this + " exiting.");
        }
        MessageDispatchingThread messageDispatchingThread = this;
        synchronized (messageDispatchingThread) {
            this.m_dispatcherThread = null;
        }
    }

    synchronized void start() {
        if (this.m_dispatcherThread != null) {
            return;
        }
        String string = THREAD_NAME + ++c_threadCount;
        this.m_dispatcherThread = new Thread((Runnable)this, string);
        this.m_dispatcherThread.start();
    }
}

