/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.configuration;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.configuration.ConfigAttribute;
import com.lotus.sametime.configuration.ConfigChangeEvent;
import com.lotus.sametime.configuration.ConfigServiceEvent;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEventListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigImpl
extends STCompImpl
implements ChannelListener,
LoginListener,
ServiceListener {
    private Channel m_channel;
    private ChannelService m_cnlService;
    private CommunityService m_commService;
    private boolean m_serviceUp = false;
    private static final short ST_CONFIG_SUBSCRIBE = 1;
    private static final short ST_CONFIG_UNSUBSCRIBE = 2;
    private static final short ST_CONFIG_CHANGE = 3;
    private static final int ST_CONFIG_CHANGE_ADD = 0;
    private static final int ST_CONFIG_CHANGE_DELETE = 1;
    private static final int ST_CONFIG_CHANGE_UPDATE = 2;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.configuration");

    public ConfigImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.configuration.ConfigComp", sTSession);
        this.m_cnlService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_commService != null) {
            this.m_commService.addServiceListener(this);
            this.m_commService.addLoginListener(this);
            if (this.m_commService.isLoggedIn()) {
                this.senseService();
            }
        }
    }

    private void senseService() {
        this.m_commService.senseService(23);
    }

    private void createConfigurationChannel() {
        Debug.stAssert(this.m_channel == null);
        this.m_channel = this.m_cnlService.createChannel(23, 24, 1, EncLevel.ENC_LEVEL_DONT_CARE, null, null);
        this.m_channel.addChannelListener(this);
        this.m_channel.open();
    }

    public void subscribe(String string) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(1);
            ndrOutputStream.writeUTF(string);
            this.m_channel.sendMsg((short)1, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void subscribe(String[] stringArray) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                ndrOutputStream.writeUTF(stringArray[i]);
            }
            this.m_channel.sendMsg((short)1, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void unsubscribe(String string) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(1);
            ndrOutputStream.writeUTF(string);
            this.m_channel.sendMsg((short)2, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void unsubscribe(String[] stringArray) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                ndrOutputStream.writeUTF(stringArray[i]);
            }
            this.m_channel.sendMsg((short)2, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void componentLoaded(STEventListener sTEventListener) {
        if (sTEventListener instanceof ChannelService) {
            if (this.m_cnlService == null) {
                this.m_cnlService = (ChannelService)((Object)sTEventListener);
            }
        } else if (sTEventListener instanceof CommunityService && this.m_commService == null) {
            this.m_commService = (CommunityService)((Object)sTEventListener);
            this.m_commService.addServiceListener(this);
            this.m_commService.addLoginListener(this);
            if (!this.m_serviceUp && this.m_commService.isLoggedIn()) {
                this.senseService();
            }
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.senseService();
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_serviceUp = false;
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (serviceEvent.getServiceType() == 23) {
            this.createConfigurationChannel();
        }
    }

    public void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        this.m_serviceUp = true;
        this.sendEvent(new ConfigServiceEvent(this, -2147483647));
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        this.channelClosed(channelEvent);
    }

    public void channelClosed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        this.m_channel = null;
        if (this.m_serviceUp) {
            this.m_serviceUp = false;
            this.sendEvent(new ConfigServiceEvent(this, -2147483646));
            this.senseService();
        }
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
        switch (channelEvent.getMessageType()) {
            case 3: {
                this.handleConfigChange(ndrInputStream);
            }
        }
    }

    private void handleConfigChange(NdrInputStream ndrInputStream) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleConfigChange", "Received config change");
        }
        Vector<ConfigAttribute> vector = new Vector<ConfigAttribute>();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        try {
            for (int i = 1; i < 4; ++i) {
                Vector<ConfigAttribute> vector4;
                short s = ndrInputStream.readShort();
                int n = ndrInputStream.readInt();
                String string = "";
                if (n < 1) continue;
                string = string + "Reading [" + n + "] " + "config changes of type [";
                switch (s) {
                    case 0: {
                        string = string + "Added]";
                        vector4 = vector;
                        break;
                    }
                    case 1: {
                        string = string + "Deleted]";
                        vector4 = vector2;
                        break;
                    }
                    case 2: {
                        string = string + "Updated]";
                        vector4 = vector3;
                        break;
                    }
                    default: {
                        string = string + "Error: illegal change type" + s + "]";
                        return;
                    }
                }
                while (--n >= 0) {
                    ConfigAttribute configAttribute = ConfigAttribute.load(ndrInputStream);
                    if (configAttribute == null) {
                        if (this.m_logger.isLoggable(Level.FINER)) {
                            this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleConfigChange", "Failed loading attribute");
                        }
                        return;
                    }
                    vector4.add(configAttribute);
                }
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleConfigChange", string);
            }
            this.sendEvent(new ConfigChangeEvent(this, -2147483647, vector, vector2, vector3));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isServiceUp() {
        return this.m_serviceUp;
    }
}

