/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.im;

import com.lotus.sametime.chatui.ChatEditEvent;
import com.lotus.sametime.chatui.ChatEditListener;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.TextModifier;
import com.lotus.sametime.chatui.im.ImModel;
import com.lotus.sametime.chatui.im.ImModelListener;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.chat.ChatArea;
import com.lotus.sametime.guiutils.chat.ChatAreaEvent;
import com.lotus.sametime.guiutils.chat.ChatAreaListener;
import com.lotus.sametime.guiutils.chat.ChatSendField;
import com.lotus.sametime.guiutils.chat.ChatSendFieldEvent;
import com.lotus.sametime.guiutils.chat.ChatSendFieldListener;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImPanel
extends Panel
implements ImModelListener,
ChatSendFieldListener,
FocusListener,
ChatAreaListener {
    private static final Integer MY_LINE = new Integer(0);
    private static final Integer PARTNER_LINE = new Integer(1);
    private static final Color MY_TEXT_COLOR = Color.blue;
    private static final Color PARTNER_TEXT_COLOR = Color.black;
    private boolean m_isResponding = false;
    private TextModifier m_textModifier = null;
    private ImModel m_ImModel;
    private ChatArea m_chatArea;
    private ChatSendField m_sendField;
    private TextArea m_taMsg;
    private Font m_font;
    private Label m_label;
    private boolean m_hideChatTranscript;
    private Panel m_bottImPanel;
    private STBundle m_resourceFile;
    private String m_partnerName;
    private boolean m_isAway = false;
    private boolean m_initialized = false;
    private boolean m_originator;
    private boolean m_chatAreaSelected = false;
    private boolean m_sendFieldSelected = false;
    private boolean m_chatAreaHasContent = false;
    private Vector m_waitingChatAreaListeners = new Vector();
    private boolean m_sendFieldHasContent = false;
    private final int NOT_ON_CHAT_FOCUS = 0;
    private final int CHAT_AREA_FOCUS = 1;
    private final int SEND_FIELD_FOCUS = 2;
    private int m_currentFocus = 0;
    private Clipboard m_clipboard;
    private Vector m_editListenersList = new Vector();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui.im");

    public ImPanel(ImModel imModel, boolean bl, String string) {
        this.m_ImModel = imModel;
        this.m_resourceFile = ((ResourceLoaderService)((Object)imModel.getSession().getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/chatui");
        this.m_partnerName = string;
        this.m_originator = bl;
        this.m_hideChatTranscript = bl;
        this.m_ImModel.addImModelListener(this);
    }

    private void init() {
        STUserStatus sTUserStatus;
        Object object;
        block9: {
            this.m_font = this.m_resourceFile.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE");
            if (null == this.m_font) {
                object = Toolkit.getDefaultToolkit().getFontList();
                this.m_font = new Font(object[0], 0, 10);
            }
            try {
                this.m_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block9;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "init", "Security violation on getSystemClipboard");
            }
        }
        this.setLayout(new BorderLayout());
        this.m_chatArea = new ChatArea(this.m_resourceFile.getInt("CHATAREA_MAX_PARAGRAPH_NUM"), this.m_font, this.m_resourceFile.getInt("CHATTRANS_NAME_MAXWIDTH"), this.m_resourceFile);
        this.m_chatArea.addChatAreaListener(this);
        this.m_chatArea.addFocusListener(this);
        object = this.m_waitingChatAreaListeners.elements();
        while (object.hasMoreElements()) {
            ChatAreaListener chatAreaListener = (ChatAreaListener)object.nextElement();
            this.m_chatArea.addChatAreaListener(chatAreaListener);
        }
        this.m_waitingChatAreaListeners.removeAllElements();
        this.m_bottImPanel = new Panel();
        this.m_bottImPanel.setLayout(new BorderLayout());
        this.m_label = new Label();
        this.m_label.setBackground(SystemColor.control);
        this.m_bottImPanel.add("North", this.m_label);
        int n = this.m_resourceFile.getInt("INPUT_HEIGHT");
        if (StaticProps.m_bMacOSX) {
            ++n;
        }
        this.m_sendField = new ChatSendField(n, this.m_resourceFile.getInt("INPUT_WIDTH"), this.m_font, this.m_resourceFile);
        this.m_sendField.addFocusListener(this);
        this.m_bottImPanel.add("Center", this.m_sendField);
        boolean bl = false;
        String string = null;
        if (this.m_originator && (sTUserStatus = this.m_ImModel.getPartnerStatus()) != null) {
            bl = sTUserStatus.isStatus((short)96) || sTUserStatus.isStatus((short)64);
            string = sTUserStatus.getStatusDescription();
        }
        if (bl) {
            this.m_isAway = true;
            this.initAwayPanel(string);
        } else {
            this.initStdPanel();
        }
        this.m_sendField.addSendFieldListener(this);
        if (!this.m_ImModel.isViewEnabled()) {
            this.enableSendMessage(false);
        }
    }

    private void initStdPanel() {
        if (this.m_hideChatTranscript) {
            this.add("Center", this.m_bottImPanel);
            this.m_label.setText(this.m_resourceFile.formatString("LBL_TO", this.m_partnerName));
        } else {
            this.add("Center", this.m_chatArea);
            this.add("South", this.m_bottImPanel);
            this.m_label.setText(this.m_resourceFile.getString("LBL_TYPEHERE"));
        }
    }

    private void initAwayPanel(String string) {
        String string2 = this.m_resourceFile.formatString("LBL_NOT_USING_MESSAGE", this.m_partnerName);
        this.m_taMsg = new TextArea(string, this.m_resourceFile.getInt("AWAY_MESSAGE_HEIGHT"), this.m_resourceFile.getInt("AWAY_MESSAGE_WIDTH"), 1);
        this.m_taMsg.setEditable(false);
        this.m_taMsg.addFocusListener(this);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label(string2));
        panel.add("Center", this.m_taMsg);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("Center", panel);
        this.m_label.setText(this.m_resourceFile.getString("LBL_LEAVE_MESSAGE"));
        this.add("Center", panel2);
        this.add("South", this.m_bottImPanel);
    }

    private void sendText(String string) {
        this.m_ImModel.sendMessage(string);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (!this.m_initialized) {
                this.m_initialized = true;
                this.init();
                this.validate();
            }
            super.setVisible(true);
            if (this.m_sendField != null) {
                this.m_sendField.requestFocus();
            }
        } else {
            super.setVisible(false);
        }
    }

    public void setTextModifier(TextModifier textModifier) {
        this.m_textModifier = textModifier;
    }

    public void enableSendMessage(boolean bl) {
        if (this.m_initialized) {
            this.m_sendField.setEnabled(bl);
        }
    }

    public void toFront() {
    }

    public void messageReceived(ChatMessage chatMessage) {
        if (!chatMessage.isMyText() && !this.m_initialized) {
            this.setVisible(true);
        }
        if (this.m_hideChatTranscript) {
            this.m_chatArea.setVisible(false);
            this.m_bottImPanel.setVisible(false);
            this.removeAll();
            this.add("Center", this.m_chatArea);
            this.add("South", this.m_bottImPanel);
            this.m_label.setText(this.m_resourceFile.getString("LBL_TYPEHERE"));
            this.m_chatArea.setVisible(true);
            this.m_bottImPanel.setVisible(true);
            this.m_hideChatTranscript = false;
            this.m_chatArea.validate();
        }
        this.m_chatArea.write(chatMessage.getName(), chatMessage.getText(), chatMessage.isMyText() ? MY_TEXT_COLOR : PARTNER_TEXT_COLOR);
    }

    public void dataReceived(STUserInstance sTUserInstance, int n, int n2, byte[] byArray) {
    }

    public void encryptionModeChanged(boolean bl) {
    }

    public void responseStarted(STUser sTUser) {
    }

    public void responseCleared(STUser sTUser) {
    }

    public void sendFailed(int n) {
    }

    public void requestFocus() {
        if (this.m_initialized) {
            this.m_sendField.requestFocus();
        }
    }

    public void textSubmitted(ChatSendFieldEvent chatSendFieldEvent) {
        String string = chatSendFieldEvent.getMsg();
        if (this.m_textModifier != null) {
            string = this.m_textModifier.TextSubmitted(string);
        }
        this.m_ImModel.sendMessage(string);
        if (this.m_isAway) {
            this.m_ImModel.closeChat();
        }
    }

    public void startedResponse(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_ImModel.sendResponseStarted();
    }

    public void stoppedResponse(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_ImModel.sendResponseCleared();
    }

    public void contentChanged(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_sendFieldHasContent = !chatSendFieldEvent.getIsEmpty();
        this.updateEditStatus();
    }

    public void selectionChanged(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_sendFieldSelected = chatSendFieldEvent.getIsSelected();
        this.updateEditStatus();
    }

    public void sendMessage() {
        if (this.m_initialized) {
            this.m_sendField.submitText();
        }
    }

    public void sendAllText() {
        if (this.m_initialized) {
            this.m_sendField.submitText();
        }
    }

    public void cut() {
        if (this.m_currentFocus != 2 || this.m_sendField.getSelectedText().length() == 0) {
            return;
        }
        this.m_sendField.cut();
    }

    public void copy() {
        if (this.m_currentFocus == 1) {
            this.m_chatArea.copy();
        } else if (this.m_currentFocus == 2) {
            this.m_sendField.copy();
        }
    }

    public void paste() {
        if (this.m_currentFocus == 2) {
            this.m_sendField.paste();
        }
    }

    public void clearAll() {
        if (this.m_currentFocus == 1) {
            this.m_chatArea.clear();
        } else if (this.m_currentFocus == 2) {
            this.m_sendField.clear();
        }
    }

    public void addChatEditListener(ChatEditListener chatEditListener) {
        this.m_editListenersList.addElement(chatEditListener);
    }

    public void removeChatEditListener(ChatEditListener chatEditListener) {
        this.m_editListenersList.removeElement(chatEditListener);
    }

    public void removeAllChatEditListeners() {
        this.m_editListenersList.removeAllElements();
    }

    public Vector getChatEditListeners() {
        Vector vector = new Vector();
        for (int i = 0; i < this.m_editListenersList.size(); ++i) {
            vector.addElement(this.m_editListenersList.elementAt(i));
        }
        return vector;
    }

    public void addChatAreaListener(ChatAreaListener chatAreaListener) {
        if (this.m_chatArea != null) {
            this.m_chatArea.addChatAreaListener(chatAreaListener);
        } else {
            this.m_waitingChatAreaListeners.addElement(chatAreaListener);
        }
    }

    public void removeChatAreaListener(ChatAreaListener chatAreaListener) {
        if (this.m_chatArea != null) {
            this.m_chatArea.removeChatAreaListener(chatAreaListener);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.m_sendField)) {
            this.m_currentFocus = 2;
        } else if (focusEvent.getSource().equals(this.m_chatArea.getEventSource())) {
            this.m_currentFocus = 1;
        } else if (focusEvent.getSource().equals(this.m_taMsg)) {
            this.m_taMsg.nextFocus();
            this.m_currentFocus = 2;
        }
        this.updateEditStatus();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.m_sendField)) {
            this.m_currentFocus = 0;
            this.m_sendField.removeSelection();
        } else if (focusEvent.getSource().equals(this.m_chatArea.getEventSource())) {
            this.m_currentFocus = 0;
        }
    }

    public void chatAreaStatusChanged(ChatAreaEvent chatAreaEvent) {
        this.m_chatAreaSelected = chatAreaEvent.getSelectionStatus();
        this.updateEditStatus();
    }

    public void chatURLClicked(ChatAreaEvent chatAreaEvent) {
    }

    public void chatAreaContentChanged(ChatAreaEvent chatAreaEvent) {
        this.m_chatAreaHasContent = chatAreaEvent.getContentStatus();
        this.updateEditStatus();
    }

    protected void updateEditStatus() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.m_sendField.hasClipboardAccess()) {
            bl = null == this.m_clipboard || null == this.m_clipboard.getContents(this);
            bl3 = this.m_currentFocus == 2 & this.m_sendFieldSelected || this.m_currentFocus == 1 & this.m_chatAreaSelected;
            bl2 = this.m_currentFocus == 2 & this.m_sendFieldSelected;
            bl4 = this.m_currentFocus == 2 & !bl;
        }
        bl = this.m_currentFocus == 2 & this.m_sendFieldHasContent || this.m_currentFocus == 1 & this.m_chatAreaHasContent;
        ChatEditEvent chatEditEvent = new ChatEditEvent(this, bl2, bl3, bl4, bl);
        for (int i = 0; i < this.m_editListenersList.size(); ++i) {
            ChatEditListener chatEditListener = (ChatEditListener)this.m_editListenersList.elementAt(i);
            chatEditListener.editStatusChanged(chatEditEvent);
        }
    }

    public ChatSendField getChatSendField() {
        return this.m_sendField;
    }
}

