/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.tree;

import com.lotus.sametime.announcementui.AnnouncementUI;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.AwarenessViewController;
import com.lotus.sametime.awarenessui.tree.STPrivateGroup;
import com.lotus.sametime.awarenessui.tree.STTreeControllerUtil;
import com.lotus.sametime.awarenessui.tree.STTreeGroup;
import com.lotus.sametime.awarenessui.tree.STTreeModel;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.ImageResources;
import com.lotus.sametime.filetransferui.FileTransferUI;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TreeNode;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class STTreeController
extends AwarenessViewController {
    public STTreeController(AwarenessModel awarenessModel) {
        super(awarenessModel);
        STTreeControllerUtil.m_model = (STTreeModel)awarenessModel;
        STTreeControllerUtil.m_resource = this.m_resource;
    }

    public void createMessage(Vector vector) {
        Vector vector2 = this.getOnlineUsers(vector);
        if (vector2 == null) {
            return;
        }
        if (vector2.size() == 1) {
            AwarenessNode awarenessNode = (AwarenessNode)vector2.firstElement();
            STUser sTUser = (STUser)awarenessNode.getKey();
            this.m_chat.create1On1ChatById(sTUser);
        } else if (vector2.size() > 1) {
            Serializable serializable;
            Object object;
            STBoolean sTBoolean = new STBoolean(false);
            Vector vector3 = this.getOnlineUsers(vector, true, sTBoolean);
            if (vector3.size() == 1) {
                object = (AwarenessNode)vector3.firstElement();
                serializable = (STUser)((TreeNode)object).getKey();
                this.m_chat.create1On1ChatById((STUser)serializable);
            } else if (vector3.size() > 1) {
                this.openConference(vector3);
            }
            if (sTBoolean.getValue()) {
                object = ImageResources.getInstance().getImage("images/alert.gif");
                serializable = new UbqDialog(this.getMainFrame(), this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray("NON_ST_USERS_IN_CHAT"), this.m_resource.formatStringArray("BTN_LBL_OK"));
                ((UbqDialog)serializable).setImage((Image)object);
                ((UbqDialog)serializable).setVisible(true);
            }
        }
    }

    public void createAnnouncement(Vector vector) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        STTreeGroup[] sTTreeGroupArray = ((STTreeModel)this.m_model).getSelectedGroups(vector);
        for (int i = 0; i < sTTreeGroupArray.length; ++i) {
            STTreeGroup sTTreeGroup = sTTreeGroupArray[i];
            if (sTTreeGroup.isShortcut()) {
                vector2.addElement(sTTreeGroup);
                continue;
            }
            object = ((STTreeModel)this.m_model).getUsersInGroup(sTTreeGroup);
            for (int j = 0; j < ((STUser[])object).length; ++j) {
                STUserStatus sTUserStatus = ((STWatchedUser)object[j]).getStatus();
                if (sTUserStatus.isStatus((short)0) || sTUserStatus.isStatus((short)128) || ((STUser)object[j]).isExternalUser() || vector2.contains(object[j])) continue;
                vector2.addElement(object[j]);
            }
        }
        STWatchedUser[] sTWatchedUserArray = ((STTreeModel)this.m_model).getSelectedUsers(vector);
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            object = sTWatchedUserArray[i].getStatus();
            if (((STUserStatus)object).isStatus((short)0) || ((STUserStatus)object).isStatus((short)128) || sTWatchedUserArray[i].isExternalUser() || vector2.contains(sTWatchedUserArray[i])) continue;
            vector2.addElement(sTWatchedUserArray[i]);
        }
        Object[] objectArray = new STObject[vector2.size()];
        vector2.copyInto(objectArray);
        object = (AnnouncementUI)this.m_model.getSession().getCompApi("com.lotus.sametime.announcementui.AnnouncementUIComp");
        object.sendAnnouncement((STObject[])objectArray);
    }

    protected void createFileTransfer(Vector vector) {
        STBoolean sTBoolean = new STBoolean(false);
        Vector vector2 = this.getOnlineUsers(vector, true, sTBoolean);
        if (vector2.size() == 1) {
            STUser sTUser = (STUser)((AwarenessNode)vector2.firstElement()).getKey();
            FileTransferUI fileTransferUI = (FileTransferUI)this.m_model.getSession().getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
            fileTransferUI.sendFile(sTUser);
        }
    }

    public void removeSelectedNodes(Vector vector) {
        STTreeControllerUtil.removeSelectedNodes(vector);
    }

    protected void handleNodeExpanded(TreeNode treeNode) {
        STTreeControllerUtil.nodeExpanded(treeNode);
    }

    protected void handleNodeCollapsed(TreeNode treeNode) {
        STTreeControllerUtil.nodeCollapsed(treeNode);
    }

    public void nodeDoubleClicked(TreeNode treeNode) {
        if (this.m_model.isGroup((ModelNode)treeNode)) {
            return;
        }
        Vector<TreeNode> vector = new Vector<TreeNode>();
        vector.addElement(treeNode);
        this.createMessage(vector);
    }

    public void deletePressed(Vector vector) {
        STTreeControllerUtil.deletePressed(vector, this.m_deleteEnabled);
    }

    public void enablePopupItems(Vector vector) {
        if (vector.size() == 1) {
            AwarenessNode awarenessNode = (AwarenessNode)vector.firstElement();
            this.enablePopupItemsForNode(awarenessNode);
        } else {
            this.enablePopupItemsForNodes(vector);
        }
    }

    private void openConference(Vector vector) {
        String string = this.m_commService.getLogin().getMyUserInstance().getName();
        String string2 = this.m_resource.getString("PLEASE_JOIN_THIS_CHAT");
        String string3 = this.m_resource.formatString("'S_CONFERENCE", string);
        STBoolean sTBoolean = new STBoolean(false);
        STUser[] sTUserArray = this.m_model.getUsersFromNodes(vector, true, sTBoolean);
        this.m_chat.createConferenceChat(string3, string2, true, sTUserArray);
        if (sTBoolean.getValue()) {
            Image image = ImageResources.getInstance().getImage("images/alert.gif");
            UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray("NON_ST_USERS_IN_CHAT"), this.m_resource.formatStringArray("BTN_LBL_OK"));
            ubqDialog.setImage(image);
            ubqDialog.setVisible(true);
        }
    }

    protected void enablePopupItemsForNode(AwarenessNode awarenessNode) {
        boolean bl = false;
        this.m_popup.removeAll();
        this.m_popup.add(this.m_message);
        if (this.m_model.isGroup(awarenessNode)) {
            if (this.m_deleteEnabled) {
                this.m_popup.add(this.m_separator);
                this.m_popup.add(this.m_remove);
            }
            bl = STTreeControllerUtil.doesGroupContainOnlineUsers(awarenessNode);
        } else {
            if (awarenessNode.getParent().getKey() instanceof STPrivateGroup && this.m_deleteEnabled) {
                this.m_popup.add(this.m_separator);
                this.m_popup.add(this.m_remove);
            }
            bl = awarenessNode.isOnline();
        }
        this.m_message.setEnabled(bl && this.m_messageEnabled);
    }

    protected void enablePopupItemsForNodes(Vector vector) {
        this.m_popup.removeAll();
        this.m_popup.add(this.m_message);
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            if (this.m_model.isGroup(awarenessNode)) {
                bl = STTreeControllerUtil.doesGroupContainOnlineUsers(awarenessNode);
                continue;
            }
            if (!awarenessNode.isOnline() || ((STUser)awarenessNode.getKey()).isExternalUser()) continue;
            bl = true;
            break;
        }
        this.m_message.setEnabled(bl && this.m_messageEnabled);
        if (this.m_deleteEnabled) {
            this.m_popup.add(this.m_separator);
            this.m_popup.add(this.m_remove);
        }
    }

    protected void startPhoneCall(Vector vector) {
    }
}

