/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.placelist;

import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TreeEvent;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.places.MySectionListener;
import com.lotus.sametime.places.MyselfEvent;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceEvent;
import com.lotus.sametime.places.PlaceListener;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlacesService;
import com.lotus.sametime.places.PlacesServiceEvent;
import com.lotus.sametime.places.PlacesServiceListener;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.SectionEvent;
import com.lotus.sametime.places.SectionListener;
import com.lotus.sametime.places.UserInPlace;
import com.lotus.sametime.places.UserInPlaceListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlaceListModel
extends AwarenessModel
implements PlacesServiceListener,
SectionListener,
UserInPlaceListener,
PlaceListener,
MySectionListener {
    private PlacesService m_placesService;
    private Section m_section;
    private Place m_place;
    private Hashtable m_duplicates = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awarenessui.placelist");

    public PlaceListModel(STSession sTSession) {
        super(sTSession);
        this.m_placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        this.m_placesService.addPlacesServiceListener(this);
    }

    public void bindToSection(Section section) {
        this.reset();
        if (null != this.m_place) {
            this.m_place.removePlaceListener(this);
        }
        this.bind(section);
    }

    private void bind(Section section) {
        this.removeSectionListener();
        this.m_section = section;
        this.m_section.addSectionListener(this);
    }

    public void bindToPlace(Place place) {
        if (null != this.m_place) {
            this.m_place.removePlaceListener(this);
            this.removeSectionListener();
        }
        this.m_place = place;
        this.m_place.addPlaceListener(this);
        Section section = this.m_place.getMySection();
        if (null != section) {
            this.bind(section);
        }
    }

    public void left(PlaceEvent placeEvent) {
        this.removeSectionListener();
        this.reset();
    }

    public void entered(PlaceEvent placeEvent) {
        this.reset();
        this.bind(placeEvent.getSection());
        this.m_place.getMyselfInPlace().addMySectionListener(this);
    }

    public void sectionChanged(MyselfEvent myselfEvent) {
        this.reset();
        this.bind(myselfEvent.getSection());
    }

    private void removeSectionListener() {
        if (null != this.m_section) {
            this.m_section.removeSectionListener(this);
            Enumeration enumeration = this.getItems().elements();
            while (enumeration.hasMoreElements()) {
                AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
                UserInPlace userInPlace = (UserInPlace)awarenessNode.getKey();
                userInPlace.removeUserInPlaceListener(this);
            }
            this.m_section = null;
        }
    }

    public void usersEntered(SectionEvent sectionEvent) {
        UserInPlace[] userInPlaceArray = sectionEvent.getUsers();
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        boolean bl = false;
        for (int i = 0; i < userInPlaceArray.length; ++i) {
            boolean bl2 = bl = this.getNode(userInPlaceArray[i]) != null;
            if (!bl) {
                for (int j = 0; j < i; ++j) {
                    if (!userInPlaceArray[i].getId().equals(userInPlaceArray[j].getId())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.m_duplicates.put(userInPlaceArray[i].getLoginId(), userInPlaceArray[i]);
                continue;
            }
            vector.addElement(this.createNewNode(userInPlaceArray[i]));
        }
        this.addUsers(vector);
    }

    private void addUsers(Vector vector) {
        if (null == vector || vector.isEmpty()) {
            return;
        }
        this.insertNodes(vector);
        STUser[] sTUserArray = new STUser[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            ((UserInPlace)awarenessNode.getKey()).addUserInPlaceListener(this);
            sTUserArray[n++] = (STUser)awarenessNode.getKey();
        }
        this.addUsers(sTUserArray);
        AwarenessViewEvent awarenessViewEvent = new AwarenessViewEvent(1, (Object)this, sTUserArray);
        this.sendEvent(awarenessViewEvent);
    }

    public void userLeft(SectionEvent sectionEvent) {
        Object v = this.m_duplicates.remove(sectionEvent.getUser().getLoginId());
        if (null != v) {
            return;
        }
        STUser[] sTUserArray = new STUser[]{sectionEvent.getUser()};
        this.removeUsers(sTUserArray);
        Enumeration enumeration = this.m_duplicates.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlace userInPlace = (UserInPlace)enumeration.nextElement();
            if (!userInPlace.getId().equals(sectionEvent.getUser().getId())) continue;
            this.m_duplicates.remove(userInPlace.getLoginId());
            Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
            vector.addElement(this.createNewNode(userInPlace));
            this.addUsers(vector);
            break;
        }
    }

    private AwarenessNode createNewNode(UserInPlace userInPlace) {
        Vector vector = null;
        Vector vector2 = null;
        if (this.m_leftAttributes.size() > 0) {
            vector = new Vector();
            vector.setSize(this.m_leftAttributes.size());
        }
        if (this.m_rightAttributes.size() > 0) {
            vector2 = new Vector();
            vector2.setSize(this.m_rightAttributes.size());
        }
        STUserStatus sTUserStatus = new STUserStatus(0, 0, "");
        if (null != this.m_namesService) {
            userInPlace.setNickName(this.m_namesService.getNickname(userInPlace));
        }
        AwarenessNode awarenessNode = new AwarenessNode(userInPlace, userInPlace.getDisplayName(), userInPlace.getName(), this.getIcon(sTUserStatus), vector, vector2, this.m_res);
        awarenessNode.setParent((ModelNode)this.getRoot());
        awarenessNode.setStatus(sTUserStatus);
        this.updateNode(awarenessNode);
        return awarenessNode;
    }

    public void serviceUnavailable(PlacesServiceEvent placesServiceEvent) {
        this.reset();
        this.removeSectionListener();
    }

    public void attributeChanged(PlaceMemberEvent placeMemberEvent) {
        if (!(placeMemberEvent.getSource() instanceof STUser)) {
            return;
        }
        AwarenessNode awarenessNode = (AwarenessNode)this.getNode((STUser)placeMemberEvent.getSource());
        if (null != awarenessNode) {
            awarenessNode.getAttributes().put(new Integer(placeMemberEvent.getAttribute().getKey()), placeMemberEvent.getAttribute());
            boolean bl = false;
            if (this.isAttribWatched(placeMemberEvent.getAttributeKey())) {
                this.updateNode(awarenessNode);
                bl = true;
            }
            boolean bl2 = this.resortIfNeeded(placeMemberEvent.getAttributeKey());
            if (bl && !bl2) {
                TreeNode[] treeNodeArray = new AwarenessNode[]{awarenessNode};
                this.sendEvent(new TreeEvent(1, treeNodeArray));
            }
        }
    }

    public void attributeRemoved(PlaceMemberEvent placeMemberEvent) {
        if (!(placeMemberEvent.getSource() instanceof STUser)) {
            return;
        }
        AwarenessNode awarenessNode = (AwarenessNode)this.getNode((STUser)((Object)placeMemberEvent.getPlaceMember()));
        if (null != awarenessNode) {
            awarenessNode.getAttributes().remove(new Integer(placeMemberEvent.getAttributeKey()));
            boolean bl = false;
            if (this.isAttribWatched(placeMemberEvent.getAttributeKey())) {
                this.updateNode(awarenessNode);
                bl = true;
            }
            boolean bl2 = this.resortIfNeeded(placeMemberEvent.getAttributeKey());
            if (bl && !bl2) {
                TreeNode[] treeNodeArray = new AwarenessNode[]{awarenessNode};
                this.sendEvent(new TreeEvent(1, treeNodeArray));
            }
        }
    }

    public void serviceAvailable(PlacesServiceEvent placesServiceEvent) {
    }

    protected void handleStatusChanged(STWatchedUser[] sTWatchedUserArray) {
        Vector<STWatchedUser> vector = new Vector<STWatchedUser>();
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            if (this.getNode(sTWatchedUserArray[i]) != null) {
                vector.addElement(sTWatchedUserArray[i]);
                continue;
            }
            if (!this.m_logger.isLoggable(Level.FINER)) continue;
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleStatusChanged", "Place list received status changeon user not in the list" + sTWatchedUserArray[i].getName());
        }
        if (vector.size() > 0) {
            Object[] objectArray = new STWatchedUser[vector.size()];
            vector.copyInto(objectArray);
            super.handleStatusChanged((STWatchedUser[])objectArray);
        }
    }

    public void reset() {
        super.reset();
        this.m_duplicates.clear();
    }

    public void removeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void queryAttrContentFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void sendFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void changeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void addAllowedUsersFailed(SectionEvent sectionEvent) {
    }

    public void removeAllowedUsersFailed(SectionEvent sectionEvent) {
    }

    public void enterFailed(PlaceEvent placeEvent) {
    }

    public void activityAdded(PlaceEvent placeEvent) {
    }

    public void activityRemoved(PlaceEvent placeEvent) {
    }

    public void addActivityFailed(PlaceEvent placeEvent) {
    }

    public void sectionAdded(PlaceEvent placeEvent) {
    }

    public void sectionRemoved(PlaceEvent placeEvent) {
    }

    public void addAllowedUsersFailed(PlaceEvent placeEvent) {
    }

    public void removeAllowedUsersFailed(PlaceEvent placeEvent) {
    }

    public void invite15UserFailed(PlaceEvent placeEvent) {
    }

    public void changeSectionFailed(MyselfEvent myselfEvent) {
    }
}

