/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awareness;

import com.lotus.sametime.awareness.STWatchedObject;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.Dumpable;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class WioObject
implements Dumpable {
    private STWatchedObject m_watchedObject;
    private short m_type;
    private Hashtable m_watchingSessions = new Hashtable();
    private Hashtable m_watchingGroups = new Hashtable();

    public WioObject(STWatchedObject sTWatchedObject, short s) {
        this.m_watchedObject = sTWatchedObject;
        this.m_type = s;
    }

    public WioObject(STWatchedObject sTWatchedObject, STGroup sTGroup) {
        this.m_watchedObject = sTWatchedObject;
        this.m_watchingGroups.put(sTGroup, sTGroup);
    }

    public void setStatus(short s, String string) {
        STUserStatus sTUserStatus = new STUserStatus(s, (int)System.currentTimeMillis(), string);
        this.setStatus(sTUserStatus);
    }

    void setStatus(STUserStatus sTUserStatus) {
        ((STWatchedUser)this.m_watchedObject).setStatus(sTUserStatus);
    }

    void setIconUrl(String string) {
        Debug.stAssert(this.m_watchedObject instanceof STWatchedUser);
        ((STWatchedUser)this.m_watchedObject).setIconUrl(string);
    }

    void setName(String string) {
        if (!string.equals(this.m_watchedObject.getName()) && this.m_watchedObject instanceof STUser) {
            this.m_watchedObject = ((STWatchedUser)this.m_watchedObject).changeName(string);
        }
    }

    public void addWatch(Integer n) {
        this.m_watchingSessions.put(n, n);
    }

    public void removeWatch(Integer n) {
        this.m_watchingSessions.remove(n);
    }

    public boolean isWatched(Integer n) {
        return this.m_watchingSessions.get(n) != null;
    }

    public boolean isWatched(Object object) {
        return this.m_watchingGroups.get(object) != null;
    }

    public Enumeration getWatchingSessions() {
        return this.m_watchingSessions.elements();
    }

    public Enumeration getWatchingGroups() {
        return this.m_watchingGroups.elements();
    }

    public boolean isWatched() {
        return !this.m_watchingSessions.isEmpty() || !this.m_watchingGroups.isEmpty();
    }

    public void dumpToStream(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeShort(this.m_type);
        this.m_watchedObject.getId().dump(ndrOutputStream);
    }

    public void addWatch(STGroup sTGroup) {
        this.m_watchingGroups.put(sTGroup, sTGroup);
    }

    public void removeWatch(STGroup sTGroup) {
        this.m_watchingGroups.remove(sTGroup);
    }

    public boolean isWatchedBySession() {
        return !this.m_watchingSessions.isEmpty();
    }

    public STWatchedObject getWatchedObject() {
        return this.m_watchedObject;
    }
}

