/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.UnsupportedEncodingException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TextTokens;

public class StringUtils {
    private static final int ampersand = 38;
    private static final int ampersandInt = 65;
    private static final int aInt = 97;
    private static final int zeroInt = 48;
    private static final int nineInt = 57;
    private static final int openSquareBracketInt = 91;
    private static final int closeSquareBracketInt = 93;
    private static final int openCurlyBracket = 40;
    private static final int closeCurlyBracket = 41;
    private static final int backSlashInt = 92;
    private static final int forwardSlashInt = 47;
    private static final int hashInt = 35;
    private static final int divideInt = 247;
    private static final int fullStopInt = 46;
    private static final int spaceInt = 32;
    private static final int percentInt = 37;
    private static final int minusInt = 45;
    private static final int underScoreInt = 95;
    private static final int plusInt = 43;
    private static final int pInt = 112;
    private static final int colonInt = 58;
    private static final int equalsInt = 61;
    private static final int cInt = 99;
    private static final int qInt = 113;
    private static String enc = System.getProperty("file.encoding");

    public static final String convertHexChars(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int escapeChar = value.indexOf(35);
        if (escapeChar == -1) {
            return value;
        }
        StringBuilder newString = new StringBuilder();
        int length = value.length();
        for (int ii = 0; ii < length; ++ii) {
            char c = value.charAt(ii);
            if (c == '#') {
                int end;
                if ((end = ++ii + 2) > length) {
                    end = length;
                }
                String key = value.substring(ii, end);
                c = (char)Integer.parseInt(key, 16);
                ++ii;
                if (c == ' ') continue;
                newString.append(c);
                continue;
            }
            newString.append(c);
        }
        return newString.toString();
    }

    public static boolean isNumber(String textString) {
        byte[] data = StringUtils.toBytes(textString);
        int strLength = data.length;
        boolean isNumber = true;
        for (int j = 0; j < strLength; ++j) {
            if (data[j] >= 48 && data[j] <= 57 || data[j] == 46 || j == 0 && data[j] == 45) continue;
            isNumber = false;
            j = strLength;
        }
        return isNumber;
    }

    public static String makeHTMLNameSafe(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        char[] chrs = name.toCharArray();
        if (name.indexOf(37) != -1 || name.indexOf(32) != -1 || name.indexOf(46) != -1 || name.indexOf(43) != -1 || name.indexOf(58) != -1 || name.indexOf(61) != -1 || name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            block11: for (int i = 0; i < chrs.length; ++i) {
                switch (chrs[i]) {
                    case '&': {
                        chrs[i] = 65;
                        continue block11;
                    }
                    case ' ': {
                        chrs[i] = 95;
                        continue block11;
                    }
                    case '.': {
                        chrs[i] = 45;
                        continue block11;
                    }
                    case '%': {
                        chrs[i] = 95;
                        continue block11;
                    }
                    case '+': {
                        chrs[i] = 112;
                        continue block11;
                    }
                    case ':': {
                        chrs[i] = 99;
                        continue block11;
                    }
                    case '=': {
                        chrs[i] = 113;
                        continue block11;
                    }
                    case '/': {
                        chrs[i] = 95;
                        continue block11;
                    }
                    case '\\': {
                        chrs[i] = 95;
                    }
                }
            }
        }
        char[] testchrs = new char[]{'[', ']', '#', '\u00f7', '(', ')'};
        int count = 0;
        for (char chr1 : chrs) {
            for (char testchr : testchrs) {
                if (chr1 != testchr) continue;
                ++count;
            }
        }
        if (count > 0) {
            int c = 0;
            char[] tmp = new char[chrs.length - count];
            block14: for (char chr : chrs) {
                for (char testchr : testchrs) {
                    if (chr == testchr) continue block14;
                }
                tmp[c++] = chr;
            }
            chrs = tmp;
        }
        if (chrs[0] >= '0' && chrs[0] <= '9') {
            char[] tmp = new char[chrs.length + 1];
            System.arraycopy(chrs, 0, tmp, 1, chrs.length);
            tmp[0] = 97;
            chrs = tmp;
        }
        name = new String(chrs);
        return name;
    }

    public static String getTextString(byte[] rawText, boolean keepReturns) {
        return StringUtils.getTextString(rawText, keepReturns, false);
    }

    public static String getTextString(byte[] rawText, boolean keepReturns, boolean keepTabs) {
        StandardFonts.checkLoaded(6);
        if (rawText == null) {
            return null;
        }
        char[] chars = new char[rawText.length * 2];
        int ii = 0;
        TextTokens rawChars = new TextTokens(rawText);
        if (rawChars.isUnicode()) {
            while (rawChars.hasMoreTokens()) {
                char nextChar = rawChars.nextUnicodeToken(keepReturns);
                if (!keepTabs && nextChar == '\t' || !keepReturns && (nextChar == '\n' || nextChar == '\r')) {
                    chars[ii] = 32;
                    ++ii;
                    continue;
                }
                if (nextChar <= '\u001f' && (!keepReturns || nextChar != '\n' && nextChar != '\r') && (!keepTabs || nextChar != '\t')) continue;
                chars[ii] = nextChar;
                ++ii;
            }
        } else {
            while (rawChars.hasMoreTokens()) {
                char nextChar = rawChars.nextToken();
                String c = null;
                if (!keepTabs && nextChar == '\t' || !keepReturns && (nextChar == '\n' || nextChar == '\r')) {
                    c = " ";
                } else if (keepReturns && (nextChar == '\n' || nextChar == '\r') || keepTabs && nextChar == '\t') {
                    c = String.valueOf(nextChar);
                } else if (nextChar > '\u001f' && nextChar < '\u00fd') {
                    c = StandardFonts.getEncodedChar(6, nextChar);
                }
                if (c == null) continue;
                int len = c.length();
                if (ii + len >= chars.length) {
                    char[] tmp = new char[len + ii + 10];
                    System.arraycopy(chars, 0, tmp, 0, chars.length);
                    chars = tmp;
                }
                for (int i = 0; i < len; ++i) {
                    chars[ii] = c.charAt(i);
                    ++ii;
                }
            }
        }
        return String.copyValueOf(chars, 0, ii);
    }

    private static String replaceAllManual(String string, int find, String replace) {
        int index = string.indexOf(find);
        while (index != -1) {
            string = string.substring(0, index) + replace + string.substring(index + 1);
            index = string.indexOf(find, index + 1);
        }
        return string;
    }

    public static String correctSpecialChars(String string) {
        int i;
        if (string == null) {
            return null;
        }
        for (i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '&') continue;
            string = StringUtils.replaceAllManual(string, 38, "&amp;");
            i = string.length();
        }
        block34: for (i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    string = StringUtils.replaceAllManual(string, 34, "&quot;");
                    continue block34;
                }
                case '\u00e1': {
                    string = StringUtils.replaceAllManual(string, 225, "&aacute;");
                    continue block34;
                }
                case '\u00e0': {
                    string = StringUtils.replaceAllManual(string, 224, "&agrave;");
                    continue block34;
                }
                case '\u00e2': {
                    string = StringUtils.replaceAllManual(string, 226, "&acirc;");
                    continue block34;
                }
                case '\u00e5': {
                    string = StringUtils.replaceAllManual(string, 229, "&aring;");
                    continue block34;
                }
                case '\u00e3': {
                    string = StringUtils.replaceAllManual(string, 227, "&atilde;");
                    continue block34;
                }
                case '\u00e4': {
                    string = StringUtils.replaceAllManual(string, 228, "&auml;");
                    continue block34;
                }
                case '\u00e6': {
                    string = StringUtils.replaceAllManual(string, 230, "&aelig;");
                    continue block34;
                }
                case '\u00e7': {
                    string = StringUtils.replaceAllManual(string, 231, "&ccedil;");
                    continue block34;
                }
                case '\u00e9': {
                    string = StringUtils.replaceAllManual(string, 233, "&eacute;");
                    continue block34;
                }
                case '\u00e8': {
                    string = StringUtils.replaceAllManual(string, 232, "&egrave;");
                    continue block34;
                }
                case '\u00ea': {
                    string = StringUtils.replaceAllManual(string, 234, "&ecirc;");
                    continue block34;
                }
                case '\u00eb': {
                    string = StringUtils.replaceAllManual(string, 235, "&euml;");
                    continue block34;
                }
                case '\u00ed': {
                    string = StringUtils.replaceAllManual(string, 237, "&iacute;");
                    continue block34;
                }
                case '\u00ec': {
                    string = StringUtils.replaceAllManual(string, 236, "&igrave;");
                    continue block34;
                }
                case '\u00ee': {
                    string = StringUtils.replaceAllManual(string, 238, "&icirc;");
                    continue block34;
                }
                case '\u00ef': {
                    string = StringUtils.replaceAllManual(string, 239, "&iuml;");
                    continue block34;
                }
                case '\u00f1': {
                    string = StringUtils.replaceAllManual(string, 241, "&ntilde;");
                    continue block34;
                }
                case '\u00f3': {
                    string = StringUtils.replaceAllManual(string, 243, "&oacute;");
                    continue block34;
                }
                case '\u00f2': {
                    string = StringUtils.replaceAllManual(string, 242, "&ograve;");
                    continue block34;
                }
                case '\u00f4': {
                    string = StringUtils.replaceAllManual(string, 244, "&ocirc;");
                    continue block34;
                }
                case '\u00f8': {
                    string = StringUtils.replaceAllManual(string, 248, "&oslash;");
                    continue block34;
                }
                case '\u00f5': {
                    string = StringUtils.replaceAllManual(string, 245, "&otilde;");
                    continue block34;
                }
                case '\u00f6': {
                    string = StringUtils.replaceAllManual(string, 246, "&ouml;");
                    continue block34;
                }
                case '\u00df': {
                    string = StringUtils.replaceAllManual(string, 223, "&szlig;");
                    continue block34;
                }
                case '\u00fa': {
                    string = StringUtils.replaceAllManual(string, 250, "&uacute;");
                    continue block34;
                }
                case '\u00f9': {
                    string = StringUtils.replaceAllManual(string, 249, "&ugrave;");
                    continue block34;
                }
                case '\u00fb': {
                    string = StringUtils.replaceAllManual(string, 251, "&ucirc;");
                    continue block34;
                }
                case '\u00fc': {
                    string = StringUtils.replaceAllManual(string, 252, "&uuml;");
                    continue block34;
                }
                case '\u00ff': {
                    string = StringUtils.replaceAllManual(string, 255, "&yuml;");
                    continue block34;
                }
                case '\u2019': {
                    string = StringUtils.replaceAllManual(string, 8217, "&#39;");
                }
            }
        }
        return string;
    }

    public static byte[] toBytes(String value) {
        byte[] data = null;
        try {
            data = value.getBytes(enc);
        }
        catch (UnsupportedEncodingException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return data;
    }

    static {
        if (!(enc.equals("UTF-8") || enc.equals("MacRoman") || enc.equals("Cp1252"))) {
            enc = DecoderOptions.isRunningOnMac ? "MacRoman" : (DecoderOptions.isRunningOnWindows ? "Cp1252" : "UTF-8");
        }
    }
}

