/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.CodeSpaceRange;
import org.jpedal.fonts.PdfFont;

class GlyphData {
    private boolean firstTime = true;
    private int textLength;
    private int numOfPrefixes;
    private float fontScale;
    private char lastChar;
    private char openChar;
    private int fontSize;
    private int charSize = 2;
    private String displayValue;
    private String unicodeValue;
    private boolean isHorizontal;
    private boolean inText;
    private char rawChar;
    private float actualWidth;
    private int rawInt = -1;
    private int possibleVal;
    private char lastTextChar = (char)120;
    private CodeSpaceRange codeSpaceRange;
    private boolean isXMLExtraction = true;
    private float leading;
    private float width;

    GlyphData() {
    }

    public int getRawInt() {
        return this.rawInt;
    }

    public void setRawInt(int rawInt) {
        this.rawInt = rawInt;
    }

    public void setRaw(int rawInt) {
        this.rawInt = rawInt;
        this.rawChar = (char)rawInt;
    }

    public float getLeading() {
        return this.leading;
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public float getWidth() {
        return this.width;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public String getUnicodeValue() {
        return this.unicodeValue;
    }

    public void setUnicodeValue(String unicodeValue) {
        this.unicodeValue = unicodeValue;
    }

    void reset() {
        this.firstTime = true;
        this.textLength = 0;
        this.rawChar = (char)32;
        this.displayValue = "";
        this.unicodeValue = "";
        this.leading = 0.0f;
        this.width = 0.0f;
        this.rawInt = 0;
        this.actualWidth = 0.0f;
        this.lastChar = (char)32;
        this.openChar = (char)32;
        this.numOfPrefixes = 0;
        this.lastTextChar = (char)120;
    }

    void set(String val) {
        this.displayValue = val;
        this.unicodeValue = val;
    }

    boolean isText() {
        return this.inText;
    }

    void setText(boolean b) {
        this.inText = b;
    }

    boolean isHorizontal() {
        return this.isHorizontal;
    }

    void setHorizontal(boolean b) {
        this.isHorizontal = b;
    }

    void setXMLExtraction(boolean xmlExtraction) {
        this.isXMLExtraction = xmlExtraction;
    }

    boolean isXMLExtraction() {
        return this.isXMLExtraction;
    }

    void updateGlyphSettings(float value, char rc) {
        this.width += value;
        this.leading += value;
        this.rawChar = rc;
    }

    void subtractLeading(float value) {
        this.leading -= value;
    }

    void addToWidth(float currentWidth) {
        ++this.textLength;
        this.width += currentWidth;
    }

    char getRawChar() {
        return this.rawChar;
    }

    void setRawChar(char c) {
        this.rawChar = c;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
    }

    void setActualWidth(float actualWidth) {
        this.actualWidth = actualWidth;
    }

    float getActualWidth() {
        return this.actualWidth;
    }

    void setDefaultCharSize(PdfFont currentFontData) {
        this.charSize = 2;
        if (currentFontData.isCIDFont() && !currentFontData.isSingleByte()) {
            this.charSize = 4;
        }
    }

    public int getCharSize() {
        return this.charSize;
    }

    public void setCharSize(int charSize) {
        this.charSize = charSize;
    }

    int getFontSize() {
        return this.fontSize;
    }

    void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    void setLastChar(char newChar) {
        this.lastChar = newChar;
    }

    char getLastChar() {
        return this.lastChar;
    }

    char getOpenChar() {
        return this.openChar;
    }

    void setOpenChar(char rawChar) {
        this.openChar = rawChar;
    }

    void updatePrefixCount(char testChar) {
        if (testChar == '(') {
            ++this.numOfPrefixes;
        } else if (testChar == ')') {
            if (this.numOfPrefixes <= 0) {
                this.inText = false;
            } else {
                --this.numOfPrefixes;
            }
        }
    }

    void setLastChar() {
        this.lastChar = this.lastChar == '\\' && this.rawChar == '\\' ? (char)120 : this.rawChar;
    }

    int getTextLength() {
        return this.textLength;
    }

    boolean isfirstTime() {
        return this.firstTime;
    }

    void setFirstTime() {
        this.firstTime = false;
    }

    void setPossibleValue(int val) {
        this.possibleVal = val;
    }

    int getPossibleValue() {
        return this.possibleVal;
    }

    public void setLastTextChar(char lastTextChar) {
        this.lastTextChar = lastTextChar;
    }

    public char getLastTextChar() {
        return this.lastTextChar;
    }

    public CodeSpaceRange getCodeSpaceRange() {
        return this.codeSpaceRange;
    }

    public void setCodeSpaceRange(CodeSpaceRange encodingCMAP) {
        this.codeSpaceRange = encodingCMAP;
    }
}

