/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.mask.MaskDataDecoder;

public class MaskDecoder {
    public static byte[] applyMask(ImageData imageData, GenericColorSpace decodeColorData, PdfObject newMask, PdfObject XObject2, byte[] maskDataSream) {
        int[] maskArray = XObject2.getIntArray(489767739);
        if (maskArray != null) {
            maskArray = MaskDecoder.convertToRGB(maskArray, decodeColorData);
        }
        byte[] objectData = imageData.getObjectData();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        if (objectData == null && d == 8) {
            objectData = new byte[w * h];
        } else if (objectData != null && d == 1 && decodeColorData.getID() == 1568372915) {
            objectData = ColorSpaceConvertor.normaliseTo8Bit(1, 1, w, h, objectData);
            d = 8;
        }
        objectData = MaskDataDecoder.convertData(decodeColorData, objectData, w, h, imageData, d);
        XObject2.setIntNumber(-1344207655, 8);
        objectData = maskArray != null ? MaskDecoder.applyMaskArray(w, h, objectData, maskArray) : MaskDecoder.applyMaskStream(objectData, maskDataSream, imageData, newMask, XObject2);
        return objectData;
    }

    private static byte[] applyMaskArray(int w, int h, byte[] objectData, int[] maskArray) {
        int pixels = w * h * 4;
        int rgbPtr = 0;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        float[] diff = new float[3];
        if (maskArray != null) {
            for (int a = 0; a < 3; ++a) {
                diff[a] = maskArray[1] - maskArray[0];
                if (!(diff[a] > 1.0f)) continue;
                int n = a;
                diff[n] = diff[n] / 255.0f;
            }
        }
        try {
            for (int i = 0; i < pixels; i += 4) {
                if (rgbPtr + 3 <= rawDataSize && objectData[rgbPtr] == -1 && objectData[rgbPtr + 1] == -1 && objectData[rgbPtr + 2] == -1) {
                    rgbPtr += 3;
                    combinedData[i] = -1;
                    combinedData[i + 1] = -1;
                    combinedData[i + 2] = -1;
                    combinedData[i + 3] = 0;
                    continue;
                }
                if (rgbPtr + 3 <= rawDataSize && objectData[rgbPtr] == 0 && objectData[rgbPtr + 1] == 0 && objectData[rgbPtr + 2] == 0) {
                    rgbPtr += 3;
                    combinedData[i] = -1;
                    combinedData[i + 1] = 0;
                    combinedData[i + 2] = 0;
                    combinedData[i + 3] = 0;
                    continue;
                }
                for (int comp = 0; comp < 3; ++comp) {
                    if (rgbPtr < rawDataSize) {
                        combinedData[i + comp] = objectData[rgbPtr];
                    }
                    ++rgbPtr;
                }
                combinedData[i + 3] = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static byte[] applyMaskStream(byte[] objectData, byte[] maskData, ImageData imageData, PdfObject newMask, PdfObject XObject2) {
        float diff;
        float[] maskDecodeArray;
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int maskW = newMask.getInt(959726687);
        int maskH = newMask.getInt(959926393);
        int maskD = newMask.getInt(-1344207655);
        boolean isImageMask = newMask.getBoolean(1516403337);
        if (isImageMask) {
            maskD = 1;
        }
        if (maskD != 8) {
            maskData = ColorSpaceConvertor.normaliseTo8Bit(1, maskD, maskW, maskH, maskData);
        }
        if ((maskDecodeArray = newMask.getFloatArray(859785322)) != null && (diff = maskDecodeArray[1] - maskDecodeArray[0]) == -1.0f) {
            int i = 0;
            while (i < maskData.length) {
                int n = i++;
                maskData[n] = (byte)(maskData[n] ^ 0xFF);
            }
        }
        if (w == maskW && h == maskH) {
            objectData = MaskDecoder.buildUnscaledByteArray(w, h, objectData, maskData);
        } else if (w < maskW) {
            objectData = MaskDecoder.upScaleImageToMask(w, h, maskW, maskH, objectData, maskData);
            XObject2.setIntNumber(959726687, maskW);
            XObject2.setIntNumber(959926393, maskH);
        } else {
            objectData = MaskDecoder.upScaleMaskToImage(w, h, maskW, maskH, objectData, maskData);
        }
        XObject2.setIntNumber(-1344207655, 8);
        return objectData;
    }

    public static BufferedImage createMaskImage(boolean isPrinting, byte[] data, int w, int h, ImageData imageData, int d, GenericColorSpace decodeColorData, byte[] maskCol) {
        BufferedImage image = null;
        if (imageData.isDownsampled()) {
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] bands = new int[]{0, 1, 2, 3};
            image = new BufferedImage(w, h, 2);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bands, null);
            image.setData(raster);
        } else {
            boolean isBlank = false;
            boolean keepNonTransparent = false;
            if (maskCol != null && d == 1 && decodeColorData.getID() == 1785221209 && maskCol[0] == 0 && maskCol[1] == 0 && maskCol[2] == 0) {
                isBlank = true;
                for (int aa = 0; aa < data.length; ++aa) {
                    if (data[aa] == -1) continue;
                    isBlank = false;
                    aa = data.length;
                }
                if (isPrinting) {
                    WritableRaster raster = Raster.createPackedRaster(new DataBufferByte(data, data.length), w, h, 1, null);
                    image = new BufferedImage(w, h, 12);
                    image.setData(raster);
                    keepNonTransparent = true;
                } else if (isBlank) {
                    image = null;
                    imageData.setRemoved(true);
                } else {
                    byte[] newIndex = new byte[]{maskCol[0], maskCol[1], maskCol[2], -1, -1, -1};
                    image = ColorSpaceConvertor.convertIndexedToFlat(1, w, h, data, newIndex, true, true);
                }
            }
            if (!isBlank && !keepNonTransparent && maskCol != null) {
                byte[] newIndex = new byte[]{maskCol[0], maskCol[1], maskCol[2], -1, -1, -1};
                image = ColorSpaceConvertor.convertIndexedToFlat(1, w, h, data, newIndex, true, false);
            }
        }
        return image;
    }

    private static byte[] buildUnscaledByteArray(int w, int h, byte[] objectData, byte[] maskData) {
        int pixels = w * h * 4;
        int rgbPtr = 0;
        int aPtr = 0;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        try {
            for (int i = 0; i < pixels; i += 4) {
                int comp;
                if (maskData[aPtr] == -1) {
                    for (comp = 0; comp < 3; ++comp) {
                        if (rgbPtr < rawDataSize) {
                            combinedData[i + comp] = -1;
                        }
                        ++rgbPtr;
                    }
                    combinedData[i + 3] = 0;
                } else {
                    for (comp = 0; comp < 3; ++comp) {
                        if (rgbPtr < rawDataSize) {
                            combinedData[i + comp] = objectData[rgbPtr];
                        }
                        ++rgbPtr;
                    }
                    combinedData[i + 3] = -1;
                }
                ++aPtr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static byte[] upScaleMaskToImage(int w, int h, int maskW, int maskH, byte[] objectData, byte[] maskData) {
        int rgbPtr = 0;
        int i = 0;
        float ratioW = (float)maskW / (float)w;
        float ratioH = (float)maskH / (float)h;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        try {
            for (int iY = 0; iY < h; ++iY) {
                for (int iX = 0; iX < w; ++iX) {
                    int comp;
                    int aPtr = (int)((float)iX * ratioW) + (int)((float)iY * ratioH) * maskW;
                    if (maskData[aPtr] == -1) {
                        for (comp = 0; comp < 3; ++comp) {
                            if (rgbPtr < rawDataSize) {
                                combinedData[i + comp] = -1;
                            }
                            ++rgbPtr;
                        }
                        combinedData[i + 3] = 0;
                    } else {
                        for (comp = 0; comp < 3; ++comp) {
                            if (rgbPtr < rawDataSize) {
                                combinedData[i + comp] = objectData[rgbPtr];
                            }
                            ++rgbPtr;
                        }
                        combinedData[i + 3] = -1;
                    }
                    i += 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static byte[] upScaleImageToMask(int w, int h, int maskW, int maskH, byte[] objectData, byte[] maskData) {
        int aPtr = 0;
        int i = 0;
        float ratioW = (float)w / (float)maskW;
        float ratioH = (float)h / (float)maskH;
        byte[] combinedData = new byte[maskW * maskH * 4];
        int rawDataSize = objectData.length;
        try {
            for (int mY = 0; mY < maskH; ++mY) {
                for (int mX = 0; mX < maskW; ++mX) {
                    int comp;
                    int rgbPtr = (int)((float)mX * ratioW) * 3 + (int)((float)mY * ratioH) * w * 3;
                    if (maskData[aPtr] == -1) {
                        for (comp = 0; comp < 3; ++comp) {
                            if (rgbPtr < rawDataSize) {
                                combinedData[i + comp] = -1;
                            }
                            ++rgbPtr;
                        }
                        combinedData[i + 3] = 0;
                    } else {
                        for (comp = 0; comp < 3; ++comp) {
                            if (rgbPtr < rawDataSize) {
                                combinedData[i + comp] = objectData[rgbPtr];
                            }
                            ++rgbPtr;
                        }
                        combinedData[i + 3] = -1;
                    }
                    ++aPtr;
                    i += 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static int[] convertToRGB(int[] intArray, GenericColorSpace decodeColorData) {
        byte[] index = decodeColorData.getIndexedMap();
        if (index != null) {
            index = decodeColorData.convertIndexToRGB(index);
            int[] indexedArray = intArray;
            intArray = new int[6];
            for (int values = 0; values < 2; ++values) {
                int ptr = indexedArray[values];
                intArray[0 + 3 * values] = (byte)(index[0 + 3 * ptr] & 0xFF);
                intArray[1 + 3 * values] = (byte)(index[1 + 3 * ptr] & 0xFF);
                intArray[2 + 3 * values] = (byte)(index[2 + 3 * ptr] & 0xFF);
            }
        }
        int comps = intArray.length / 2;
        int[] rgbArray = new int[6];
        int[] rawColorData = new int[comps];
        for (int values = 0; values < 2; ++values) {
            for (int a = 0; a < comps; ++a) {
                rawColorData[a] = intArray[a * 2];
            }
            decodeColorData.setColor(rawColorData);
            int foreground = decodeColorData.getColor().getRGB();
            for (int a = 0; a < comps; ++a) {
                rgbArray[0 + 3 * values] = (byte)(foreground >> 16 & 0xFF);
                rgbArray[1 + 3 * values] = (byte)(foreground >> 8 & 0xFF);
                rgbArray[2 + 3 * values] = (byte)(foreground & 0xFF);
            }
        }
        return rgbArray;
    }
}

