/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

class IndexedImage {
    IndexedImage() {
    }

    public static BufferedImage make(GenericColorSpace decodeColorData, ImageData imageData) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        byte[] index = decodeColorData.getIndexedMap();
        BufferedImage image = null;
        LogWriter.writeLog("Indexed " + w + ' ' + h);
        if (!decodeColorData.isIndexConverted()) {
            index = decodeColorData.convertIndexToRGB(index);
        }
        if (d == 8 && decodeColorData.getIndexSize() == 0 && decodeColorData.getID() == 1785221209 && decodeColorData.getRawColorSpacePDFType() != 1247168582) {
            boolean hasPixels = false;
            int indexCount = index.length;
            for (int ii = 0; ii < indexCount; ++ii) {
                if (index[ii] == 0) continue;
                hasPixels = true;
                ii = indexCount;
            }
            if (!hasPixels) {
                int pixelCount = data.length;
                for (int ii = 0; ii < pixelCount; ++ii) {
                    if (data[ii] == 0) continue;
                    hasPixels = true;
                    ii = pixelCount;
                }
            }
            if (!hasPixels) {
                return new BufferedImage(1, 1, 2);
            }
        }
        try {
            if (d == 1 && index.length == 6 && index[0] == index[3] && index[1] == index[4] && index[2] == index[5]) {
                imageData.setRemoved(true);
            } else if (d == 8 && w == 1 && h == 1 && index[0] == -1 && index[1] == -1 && index[2] == -1 && IndexedImage.allBytesZero(data)) {
                image = new BufferedImage(1, 1, 1);
                image.createGraphics().setPaint(Color.CYAN);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(new byte[]{-1, -1, -1}, 1, 1);
                image.setData(raster);
            } else {
                image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, index, false, false);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return image;
    }

    private static boolean allBytesZero(byte[] data) {
        boolean allZero = true;
        for (byte bytes : data) {
            if (bytes == 0) continue;
            allZero = false;
            break;
        }
        return allZero;
    }
}

