/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.BinaryImage;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.image.IndexedImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.mask.MaskDecoder;
import org.jpedal.parser.image.utils.ConvertImageToShape;
import org.jpedal.parser.image.utils.ConvertMaskToShape;
import org.jpedal.render.DynamicVectorRenderer;

public class ImageDataToJavaImage {
    public static BufferedImage makeImage(GenericColorSpace decodeColorData, ImageData imageData) {
        BufferedImage image;
        int comp = imageData.getCompCount();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        int ID2 = decodeColorData.getID();
        boolean isConverted = imageData.isConvertedToARGB() || ID2 == 1785221209 && comp == 4;
        byte[] index = decodeColorData.getIndexedMap();
        if (isConverted) {
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] bands = new int[]{0, 1, 2, 3};
            image = new BufferedImage(w, h, 2);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bands, null);
            image.setData(raster);
        } else if (index != null) {
            image = IndexedImage.make(decodeColorData, imageData);
        } else if (d == 1) {
            image = BinaryImage.make(w, h, data, decodeColorData, 1);
        } else {
            if (d != 8) {
                data = ColorSpaceConvertor.normaliseTo8Bit(comp, d, w, h, data);
            }
            image = decodeColorData.dataToRGB(data, w, h);
        }
        return image;
    }

    public static BufferedImage makeMaskImage(ParserOptions parserOptions, GraphicsState gs, DynamicVectorRenderer current, ImageData imageData, GenericColorSpace decodeColorData, byte[] maskCol) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        BufferedImage image = null;
        float ratio = (float)h / (float)w;
        if (w == 1 && h == 1 && imageData.hasDecodeArrayInverted() && imageData.getImageSource() == 6420) {
            image = MaskDecoder.createMaskImage(parserOptions.isPrinting() && !ImageDecoder.allowPrintTransparency, data, 1, 1, imageData, d, decodeColorData, maskCol);
        } else if (parserOptions.isPrinting() && ratio < 0.1f && w > 4000 && h > 1 || ratio < 0.001f && w > 4000 && h > 1 || w == 1 && h == 1 && data[0] != -128) {
            ConvertMaskToShape.convert(gs, current, parserOptions);
            imageData.setRemoved(true);
        } else if (h == 2 && d == 1 && ImageCommands.isRepeatingLine(data, h)) {
            ConvertImageToShape.convert(data, 2, gs, current, parserOptions);
            imageData.setRemoved(true);
        } else {
            image = MaskDecoder.createMaskImage(parserOptions.isPrinting() && !ImageDecoder.allowPrintTransparency, data, w, h, imageData, d, decodeColorData, maskCol);
        }
        return image;
    }
}

