/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.external.GlyphTracker;
import org.jpedal.external.ShapeTracker;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.structuredtext.StructuredContentHandler;

public class ParserOptions {
    private boolean clippedImagesExtracted = true;
    private boolean finalImagesExtracted = true;
    private boolean createScaledVersion = true;
    private boolean renderImages;
    private boolean rawImagesExtracted = true;
    public boolean imagesProcessedFully;
    private boolean isLayerVisible = true;
    private boolean isType3Font;
    private int layerLevel;
    private final Set<Integer> layerVisibility = new HashSet<Integer>(50);
    public final Set<Integer> layerClips = new HashSet<Integer>(50);
    public PdfLayerList layers;
    private boolean isPageContent;
    private boolean renderPage;
    private boolean isFlattenedForm;
    private float flattenX;
    private float flattenY;
    private boolean isPrinting;
    private float samplingUsed = -1.0f;
    private StructuredContentHandler contentHandler;
    private int textPrint;
    public Shape defaultClip;
    private boolean generateGlyphOnRender;
    private boolean textExtracted = true;
    private boolean renderText;
    private boolean textColorExtracted;
    private int renderMode;
    private int pageNum;
    private int extractionMode;
    private boolean isXFA;
    private GlyphTracker customGlyphTracker;
    private boolean renderDirectly;
    private ShapeTracker customShapeTracker;
    private String fileName = "";
    boolean tooManyShapes;

    public void setName(String name) {
        if (name != null) {
            this.fileName = name.toLowerCase();
            int sep = this.fileName.lastIndexOf(47);
            if (sep != -1) {
                this.fileName = this.fileName.substring(sep + 1);
            }
            if ((sep = this.fileName.lastIndexOf(92)) != -1) {
                this.fileName = this.fileName.substring(sep + 1);
            }
            if ((sep = this.fileName.lastIndexOf(46)) != -1) {
                this.fileName = this.fileName.substring(0, sep);
            }
        }
    }

    public GlyphTracker getCustomGlyphTracker() {
        return this.customGlyphTracker;
    }

    public void setCustomGlyphTracker(GlyphTracker customGlyphTracker) {
        this.customGlyphTracker = customGlyphTracker;
    }

    public void setXFA(boolean isXFA) {
        this.isXFA = isXFA;
    }

    public boolean isPageContent() {
        return this.isPageContent;
    }

    public boolean isRenderPage() {
        return this.renderPage;
    }

    public void init(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, boolean isPrinting) {
        this.isPageContent = isPageContent;
        this.renderPage = renderPage;
        this.renderMode = renderMode;
        this.extractionMode = extractionMode;
        this.isPrinting = isPrinting;
        this.textExtracted = (extractionMode & 1) == 1;
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
        this.renderImages = renderPage && (renderMode & 2) == 2;
        this.finalImagesExtracted = (extractionMode & 4) == 4;
        this.clippedImagesExtracted = (extractionMode & 0x20) == 32;
        this.rawImagesExtracted = (extractionMode & 2) == 2;
        this.createScaledVersion = this.finalImagesExtracted || this.renderImages;
    }

    public boolean isRenderText() {
        return this.renderText;
    }

    public void isPrinting(boolean printing) {
        this.isPrinting = printing;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public boolean isTextColorExtracted() {
        return this.textColorExtracted;
    }

    public boolean isTextExtracted() {
        return this.textExtracted;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public int getExtractionMode() {
        return this.extractionMode;
    }

    public boolean isXFA() {
        return this.isXFA;
    }

    public boolean generateGlyphOnRender() {
        return this.generateGlyphOnRender;
    }

    public void setGenerateGlyphOnRender(boolean value) {
        this.generateGlyphOnRender = value;
    }

    public int getTextPrint() {
        return this.textPrint;
    }

    public void setTextPrint(int value) {
        this.textPrint = value;
    }

    public StructuredContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(StructuredContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public boolean renderDirectly() {
        return this.renderDirectly;
    }

    void setRenderDirectly() {
        this.renderDirectly = true;
    }

    public void setSamplingUsed(float scaleY) {
        this.samplingUsed = scaleY;
    }

    float getSamplingUsed() {
        return this.samplingUsed;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getPageNumber() {
        return this.pageNum;
    }

    public void setPageNumber(int value) {
        this.pageNum = value;
    }

    public void setCustomShapeTracker(ShapeTracker obj) {
        this.customShapeTracker = obj;
    }

    public ShapeTracker getCustomShapeTraker() {
        return this.customShapeTracker;
    }

    public void setFlattenedForm(boolean b) {
        this.isFlattenedForm = b;
    }

    public boolean isFlattenedForm() {
        return this.isFlattenedForm;
    }

    public void setOffsets(float x, float y) {
        this.flattenX = x;
        this.flattenY = y;
    }

    public float getflattenX() {
        return this.flattenX;
    }

    public float getflattenY() {
        return this.flattenY;
    }

    public boolean isLayerVisible() {
        return this.isLayerVisible;
    }

    public void setPdfLayerList(PdfLayerList layers) {
        this.layers = layers;
    }

    boolean hasContentHandler() {
        return this.contentHandler != null;
    }

    public int getLayerLevel() {
        return this.layerLevel;
    }

    public void setLayerLevel(int layerLevel) {
        this.layerLevel = layerLevel;
    }

    public Set<Integer> getLayerVisibility() {
        return this.layerVisibility;
    }

    public void setIsLayerVisible(boolean isLayerVisible) {
        this.isLayerVisible = isLayerVisible;
    }

    public void isType3Font(boolean isType3Font) {
        this.isType3Font = isType3Font;
    }

    public boolean isType3Font() {
        return this.isType3Font;
    }

    public boolean isFinalImagesExtracted() {
        return this.finalImagesExtracted;
    }

    public boolean isRawImagesExtracted() {
        return this.rawImagesExtracted;
    }

    public boolean renderImages() {
        return this.renderImages;
    }

    public boolean imagesNeeded() {
        return this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted;
    }

    public boolean createScaledVersion() {
        return this.createScaledVersion;
    }

    public boolean isClippedImagesExtracted() {
        return this.clippedImagesExtracted;
    }
}

