/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormAppearanceObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.xfa.XFAFormStream;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.SwingDisplay;

public class APImageForXFA {
    public static BufferedImage flattenAPForm(FormAppearanceObject imgObj, PdfObject form, ParserOptions parserOptions, PdfObjectReader currentPdfFile) {
        imgObj.setMatteBorderDetails(((FormObject)form).getMatteBorderDetails());
        BufferedImage image = XFAFormStream.decodeApperanceObject(imgObj, 4.0f);
        APImageForXFA.addTextToXFAAPImage(form, currentPdfFile, parserOptions, image, 4.0f);
        APImageForXFA.completeImage(imgObj, image, 4.0f);
        return image;
    }

    public static void addTextToXFAAPImage(PdfObject form, PdfObjectReader currentPdfFile, ParserOptions parserOptions, BufferedImage image, float scaling) {
        FormObject formObj = (FormObject)form;
        byte[] formData = form.getTextStreamValueAsByte(5137);
        if (formData != null) {
            ObjectStore localStore = currentPdfFile.getObjectStore();
            SwingDisplay glyphDisplay = new SwingDisplay(0, false, 20, localStore);
            PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
            glyphDecoder.setParameters(true, true, 3, 65, false);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDecoder.setMultiplyer(1.0f);
            glyphDecoder.setRenderer(glyphDisplay);
            PdfObject SMaskResources = form.getDictionary(2004251818);
            if (SMaskResources != null) {
                glyphDecoder.readResources(SMaskResources, false);
            }
            glyphDecoder.decodeStreamIntoObjects(formData, false);
            Rectangle occupied = glyphDisplay.getOccupiedArea();
            int textH = (int)(((float)image.getHeight() + (float)occupied.y * scaling) / 2.0f - (float)(2 * (occupied.height - occupied.y)));
            if ((double)(image.getWidth() + 10) < occupied.getWidth() * (double)scaling && formObj.getFieldFlags()[13]) {
                String textData = new String(formData);
                int start = textData.indexOf(40);
                int end = textData.lastIndexOf(")Tj");
                if (start == -1 || end == -1) {
                    return;
                }
                textData = textData.substring(start + 1, end);
                String div = "<div style='font-family:arial;font-size:" + scaling * 10.0f + "pt'>" + textData + "</div>";
                JEditorPane ed = new JEditorPane("text/html", div);
                ed.setSize(image.getWidth(), image.getHeight());
                SwingUtilities.paintComponent(image.createGraphics(), ed, new JPanel(), 2, 2, image.getWidth() - 4, image.getHeight() - 4);
                return;
            }
            Graphics2D formG2 = image.createGraphics();
            formG2.translate(5, textH);
            formG2.scale(scaling, -scaling);
            glyphDisplay.setG2(formG2);
            glyphDisplay.paint(null, null, null);
            localStore.flush();
        }
    }

    public static void completeImage(FormAppearanceObject imgObj, BufferedImage image, float scaling) {
        Graphics2D g2 = image.createGraphics();
        int w = (int)(scaling * (float)imgObj.getWidth());
        int h = (int)(scaling * (float)imgObj.getHeight());
        g2.setTransform(AffineTransform.getScaleInstance((float)w / 80.0f, (float)h / 80.0f));
        int subtype = imgObj.getSubtype();
        if (subtype == 2) {
            APImageForXFA.drawComboBoxDArrow(image);
        }
    }

    private static void drawComboBoxDArrow(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        Color lightGrey = new Color(212, 208, 200);
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(width - 34, 4.0, 30.0, height - 8));
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(width - 32, 6.0, 26.0, height - 12));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(width - 30, 8.0, 24.0, height - 14));
        g2.setColor(lightGrey);
        g2.fill(new Rectangle2D.Double(width - 30, 8.0, 22.0, height - 16));
        g2.setColor(Color.BLACK);
        int[] x = new int[]{0, -8, -16};
        int[] y = new int[]{0, 11, 0};
        int n = 3;
        Polygon p = new Polygon(x, y, 3);
        p.translate(width - 11, height / 2 - 6);
        g2.fillPolygon(p);
        g2.setColor(darkGrey);
        x = new int[]{width - 4, width - 2, width - 2};
        y = new int[]{4, 2, 4};
        p = new Polygon(x, y, 3);
        p.translate(-4, 4);
        g2.fillPolygon(p);
        g2.setColor(darkGrey);
        x = new int[]{width - 4, width - 2, width - 2};
        y = new int[]{4, 2, 4};
        p = new Polygon(x, y, 3);
        p.translate(-28, height - 10);
        g2.fillPolygon(p);
        g2.setColor(lightGrey);
        x = new int[]{width - 4, width - 2, width - 2};
        y = new int[]{4, 2, 4};
        p = new Polygon(x, y, 3);
        g2.fillPolygon(p);
        g2.setColor(lightGrey);
        x = new int[]{2, 4, 4};
        y = new int[]{height - 2, height - 2, height - 4};
        p = new Polygon(x, y, 3);
        g2.fillPolygon(p);
    }
}

