/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.CIDEncodings;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class FontObject
extends PdfObject {
    private static final int MMType1 = 1230852645;
    private static final int Type1C = 1077224796;
    private static final int ZaDb = 707859506;
    private static final int ZapfDingbats = 1889256112;
    private static final int Symbol = 1026712197;
    private PdfObject CharProcs;
    private PdfObject CIDSet;
    private PdfObject CIDSystemInfo;
    private PdfObject CIDToGIDMap;
    private PdfObject DescendantFonts;
    private PdfObject FontDescriptor;
    private PdfObject FontFile;
    private PdfObject FontFile2;
    private PdfObject FontFile3;
    private PdfObject ToUnicode;
    private int BaseEncoding = -1;
    private int CIDToGIDMapAsConstant = -1;
    private int AvgWidth = -1;
    private int FirstChar;
    private int LastChar = 255;
    private int Flags;
    private int MissingWidth;
    private int DW = -1;
    private int StemV;
    private int Supplement;
    private float Ascent;
    private float Descent;
    private float[] Widths;
    private float[] FontBBox;
    private double[] FontMatrix;
    private byte[][] Differences;
    private Object[] W;
    private Object[] W2;
    private byte[] rawBaseFont;
    private byte[] rawCharSet;
    private byte[] rawCMapName;
    private byte[] rawFontName;
    private byte[] rawFontStretch;
    private byte[] rawOrdering;
    private byte[] rawRegistry;
    private String BaseFont;
    private String CharSet;
    private String CMapName;
    private String FontName;
    private String FontStretch;
    private String Ordering;
    private String Registry;
    private int[] DW2;

    public FontObject(String ref) {
        super(ref);
    }

    public FontObject(int ref, int gen) {
        super(ref, gen);
    }

    public FontObject(int type) {
        super(type);
    }

    @Override
    public PdfObject getDictionary(int id) {
        switch (id) {
            case 2054190454: {
                return this.CharProcs;
            }
            case 337856605: {
                return this.CIDSet;
            }
            case 1972801240: {
                return this.CIDSystemInfo;
            }
            case 946823533: {
                return this.CIDToGIDMap;
            }
            case -1547306032: {
                return this.DescendantFonts;
            }
            case 1232564598: {
                return this.Encoding;
            }
            case -1044665361: {
                return this.FontDescriptor;
            }
            case 746093177: {
                return this.FontFile;
            }
            case 2021292334: {
                return this.FontFile2;
            }
            case 2021292335: {
                return this.FontFile3;
            }
            case 1919185554: {
                return this.ToUnicode;
            }
        }
        return super.getDictionary(id);
    }

    @Override
    public void setIntNumber(int id, int value) {
        switch (id) {
            case 859131783: {
                this.Ascent = value;
                break;
            }
            case 1249540959: {
                this.AvgWidth = value;
                break;
            }
            case 860451719: {
                this.Descent = value;
                break;
            }
            case 5159: {
                this.DW = value;
                break;
            }
            case 1283093660: {
                this.FirstChar = value;
                break;
            }
            case 1009858393: {
                this.Flags = value;
                break;
            }
            case 795440262: {
                this.LastChar = value;
                break;
            }
            case -1884569950: {
                this.MissingWidth = value;
                break;
            }
            case 1144339785: {
                this.StemV = value;
                break;
            }
            case 2104860094: {
                this.Supplement = value;
                break;
            }
            default: {
                super.setIntNumber(id, value);
            }
        }
    }

    @Override
    public int getInt(int id) {
        switch (id) {
            case 1249540959: {
                return this.AvgWidth;
            }
            case 5159: {
                return this.DW;
            }
            case 1283093660: {
                return this.FirstChar;
            }
            case 1009858393: {
                return this.Flags;
            }
            case 795440262: {
                return this.LastChar;
            }
            case -1884569950: {
                return this.MissingWidth;
            }
            case 1144339785: {
                return this.StemV;
            }
            case 2104860094: {
                return this.Supplement;
            }
        }
        return super.getInt(id);
    }

    @Override
    public void setFloatNumber(int id, float value) {
        switch (id) {
            case 859131783: {
                this.Ascent = value;
                break;
            }
            case 860451719: {
                this.Descent = value;
                break;
            }
            default: {
                super.setFloatNumber(id, value);
            }
        }
    }

    @Override
    public float getFloatNumber(int id) {
        switch (id) {
            case 859131783: {
                return this.Ascent;
            }
            case 860451719: {
                return this.Descent;
            }
        }
        return super.getFloatNumber(id);
    }

    @Override
    public void setDictionary(int id, PdfObject value) {
        value.setID(id);
        if (id == 746093177 || id == 2021292334 || id == 2021292335) {
            this.hasStream = true;
        }
        switch (id) {
            case 2054190454: {
                this.CharProcs = value;
                break;
            }
            case 337856605: {
                this.CIDSet = value;
                break;
            }
            case 1972801240: {
                this.CIDSystemInfo = value;
                break;
            }
            case 946823533: {
                this.CIDToGIDMap = value;
                break;
            }
            case -1547306032: {
                this.DescendantFonts = value;
                break;
            }
            case 1232564598: {
                this.Encoding = value;
                break;
            }
            case -1044665361: {
                this.FontDescriptor = value;
                break;
            }
            case 746093177: {
                this.FontFile = value;
                break;
            }
            case 2021292334: {
                this.FontFile2 = value;
                break;
            }
            case 2021292335: {
                this.FontFile3 = value;
                break;
            }
            case 1919185554: {
                this.ToUnicode = value;
                break;
            }
            default: {
                super.setDictionary(id, value);
            }
        }
    }

    @Override
    public int setConstant(int pdfKeyType, int keyStart, int keyLength, byte[] raw) {
        int PDFvalue = -1;
        try {
            int id = PdfObject.getId(keyStart, keyLength, raw);
            switch (id) {
                case -1684566726: {
                    PDFvalue = -1684566726;
                    break;
                }
                case -1752352082: {
                    PDFvalue = -1752352082;
                    break;
                }
                case -1684566724: {
                    PDFvalue = -1684566724;
                    break;
                }
                case 320680256: {
                    PDFvalue = 320680256;
                    break;
                }
                case 1232564598: {
                    PDFvalue = 1232564598;
                    break;
                }
                case 2038913669: {
                    PDFvalue = 2038913669;
                    break;
                }
                case 2038913683: {
                    PDFvalue = 2038913683;
                    break;
                }
                case -1159739105: {
                    PDFvalue = 3;
                    break;
                }
                case -1511664170: {
                    PDFvalue = 0;
                    break;
                }
                case 1602998461: {
                    PDFvalue = 6;
                    break;
                }
                case 1230852645: {
                    PDFvalue = 1228944677;
                    break;
                }
                case -1595087640: {
                    PDFvalue = 1;
                    break;
                }
                case 1228944676: {
                    PDFvalue = 1228944676;
                    break;
                }
                case 1228944677: {
                    PDFvalue = 1228944677;
                    break;
                }
                case 1077224796: {
                    PDFvalue = 1228944677;
                    break;
                }
                case 1228944679: {
                    PDFvalue = 1228944679;
                    break;
                }
                case 1217103210: {
                    PDFvalue = 1217103210;
                    break;
                }
                case 1524428269: {
                    PDFvalue = 2;
                    break;
                }
                default: {
                    if (pdfKeyType == 1232564598) {
                        PDFvalue = CIDEncodings.getConstant(id);
                        break;
                    }
                    PDFvalue = super.setConstant(pdfKeyType, id);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        switch (pdfKeyType) {
            case 1537782955: {
                this.BaseEncoding = PDFvalue;
                break;
            }
            case 946823533: {
                this.CIDToGIDMapAsConstant = PDFvalue;
                break;
            }
            case 1232564598: {
                this.generalType = PDFvalue;
                break;
            }
            case 1919185554: {
                this.generalType = PDFvalue;
                break;
            }
            default: {
                super.setConstant(pdfKeyType, PDFvalue);
            }
        }
        return PDFvalue;
    }

    @Override
    public int getParameterConstant(int key) {
        switch (key) {
            case 1537782955: {
                if (this.Encoding != null && this.Encoding.isZapfDingbats) {
                    return 5;
                }
                if (this.Encoding != null && this.Encoding.isSymbol) {
                    return 4;
                }
                return this.BaseEncoding;
            }
            case 946823533: {
                return this.CIDToGIDMapAsConstant;
            }
        }
        int def = super.getParameterConstant(key);
        return def;
    }

    @Override
    public PdfArrayIterator getMixedArray(int id) {
        if (id == 1954328750) {
            return new PdfArrayIterator(this.Differences);
        }
        return super.getMixedArray(id);
    }

    @Override
    public byte[][] getByteArray(int id) {
        if (id == 1954328750) {
            return this.Differences;
        }
        return super.getByteArray(id);
    }

    @Override
    public double[] getDoubleArray(int id) {
        if (id == -2105119560) {
            return FontObject.deepCopy(this.FontMatrix);
        }
        return super.getDoubleArray(id);
    }

    @Override
    public void setDoubleArray(int id, double[] value) {
        if (id == -2105119560) {
            this.FontMatrix = value;
        } else {
            super.setDoubleArray(id, value);
        }
    }

    @Override
    public void setMixedArray(int id, byte[][] value) {
        if (id == 1954328750) {
            this.Differences = value;
        } else {
            super.setMixedArray(id, value);
        }
    }

    @Override
    public void setIntArray(int id, int[] value) {
        if (id == 1320706) {
            this.DW2 = value;
        } else {
            super.setIntArray(id, value);
        }
    }

    @Override
    public int[] getIntArray(int id) {
        if (id == 1320706) {
            return FontObject.deepCopy(this.DW2);
        }
        return super.getIntArray(id);
    }

    @Override
    public float[] getFloatArray(int id) {
        switch (id) {
            case 676429196: {
                return FontObject.deepCopy(this.FontBBox);
            }
            case 876896124: {
                return FontObject.deepCopy(this.Widths);
            }
        }
        return super.getFloatArray(id);
    }

    @Override
    public void setFloatArray(int id, float[] value) {
        switch (id) {
            case 676429196: {
                this.FontBBox = value;
                break;
            }
            case 876896124: {
                this.Widths = value;
                break;
            }
            default: {
                super.setFloatArray(id, value);
            }
        }
    }

    @Override
    public void setName(int id, byte[] value) {
        switch (id) {
            case 678461817: {
                this.rawBaseFont = value;
                int checksum = PdfDictionary.generateChecksum(0, value.length, value);
                this.isZapfDingbats = checksum == 1889256112 || checksum == 707859506;
                boolean bl = this.isSymbol = checksum == 1026712197;
                if (this.Encoding == null) break;
                this.Encoding.isZapfDingbats = this.isZapfDingbats;
                this.Encoding.isSymbol = this.isSymbol;
                break;
            }
            case 827223669: {
                this.rawCMapName = value;
                break;
            }
            case 879786873: {
                this.rawFontName = value;
                break;
            }
            case 2038281912: {
                this.rawFontStretch = value;
                break;
            }
            default: {
                super.setName(id, value);
            }
        }
    }

    @Override
    public void setTextStreamValue(int id, byte[] value) {
        switch (id) {
            case 1110863221: {
                this.rawCharSet = value;
                break;
            }
            case 1635480172: {
                this.rawOrdering = value;
                break;
            }
            case 1702459778: {
                this.rawRegistry = value;
                break;
            }
            default: {
                super.setTextStreamValue(id, value);
            }
        }
    }

    @Override
    public String getName(int id) {
        switch (id) {
            case 678461817: {
                if (this.BaseFont == null && this.rawBaseFont != null) {
                    this.BaseFont = new String(this.rawBaseFont);
                }
                return this.BaseFont;
            }
            case 827223669: {
                if (this.CMapName == null && this.rawCMapName != null) {
                    this.CMapName = new String(this.rawCMapName);
                }
                return this.CMapName;
            }
            case 879786873: {
                if (this.FontName == null && this.rawFontName != null) {
                    this.FontName = new String(this.rawFontName);
                }
                return this.FontName;
            }
            case 2038281912: {
                if (this.FontStretch == null && this.rawFontStretch != null) {
                    this.FontStretch = new String(this.rawFontStretch);
                }
                return this.FontStretch;
            }
        }
        return super.getName(id);
    }

    @Override
    public String getTextStreamValue(int id) {
        switch (id) {
            case 1110863221: {
                if (this.CharSet == null && this.rawCharSet != null) {
                    this.CharSet = new String(this.rawCharSet);
                }
                return this.CharSet;
            }
            case 1635480172: {
                if (this.Ordering == null && this.rawOrdering != null) {
                    this.Ordering = new String(this.rawOrdering);
                }
                return this.Ordering;
            }
            case 1702459778: {
                if (this.Registry == null && this.rawRegistry != null) {
                    this.Registry = new String(this.rawRegistry);
                }
                return this.Registry;
            }
        }
        return super.getTextStreamValue(id);
    }

    @Override
    public String getStringValue(int id, int mode) {
        byte[] data = null;
        switch (id) {
            case 678461817: {
                data = this.rawBaseFont;
                break;
            }
            case 827223669: {
                data = this.rawCMapName;
                break;
            }
            case 879786873: {
                data = this.rawFontName;
                break;
            }
            case 2038281912: {
                data = this.rawFontStretch;
            }
        }
        switch (mode) {
            case 0: {
                if (data != null) {
                    return new String(data);
                }
                return null;
            }
            case 1: {
                if (data != null) {
                    return new String(data);
                }
                return null;
            }
            case 2: {
                if (data != null) {
                    int len = data.length;
                    if (len > 6 && data[6] == 43) {
                        int length = len - 7;
                        byte[] newData = new byte[length];
                        System.arraycopy(data, 7, newData, 0, length);
                        return new String(newData);
                    }
                    if (len > 7 && data[len - 7] == 43) {
                        int length = len - 7;
                        byte[] newData = new byte[length];
                        System.arraycopy(data, 0, newData, 0, length);
                        return new String(newData);
                    }
                    return new String(data);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode)");
    }

    @Override
    public int getObjectType() {
        return 373243460;
    }

    @Override
    public boolean decompressStreamWhenRead() {
        return true;
    }

    @Override
    public Object[] getObjectArray(int id) {
        switch (id) {
            case 39: {
                return this.W;
            }
            case 9986: {
                return this.W2;
            }
        }
        return super.getObjectArray(id);
    }

    @Override
    public void setObjectArray(int id, Object[] objectValues) {
        switch (id) {
            case 39: {
                this.W = objectValues;
                break;
            }
            case 9986: {
                this.W2 = objectValues;
                break;
            }
            default: {
                super.setObjectArray(id, objectValues);
            }
        }
    }
}

