/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.FormTypes;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.xfa.XFAFormStream;
import org.jpedal.parser.FormFlattener;
import org.jpedal.parser.FormFlattenerXFA;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PrintStreamDecoder;
import org.jpedal.parser.XFAStreamDecoder;
import org.jpedal.parser.XFAStreamDecoderForPrinting;
import org.jpedal.utils.InputStreamUtils;
import org.jpedal.utils.LogWriter;

public class AcroRendererXFA
extends AcroRenderer {
    private final HashMap<String, Object> globalMap = new HashMap();

    @Override
    public PdfStreamDecoder getStreamDecoder(PdfObjectReader currentPdfFile, PdfLayerList layer, boolean isFirst) {
        if (this.isXFA() && this.useXFA()) {
            return new XFAStreamDecoder(currentPdfFile, layer, this);
        }
        return super.getStreamDecoder(currentPdfFile, layer, isFirst);
    }

    @Override
    public boolean showFormWarningMessage(int page) {
        return false;
    }

    @Override
    public int openFile(int pageCount, int insetW, int insetH, PdfPageData pageData, PdfObjectReader currentPdfFile, PdfObject acroObj) {
        super.openFile(pageCount, insetW, insetH, pageData, currentPdfFile, acroObj);
        if (this.isXFA() && this.useXFA()) {
            pageCount = this.getPageMapXFA().size();
        }
        return pageCount;
    }

    @Override
    void processXFAFields(PdfObject acroObj1, PdfObjectReader currentPdfFile1, PdfPageData pageData1) {
        this.resolveIndirectFieldList(true);
        if (this.fieldList != null) {
            int fieldCount;
            for (int fieldNum = fieldCount = this.fieldList.getTokenCount() - 1; fieldNum > -1; --fieldNum) {
                String objRef = this.fieldList.getNextValueAsString(true);
                if (objRef == null) continue;
                FormObject formObject = this.convertRefToFormObject(objRef, -1);
                this.globalMap.put("signature", formObject);
            }
        }
        this.fDecoder = new com.idrsolutions.pdf.acroforms.xfa.XFAFormStream(acroObj1, currentPdfFile1, this);
        if (this.fDecoder.isXFA()) {
            ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).updatePageData(pageData1);
            this.PDFformType = ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).getPDFFormType();
            this.pageCount = pageData1.getPageCount();
        } else {
            this.hasXFA = false;
            this.fDecoder = new FormStream();
            this.PDFformType = FormTypes.NON_XFA;
        }
    }

    @Override
    Map<String, String> createAndStoreFormComponents(PdfStreamDecoder current, List<FormObject> unsortedForms, List<FormObject> sortedForms, int page) {
        FormObject[] xfaFormList = null;
        if (this.hasXFA && this.useXFA) {
            xfaFormList = this.createXFADisplayComponentsForPage(page);
        }
        return super.createComponents(current, unsortedForms, sortedForms, page, xfaFormList);
    }

    private FormObject[] createXFADisplayComponentsForPage(int page) {
        FormObject[] xfaFormList = ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).createAppearanceString(page);
        this.Fforms = xfaFormList;
        if (!this.globalMap.isEmpty()) {
            for (int z = 0; z < this.Fforms.length; ++z) {
                int subType = this.Fforms[z].getNameAsConstant(5668);
                if (subType != 2308407) continue;
                FormObject xForm = this.Fforms[z];
                FormObject gForm = (FormObject)this.globalMap.get("signature");
                Rectangle rect = xForm.getBoundingRectangle();
                float[] floatCoords = new float[]{(float)rect.getX(), (float)rect.getY(), (float)(rect.getX() + rect.getWidth()), (float)(rect.getY() + rect.getHeight())};
                gForm.setFloatArray(573911876, floatCoords);
                gForm.setRef(xForm.getObjectRefAsString());
                gForm.setPageNumber(xForm.getPageNumber());
                gForm.setAppreancesUsed(true);
                this.Fforms[z] = gForm;
            }
        }
        return xfaFormList;
    }

    public HashMap<Integer, XFAPageContent> getPageMapXFA() {
        return ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).getPageMapXFA();
    }

    @Override
    public byte[] getXMLContentAsBytes(int key) {
        return this.fDecoder.getXFA(key);
    }

    private String getXMLContentAsBase64(int key) {
        byte[] data = this.getXMLContentAsBytes(key);
        try {
            return Base64.getEncoder().encodeToString(data);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception in reading XML data " + e);
            return "";
        }
    }

    private String getXMLTemplateAsBAse64() {
        byte[] data = ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).getAlteredTemplateBytes();
        try {
            return Base64.getEncoder().encodeToString(data);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception in handling script " + e);
            return "";
        }
    }

    @Override
    public void outputJavascriptXFA(String outputDir, String fileName) {
        this.outputJavascriptXFA(outputDir, fileName, true);
    }

    @Override
    public void outputJavascriptXFA(String outputDir, String fileName, boolean outputMenu) {
        String seperator = File.separator;
        File eventsDir = new File(outputDir + seperator + "js");
        File eventsFile = new File(outputDir + seperator + "form.html");
        try {
            if (!eventsDir.exists()) {
                eventsDir.mkdirs();
            }
            if (!eventsFile.exists()) {
                eventsFile.createNewFile();
            }
        }
        catch (IOException e) {
            LogWriter.writeLog(e);
        }
        try (PrintWriter writer = new PrintWriter(eventsFile);){
            String start = "<!DOCTYPE html>\n<html>\n<head>\n<title>" + fileName + "</title>\n<link rel=\"stylesheet\" href=\"js/FDFXFASTYLE.css\"/>\n<script type=\"text/javascript\" src=\"js/FDFXFAENCODING.js\"></script>\n<script type=\"text/javascript\" src=\"js/FDFXFAMIN.js\"></script>\n</head>\n";
            String toolBarStr = "<div id='FDFXFA_Menu'><a title='Go To FirstPage'onclick=\"app.execMenuItem('FirstPage')\">&#xF01C;</a><a title='Go To PrevPage'onclick=\"app.execMenuItem('PrevPage')\">&#xF01D;</a><label id='FDFXFA_PageLabel'><span>1</span></label><label id='FDFXFA_PageCount'>/ <span>1</span></label><a title='Go To NextPage'onclick=\"app.execMenuItem('NextPage')\">&#xF01E;</a><a title='Go To LastPage'onclick=\"app.execMenuItem('LastPage')\">&#xF01F;</a><a title='Save As Editable PDF'onclick=\"app.execMenuItem('SaveAs')\">&#xF01A;</a></div>";
            String end = "<body onload=\"app.parseDocument()\">\n<form id='FDFXFA_Form' method='post' action=''><textarea name='pdfdata' id='FDFXFA_Textarea'></textarea></form><div id=\"FDFXFA_FormType\">XFA</div><div id=\"FDFXFA_PDFName\">" + fileName + "</div>" + (outputMenu ? "<div id='FDFXFA_Menu'><a title='Go To FirstPage'onclick=\"app.execMenuItem('FirstPage')\">&#xF01C;</a><a title='Go To PrevPage'onclick=\"app.execMenuItem('PrevPage')\">&#xF01D;</a><label id='FDFXFA_PageLabel'><span>1</span></label><label id='FDFXFA_PageCount'>/ <span>1</span></label><a title='Go To NextPage'onclick=\"app.execMenuItem('NextPage')\">&#xF01E;</a><a title='Go To LastPage'onclick=\"app.execMenuItem('LastPage')\">&#xF01F;</a><a title='Save As Editable PDF'onclick=\"app.execMenuItem('SaveAs')\">&#xF01A;</a></div>" : "") + "<form id=\"mainXFAForm\"></form>\n<div style=\"display: none\">\n<div id=\"templateDump\">" + this.getXMLTemplateAsBAse64() + "</div>\n<div id=\"dataDump\">" + this.getXMLContentAsBase64(1130793076) + "</div>\n<div id=\"configDump\">" + this.getXMLContentAsBase64(1043741046) + "</div>\n<div id=\"localeSetDump\">" + this.getXMLContentAsBase64(1951819392) + "</div>\n</div>\n<div id=\"preRenderer\" style=\"display:invisible\" ></div>" + ("true".equalsIgnoreCase(System.getProperty("applyBranding")) ? '\n' + InputStreamUtils.readInputStreamToString(this.getClass().getResourceAsStream("/org/jpedal/render/output/formvu-branding.txt")) + '\n' : "") + "</body>\n</html>";
            writer.write(start + end);
            writer.close();
            writer.flush();
        }
        catch (IOException e) {
            LogWriter.writeLog(e);
        }
        String[] jsFiles = new String[]{"FDFXFASTYLE", "FDFXFAENCODING", "FDFXFAMIN"};
        String[] jsExt = new String[]{"css", "js", "js", "js", "js", "js"};
        for (int z = 0; z < jsFiles.length; ++z) {
            File dest = new File(outputDir + seperator + "js" + seperator + jsFiles[z] + '.' + jsExt[z]);
            try (InputStream inputStream = this.getClass().getResourceAsStream("/com/idrsolutions/pdf/acroforms/xfa/res/js/" + jsFiles[z] + '.' + jsExt[z]);
                 FileOutputStream outputStream = new FileOutputStream(dest);){
                ObjectStore.copy(inputStream, outputStream);
                continue;
            }
            catch (IOException ex) {
                LogWriter.writeLog(ex);
            }
        }
    }

    @Override
    public PrintStreamDecoder getStreamDecoderForPrinting(PdfObjectReader currentPdfFile, PdfLayerList pdfLayerList) {
        if (this.isXFA() && this.useXFA()) {
            return new XFAStreamDecoderForPrinting(currentPdfFile, pdfLayerList, this);
        }
        return super.getStreamDecoderForPrinting(currentPdfFile, pdfLayerList);
    }

    @Override
    public BufferedImage decode(PdfObject formObj, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        return XFAFormStream.decode(formObj, currentPdfFile, XObject2);
    }

    @Override
    public FormFlattener getFormFlattener() {
        return new FormFlattenerXFA();
    }
}

