/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

public class PdfData {
    public static final int HORIZONTAL_LEFT_TO_RIGHT = 0;
    public static final int HORIZONTAL_RIGHT_TO_LEFT = 1;
    public static final int VERTICAL_TOP_TO_BOTTOM = 2;
    public static final int VERTICAL_BOTTOM_TO_TOP = 3;
    private int pointer;
    private boolean widthIsEmbedded;
    public static final String marker = String.valueOf('\u0000');
    private int max = 2000;
    public String[] contents = new String[this.max];
    public int[] f_writingMode = new int[this.max];
    public int[] text_length = new int[this.max];
    public int[] f_end_font_size = new int[this.max];
    public float[] space_width = new float[this.max];
    public float[] f_x1 = new float[this.max];
    public String[] colorTag = new String[this.max];
    public float[] f_x2 = new float[this.max];
    public float[] f_y1 = new float[this.max];
    public float[] f_y2 = new float[this.max];
    private boolean isColorExtracted;

    public final int getRawTextElementCount() {
        return this.pointer;
    }

    public final void flushTextList() {
        this.pointer = 0;
        this.max = 2000;
        this.contents = new String[this.max];
        this.f_writingMode = new int[this.max];
        this.text_length = new int[this.max];
        this.f_end_font_size = new int[this.max];
        this.space_width = new float[this.max];
        this.f_x1 = new float[this.max];
        this.f_x2 = new float[this.max];
        this.f_y1 = new float[this.max];
        this.f_y2 = new float[this.max];
        this.colorTag = new String[this.max];
    }

    public final void addRawTextElement(int writingMode, String font_as_string, float current_space, int fontSize, float x1, float y1, float x2, float y2, StringBuffer processed_line, int current_text_length, String currentColorTag, boolean isXMLExtraction) {
        if (processed_line.length() > 0) {
            if (isXMLExtraction) {
                processed_line.insert(0, font_as_string);
                processed_line.append("</font>");
            }
            if (this.isColorExtracted) {
                processed_line.insert(0, currentColorTag);
                processed_line.append("</color>");
            }
            this.f_writingMode[this.pointer] = writingMode;
            this.text_length[this.pointer] = current_text_length;
            this.f_x1[this.pointer] = x1;
            this.colorTag[this.pointer] = currentColorTag;
            this.f_x2[this.pointer] = x2;
            this.f_y1[this.pointer] = y1;
            this.f_y2[this.pointer] = y2;
            this.contents[this.pointer] = processed_line.toString();
            this.f_end_font_size[this.pointer] = fontSize;
            this.space_width[this.pointer] = current_space * 1000.0f;
            ++this.pointer;
            if (this.pointer == this.max) {
                this.resizeArrays();
            }
        }
    }

    private void resizeArrays() {
        this.max = this.max < 5000 ? (this.max *= 5) : (this.max < 10000 ? (this.max *= 2) : (this.max += 1000));
        String[] temp_s = this.contents;
        this.contents = new String[this.max];
        System.arraycopy(temp_s, 0, this.contents, 0, this.pointer);
        int[] temp_i = this.f_writingMode;
        this.f_writingMode = new int[this.max];
        this.f_writingMode = new int[this.max];
        System.arraycopy(temp_i, 0, this.f_writingMode, 0, this.pointer);
        temp_s = this.colorTag;
        this.colorTag = new String[this.max];
        System.arraycopy(temp_s, 0, this.colorTag, 0, this.pointer);
        temp_i = this.text_length;
        this.text_length = new int[this.max];
        System.arraycopy(temp_i, 0, this.text_length, 0, this.pointer);
        temp_i = this.f_end_font_size;
        this.f_end_font_size = new int[this.max];
        System.arraycopy(temp_i, 0, this.f_end_font_size, 0, this.pointer);
        float[] temp_f = this.space_width;
        this.space_width = new float[this.max];
        System.arraycopy(temp_f, 0, this.space_width, 0, this.pointer);
        temp_f = this.f_x1;
        this.f_x1 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_x1, 0, this.pointer);
        temp_f = this.f_x2;
        this.f_x2 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_x2, 0, this.pointer);
        temp_f = this.f_y1;
        this.f_y1 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_y1, 0, this.pointer);
        temp_f = this.f_y2;
        this.f_y2 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_y2, 0, this.pointer);
    }

    public void widthIsEmbedded() {
        this.widthIsEmbedded = true;
    }

    public boolean IsEmbedded() {
        return this.widthIsEmbedded;
    }

    public void enableTextColorDataExtraction() {
        this.isColorExtracted = true;
    }

    public boolean isColorExtracted() {
        return this.isColorExtracted;
    }

    public void dispose() {
        this.contents = null;
        this.f_writingMode = null;
        this.text_length = null;
        this.f_end_font_size = null;
        this.space_width = null;
        this.f_x1 = null;
        this.colorTag = null;
        this.f_x2 = null;
        this.f_y1 = null;
        this.f_y2 = null;
    }
}

