/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.PdfClip;
import org.jpedal.objects.TextState;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;

public class GraphicsState {
    public float x;
    public float y;
    private TextState currentTextState = new TextState();
    private float strokeAlpha = 1.0f;
    private float nonstrokeAlpha = 1.0f;
    private float maxStrokeAlpha = 1.0f;
    private float maxNonstrokeAlpha = 1.0f;
    public final float[][] lastCTM = new float[3][3];
    private PdfObject TRobj;
    private byte[][] TR;
    public PdfObject SMask;
    public GenericColorSpace strokeColorSpace = new DeviceGrayColorSpace();
    public GenericColorSpace nonstrokeColorSpace = new DeviceGrayColorSpace();
    private boolean hasClipChanged;
    private boolean op;
    private boolean OP;
    private float OPM;
    private Area current_clipping_shape;
    private PdfClip current_clip;
    private static final boolean debugClip = false;
    public float[][] CTM = new float[3][3];
    public float[][] scaleFactor;
    private int current_line_dash_phase;
    private GeneralPath TRmask;
    private int fill_type;
    private int mitre_limit = 10;
    private float[] current_line_dash_array = new float[0];
    private int current_line_cap_style;
    private float current_line_width = 1.0f;
    private int current_line_join_style;
    private int text_render_type = 2;
    private int minX;
    private int minY;
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int FILLSTROKE = 3;
    public static final int INVISIBLE = 4;
    public static final int CLIPTEXT = 7;
    private int BMvalue = 1111314299;
    private Area area;

    public GraphicsState(GraphicsState gs) {
        this.resetCTM();
        this.BMvalue = gs.BMvalue;
    }

    public GraphicsState() {
        this.resetCTM();
    }

    public GraphicsState(int minX, int minY) {
        this.minX = -minX;
        this.minY = -minY;
        this.resetCTM();
    }

    public void setMaxAlpha(int type, float value) {
        switch (type) {
            case 1: {
                this.maxStrokeAlpha = value;
                break;
            }
            case 2: {
                this.maxNonstrokeAlpha = value;
            }
        }
    }

    private void setAlpha(int type, float value) {
        switch (type) {
            case 1: {
                if (value > this.maxStrokeAlpha) {
                    value = this.maxStrokeAlpha;
                }
                this.strokeAlpha = value;
                break;
            }
            case 2: {
                if (value > this.maxNonstrokeAlpha) {
                    value = this.maxNonstrokeAlpha;
                }
                this.nonstrokeAlpha = value;
            }
        }
    }

    public float getAlpha(int type) {
        float value = 1.0f;
        switch (type) {
            case 1: {
                value = Math.min(this.strokeAlpha, this.maxStrokeAlpha);
                break;
            }
            case 2: {
                value = Math.min(this.nonstrokeAlpha, this.maxNonstrokeAlpha);
            }
        }
        return value;
    }

    public float getAlphaMax(int type) {
        float value = 1.0f;
        switch (type) {
            case 1: {
                value = this.maxStrokeAlpha;
                break;
            }
            case 2: {
                value = this.maxNonstrokeAlpha;
            }
        }
        return value;
    }

    public float getOPM() {
        return this.OPM;
    }

    public Object[] getTR() {
        if (this.TRobj == null && this.TR == null) {
            return null;
        }
        return new Object[]{this.TRobj, this.TR};
    }

    public final void setTextRenderType(int text_render_type) {
        this.text_render_type = text_render_type;
        this.TRmask = null;
        this.area = null;
    }

    public final int getTextRenderType() {
        return this.text_render_type;
    }

    public final void setMitreLimit(int mitre_limit) {
        this.mitre_limit = mitre_limit;
    }

    public final int getMitreLimit() {
        return this.mitre_limit;
    }

    public final float getLineWidth() {
        return this.current_line_width;
    }

    public final void setFillType(int fill_type) {
        this.fill_type = fill_type;
    }

    public final void updateClip(Area current_area) {
        if (this.current_clipping_shape == null || current_area == null) {
            this.current_clipping_shape = current_area;
            this.hasClipChanged = true;
        } else {
            this.current_clipping_shape.intersect(current_area);
            this.hasClipChanged = true;
        }
    }

    public final void addClip(Area current_area) {
        if (this.TRmask == null) {
            this.TRmask = new GeneralPath();
            this.area = null;
        }
        this.TRmask.append(current_area, false);
    }

    public final Stroke getStroke() {
        BasicStroke current_stroke;
        int dashCount;
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        if ((dashCount = this.current_line_dash_array.length) > 0) {
            float[] dash = new float[dashCount];
            for (int aa = 0; aa < dashCount; ++aa) {
                dash[aa] = this.CTM[0][0] != 0.0f ? this.current_line_dash_array[aa] * this.CTM[0][0] : this.current_line_dash_array[aa] * this.CTM[0][1];
                if (!(dash[aa] < 0.0f)) continue;
                dash[aa] = -dash[aa];
            }
            current_stroke = new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit, dash, Math.abs(this.current_line_dash_phase));
        } else {
            current_stroke = new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit);
        }
        return current_stroke;
    }

    public float getCTMAdjustedLineWidth() {
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        return w;
    }

    public final void setLineWidth(float current_line_width) {
        this.current_line_width = current_line_width;
    }

    public final Area getClippingShape() {
        if (this.TRmask != null) {
            if (this.area == null) {
                this.area = new Area(this.TRmask);
            }
            return this.area;
        }
        return this.current_clipping_shape;
    }

    public void setMode(PdfObject GS) {
        PdfArrayIterator BM;
        boolean notMask;
        this.op = false;
        this.OP = false;
        if (GS == null) {
            return;
        }
        float LW = GS.getFloatNumber(7207);
        if (LW != -1.0f) {
            this.current_line_width = LW;
        }
        boolean AIS = GS.getBoolean(1120547);
        PdfObject temp = GS.getDictionary(489767774);
        if (temp != null) {
            this.SMask = temp;
        }
        boolean bl = notMask = this.SMask == null || AIS || this.SMask.getGeneralType(489767774) == 507461173;
        if (notMask) {
            float newCA = GS.getFloatNumber(4881);
            float newca = GS.getFloatNumber(13105);
            if (newCA != -1.0f) {
                this.setAlpha(1, newCA);
            }
            if (newca != -1.0f) {
                this.setAlpha(2, newca);
            }
        }
        this.OP = GS.getBoolean(7968);
        this.op = GS.getBoolean(16192);
        float newOPM = GS.getFloatNumber(2039837);
        this.OPM = newOPM != -1.0f ? newOPM : 0.0f;
        this.TRobj = GS.getDictionary(9250);
        this.TR = GS.getKeyArray(9250);
        if (this.TRobj != null || this.TR != null) {
            int count;
            boolean isIdentity = false;
            if (this.TRobj != null && this.TRobj.getGeneralType(9250) == 1567455623) {
                isIdentity = true;
            } else if (this.TR != null && (count = this.TR.length) > 0) {
                isIdentity = true;
                for (byte[] aMaskArray : this.TR) {
                    int nextID = PdfDictionary.getIntKey(1, aMaskArray.length - 1, aMaskArray);
                    if (nextID == 1567455623) continue;
                    isIdentity = false;
                    break;
                }
            }
            if (isIdentity) {
                this.TRobj = null;
                this.TR = null;
            }
        }
        if ((BM = GS.getMixedArray(4637)) != null && BM.hasMoreTokens()) {
            this.BMvalue = BM.getNextValueAsConstant(false);
        }
    }

    public final void setCapStyle(int cap_style) {
        this.current_line_cap_style = cap_style;
    }

    public final int getCapStyle() {
        return this.current_line_cap_style;
    }

    public final int setJoinStyle() {
        return this.current_line_join_style;
    }

    public final void setJoinStyle(int join_style) {
        this.current_line_join_style = join_style;
    }

    public final void checkWholePageClip(int max_y) {
        if (this.current_clipping_shape != null && this.current_clipping_shape.getBounds().getHeight() > (double)(max_y + 2) && this.current_clipping_shape.getBounds().y >= 0) {
            this.current_clipping_shape = null;
            this.hasClipChanged = true;
        }
    }

    public final void setDashArray(float[] current_line_dash_array) {
        this.current_line_dash_array = current_line_dash_array;
    }

    public final float[] getDashArray() {
        return this.current_line_dash_array;
    }

    public final GraphicsState deepCopy() {
        GraphicsState newGS = new GraphicsState();
        newGS.x = this.x;
        newGS.y = this.y;
        if (this.SMask != null) {
            newGS.SMask = this.SMask;
        }
        if (this.TR != null) {
            newGS.TR = this.TR;
        }
        if (this.TRobj != null) {
            newGS.TRobj = this.TRobj;
        }
        newGS.maxNonstrokeAlpha = this.maxNonstrokeAlpha;
        newGS.maxStrokeAlpha = this.maxStrokeAlpha;
        newGS.strokeAlpha = this.strokeAlpha;
        newGS.nonstrokeAlpha = this.nonstrokeAlpha;
        newGS.op = this.op;
        newGS.OP = this.OP;
        newGS.OPM = this.OPM;
        newGS.nonstrokeColorSpace = this.nonstrokeColorSpace;
        newGS.strokeColorSpace = this.strokeColorSpace;
        if (this.current_clipping_shape != null) {
            newGS.current_clipping_shape = (Area)this.current_clipping_shape.clone();
        }
        if (this.CTM != null) {
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(this.CTM[i], 0, newGS.CTM[i], 0, 3);
            }
        }
        newGS.hasClipChanged = this.hasClipChanged;
        newGS.current_line_dash_phase = this.current_line_dash_phase;
        if (this.TRmask != null) {
            newGS.TRmask = (GeneralPath)this.TRmask.clone();
        }
        newGS.fill_type = this.fill_type;
        newGS.mitre_limit = this.mitre_limit;
        if (this.current_line_dash_array != null) {
            int size = this.current_line_dash_array.length;
            newGS.current_line_dash_array = new float[size];
            System.arraycopy(this.current_line_dash_array, 0, newGS.current_line_dash_array, 0, size);
        }
        newGS.current_line_cap_style = this.current_line_cap_style;
        newGS.current_line_width = this.current_line_width;
        newGS.current_line_join_style = this.current_line_join_style;
        newGS.text_render_type = this.text_render_type;
        newGS.minX = this.minX;
        newGS.minY = this.minY;
        return newGS;
    }

    private void resetCTM() {
        this.CTM[0][0] = 1.0f;
        this.CTM[1][0] = 0.0f;
        this.CTM[2][0] = this.minX;
        this.CTM[0][1] = 0.0f;
        this.CTM[1][1] = 1.0f;
        this.CTM[2][1] = this.minY;
        this.CTM[0][2] = 0.0f;
        this.CTM[1][2] = 0.0f;
        this.CTM[2][2] = 1.0f;
    }

    public final void setDashPhase(int current_line_dash_phase) {
        this.current_line_dash_phase = current_line_dash_phase;
    }

    public final int getDashPhase() {
        return this.current_line_dash_phase;
    }

    public final int getFillType() {
        return this.fill_type;
    }

    public final void setClippingShape(Area new_clip) {
        this.current_clipping_shape = new_clip;
        this.hasClipChanged = true;
    }

    public PdfPaint getNonstrokeColor() {
        return this.nonstrokeColorSpace.getColor();
    }

    public PdfPaint getStrokeColor() {
        return this.strokeColorSpace.getColor();
    }

    public void setTextState(TextState currentTextState) {
        this.currentTextState = currentTextState;
    }

    public TextState getTextState() {
        return this.currentTextState;
    }

    public Object getFXClippingShape() {
        if (this.current_clip == null) {
            return null;
        }
        return this.current_clip.getClippingShape();
    }

    public int getBMValue() {
        return this.BMvalue;
    }

    public void setBMValue(int bm) {
        this.BMvalue = bm;
    }

    public void resetColorSpaces(int strokeColorData, int nonStrokeColorData) {
        if (this.strokeColorSpace.getID() != 1146450818) {
            this.strokeColorSpace.invalidateCaching(strokeColorData);
            this.strokeColorSpace.setColor(new PdfColor(strokeColorData));
        }
        if (this.nonstrokeColorSpace.getID() != 1146450818) {
            this.nonstrokeColorSpace.invalidateCaching(nonStrokeColorData);
            this.nonstrokeColorSpace.setColor(new PdfColor(nonStrokeColorData));
        }
    }
}

