/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.decoders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jpedal.jbig2.JBIG2Data;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.io.StreamReader;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.SegmentHeader;
import org.jpedal.jbig2.segment.extensions.ExtensionSegment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.pattern.PatternDictionarySegment;
import org.jpedal.jbig2.segment.region.generic.GenericRegionSegment;
import org.jpedal.jbig2.segment.region.halftone.HalftoneRegionSegment;
import org.jpedal.jbig2.segment.region.refinement.RefinementRegionSegment;
import org.jpedal.jbig2.segment.region.text.TextRegionSegment;
import org.jpedal.jbig2.segment.stripes.EndOfStripeSegment;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionarySegment;
import org.jpedal.jbig2.segment.tables.CodeTableSegment;
import org.jpedal.jbig2.util.BinaryOperation;

public class JBIG2StreamDecoder {
    private StreamReader reader;
    private boolean randomAccessOrganisation;
    private final ArrayList<Segment> segments = new ArrayList();
    private final ArrayList<JBIG2Bitmap> bitmaps = new ArrayList();
    private JBIG2Data globalData;
    private ArithmeticDecoder arithmeticDecoder;
    private HuffmanDecoder huffmanDecoder;
    private MMRDecoder mmrDecoder;
    public static final boolean debug = false;

    public void movePointer(int i) {
        this.reader.movePointer(i);
    }

    public void setGlobalData(byte[] data) {
        this.globalData = new JBIG2Data(data);
    }

    public void decodeJBIG2(JBIG2Data jBIG2Data) throws IOException, JBIG2Exception {
        this.reader = new StreamReader(jBIG2Data);
        this.resetDecoder();
        boolean validFile = this.checkHeader();
        if (!validFile) {
            this.randomAccessOrganisation = false;
            if (this.globalData != null) {
                this.reader = new StreamReader(this.globalData);
                this.huffmanDecoder = new HuffmanDecoder(this.reader);
                this.mmrDecoder = new MMRDecoder(this.reader);
                this.arithmeticDecoder = new ArithmeticDecoder(this.reader);
                this.readSegments();
                this.reader = new StreamReader(jBIG2Data);
            } else {
                this.reader.movePointer(-8);
            }
        } else {
            this.setFileHeaderFlags();
        }
        this.huffmanDecoder = new HuffmanDecoder(this.reader);
        this.mmrDecoder = new MMRDecoder(this.reader);
        this.arithmeticDecoder = new ArithmeticDecoder(this.reader);
        this.readSegments();
    }

    public HuffmanDecoder getHuffmanDecoder() {
        return this.huffmanDecoder;
    }

    public MMRDecoder getMMRDecoder() {
        return this.mmrDecoder;
    }

    public ArithmeticDecoder getArithmeticDecoder() {
        return this.arithmeticDecoder;
    }

    private void resetDecoder() {
        this.randomAccessOrganisation = false;
        this.segments.clear();
        this.bitmaps.clear();
    }

    private void readSegments() throws IOException, JBIG2Exception {
        boolean finished = false;
        block23: while (this.reader.bytesRemaining() && !finished) {
            SegmentHeader segmentHeader = new SegmentHeader();
            this.readSegmentHeader(segmentHeader);
            Segment segment = null;
            int segmentType = segmentHeader.getSegmentType();
            int[] referredToSegments = segmentHeader.getReferredToSegments();
            int noOfReferredToSegments = segmentHeader.getReferredToSegmentCount();
            switch (segmentType) {
                case 0: {
                    segment = new SymbolDictionarySegment(this);
                    break;
                }
                case 4: {
                    segment = new TextRegionSegment(this, false);
                    break;
                }
                case 6: {
                    segment = new TextRegionSegment(this, true);
                    break;
                }
                case 7: {
                    segment = new TextRegionSegment(this, true);
                    break;
                }
                case 16: {
                    segment = new PatternDictionarySegment(this);
                    break;
                }
                case 20: {
                    segment = new HalftoneRegionSegment(this, false);
                    break;
                }
                case 22: {
                    segment = new HalftoneRegionSegment(this, true);
                    break;
                }
                case 23: {
                    segment = new HalftoneRegionSegment(this, true);
                    break;
                }
                case 36: {
                    segment = new GenericRegionSegment(this, false);
                    break;
                }
                case 38: {
                    segment = new GenericRegionSegment(this, true);
                    break;
                }
                case 39: {
                    segment = new GenericRegionSegment(this, true);
                    break;
                }
                case 40: {
                    segment = new RefinementRegionSegment(this, false, referredToSegments, noOfReferredToSegments);
                    break;
                }
                case 42: {
                    segment = new RefinementRegionSegment(this, true, referredToSegments, noOfReferredToSegments);
                    break;
                }
                case 43: {
                    segment = new RefinementRegionSegment(this, true, referredToSegments, noOfReferredToSegments);
                    break;
                }
                case 48: {
                    segment = new PageInformationSegment(this);
                    break;
                }
                case 49: {
                    continue block23;
                }
                case 50: {
                    segment = new EndOfStripeSegment(this);
                    break;
                }
                case 51: {
                    finished = true;
                    continue block23;
                }
                case 52: {
                    break;
                }
                case 53: {
                    segment = new CodeTableSegment(this);
                    break;
                }
                case 62: {
                    segment = new ExtensionSegment(this);
                    break;
                }
                default: {
                    System.out.println("Unknown Segment type in JBIG2 stream");
                }
            }
            if (segment != null) {
                segment.setSegmentHeader(segmentHeader);
                if (!this.randomAccessOrganisation) {
                    segment.readSegment();
                }
            }
            this.segments.add(segment);
        }
        if (this.randomAccessOrganisation) {
            for (Segment segment : this.segments) {
                segment.readSegment();
            }
        }
    }

    public PageInformationSegment findPageSegment(int page) {
        for (Segment segment : this.segments) {
            SegmentHeader segmentHeader = segment.getSegmentHeader();
            if (segmentHeader.getSegmentType() != 48 || segmentHeader.getPageAssociation() != page) continue;
            return (PageInformationSegment)segment;
        }
        return null;
    }

    public Segment findSegment(int segmentNumber) {
        for (Segment segment : this.segments) {
            if (segment.getSegmentHeader().getSegmentNumber() != segmentNumber) continue;
            return segment;
        }
        return null;
    }

    private void readSegmentHeader(SegmentHeader segmentHeader) throws JBIG2Exception {
        this.handleSegmentNumber(segmentHeader);
        this.handleSegmentHeaderFlags(segmentHeader);
        this.handleSegmentReferredToCountAndRetentionFlags(segmentHeader);
        this.handleReferredToSegmentNumbers(segmentHeader);
        this.handlePageAssociation(segmentHeader);
        if (segmentHeader.getSegmentType() != 51) {
            this.handleSegmentDataLength(segmentHeader);
        }
    }

    private void handlePageAssociation(SegmentHeader segmentHeader) {
        int pageAssociation;
        boolean isPageAssociationSizeSet = segmentHeader.isPageAssociationSizeSet();
        if (isPageAssociationSizeSet) {
            short[] buf = new short[4];
            this.reader.readByte(buf);
            pageAssociation = BinaryOperation.getInt32(buf);
        } else {
            pageAssociation = this.reader.readByte();
        }
        segmentHeader.setPageAssociation(pageAssociation);
    }

    private void handleSegmentNumber(SegmentHeader segmentHeader) {
        short[] segmentBytes = new short[4];
        this.reader.readByte(segmentBytes);
        int segmentNumber = BinaryOperation.getInt32(segmentBytes);
        segmentHeader.setSegmentNumber(segmentNumber);
    }

    private void handleSegmentHeaderFlags(SegmentHeader segmentHeader) {
        short segmentHeaderFlags = this.reader.readByte();
        segmentHeader.setSegmentHeaderFlags(segmentHeaderFlags);
    }

    private void handleSegmentReferredToCountAndRetentionFlags(SegmentHeader segmentHeader) throws JBIG2Exception {
        short referredToSegmentCountAndRetentionFlags = this.reader.readByte();
        int referredToSegmentCount = (referredToSegmentCountAndRetentionFlags & 0xE0) >> 5;
        short firstByte = (short)(referredToSegmentCountAndRetentionFlags & 0x1F);
        if (referredToSegmentCount <= 4) {
            short[] retentionFlags = new short[]{firstByte};
        } else if (referredToSegmentCount == 7) {
            short[] longFormCountAndFlags = new short[4];
            longFormCountAndFlags[0] = firstByte;
            for (int i = 1; i < 4; ++i) {
                longFormCountAndFlags[i] = this.reader.readByte();
            }
            referredToSegmentCount = BinaryOperation.getInt32(longFormCountAndFlags);
            int noOfBytesInField = (int)Math.ceil(4.0 + (double)(referredToSegmentCount + 1) / 8.0);
            int noOfRetentionFlagBytes = noOfBytesInField - 4;
            short[] retentionFlags = new short[noOfRetentionFlagBytes];
            this.reader.readByte(retentionFlags);
        } else {
            throw new JBIG2Exception("Error, 3 bit Segment count field = " + referredToSegmentCount);
        }
        segmentHeader.setReferredToSegmentCount(referredToSegmentCount);
    }

    private void handleReferredToSegmentNumbers(SegmentHeader segmentHeader) {
        int referredToSegmentCount = segmentHeader.getReferredToSegmentCount();
        int[] referredToSegments = new int[referredToSegmentCount];
        int segmentNumber = segmentHeader.getSegmentNumber();
        if (segmentNumber <= 256) {
            for (int i = 0; i < referredToSegmentCount; ++i) {
                referredToSegments[i] = this.reader.readByte();
            }
        } else if (segmentNumber <= 65536) {
            short[] buf = new short[2];
            for (int i = 0; i < referredToSegmentCount; ++i) {
                this.reader.readByte(buf);
                referredToSegments[i] = BinaryOperation.getInt16(buf);
            }
        } else {
            short[] buf = new short[4];
            for (int i = 0; i < referredToSegmentCount; ++i) {
                this.reader.readByte(buf);
                referredToSegments[i] = BinaryOperation.getInt32(buf);
            }
        }
        segmentHeader.setReferredToSegments(referredToSegments);
    }

    private void handleSegmentDataLength(SegmentHeader segmentHeader) {
        short[] buf = new short[4];
        this.reader.readByte(buf);
        int dataLength = BinaryOperation.getInt32(buf);
        segmentHeader.setDataLength(dataLength);
    }

    private void setFileHeaderFlags() {
        int fileOrganisation;
        short headerFlags = this.reader.readByte();
        if ((headerFlags & 0xFC) != 0) {
            System.out.println("Warning, reserved bits (2-7) of file header flags are not zero " + headerFlags);
        }
        this.randomAccessOrganisation = (fileOrganisation = headerFlags & 1) == 0;
    }

    private boolean checkHeader() {
        short[] controlHeader = new short[]{151, 74, 66, 50, 13, 10, 26, 10};
        short[] actualHeader = new short[8];
        this.reader.readByte(actualHeader);
        return Arrays.equals(controlHeader, actualHeader);
    }

    public int readBits(int num) {
        return this.reader.readBits(num);
    }

    public int readBit() {
        return this.reader.readBit();
    }

    public void readByte(short[] buff) {
        this.reader.readByte(buff);
    }

    public void consumeRemainingBits() {
        this.reader.consumeRemainingBits();
    }

    public short readByte() {
        return this.reader.readByte();
    }

    public void appendBitmap(JBIG2Bitmap bitmap) {
        this.bitmaps.add(bitmap);
    }

    public JBIG2Bitmap findBitmap(int bitmapNumber) {
        for (JBIG2Bitmap bitmap : this.bitmaps) {
            if (bitmap.getBitmapNumber() != bitmapNumber) continue;
            return bitmap;
        }
        return null;
    }
}

