/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class StringValue {
    public static int setStringConstantValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        i = raw[i = StreamReaderUtils.skipSpaces(raw, i)] == 60 && raw[i + 1] == 60 ? StringValue.writeConstantInDirectObject(pdfObject, i, raw, PDFkeyInt, objectReader) : (raw[i] >= 48 && raw[i] <= 57 && StringValue.writeConstantInObject(i, raw) ? StringValue.readFromIndirectObj(PDFkeyInt, pdfObject, i, raw, objectReader, raw.length, PDFkeyInt) : StringValue.writeConstant(pdfObject, i, raw, PDFkeyInt));
        return i - 1;
    }

    private static boolean writeConstantInObject(int i, byte[] raw) {
        int aa = StreamReaderUtils.skipToEndOfRef(raw, i);
        return (aa = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, aa, 47)) < raw.length && raw[aa] == 82;
    }

    private static int writeConstantInDirectObject(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        PdfObject childObject = new PdfObject(pdfObject.getObjectRefAsString());
        i = Dictionary.readDictionary(childObject, i, raw, PDFkeyInt, objectReader);
        return i;
    }

    private static int writeConstant(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt) {
        int keyStart = i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i + 1, 47);
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
            ++i;
        }
        pdfObject.setConstant(PDFkeyInt, keyStart, i - keyStart, raw);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Set constant in " + pdfObject + " to " + pdfObject.setConstant(PDFkeyInt, keyStart, i - keyStart, raw));
        }
        return i;
    }

    private static int readFromIndirectObj(int PDFkeyInt, PdfObject pdfObject, int i, byte[] raw, PdfFileReader objectReader, int rawLength, int number) {
        int keyStart = i = StreamReaderUtils.skipSpaces(raw, i);
        i = StreamReaderUtils.skipToEndOfRef(raw, i);
        int generation = NumberUtils.parseInt(keyStart, i, raw);
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
            ++i;
        }
        if (raw[i] != 82) {
            throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
        }
        byte[] data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
        if (data == null) {
            pdfObject.setFullyResolved(false);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Data not yet loaded");
            }
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
            return rawLength;
        }
        int[] pos = NumberValue.extractDataFromIndirectRef(data);
        i = StringValue.writeConstant(pdfObject, pos[0], raw, PDFkeyInt);
        return i - 1;
    }

    public static int setStringKeyValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt) {
        int keyStart = i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i + 1, 47);
        boolean isNull = false;
        while (raw[i] != 82 && !isNull) {
            if (PDFkeyInt == 1110793845 && StreamReaderUtils.isNull(raw, i)) {
                isNull = true;
            }
            ++i;
        }
        if (!isNull) {
            StringValue.setValue(pdfObject, 1 + i - keyStart, raw, PDFkeyInt, keyStart);
        }
        return i - 1;
    }

    private static void setValue(PdfObject pdfObject, int keyLength, byte[] raw, int PDFkeyInt, int keyStart) {
        byte[] stringBytes = new byte[keyLength];
        System.arraycopy(raw, keyStart, stringBytes, 0, keyLength);
        pdfObject.setStringKey(PDFkeyInt, stringBytes);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Set constant in " + pdfObject + " to " + new String(stringBytes));
        }
    }
}

