/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.Offsets;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

class BrokenRefTable {
    BrokenRefTable() {
    }

    public static Object[] readCatalogObjects(RandomAccessBuffer pdf_datafile, Offsets offset, PdfFileReader currentPdfFile, byte[] ID2) {
        LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
        PageObject root = null;
        PdfObject encrypt = null;
        PdfObject info = null;
        boolean hasEncryption = false;
        long rootPtr = 0L;
        String line = null;
        int i = 0;
        try {
            pdf_datafile.seek(0L);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading line");
        }
        while (true) {
            try {
                i = (int)pdf_datafile.getFilePointer();
                line = pdf_datafile.readLine();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading line");
            }
            if (line == null) break;
            if (line.contains(" obj")) {
                int pointer = line.indexOf(32);
                try {
                    if (pointer > 0) {
                        offset.storeObjectOffset(Integer.parseInt(line.substring(0, pointer)), i, 1, false, true);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("[PDF] Exception " + e + " Unable to manually read line " + line);
                }
            }
            if (line.contains("/Root")) {
                root = new PageObject(BrokenRefTable.readID(line, pdf_datafile));
                rootPtr = i;
            }
            if (!line.contains("/Encrypt")) continue;
            hasEncryption = true;
        }
        if (hasEncryption) {
            try {
                pdf_datafile.seek(rootPtr);
            }
            catch (IOException ex) {
                LogWriter.writeLog("[PDF] Exception " + ex + " Unable to manually read Encryption object");
            }
            byte[] rootDictBytes = currentPdfFile.getObjectReader().readObjectData(-1, null);
            if (rootDictBytes != null) {
                byte[][] IDs;
                CompressedObject pdfObject = new CompressedObject("0 0 R");
                Dictionary.readDictionary(pdfObject, 0, rootDictBytes, -1, currentPdfFile);
                encrypt = ((PdfObject)pdfObject).getDictionary(1113489015);
                if (encrypt != null && (IDs = ((PdfObject)pdfObject).getStringArray(6420)) != null && ID2 == null) {
                    ID2 = IDs[0];
                }
                info = ((PdfObject)pdfObject).getDictionary(423507519);
            }
        }
        return new Object[]{root, encrypt, info, ID2};
    }

    private static String readID(String line, RandomAccessBuffer pdf_datafile) {
        int start = line.indexOf("/Root") + 5;
        int pointer = line.indexOf(82, start);
        while (pointer == -1) {
            start = 0;
            try {
                line = pdf_datafile.readLine();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading line");
            }
            pointer = line.indexOf(82, start);
        }
        return line.substring(start, pointer + 1).trim();
    }
}

