/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PathSerializer {
    public static void serializePath(ObjectOutput os, PathIterator pi) throws IOException {
        os.writeObject(pi.getWindingRule());
        ArrayList<Object> list = new ArrayList<Object>();
        while (!pi.isDone()) {
            float[] array = new float[6];
            int type = pi.currentSegment(array);
            list.add(type);
            list.add(array);
            pi.next();
        }
        os.writeObject(list);
    }

    public static GeneralPath deserializePath(ObjectInput os) throws ClassNotFoundException, IOException {
        Integer windingRule = (Integer)os.readObject();
        if (windingRule == null) {
            return null;
        }
        List list = (List)os.readObject();
        GeneralPath path = new GeneralPath();
        path.setWindingRule(windingRule);
        Iterator iter = list.iterator();
        block7: while (iter.hasNext()) {
            float[] pathType = (float[])iter.next();
            float[] array = (float[])iter.next();
            switch ((int)pathType[0]) {
                case 1: {
                    path.lineTo(array[0], array[1]);
                    continue block7;
                }
                case 0: {
                    path.moveTo(array[0], array[1]);
                    continue block7;
                }
                case 2: {
                    path.quadTo(array[0], array[1], array[2], array[3]);
                    continue block7;
                }
                case 3: {
                    path.curveTo(array[0], array[1], array[2], array[3], array[4], array[5]);
                    continue block7;
                }
                case 4: {
                    path.closePath();
                    continue block7;
                }
            }
            System.out.println("unrecognized general path type");
        }
        return path;
    }
}

