/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.Serializable;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.BooleanArray;
import org.jpedal.io.types.BooleanValue;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.DoubleArray;
import org.jpedal.io.types.FloatArray;
import org.jpedal.io.types.FloatValue;
import org.jpedal.io.types.Form;
import org.jpedal.io.types.General;
import org.jpedal.io.types.IntArray;
import org.jpedal.io.types.KeyArray;
import org.jpedal.io.types.Name;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.ObjectArray;
import org.jpedal.io.types.Stream;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.StringArray;
import org.jpedal.io.types.StringValue;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ObjectDecoder
implements Serializable {
    protected PdfFileReader objectReader;
    protected DecryptionFactory decryption;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static boolean debugFastCode;
    public static String padding;
    boolean isInlineImage;
    private int endPt = -1;

    public ObjectDecoder(PdfFileReader pdfFileReader) {
        this.init(pdfFileReader);
    }

    private void init(PdfFileReader objectReader) {
        this.objectReader = objectReader;
        this.decryption = objectReader.getDecryptionObject();
    }

    public final int readDictionaryAsObject(PdfObject pdfObject, int i, byte[] raw) {
        int len;
        if (this.endPt == -1) {
            this.endPt = raw.length;
        }
        if (debugFastCode) {
            padding = padding + "   ";
        }
        if (debugFastCode) {
            ObjectUtils.showData(pdfObject, i, raw, padding);
        }
        i = this.readObjectDataValues(pdfObject, i, raw);
        if (!pdfObject.ignoreStream() && pdfObject.getGeneralType(-1) != 6420) {
            Stream.readStreamData(pdfObject, i, raw, raw.length, this.objectReader);
        }
        if (pdfObject.getObjectType() == 373244477) {
            Form.setFieldNames(pdfObject, this.objectReader);
        }
        if (debugFastCode && (len = padding.length()) > 3) {
            padding = padding.substring(0, len - 3);
        }
        return i;
    }

    private int readObjectDataValues(PdfObject pdfObject, int i, byte[] raw) {
        int length = raw.length;
        int level = 0;
        if (this.isInlineImage) {
            level = 1;
        }
        while (true) {
            if (i < length && raw[i] == 37) {
                i = StreamReaderUtils.skipComment(raw, i);
            }
            if (i >= length || this.endPt != -1 && i >= this.endPt || raw[i] == 101 && raw[i + 1] == 110 && raw[i + 2] == 100 && raw[i + 3] == 111 || raw[i] == 115 && raw[i + 1] == 116 && raw[i + 2] == 114 && raw[i + 3] == 101 && raw[i + 4] == 97 && raw[i + 5] == 109) break;
            if (raw[i] == 60 && raw[i + 1] == 60) {
                ++i;
                ++level;
            } else if (raw[i] == 62 && i + 1 != length && raw[i + 1] == 62) {
                ++i;
                if (--level == 0) {
                    break;
                }
            } else if (raw[i] == 47 && raw[++i] != 47 && raw[i] != 32) {
                i = this.getKey(i, raw, length, pdfObject);
            }
            ++i;
        }
        return i;
    }

    private int getKey(int i, byte[] raw, int length, PdfObject pdfObject) {
        int keyStart = i;
        int keyLength = StreamReaderUtils.findDictionaryEnd(i, raw, length);
        i += keyLength;
        int type = pdfObject.getObjectType();
        if (debugFastCode) {
            System.out.println("type=" + type + ' ' + ' ' + pdfObject.getID() + " chars=" + (char)raw[i - 1] + (char)raw[i] + (char)raw[i + 1] + ' ' + pdfObject + " i=" + i);
        }
        int PDFkeyInt = PdfDictionary.getIntKey(keyStart, keyLength, raw);
        if (this.isInlineImage) {
            PDFkeyInt = PdfObjectFactory.getInlineID(PDFkeyInt);
        }
        int pdfKeyType = PdfDictionary.getKeyType(PDFkeyInt, type);
        if (raw[i] == 47 || raw[i] == 40 || raw[i] == 91 && raw[i + 1] != 93) {
            --i;
        }
        if (pdfKeyType == -1) {
            i = ObjectUtils.handleUnknownType(i, raw, length);
        }
        if (PDFkeyInt == -1 || pdfKeyType == -1) {
            if (debugFastCode) {
                System.out.println(padding + pdfObject.getObjectRefAsString() + " =================Not implemented=" + PdfDictionary.getKey(keyStart, keyLength, raw) + " pdfKeyType=" + pdfKeyType);
            }
        } else {
            if (debugFastCode) {
                System.out.println(padding + pdfObject.getObjectRefAsString() + " =================Reading value for key=" + PdfDictionary.getKey(keyStart, keyLength, raw) + " (" + PDFkeyInt + ") type=" + PdfDictionary.showAsConstant(pdfKeyType) + ' ' + pdfObject);
            }
            i = this.setValue(pdfObject, i, raw, PDFkeyInt, pdfKeyType);
        }
        return i;
    }

    private int setValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, int pdfKeyType) {
        if (pdfKeyType == 5 && pdfObject.isDataExternal()) {
            pdfKeyType = 1;
        }
        switch (pdfKeyType) {
            case 25: {
                i = TextStream.setTextStreamValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 35: {
                i = Name.setNameTreeValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 2: {
                i = Dictionary.setDictionaryValue(pdfObject, i, raw, this.objectReader, PDFkeyInt, true);
                break;
            }
            case 20: {
                StringArray objDecoder = new StringArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 12: {
                BooleanArray objDecoder = new BooleanArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 14: {
                KeyArray objDecoder = new KeyArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 18: {
                Array objDecoder = new Array(this.objectReader, i, 18, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 22: {
                ObjectArray objDecoder = new ObjectArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 16: {
                DoubleArray objDecoder = new DoubleArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 9: {
                IntArray objDecoder = new IntArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 10: {
                FloatArray objDecoder = new FloatArray(this.objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 30: {
                i = Name.setNameStringValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 8: {
                i = BooleanValue.set(pdfObject, i, raw, PDFkeyInt);
                break;
            }
            case 3: {
                i = StringValue.setStringConstantValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 4: {
                i = StringValue.setStringKeyValue(pdfObject, i, raw, PDFkeyInt);
                break;
            }
            case 6: {
                i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 47);
                i = NumberValue.setNumberValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 7: {
                i = FloatValue.setFloatValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 5: {
                i = Dictionary.setUnreadDictionaryValue(pdfObject, i, raw, PDFkeyInt, this.isInlineImage);
                break;
            }
            case 40: {
                if (raw.length - 5 > 0 && StreamReaderUtils.isNull(raw, i + 1)) {
                    i += 5;
                    break;
                }
                i = ObjectDecoder.setVariousValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 1: {
                i = Dictionary.setDictionaryValue(pdfObject, i, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 45: {
                i = Dictionary.setDictionaryValue(pdfObject, i, raw, this.objectReader, PDFkeyInt, false);
            }
        }
        return i;
    }

    private static int setVariousValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (raw[i] != 60) {
            ++i;
        }
        if (debugFastCode) {
            System.out.println(padding + "Various value (first char=" + (char)raw[i] + (char)raw[i + 1] + " )");
        }
        if (raw[i] == 47) {
            i = Name.setNameStringValue(pdfObject, i, raw, PDFkeyInt, objectReader);
        } else if (raw[i] == 102 && raw[i + 1] == 97 && raw[i + 2] == 108 && raw[i + 3] == 115 && raw[i + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
            i += 4;
        } else if (raw[i] == 116 && raw[i + 1] == 114 && raw[i + 2] == 117 && raw[i + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
            i += 3;
        } else {
            i = raw[i] == 40 || raw[i] == 60 && raw[i - 1] != 60 && raw[i + 1] != 60 ? TextStream.readTextStream(pdfObject, i, raw, PDFkeyInt, objectReader) : (raw[i] == 91 ? ObjectDecoder.setArray(pdfObject, i, raw, PDFkeyInt, objectReader) : (raw[i] == 60 && raw[i + 1] == 60 ? Dictionary.readDictionary(pdfObject, i, raw, PDFkeyInt, objectReader) : General.readGeneral(pdfObject, i, raw, PDFkeyInt, objectReader)));
        }
        return i;
    }

    private static int setArray(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        switch (PDFkeyInt) {
            case 20: 
            case 27: 
            case 2627089: 
            case 2037870513: {
                Array objDecoder = new Array(objectReader, i, 18, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 489767739: {
                IntArray objDecoder = new IntArray(objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 19: 
            case 6419: {
                FloatArray objDecoder = new FloatArray(objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 9250: 
            case 521344835: {
                KeyArray objDecoder = new KeyArray(objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 1888135062: {
                ObjectArray objDecoder = new ObjectArray(objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            default: {
                StringArray objDecoder = new StringArray(objectReader, i, raw);
                i = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
        }
        return i;
    }

    public static synchronized boolean resolveFully(PdfObject pdfObject, PdfFileReader objectReader) {
        boolean fullyResolved;
        boolean bl = fullyResolved = pdfObject != null;
        if (fullyResolved) {
            byte[] raw = pdfObject.getStatus() == 0 ? StringUtils.toBytes(pdfObject.getObjectRefAsString()) : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (raw[0] != 101 && raw[1] != 110 && raw[2] != 100 && raw[3] != 111 && raw[4] != 98) {
                int j;
                int keyStart = j = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, 0, 91);
                j = StreamReaderUtils.skipToEndOfRef(raw, j);
                int ref = NumberUtils.parseInt(keyStart, j, raw);
                keyStart = j = StreamReaderUtils.skipSpaces(raw, j);
                j = StreamReaderUtils.skipToEndOfRef(raw, j);
                int generation = NumberUtils.parseInt(keyStart, j, raw);
                if (raw[raw.length - 1] == 82) {
                    fullyResolved = ObjectDecoder.resolveFullyChildren(pdfObject, raw, ref, generation, objectReader);
                }
                if (fullyResolved) {
                    pdfObject.ignoreRecursion(false);
                    ObjectDecoder objDecoder = new ObjectDecoder(objectReader);
                    objDecoder.readDictionaryAsObject(pdfObject, j, raw);
                }
            }
        }
        return fullyResolved;
    }

    private static boolean resolveFullyChildren(PdfObject pdfObject, byte[] raw, int ref, int generation, PdfFileReader objectReader) {
        boolean fullyResolved = true;
        pdfObject.setRef(new String(raw));
        pdfObject.isDataExternal(true);
        byte[] pageData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
        if (pageData == null) {
            pdfObject.setFullyResolved(false);
            fullyResolved = false;
        } else {
            pdfObject.setStatus(2);
            pdfObject.setUnresolvedData(pageData, 2004845231);
            pdfObject.isDataExternal(true);
            if (!ObjectDecoder.resolveFully(pdfObject, objectReader)) {
                pdfObject.setFullyResolved(false);
            }
        }
        return fullyResolved;
    }

    public final void checkResolved(PdfObject pdfObject) {
        if (pdfObject != null && pdfObject.getStatus() != 0) {
            byte[] raw = pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (!(raw[0] == 101 && raw[1] == 110 && raw[2] == 100 && raw[3] == 111 && raw[4] == 98 || StreamReaderUtils.isNull(raw, 0))) {
                String objectRef = pdfObject.getObjectRefAsString();
                if (raw[raw.length - 1] == 82) {
                    objectRef = new String(raw);
                    pdfObject.setRef(objectRef);
                } else if (raw[0] != 60 && raw[raw.length - 1] == 62) {
                    ObjectDecoder.extractRefFromEnd(raw, pdfObject, this.objectReader);
                    return;
                }
                Dictionary.readDictionaryFromRefOrDirect(pdfObject, objectRef, 0, raw, -1, this.objectReader);
            }
        }
    }

    private static void extractRefFromEnd(byte[] raw, PdfObject pdfObject, PdfFileReader objectReader) {
        int ptr = 0;
        int len = raw.length;
        for (int jj = 0; jj < len; ++jj) {
            if (raw[jj] < 48 || raw[jj] > 57) continue;
            ptr = jj;
            jj = len;
        }
        int end = ptr;
        while (raw[end] >= 48 && raw[end] <= 57 || raw[end] == 32 || raw[end] == 10 || raw[end] == 13 || raw[end] == 9) {
            ++end;
        }
        if (raw[end] == 111 && raw[end + 1] == 98 && raw[end + 2] == 106) {
            String objectRef = new String(raw, 0, end) + 'R';
            int newArrayLen = raw.length - end - 4;
            byte[] newArray = new byte[newArrayLen];
            System.arraycopy(raw, end + 4, newArray, 0, newArrayLen);
            raw = newArray;
            pdfObject.setRef(objectRef);
            Dictionary.readDictionaryFromRefOrDirect(pdfObject, objectRef, 0, raw, -1, objectReader);
        }
    }

    public void setEndPt(int dataPointer) {
        this.endPt = dataPointer;
    }

    static {
        padding = "";
    }
}

