/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import org.jpedal.utils.LogWriter;

class CustomColorConvertOp
implements BufferedImageOp {
    private final RenderingHints hints;

    CustomColorConvertOp(RenderingHints hints) {
        this.hints = hints;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        if (src.getType() == dest.getType()) {
            dest.getRaster().setRect(src.getRaster());
        } else if (src.getType() == 10) {
            byte[] srcPixels = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
            int[] destPixels = ((DataBufferInt)dest.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < srcPixels.length; ++i) {
                int px = srcPixels[i] & 0xFF;
                destPixels[i] = 0xFF000000 | px << 16 | px << 8 | px;
            }
        } else {
            try {
                ColorConvertOp xformOp = new ColorConvertOp(this.hints);
                xformOp.filter(src, dest);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " creating argb image");
            }
        }
        return dest;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle2D.Float(0.0f, 0.0f, src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return srcPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

