/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.EventListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.PointData;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.LogWriter;

public class TTVMDebug
extends TTVM {
    private static final boolean PRINT_COORDS_AFTER_EACH_INSTRUCTION = false;
    private static final boolean WATCH_A_POINT = false;
    private static final int WATCH_POINT = 53;
    private static boolean showDebugWindow;
    private static final String[] OPCODE_DESCRIPTIONS;
    private static final String GLYPH_PROGRAM_STRING = "Glyph program";
    private static final String X_STRING = "  X: ";
    private static final String Y_STRING = "  Y: ";
    private JList<String> currentInstructionList;
    private JList<String> stackList;
    private JList<String> cvtList;
    private JList<String> storageList;
    private final Deque<int[]> codeStack = new ArrayDeque<int[]>();
    private final Deque<Integer> numberStack = new ArrayDeque<Integer>();
    private final Deque<String> idStack = new ArrayDeque<String>();
    private int watchX;
    private int watchY;
    private int[] programToDebug;
    private boolean[] programToDebugIsData;
    private JDialog debugWindow;
    private JLabel currentCode;
    private JLabel debugXLabel;
    private JLabel debugYLabel;
    private JButton stepOutButton;
    private JComponent stateDisplay;
    private JComponent debugGlyphDisplay;
    private JCheckBox showInterpolatedShadow;
    private JLabel currentInstructionDescription;
    private boolean stepInto;
    private boolean debuggerRunningInBackground;
    private int debugPointer;
    private int instructionsExecuted;
    private int functionsLineCount;
    private TTGraphicsState dGS;
    private JPanel chooserPanel;
    private JFrame chooserFrame;
    private final String fontName;
    private static int nextWindowY;

    public TTVMDebug(FontFile2 currentFontFile, Maxp maxp, String fontName) {
        super(currentFontFile, maxp);
        this.fontName = fontName;
    }

    private void setUpChooserFrame() {
        this.chooserFrame = new JFrame("Hinting Debugger Glyphs - " + this.fontName);
        this.chooserFrame.setSize(800, 600);
        this.chooserFrame.setLocation(0, nextWindowY);
        nextWindowY = (nextWindowY + 30) % 300;
        this.chooserFrame.setDefaultCloseOperation(2);
        this.chooserFrame.setLayout(new BorderLayout());
        this.chooserPanel = new JPanel();
        this.chooserPanel.setLayout(new GridLayout(0, 6));
        JScrollPane scrollPane = new JScrollPane(this.chooserPanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.chooserFrame.add((Component)scrollPane, "Center");
        this.chooserFrame.setVisible(true);
    }

    private String getCurrentFunc() {
        String function = GLYPH_PROGRAM_STRING;
        for (Map.Entry entry : this.functions.entrySet()) {
            if (entry.getValue() != this.programToDebug) continue;
            function = "Function " + entry.getKey();
        }
        for (Map.Entry entry : this.instructions.entrySet()) {
            if (entry.getValue() != this.programToDebug) continue;
            function = "Instruction " + entry.getKey();
        }
        return function;
    }

    @Override
    void setProgramToDebug(int[] instructions) {
        if (showDebugWindow) {
            this.programToDebug = instructions;
            this.programToDebugIsData = TTVMDebug.getInstructionStreamIsData(this.programToDebug);
        }
    }

    @Override
    int process(int code, int currentPointer, int[] program, TTGraphicsState gs) {
        if (this.printOut) {
            System.out.print(currentPointer + "\t");
            System.out.println(TTVMDebug.getStringForOpcode(program, currentPointer));
        }
        if (showDebugWindow) {
            this.stack.setCurrentFunc(this.getCurrentFunc());
        }
        int originalPointer = currentPointer;
        if ((currentPointer = super.process(code, currentPointer, program, gs)) < 0) {
            currentPointer = -currentPointer;
        }
        if (showDebugWindow && this.debugWindow != null && this.debugWindow.isVisible()) {
            this.instructionsExecuted += currentPointer + 1 - originalPointer;
            if (this.debugPointer == -1) {
                return this.debugPointer;
            }
        }
        return currentPointer;
    }

    @Override
    boolean execute(int[] program, TTGraphicsState gs) {
        if (program == null) {
            return false;
        }
        if (showDebugWindow && this.stepInto && this.debugWindow != null && this.debugWindow.isVisible()) {
            this.codeStack.push(this.programToDebug);
            this.numberStack.push(this.debugPointer);
            this.idStack.push(this.getCurrentFunc());
            this.functionsLineCount += program.length;
            this.setCurrentCodeForDebug(program, -1, !this.debuggerRunningInBackground);
            return false;
        }
        boolean failedOnHinting = super.execute(program, gs);
        return failedOnHinting;
    }

    private void printCoords() {
        for (int i = 0; i < this.x[1].length; ++i) {
            System.out.print(i + "\t" + this.x[1][i] + '\t' + this.y[1][i] + '\t' + this.x[3][i] + '\t' + this.y[3][i]);
            System.out.println();
            if (!this.contour[1][i]) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println();
    }

    private void restartDebugger() {
        this.stack = new TTVM.Stack();
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
            this.graphicsState.resetForGlyph();
            this.dGS.resetForGlyph();
        }
        catch (CloneNotSupportedException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        int twilightCount = this.maxp.getMaxTwilightPoints();
        this.x[1] = new int[this.x[1].length];
        this.y[1] = new int[this.y[1].length];
        this.fontProgramRun = false;
        this.setScaleVars(this.scaler, this.ppem, this.ptSize);
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[twilightCount];
        this.x[2] = new int[twilightCount];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[twilightCount];
        this.y[2] = new int[twilightCount];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[twilightCount][2];
        this.touched[2] = new boolean[twilightCount][2];
        if (!this.codeStack.isEmpty()) {
            this.programToDebug = this.codeStack.getFirst();
            this.programToDebugIsData = TTVMDebug.getInstructionStreamIsData(this.programToDebug);
        }
        this.codeStack.clear();
        this.numberStack.clear();
        this.idStack.clear();
        this.functionsLineCount = 0;
        this.debugPointer = 0;
        this.instructionsExecuted = 0;
        this.currentCode.setText(GLYPH_PROGRAM_STRING);
        this.stepOutButton.setEnabled(false);
    }

    private void refreshDebugger(boolean programHasChanged) {
        if (programHasChanged) {
            this.currentInstructionList.setListData((String[])TTVMDebug.getInstructionsAsStringArray(this.programToDebug));
        }
        int start = this.debugPointer;
        int end = this.debugPointer;
        while (end + 1 < this.programToDebug.length && this.programToDebugIsData[end + 1]) {
            ++end;
        }
        this.currentInstructionList.setSelectionInterval(start, end);
        if (start != 0) {
            int forward = end + 3;
            if (forward >= this.programToDebug.length) {
                forward = this.programToDebug.length - 1;
            }
            this.currentInstructionList.ensureIndexIsVisible(forward);
            int back = start - 2;
            if (back < 0) {
                back = 0;
            }
            this.currentInstructionList.ensureIndexIsVisible(back);
            this.currentInstructionList.ensureIndexIsVisible(end);
        }
        this.currentInstructionList.ensureIndexIsVisible(start);
        this.stackList.setListData((String[])this.stack.toStringArray());
        this.cvtList.setListData((String[])this.cvt.getCVTForDebug());
        this.storageList.setListData((String[])this.getStorageAsArray());
        int line = Math.max(this.debugPointer, 0);
        this.currentInstructionDescription.setText(TTVMDebug.getStringForOpcode(this.programToDebug, line));
        this.stateDisplay.repaint();
        this.debugGlyphDisplay.repaint();
    }

    private static String getStringForOpcode(int[] program, int line) {
        if (line < 0) {
            line = 0;
        }
        int opcode = line < program.length ? program[line] : -1;
        if ((opcode = TTVMDebug.reduceInstructionToKey(opcode)) >= 0 && opcode <= 142) {
            return OPCODE_DESCRIPTIONS[opcode];
        }
        switch (opcode) {
            case 176: {
                return "PUSHB     - Pushes bytes to the stack";
            }
            case 184: {
                return "PUSHW     - Pushes words to the stack";
            }
            case 192: {
                return "MDRP      - Preserves the master outline distance between the specified point and the reference point rp0";
            }
            case 224: {
                return "MIRP      - Sets the distance between a point and rp0 to a CVT entry";
            }
        }
        return " ";
    }

    private String[] getStorageAsArray() {
        String[] result = new String[this.storage.length];
        for (int i = 0; i < this.storage.length; ++i) {
            result[i] = i + ": " + this.storage[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.storage[i] / 64.0) + ')';
        }
        return result;
    }

    private void setCurrentCodeForDebug(int[] code, int pointer, boolean updateDisplay) {
        this.programToDebug = code;
        this.debugPointer = pointer;
        try {
            if (!updateDisplay) {
                return;
            }
            this.programToDebugIsData = TTVMDebug.getInstructionStreamIsData(this.programToDebug);
            this.refreshDebugger(true);
            StringBuilder idText = new StringBuilder("<html>");
            for (String s : this.idStack) {
                idText.append(s).append("<br>");
            }
            idText.append("> ").append(this.getCurrentFunc()).append("</html>");
            this.currentCode.setText(idText.toString());
            this.stepOutButton.setEnabled(!GLYPH_PROGRAM_STRING.equals(this.getCurrentFunc()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runDebuggerTo(int targetPointer) {
        if (targetPointer == this.debugPointer) {
            return;
        }
        int targetInstr = targetPointer;
        int diff = -1;
        if (targetInstr >= 0) {
            int add = 0;
            if (targetInstr >= this.programToDebug.length) {
                add = targetInstr - (this.programToDebug.length - 1);
                targetInstr = this.programToDebug.length - 1;
            }
            while (this.programToDebugIsData[targetInstr]) {
                --targetInstr;
            }
            diff = targetInstr - this.debugPointer + add;
        }
        int target = this.instructionsExecuted + diff;
        boolean skipFunctions = true;
        if (target < this.instructionsExecuted) {
            this.restartDebugger();
            skipFunctions = false;
        }
        int startLineCount = this.functionsLineCount;
        this.debuggerRunningInBackground = true;
        while (this.instructionsExecuted < target + (skipFunctions ? this.functionsLineCount - startLineCount : 0)) {
            this.stepInto = true;
            this.debugPointer = this.process(this.programToDebug[this.debugPointer], this.debugPointer, this.programToDebug, this.dGS);
            if (!this.stepInto && this.debugPointer < 0) {
                this.debugPointer = -this.debugPointer;
            }
            ++this.debugPointer;
            if (this.debugPointer != this.programToDebug.length || this.codeStack.isEmpty()) continue;
            this.idStack.pop();
            this.setCurrentCodeForDebug(this.codeStack.pop(), this.numberStack.pop() + 1, false);
        }
        this.debuggerRunningInBackground = false;
        this.setCurrentCodeForDebug(this.programToDebug, this.debugPointer, true);
        this.stepInto = false;
        this.instructionsExecuted = target;
    }

    private void advanceDebugger(boolean stepIntoCall) {
        if (this.debugPointer < this.programToDebug.length) {
            Runnable t = () -> {
                this.stepInto = stepIntoCall;
                this.debugPointer = this.process(this.programToDebug[this.debugPointer], this.debugPointer, this.programToDebug, this.dGS);
                if (!this.stepInto && this.debugPointer < 0) {
                    this.debugPointer = -this.debugPointer;
                }
                this.stepInto = false;
                ++this.debugPointer;
                this.refreshDebugger(false);
                while (this.debugPointer == this.programToDebug.length && !this.codeStack.isEmpty()) {
                    this.idStack.pop();
                    this.setCurrentCodeForDebug(this.codeStack.pop(), this.numberStack.pop() + 1, true);
                }
            };
            SwingUtilities.invokeLater(t);
        }
    }

    private void runDebugger() {
        if (this.programToDebug == null) {
            JOptionPane.showMessageDialog(this.debugWindow, "No glyph program found to debug!");
            return;
        }
        this.debugWindow = new JDialog(this.chooserFrame, "TrueType Hinting Debugger", true){

            @Override
            public void dispose() {
                showDebugWindow = false;
                super.dispose();
            }
        };
        this.debugWindow.setSize(1000, 700);
        this.debugWindow.setLayout(new BorderLayout());
        this.debugWindow.setDefaultCloseOperation(2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton stepOverButton = new JButton("Step Over");
        stepOverButton.addActionListener(e -> this.advanceDebugger(false));
        buttonPanel.add(stepOverButton);
        JButton stepIntoButton = new JButton("Step Into");
        stepIntoButton.addActionListener(e -> this.advanceDebugger(true));
        buttonPanel.add(stepIntoButton);
        this.stepOutButton = new JButton("Step Out");
        this.stepOutButton.setEnabled(false);
        this.stepOutButton.addActionListener(e -> this.runDebuggerTo(this.programToDebug.length));
        buttonPanel.add(this.stepOutButton);
        JButton restartButton = new JButton("Restart");
        restartButton.addActionListener(e -> {
            this.restartDebugger();
            this.refreshDebugger(true);
        });
        buttonPanel.add(restartButton);
        JButton backButton = new JButton("Back");
        backButton.addActionListener(e -> this.runDebuggerTo(this.debugPointer - 1));
        buttonPanel.add(backButton);
        this.debugWindow.add("North", buttonPanel);
        JPanel instructionPanel = new JPanel();
        instructionPanel.setLayout(new BorderLayout());
        instructionPanel.setBorder(new LineBorder(Color.BLACK));
        this.currentInstructionList = new JList();
        for (MouseMotionListener mouseMotionListener : this.currentInstructionList.getMouseMotionListeners()) {
            this.currentInstructionList.removeMouseMotionListener(mouseMotionListener);
        }
        for (EventListener eventListener : this.currentInstructionList.getMouseListeners()) {
            this.currentInstructionList.removeMouseListener((MouseListener)eventListener);
        }
        JScrollPane codePane = new JScrollPane(this.currentInstructionList){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                int w = Math.max(pref.width, min.width);
                int h = Math.max(pref.height, min.height);
                return new Dimension(w, h);
            }
        };
        codePane.setMinimumSize(new Dimension(150, 100));
        this.currentCode = new JLabel(GLYPH_PROGRAM_STRING);
        instructionPanel.add("Center", codePane);
        instructionPanel.add("South", this.currentCode);
        this.debugWindow.add("West", instructionPanel);
        JPanel glyphPanel = new JPanel();
        glyphPanel.setLayout(new BorderLayout());
        glyphPanel.setBorder(new LineBorder(Color.BLACK));
        this.debugGlyphDisplay = new JComponent(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                int[] glyphBounds = TTVMDebug.getBounds(TTVMDebug.this.x[1], TTVMDebug.this.y[1]);
                int[] twilightBounds = TTVMDebug.getBounds(TTVMDebug.this.x[0], TTVMDebug.this.y[0]);
                int minX = Math.min(glyphBounds[0], twilightBounds[0]);
                int minY = Math.min(glyphBounds[1], twilightBounds[1]);
                int maxX = Math.max(glyphBounds[2], twilightBounds[2]);
                int maxY = Math.max(glyphBounds[3], twilightBounds[3]);
                int displayWidth = this.getWidth();
                int displayHeight = this.getHeight();
                int xRange = maxX - minX;
                int yRange = maxY - minY;
                double xScale = (double)displayWidth / (double)xRange;
                double yScale = (double)displayHeight / (double)yRange;
                double scale = Math.min(xScale, yScale);
                int borderWidth = 15;
                minX = (int)((double)minX - (double)borderWidth / scale);
                maxX = (int)((double)maxX + (double)borderWidth / scale);
                minY = (int)((double)minY - (double)borderWidth / scale);
                maxY = (int)((double)maxY + (double)borderWidth / scale);
                xRange = maxX - minX;
                yRange = maxY - minY;
                xScale = (double)displayWidth / (double)xRange;
                yScale = (double)displayHeight / (double)yRange;
                scale = Math.min(xScale, yScale);
                g2.translate(0, displayHeight);
                g2.scale(scale, -scale);
                g2.translate(-minX, -minY);
                g2.setPaint(Color.WHITE);
                g2.fillRect(minX, minY, (int)((double)displayWidth / scale), (int)((double)displayHeight / scale));
                g2.setPaint(new Color(180, 180, 255));
                g2.drawLine(0, minY, 0, (int)((double)displayHeight / scale));
                g2.drawLine(minX, 0, (int)((double)displayWidth / scale), 0);
                int len = (int)(3.0 / scale);
                for (int i = 0; i < TTVMDebug.this.x[1].length; ++i) {
                    int xVal = TTVMDebug.this.x[1][i];
                    int yVal = TTVMDebug.this.y[1][i];
                    if (TTVMDebug.this.curve[1][i]) {
                        g2.setPaint(Color.BLACK);
                        Ellipse2D.Double s = new Ellipse2D.Double((double)xVal - 2.0 / scale, (double)yVal - 2.0 / scale, 4.0 / scale, 4.0 / scale);
                        g2.fill(s);
                    } else {
                        g2.setPaint(Color.RED);
                        g2.drawLine(xVal - len, yVal - len, xVal + len, yVal + len);
                        g2.drawLine(xVal + len, yVal - len, xVal - len, yVal + len);
                    }
                    AffineTransform store = g2.getTransform();
                    g2.translate(xVal, yVal);
                    g2.scale(1.0 / scale, -1.0 / scale);
                    g2.drawString(String.valueOf(i), 3, -3);
                    g2.setTransform(store);
                }
                if (TTVMDebug.this.showInterpolatedShadow.isSelected()) {
                    int c = TTVMDebug.this.x[1].length;
                    int[] xStore = new int[c];
                    System.arraycopy(TTVMDebug.this.x[1], 0, xStore, 0, c);
                    int[] yStore = new int[c];
                    System.arraycopy(TTVMDebug.this.y[1], 0, yStore, 0, c);
                    boolean[] curveStore = new boolean[c];
                    System.arraycopy(TTVMDebug.this.curve[1], 0, curveStore, 0, c);
                    boolean[] contourStore = new boolean[c];
                    System.arraycopy(TTVMDebug.this.contour[1], 0, contourStore, 0, c);
                    TTVMDebug.this.interpolateUntouchedPoints(48);
                    TTVMDebug.this.interpolateUntouchedPoints(49);
                    GeneralPath shape = TTVMDebug.getPathFromPoints(TTVMDebug.this.x[1], TTVMDebug.this.y[1], TTVMDebug.this.curve[1], TTVMDebug.this.contour[1]);
                    g2.setPaint(new Color(255, 0, 0, 100));
                    g2.draw(shape);
                    g2.setPaint(new Color(0, 0, 0, 30));
                    g2.fill(shape);
                    System.arraycopy(xStore, 0, TTVMDebug.this.x[1], 0, c);
                    System.arraycopy(yStore, 0, TTVMDebug.this.y[1], 0, c);
                    System.arraycopy(curveStore, 0, TTVMDebug.this.curve[1], 0, c);
                    System.arraycopy(contourStore, 0, TTVMDebug.this.contour[1], 0, c);
                }
                GeneralPath shape = TTVMDebug.getPathFromPoints(TTVMDebug.this.x[1], TTVMDebug.this.y[1], TTVMDebug.this.curve[1], TTVMDebug.this.contour[1]);
                g2.setPaint(new Color(100, 100, 255, 100));
                g2.fill(shape);
                g2.setPaint(Color.BLACK);
                g2.draw(shape);
                g2.setPaint(Color.BLUE);
                for (int i = 0; i < TTVMDebug.this.x[0].length; ++i) {
                    int xVal = TTVMDebug.this.x[0][i];
                    int yVal = TTVMDebug.this.y[0][i];
                    if (xVal == 0 && yVal == 0) continue;
                    if (TTVMDebug.this.curve[0][i]) {
                        Ellipse2D.Double s = new Ellipse2D.Double((double)xVal - 2.0 / scale, (double)yVal - 2.0 / scale, 4.0 / scale, 4.0 / scale);
                        g2.fill(s);
                    } else {
                        g2.drawLine(xVal - len, yVal - len, xVal + len, yVal + len);
                        g2.drawLine(xVal + len, yVal - len, xVal - len, yVal + len);
                    }
                    AffineTransform store = g2.getTransform();
                    g2.translate(xVal, yVal);
                    g2.scale(1.0 / scale, -1.0 / scale);
                    g2.drawString(String.valueOf(i), 3, -3);
                    g2.setTransform(store);
                }
            }
        };
        this.debugGlyphDisplay.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                double eX = e.getX();
                double eY = e.getY();
                int w = TTVMDebug.this.debugGlyphDisplay.getWidth();
                int h = TTVMDebug.this.debugGlyphDisplay.getHeight();
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int i = 0; i < TTVMDebug.this.x[1].length; ++i) {
                    int val = TTVMDebug.this.x[1][i];
                    if (val > maxX) {
                        maxX = val;
                    }
                    if (val < minX) {
                        minX = val;
                    }
                    if ((val = TTVMDebug.this.y[1][i]) > maxY) {
                        maxY = val;
                    }
                    if (val >= minY) continue;
                    minY = val;
                }
                int xRange = maxX - minX;
                int yRange = maxY - minY;
                double xScale = (double)w / (double)xRange;
                double yScale = (double)h / (double)yRange;
                double scale = Math.min(xScale, yScale);
                int borderWidth = 15;
                minX = (int)((double)minX - 15.0 / scale);
                maxX = (int)((double)maxX + 15.0 / scale);
                minY = (int)((double)minY - 15.0 / scale);
                maxY = (int)((double)maxY + 15.0 / scale);
                xRange = maxX - minX;
                yRange = maxY - minY;
                xScale = (double)w / (double)xRange;
                yScale = (double)h / (double)yRange;
                scale = Math.min(xScale, yScale);
                eX = eX / scale + (double)minX;
                eY = (double)h - eY;
                eY = eY / scale + (double)minY;
                TTVMDebug.this.debugXLabel.setText(TTVMDebug.X_STRING + eX);
                TTVMDebug.this.debugYLabel.setText(TTVMDebug.Y_STRING + eY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TTVMDebug.this.debugXLabel.setText(TTVMDebug.X_STRING);
                TTVMDebug.this.debugYLabel.setText(TTVMDebug.Y_STRING);
            }
        });
        glyphPanel.add("Center", this.debugGlyphDisplay);
        this.showInterpolatedShadow = new JCheckBox("Show Interpolated Shadow");
        this.showInterpolatedShadow.setSelected(true);
        this.showInterpolatedShadow.addActionListener(e -> glyphPanel.repaint());
        glyphPanel.add("North", this.showInterpolatedShadow);
        this.currentInstructionDescription = new JLabel(OPCODE_DESCRIPTIONS[0]);
        glyphPanel.add("South", this.currentInstructionDescription);
        this.debugWindow.add("Center", glyphPanel);
        JPanel dataPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                Dimension max = this.getMaximumSize();
                int w = Math.max(pref.width, min.width);
                int h = Math.max(pref.height, min.height);
                w = Math.min(w, max.width);
                h = Math.min(h, max.height);
                return new Dimension(w, h);
            }
        };
        dataPanel.setMinimumSize(new Dimension(200, 100));
        dataPanel.setMaximumSize(new Dimension(200, 1000000));
        dataPanel.setLayout(new BorderLayout());
        dataPanel.setBorder(new LineBorder(Color.BLACK));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.stackList = new JList();
        this.stackList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int i = TTVMDebug.this.stackList.locationToIndex(e.getPoint());
                if (i >= 0) {
                    TTVMDebug.this.stackList.setToolTipText("Pushed by " + TTVMDebug.this.stack.getPushedBy(i));
                }
            }
        });
        JScrollPane stackScroll = new JScrollPane(this.stackList);
        jPanel.add("North", new JLabel("Stack:"));
        jPanel.add("Center", stackScroll);
        JPanel cvtPanel = new JPanel(new BorderLayout());
        this.cvtList = new JList<String>(this.cvt.getCVTForDebug());
        JScrollPane cvtScroll = new JScrollPane(this.cvtList);
        cvtPanel.add("North", new JLabel("CVT:"));
        cvtPanel.add("Center", cvtScroll);
        JPanel storagePanel = new JPanel(new BorderLayout());
        this.storageList = new JList<String>(this.getStorageAsArray());
        JScrollPane storageScroll = new JScrollPane(this.storageList);
        storagePanel.add("North", new JLabel("Storage:"));
        storagePanel.add("Center", storageScroll);
        dataPanel.add("North", jPanel);
        dataPanel.add("Center", cvtPanel);
        dataPanel.add("South", storagePanel);
        this.debugWindow.add("East", dataPanel);
        JPanel statePanel = new JPanel();
        statePanel.setLayout(new BorderLayout());
        statePanel.setBorder(new LineBorder(Color.BLACK));
        this.stateDisplay = new JComponent(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(Color.WHITE);
                g2.fillRect(0, 0, 81, 81);
                g2.setPaint(Color.BLACK);
                g2.drawRect(0, 0, 81, 81);
                g2.setPaint(Color.GRAY);
                g2.drawOval(0, 0, 81, 81);
                g2.drawLine(0, 40, 5, 40);
                g2.drawLine(81, 40, 76, 40);
                g2.drawLine(40, 0, 40, 5);
                g2.drawLine(40, 81, 40, 76);
                g2.drawLine(12, 12, 15, 15);
                g2.drawLine(69, 12, 66, 15);
                g2.drawLine(12, 69, 15, 66);
                g2.drawLine(69, 69, 66, 66);
                g2.setPaint(new Color(0, 100, 0));
                int[] vec = TTGraphicsState.getVectorComponents(((TTVMDebug)TTVMDebug.this).dGS.freedomVector);
                g2.drawLine(40, 40, 40 + vec[0] * 40 / 16384, 40 - vec[1] * 40 / 16384);
                g2.drawString("Freedom Vector", 84, 13);
                g2.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 23);
                g2.setPaint(Color.BLUE);
                vec = TTGraphicsState.getVectorComponents(((TTVMDebug)TTVMDebug.this).dGS.dualProjectionVector);
                g2.drawLine(41, 41, 41 + vec[0] * 40 / 16384, 41 - vec[1] * 40 / 16384);
                g2.drawString("Dual Projection Vector", 84, 65);
                g2.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 75);
                g2.setPaint(Color.MAGENTA);
                vec = TTGraphicsState.getVectorComponents(((TTVMDebug)TTVMDebug.this).dGS.projectionVector);
                g2.drawLine(41, 41, 41 + vec[0] * 40 / 16384, 41 - vec[1] * 40 / 16384);
                g2.drawString("Projection Vector", 84, 39);
                g2.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 49);
                g2.setPaint(Color.GRAY);
                g2.drawLine(240, 4, 240, 77);
                g2.setPaint(Color.BLACK);
                String TWILIGHT_ZONE_STRING = " (Twilight Zone)";
                String GLYPH_ZONE_STRING = " (Glyph Zone)";
                g2.drawString("zp0: " + ((TTVMDebug)TTVMDebug.this).dGS.zp0 + (((TTVMDebug)TTVMDebug.this).dGS.zp0 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 13);
                g2.drawString("zp1: " + ((TTVMDebug)TTVMDebug.this).dGS.zp1 + (((TTVMDebug)TTVMDebug.this).dGS.zp1 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 25);
                g2.drawString("zp2: " + ((TTVMDebug)TTVMDebug.this).dGS.zp2 + (((TTVMDebug)TTVMDebug.this).dGS.zp2 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 37);
                g2.drawString("rp0: " + ((TTVMDebug)TTVMDebug.this).dGS.rp0, 250, 51);
                g2.drawString("rp1: " + ((TTVMDebug)TTVMDebug.this).dGS.rp1, 250, 63);
                g2.drawString("rp2: " + ((TTVMDebug)TTVMDebug.this).dGS.rp2, 250, 75);
                g2.setPaint(Color.GRAY);
                g2.drawLine(404, 4, 404, 77);
                g2.setPaint(Color.BLACK);
                g2.drawString("Instruct Control: " + ((TTVMDebug)TTVMDebug.this).dGS.instructControl, 414, 13);
                g2.drawString("Auto Flip: " + ((TTVMDebug)TTVMDebug.this).dGS.autoFlip, 414, 30);
                g2.drawString("Delta Base: " + ((TTVMDebug)TTVMDebug.this).dGS.deltaBase, 414, 47);
                g2.drawString("Delta Shift: " + ((TTVMDebug)TTVMDebug.this).dGS.deltaShift, 414, 59);
                g2.drawString("Loop: " + ((TTVMDebug)TTVMDebug.this).dGS.loop, 414, 75);
                g2.setPaint(Color.GRAY);
                g2.drawLine(548, 4, 548, 77);
                g2.setPaint(Color.BLACK);
                g2.drawString("Round State: " + TTVMDebug.this.dGS.getRoundStateAsString(), 558, 13);
                g2.drawString("Minimum Distance: " + ((TTVMDebug)TTVMDebug.this).dGS.minimumDistance, 558, 30);
                g2.drawString("CVT Cut In: " + ((TTVMDebug)TTVMDebug.this).dGS.controlValueTableCutIn, 558, 46);
                g2.drawString("Single Width Cut In: " + ((TTVMDebug)TTVMDebug.this).dGS.singleWidthCutIn, 558, 63);
                g2.drawString("Single Width Value: " + ((TTVMDebug)TTVMDebug.this).dGS.singleWidthValue, 558, 75);
            }
        };
        this.stateDisplay.setMinimumSize(new Dimension(700, 81));
        this.stateDisplay.setPreferredSize(new Dimension(700, 81));
        this.stateDisplay.setMaximumSize(new Dimension(700, 81));
        statePanel.add("West", this.stateDisplay);
        JPanel mousePanel = new JPanel();
        mousePanel.setLayout(new GridLayout(0, 1));
        this.debugXLabel = new JLabel(X_STRING){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                int w = Math.max(pref.width, min.width);
                int h = Math.max(pref.height, min.height);
                return new Dimension(w, h);
            }
        };
        this.debugXLabel.setBackground(Color.WHITE);
        this.debugXLabel.setOpaque(true);
        this.debugXLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugXLabel.setMinimumSize(new Dimension(200, 20));
        this.debugYLabel = new JLabel(Y_STRING);
        this.debugYLabel.setBackground(Color.WHITE);
        this.debugYLabel.setOpaque(true);
        this.debugYLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugYLabel.setMinimumSize(new Dimension(200, 20));
        mousePanel.add(this.debugXLabel);
        mousePanel.add(this.debugYLabel);
        statePanel.add("East", mousePanel);
        this.debugWindow.add("South", statePanel);
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
            this.dGS.resetForGlyph();
        }
        catch (CloneNotSupportedException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        this.stack = new TTVM.Stack();
        int twilightCount = this.maxp.getMaxTwilightPoints();
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[twilightCount];
        this.x[2] = new int[twilightCount];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[twilightCount];
        this.y[2] = new int[twilightCount];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[twilightCount][2];
        this.touched[2] = new boolean[twilightCount][2];
        this.refreshDebugger(true);
        this.debugWindow.setVisible(true);
    }

    private static int[] getBounds(int[] x, int[] y) {
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int i = 0; i < x.length; ++i) {
            int val = x[i];
            if (val > bounds[2]) {
                bounds[2] = val;
            }
            if (val < bounds[0]) {
                bounds[0] = val;
            }
            if ((val = y[i]) > bounds[3]) {
                bounds[3] = val;
            }
            if (val >= bounds[1]) continue;
            bounds[1] = val;
        }
        return bounds;
    }

    @Override
    public boolean processGlyph(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours, double ppem, double scaler) {
        if (this.chooserFrame == null) {
            this.setUpChooserFrame();
        }
        GlyphDetails details = new GlyphDetails(instructions, glyfX, glyfY, curves, contours, ppem, scaler);
        this.chooserPanel.add(details.button);
        boolean failedOnHinting = super.processGlyph(instructions, glyfX, glyfY, curves, contours, ppem, scaler);
        if (showDebugWindow) {
            this.runDebugger();
        }
        return failedOnHinting;
    }

    private static boolean[] getInstructionStreamIsData(int[] program) {
        if (program == null) {
            return new boolean[0];
        }
        String[] strings = TTVMDebug.getInstructionsAsStringArray(program);
        boolean[] result = new boolean[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = !strings[i].contains(":");
        }
        return result;
    }

    private static String[] getInstructionsAsStringArray(int[] program) {
        if (program == null) {
            return new String[0];
        }
        String[] result = new String[program.length];
        StringBuilder depth = new StringBuilder();
        for (int n = 0; n < program.length; ++n) {
            int word;
            int j;
            int count;
            int commandKey = program[n];
            commandKey = TTVMDebug.reduceInstructionToKey(commandKey);
            String commandName = TTVMDebug.getStringForOpcode(program, n).split(" ")[0];
            if (commandKey == 45 || commandKey == 27 || commandKey == 89) {
                depth.delete(0, 2);
            }
            result[n] = n + ": " + depth + commandName;
            if (commandKey == 64) {
                count = program[++n];
                result[n] = depth + "  count: " + count;
                for (j = 0; j < count; ++j) {
                    result[++n] = depth + "   " + program[n];
                }
                continue;
            }
            if (commandKey == 65) {
                count = program[++n];
                result[n] = depth + "  count: " + count;
                for (j = 0; j < count; ++j) {
                    word = TTVMDebug.getIntFrom2Uint8(program[++n], program[n + 1]);
                    result[n] = depth + "   (first half of number)";
                    result[++n] = depth + "   " + word;
                }
                continue;
            }
            if (program[n] >= 176 && program[n] < 184) {
                count = program[n] - 175;
                for (j = 0; j < count; ++j) {
                    result[++n] = depth + "   " + program[n];
                }
                continue;
            }
            if (program[n] >= 184 && program[n] < 192) {
                count = program[n] - 183;
                for (j = 0; j < count; ++j) {
                    word = TTVMDebug.getIntFrom2Uint8(program[++n], program[n + 1]);
                    result[n] = depth + "   (first half of number)";
                    result[++n] = depth + "   " + word;
                }
                continue;
            }
            if (commandKey != 44 && commandKey != 137 && commandKey != 27 && commandKey != 88) continue;
            depth.append("  ");
        }
        return result;
    }

    private static int reduceInstructionToKey(int test) {
        if (test >= 192 && test <= 223) {
            test = 192;
        }
        if (test >= 224 && test <= 255) {
            test = 224;
        }
        if (test >= 176 && test <= 183) {
            test = 176;
        }
        if (test >= 184 && test <= 191) {
            test = 184;
        }
        return test;
    }

    private static GeneralPath getPathFromPoints(int[] x, int[] y, boolean[] curve, boolean[] contour) {
        int ptCount = x.length;
        int[] pX = new int[ptCount];
        System.arraycopy(x, 0, pX, 0, ptCount);
        int[] pY = new int[ptCount];
        System.arraycopy(y, 0, pY, 0, ptCount);
        boolean[] endOfContour = new boolean[ptCount];
        System.arraycopy(contour, 0, endOfContour, 0, ptCount);
        boolean[] onCurve = new boolean[ptCount];
        System.arraycopy(curve, 0, onCurve, 0, ptCount);
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    TTVMDebug.resetValues(pX, pY, onCurve, start, firstPt, ii);
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
        int c = pX.length;
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        return TTVMDebug.processPoints(ptCount, pX, pY, endOfContour, onCurve, c, fc);
    }

    private static void resetValues(int[] pX, int[] pY, boolean[] onCurve, int start, int firstPt, int ii) {
        int diff = firstPt - start;
        int pXlength = pX.length;
        int[] oldPX = new int[pXlength];
        System.arraycopy(pX, 0, oldPX, 0, pXlength);
        int[] oldPY = new int[pXlength];
        System.arraycopy(pY, 0, oldPY, 0, pXlength);
        boolean[] oldOnCurve = new boolean[pXlength];
        System.arraycopy(onCurve, 0, oldOnCurve, 0, pXlength);
        for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
            int newPos = oldPos + diff;
            if (newPos > ii) {
                newPos -= ii - start + 1;
            }
            pX[oldPos] = oldPX[newPos];
            pY[oldPos] = oldPY[newPos];
            onCurve[oldPos] = oldOnCurve[newPos];
        }
    }

    private static GeneralPath processPoints(int ptCount, int[] pX, int[] pY, boolean[] endOfContour, boolean[] onCurve, int c, int fc) {
        boolean isFirstDraw = true;
        GeneralPath currentPath = new GeneralPath(1);
        PointData pointData = new PointData(pX, pY);
        currentPath.moveTo(pX[0], pY[0]);
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < ptCount; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                for (int jj = j + 1; jj < c; ++jj) {
                    if (!endOfContour[jj]) continue;
                    fc = jj + 1;
                    jj = c;
                }
            }
            if (lc == fc && onCurve[p]) {
                j = c;
                continue;
            }
            if (onCurve[p] && onCurve[p1]) {
                pointData.x3 = pX[p1];
                pointData.y3 = pY[p1];
                currentPath.lineTo(pX[p1], pY[p1]);
                isFirstDraw = false;
            } else if (j < c - 3 && (fc - lc > 1 || fc == lc)) {
                boolean checkEnd = false;
                if (onCurve[p] && !onCurve[p1] && onCurve[p2]) {
                    pointData.set2Points1Control(p, p1, p2);
                    ++j;
                    checkEnd = true;
                } else if (onCurve[p] && !onCurve[p1] && !onCurve[p2]) {
                    pointData.set1Point2Control(p, p1, p2);
                    ++j;
                    checkEnd = true;
                } else if (!(onCurve[p] || onCurve[p1] || endOfContour[p2] && fc - p2 != 1)) {
                    pointData.set2Control1Point(p, p1, pm1);
                } else if (!onCurve[p] && onCurve[p1]) {
                    pointData.set1Control2Point(p, p1, pm1);
                }
                if (isFirstDraw) {
                    currentPath.moveTo(pointData.x1, pointData.y1);
                    isFirstDraw = false;
                }
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    currentPath.curveTo(pointData.x1, pointData.y1, pointData.x2, pointData.y2, pointData.x3, pointData.y3);
                }
                if (checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    for (int jj = j + 1; jj < c; ++jj) {
                        if (!endOfContour[jj]) continue;
                        fc = jj + 1;
                        jj = c;
                    }
                }
            }
            if (endOfContour[p]) {
                currentPath.closePath();
            }
            if (!isEnd) continue;
            currentPath.moveTo(xs, ys);
            isEnd = false;
        }
        return currentPath;
    }

    static {
        OPCODE_DESCRIPTIONS = new String[]{"SVTCA_Y    - Set both vectors to y", "SVTCA_X    - Set both vectors to x", "SPVTCA_Y   - Sets projection vector to y", "SPVTCA_X   - Sets projection vector to x", "SFVTCA_Y   - Sets freedom vector to y", "SFVTCA_X   - Sets freedom vector to x", "SPVTL0    - Set projection vector to line", "SPVTL1    - Set projection vector perpendicular to line", "SFVTL0    - Set freedom vector to line", "SFVTL1    - Set freedom vector perpendicular to line", "SPVFS     - Sets the projection vector from the stack", "SFVFS     - Sets the freedom vector from the stack", "GPV       - Gets the projection vector onto the stack", "GFV       - Gets the freedom vector onto the stack", "SFVTPV    - Sets freedom vector to projection vector", "ISECT     - Set point to intersection of lines", "SRP0      - Set rp0", "SRP1      - Set rp1", "SRP2      - Set rp2", "SZP0      - Sets zp0", "SZP1      - Sets zp1", "SZP2      - Sets zp2", "SZPS      - Sets all zone pointers", "SLOOP     - Sets loop variable", "RTG       - Sets round state to grid", "RTHG      - Sets round state to half grid", "SMD       - Sets minimum distance", "ELSE      - ELSE", "JMPR      - Jump", "SCVTCI    - Set control value table cut in", "SSWCI     - Set single width cut in", "SSW       - Set single width", "DUP       - Duplicate the top stack element", "POP       - Remove the top stack element", "CLEAR     - Clear the stack", "SWAP      - Swap the top two stack elements", "DEPTH     - Returns depth of stack", "CINDEX    - Copy Indexed element to top of stack", "MINDEX    - Move Indexed element to top of stack", "ALIGNPTS  - Move points along fv to average of their pv positions", "", "UTP       - Untouch point", "LOOPCALL  - Call a function many times", "CALL      - Call a function", "FDEF      - Define a function", "ENDF      - End a function definition", "MDAP0     - Sets a point as touched", "MDAP1     - Rounds a point along the pV and marks as touched", "IUP_Y      - Interpolate untouched points in the y axis", "IUP_X      - Interpolate untouched points on the x axis", "SHP0      - Shift point using RP2", "SHP1      - Shift point using RP1", "SHC0      - Shift a contour using RP2", "SHC1      - Shift a contour using RP1", "SHZ0      - Shift a zone using RP2", "SHZ1      - Shift a zone using RP1", "SHPIX     - Move point along freedom vector", "IP        - Interpolate point", "MSIRP0    - Move stack indirect relative point", "MSIRP1    - Move stack indirect relative point", "ALIGNRP   - Align point to RP0", "RTDG      - Sets round state to double grid", "MIAP0     - Move point to CVT value", "MIAP1     - Move point to CVT using cut in and round", "NPUSHB    - Push N bytes from IS to stack", "NPUSHW    - Push N words from IS to stack", "WS        - Write Store", "RS        - Read Store", "WCVTP     - Write Control Value Table in Pixels", "RCVT      - Read Control Value Table", "GC0       - Get coords on the pv", "GC1       - Get original coords on the pv", "SCFS", "MD0       - Measure current distance", "MD1       - Measure original distance", "MPPEM     - Measure pixels per em in the direction of the projection vector", "MPS", "FLIPON    - Sets autoflip to true", "FLIPOFF   - Sets autoflip to false", "DEBUG     - Shouldn't be in live fonts", "LT        - Less Than", "LTEQ      - Less Than or Equal", "GT        - Greater Than", "GTEQ      - Greater Than or Equal", "EQ        - Equal", "NEQ       - Not Equal", "ODD       - Rounds, truncates, and returns if odd.", "EVEN      - Rounds, truncates, and returns if even", "IF        - IF", "EIF       - End IF", "AND       - Logical AND", "OR        - Logical OR", "NOT       - Logical NOT", "DELTAP1   - Delta exception p1", "SDB       - Set delta base", "SDS       - Set delta shift", "ADD       - Add two F26Dot6 numbers", "SUB       - Subtract a number from another", "DIV       - Divide two F26Dot6 numbers", "MUL       - Multiply two F26Dot6 numbers", "ABS       - Return the absolute value of a F26Dot6 number", "NEG       - Negate a number", "FLOOR     - Round a number down if it has a fractional component", "CEILING   - Round a number up if it has a fractional component", "ROUND00   - Round a number", "ROUND01   - Round a number", "ROUND10   - Round a number", "ROUND11   - Round a number", "NROUND00  - Compensate for engine characteristics", "NROUND01  - Compensate for engine characteristics", "NROUND10  - Compensate for engine characteristics", "NROUND11  - Compensate for engine characteristics", "WCVTF", "DELTAP2   - Delta exception p2", "DELTAP3   - Delta exception p3", "DELTAC1   - Delta exception c1", "DELTAC2   - Delta exception c2", "DELTAC3   - Delta exception c3", "SROUND    - Sets the roundState specifically", "S45ROUND  - Sets the round state for working at 45degrees", "JROT      - Jump Relative On True", "JROF      - Jump Relative On False", "ROFF      - Set round state to off", "", "RUTG      - Set round state to up to grid", "RDTG      - Set round state to down to grid", "SANGW     - deprecated", "AA        - deprecated", "FLIPPT    - Flips a number of points on/off the curve", "FLIPRGON  - Flips a range of points onto the curve", "FLIPRGOFF - Flips a range of points off the curve", "", "", "SCANCTRL  - We don't scan convert, so only pops a value", "SDPVTL0   - Sets dual projection vector to line", "SDPVTL1   - Sets dual projection vector perpendicular to line", "GETINFO   - Gets info about current glyph & font engine", "IDEF      - Define an instruction", "ROLL      - Roll the top three stack elements", "MAX       - Returns the maximum of two values", "MIN       - Returns the minimum of two values", "SCANTYPE  - We don't scan convert, so only pops a value", "INSTCTRL  - Allows for setting flags to do with glyph execution"};
        isDebug = true;
    }

    private final class GlyphDetails {
        private BufferedImage image;
        private static final int IMAGE_SIZE = 100;
        private final JButton button;

        private GlyphDetails(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours, double ppem, double scaler) {
            this.setImage(glyfX, glyfY, curves, contours);
            this.button = new JButton("", new ImageIcon(this.image));
            int[] newInstructions = Arrays.copyOf(instructions, instructions.length);
            int[] newGlyfX = Arrays.copyOf(glyfX, glyfX.length);
            int[] newGlyfY = Arrays.copyOf(glyfY, glyfY.length);
            boolean[] newCurves = Arrays.copyOf(curves, curves.length);
            boolean[] newContours = Arrays.copyOf(contours, contours.length);
            this.button.addActionListener(e -> {
                showDebugWindow = true;
                TTVMDebug.this.processGlyph(newInstructions, newGlyfX, newGlyfY, newCurves, newContours, ppem, scaler);
            });
            this.button.setMaximumSize(new Dimension(110, 110));
        }

        private void setImage(int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours) {
            this.image = new BufferedImage(100, 100, 1);
            GeneralPath shape = TTVMDebug.getPathFromPoints(glyfX, glyfY, curves, contours);
            int[] bounds = TTVMDebug.getBounds(glyfX, glyfY);
            int minX = bounds[0];
            int minY = bounds[1];
            int maxX = bounds[2];
            int maxY = bounds[3];
            int xRange = maxX - minX;
            int yRange = maxY - minY;
            double xScale = 100.0 / (double)xRange;
            double yScale = 100.0 / (double)yRange;
            double scale = Math.min(xScale, yScale);
            Graphics2D g2 = (Graphics2D)this.image.getGraphics();
            g2.setPaint(new Color(230, 230, 230));
            g2.fillRect(0, 0, 100, 100);
            minX = (int)((double)minX - 6.0 / scale);
            maxX = (int)((double)maxX + 6.0 / scale);
            minY = (int)((double)minY - 6.0 / scale);
            maxY = (int)((double)maxY + 6.0 / scale);
            xRange = maxX - minX;
            yRange = maxY - minY;
            xScale = 100.0 / (double)xRange;
            yScale = 100.0 / (double)yRange;
            scale = Math.min(xScale, yScale);
            g2.translate(0, 100);
            g2.scale(scale, -scale);
            g2.translate(-minX, -minY);
            g2.setPaint(Color.BLACK);
            g2.draw(shape);
        }
    }
}

