/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Hmtx
extends Table {
    private int[] hMetrics;
    private short[] leftSideBearing;
    private float scaling = 0.001f;

    public Hmtx(FontFile2 currentFontFile, int glyphCount, int metricsCount, int maxAdvance) {
        this.scaling = maxAdvance;
        if (metricsCount < 0) {
            metricsCount = -metricsCount;
        }
        int startPointer = currentFontFile.selectTable(6);
        int lsbCount = glyphCount - metricsCount;
        this.hMetrics = new int[glyphCount];
        this.leftSideBearing = new short[glyphCount];
        int currentMetric = 0;
        if (startPointer == 0) {
            LogWriter.writeLog("No Htmx table found");
        } else {
            int i;
            int min = Math.min(metricsCount, glyphCount);
            try {
                for (i = 0; i < min; ++i) {
                    this.hMetrics[i] = currentMetric = currentFontFile.getNextUint16();
                    this.leftSideBearing[i] = currentFontFile.getNextInt16();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LogWriter.writeLog("Invalid hmtx table found");
                return;
            }
            if (lsbCount < 0) {
                LogWriter.writeLog("Potentially invalid hmtx table found");
                return;
            }
            int tableLength = currentFontFile.getTableSize(6);
            int lsbBytes = tableLength - i * 4;
            lsbCount = lsbBytes / 2;
            try {
                for (int j = i; j < lsbCount; ++j) {
                    this.hMetrics[j] = currentMetric;
                    this.leftSideBearing[j] = currentFontFile.getFWord();
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception in reading Hmtx " + ee);
            }
        }
    }

    protected Hmtx() {
    }

    public short getLeftSideBearing(int i) {
        int length = this.hMetrics.length;
        if (i < length) {
            return (short)(this.hMetrics[i] & 0xFFFF);
        }
        if (this.leftSideBearing == null) {
            return 0;
        }
        int ptr = i - length;
        if (ptr < this.leftSideBearing.length) {
            return this.leftSideBearing[i - this.hMetrics.length];
        }
        return 0;
    }

    public float getWidth(int i) {
        float w = this.hMetrics[i];
        return w / this.scaling;
    }

    public float getUnscaledWidth(int i) {
        return this.hMetrics[i];
    }
}

